# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'ModelComponentModel',
    'ModelLock',
    'ModelMetric',
    'ModelMetricDatasetSummary',
    'ModelMetricLabelMetricsReport',
    'ModelMetricLabelMetricsReportConfidenceEntry',
    'ModelMetricOverallMetricsReport',
    'ModelMetricOverallMetricsReportConfidenceEntry',
    'ModelModelSubType',
    'ModelTestingDataset',
    'ModelTrainingDataset',
    'ModelValidationDataset',
    'ProcessorJobInputLocation',
    'ProcessorJobInputLocationObjectLocation',
    'ProcessorJobOutputLocation',
    'ProcessorJobProcessorConfig',
    'ProcessorJobProcessorConfigFeature',
    'ProcessorJobProcessorConfigNormalizationField',
    'ProcessorJobProcessorConfigNormalizationFieldMap',
    'ProjectLock',
    'GetModelComponentModelResult',
    'GetModelLockResult',
    'GetModelMetricResult',
    'GetModelMetricDatasetSummaryResult',
    'GetModelMetricLabelMetricsReportResult',
    'GetModelMetricLabelMetricsReportConfidenceEntryResult',
    'GetModelMetricOverallMetricsReportResult',
    'GetModelMetricOverallMetricsReportConfidenceEntryResult',
    'GetModelModelSubTypeResult',
    'GetModelTestingDatasetResult',
    'GetModelTrainingDatasetResult',
    'GetModelValidationDatasetResult',
    'GetModelsFilterResult',
    'GetModelsModelCollectionResult',
    'GetModelsModelCollectionItemResult',
    'GetModelsModelCollectionItemComponentModelResult',
    'GetModelsModelCollectionItemLockResult',
    'GetModelsModelCollectionItemMetricResult',
    'GetModelsModelCollectionItemMetricDatasetSummaryResult',
    'GetModelsModelCollectionItemMetricLabelMetricsReportResult',
    'GetModelsModelCollectionItemMetricLabelMetricsReportConfidenceEntryResult',
    'GetModelsModelCollectionItemMetricOverallMetricsReportResult',
    'GetModelsModelCollectionItemMetricOverallMetricsReportConfidenceEntryResult',
    'GetModelsModelCollectionItemModelSubTypeResult',
    'GetModelsModelCollectionItemTestingDatasetResult',
    'GetModelsModelCollectionItemTrainingDatasetResult',
    'GetModelsModelCollectionItemValidationDatasetResult',
    'GetProcessorJobInputLocationResult',
    'GetProcessorJobInputLocationObjectLocationResult',
    'GetProcessorJobOutputLocationResult',
    'GetProcessorJobProcessorConfigResult',
    'GetProcessorJobProcessorConfigFeatureResult',
    'GetProcessorJobProcessorConfigNormalizationFieldResult',
    'GetProcessorJobProcessorConfigNormalizationFieldMapResult',
    'GetProjectLockResult',
    'GetProjectsFilterResult',
    'GetProjectsProjectCollectionResult',
    'GetProjectsProjectCollectionItemResult',
    'GetProjectsProjectCollectionItemLockResult',
]

@pulumi.output_type
class ModelComponentModel(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "modelId":
            suggest = "model_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelComponentModel. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelComponentModel.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelComponentModel.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 model_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str model_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of active custom Key Value model that need to be composed.
        """
        if model_id is not None:
            pulumi.set(__self__, "model_id", model_id)

    @_builtins.property
    @pulumi.getter(name="modelId")
    def model_id(self) -> Optional[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of active custom Key Value model that need to be composed.
        """
        return pulumi.get(self, "model_id")


@pulumi.output_type
class ModelLock(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "compartmentId":
            suggest = "compartment_id"
        elif key == "relatedResourceId":
            suggest = "related_resource_id"
        elif key == "timeCreated":
            suggest = "time_created"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelLock. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelLock.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelLock.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: _builtins.str,
                 compartment_id: Optional[_builtins.str] = None,
                 message: Optional[_builtins.str] = None,
                 related_resource_id: Optional[_builtins.str] = None,
                 time_created: Optional[_builtins.str] = None):
        """
        :param _builtins.str type: Lock type.
        :param _builtins.str compartment_id: (Updatable) The compartment identifier.
        :param _builtins.str message: A message added by the lock creator. The message typically gives an indication of why the resource is locked.
        :param _builtins.str related_resource_id: The resource ID that is locking this resource. Indicates that deleting this resource removes the lock.
        :param _builtins.str time_created: When the model was created, as an RFC3339 datetime string.
        """
        pulumi.set(__self__, "type", type)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if related_resource_id is not None:
            pulumi.set(__self__, "related_resource_id", related_resource_id)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Lock type.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[_builtins.str]:
        """
        (Updatable) The compartment identifier.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter
    def message(self) -> Optional[_builtins.str]:
        """
        A message added by the lock creator. The message typically gives an indication of why the resource is locked.
        """
        return pulumi.get(self, "message")

    @_builtins.property
    @pulumi.getter(name="relatedResourceId")
    def related_resource_id(self) -> Optional[_builtins.str]:
        """
        The resource ID that is locking this resource. Indicates that deleting this resource removes the lock.
        """
        return pulumi.get(self, "related_resource_id")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[_builtins.str]:
        """
        When the model was created, as an RFC3339 datetime string.
        """
        return pulumi.get(self, "time_created")


@pulumi.output_type
class ModelMetric(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "datasetSummaries":
            suggest = "dataset_summaries"
        elif key == "labelMetricsReports":
            suggest = "label_metrics_reports"
        elif key == "modelType":
            suggest = "model_type"
        elif key == "overallMetricsReports":
            suggest = "overall_metrics_reports"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelMetric. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelMetric.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelMetric.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dataset_summaries: Optional[Sequence['outputs.ModelMetricDatasetSummary']] = None,
                 label_metrics_reports: Optional[Sequence['outputs.ModelMetricLabelMetricsReport']] = None,
                 model_type: Optional[_builtins.str] = None,
                 overall_metrics_reports: Optional[Sequence['outputs.ModelMetricOverallMetricsReport']] = None):
        """
        :param Sequence['ModelMetricDatasetSummaryArgs'] dataset_summaries: Summary of count of samples used during model training.
        :param Sequence['ModelMetricLabelMetricsReportArgs'] label_metrics_reports: List of metrics entries per label.
        :param _builtins.str model_type: The type of the Document model.
        :param Sequence['ModelMetricOverallMetricsReportArgs'] overall_metrics_reports: Overall Metrics report for Document Classification Model.
        """
        if dataset_summaries is not None:
            pulumi.set(__self__, "dataset_summaries", dataset_summaries)
        if label_metrics_reports is not None:
            pulumi.set(__self__, "label_metrics_reports", label_metrics_reports)
        if model_type is not None:
            pulumi.set(__self__, "model_type", model_type)
        if overall_metrics_reports is not None:
            pulumi.set(__self__, "overall_metrics_reports", overall_metrics_reports)

    @_builtins.property
    @pulumi.getter(name="datasetSummaries")
    def dataset_summaries(self) -> Optional[Sequence['outputs.ModelMetricDatasetSummary']]:
        """
        Summary of count of samples used during model training.
        """
        return pulumi.get(self, "dataset_summaries")

    @_builtins.property
    @pulumi.getter(name="labelMetricsReports")
    def label_metrics_reports(self) -> Optional[Sequence['outputs.ModelMetricLabelMetricsReport']]:
        """
        List of metrics entries per label.
        """
        return pulumi.get(self, "label_metrics_reports")

    @_builtins.property
    @pulumi.getter(name="modelType")
    def model_type(self) -> Optional[_builtins.str]:
        """
        The type of the Document model.
        """
        return pulumi.get(self, "model_type")

    @_builtins.property
    @pulumi.getter(name="overallMetricsReports")
    def overall_metrics_reports(self) -> Optional[Sequence['outputs.ModelMetricOverallMetricsReport']]:
        """
        Overall Metrics report for Document Classification Model.
        """
        return pulumi.get(self, "overall_metrics_reports")


@pulumi.output_type
class ModelMetricDatasetSummary(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "testSampleCount":
            suggest = "test_sample_count"
        elif key == "trainingSampleCount":
            suggest = "training_sample_count"
        elif key == "validationSampleCount":
            suggest = "validation_sample_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelMetricDatasetSummary. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelMetricDatasetSummary.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelMetricDatasetSummary.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 test_sample_count: Optional[_builtins.int] = None,
                 training_sample_count: Optional[_builtins.int] = None,
                 validation_sample_count: Optional[_builtins.int] = None):
        """
        :param _builtins.int test_sample_count: Number of samples used for testing the model.
        :param _builtins.int training_sample_count: Number of samples used for training the model.
        :param _builtins.int validation_sample_count: Number of samples used for validating the model.
        """
        if test_sample_count is not None:
            pulumi.set(__self__, "test_sample_count", test_sample_count)
        if training_sample_count is not None:
            pulumi.set(__self__, "training_sample_count", training_sample_count)
        if validation_sample_count is not None:
            pulumi.set(__self__, "validation_sample_count", validation_sample_count)

    @_builtins.property
    @pulumi.getter(name="testSampleCount")
    def test_sample_count(self) -> Optional[_builtins.int]:
        """
        Number of samples used for testing the model.
        """
        return pulumi.get(self, "test_sample_count")

    @_builtins.property
    @pulumi.getter(name="trainingSampleCount")
    def training_sample_count(self) -> Optional[_builtins.int]:
        """
        Number of samples used for training the model.
        """
        return pulumi.get(self, "training_sample_count")

    @_builtins.property
    @pulumi.getter(name="validationSampleCount")
    def validation_sample_count(self) -> Optional[_builtins.int]:
        """
        Number of samples used for validating the model.
        """
        return pulumi.get(self, "validation_sample_count")


@pulumi.output_type
class ModelMetricLabelMetricsReport(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "confidenceEntries":
            suggest = "confidence_entries"
        elif key == "documentCount":
            suggest = "document_count"
        elif key == "meanAveragePrecision":
            suggest = "mean_average_precision"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelMetricLabelMetricsReport. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelMetricLabelMetricsReport.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelMetricLabelMetricsReport.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 confidence_entries: Optional[Sequence['outputs.ModelMetricLabelMetricsReportConfidenceEntry']] = None,
                 document_count: Optional[_builtins.int] = None,
                 label: Optional[_builtins.str] = None,
                 mean_average_precision: Optional[_builtins.float] = None):
        """
        :param Sequence['ModelMetricLabelMetricsReportConfidenceEntryArgs'] confidence_entries: List of document classification confidence report.
        :param _builtins.int document_count: Total test documents in the label.
        :param _builtins.str label: Label name
        :param _builtins.float mean_average_precision: Mean average precision under different thresholds
        """
        if confidence_entries is not None:
            pulumi.set(__self__, "confidence_entries", confidence_entries)
        if document_count is not None:
            pulumi.set(__self__, "document_count", document_count)
        if label is not None:
            pulumi.set(__self__, "label", label)
        if mean_average_precision is not None:
            pulumi.set(__self__, "mean_average_precision", mean_average_precision)

    @_builtins.property
    @pulumi.getter(name="confidenceEntries")
    def confidence_entries(self) -> Optional[Sequence['outputs.ModelMetricLabelMetricsReportConfidenceEntry']]:
        """
        List of document classification confidence report.
        """
        return pulumi.get(self, "confidence_entries")

    @_builtins.property
    @pulumi.getter(name="documentCount")
    def document_count(self) -> Optional[_builtins.int]:
        """
        Total test documents in the label.
        """
        return pulumi.get(self, "document_count")

    @_builtins.property
    @pulumi.getter
    def label(self) -> Optional[_builtins.str]:
        """
        Label name
        """
        return pulumi.get(self, "label")

    @_builtins.property
    @pulumi.getter(name="meanAveragePrecision")
    def mean_average_precision(self) -> Optional[_builtins.float]:
        """
        Mean average precision under different thresholds
        """
        return pulumi.get(self, "mean_average_precision")


@pulumi.output_type
class ModelMetricLabelMetricsReportConfidenceEntry(dict):
    def __init__(__self__, *,
                 accuracy: Optional[_builtins.float] = None,
                 f1score: Optional[_builtins.float] = None,
                 precision: Optional[_builtins.float] = None,
                 recall: Optional[_builtins.float] = None,
                 threshold: Optional[_builtins.float] = None):
        """
        :param _builtins.float accuracy: accuracy under the threshold
        :param _builtins.float f1score: f1Score under the threshold
        :param _builtins.float precision: Precision under the threshold
        :param _builtins.float recall: Recall under the threshold
        :param _builtins.float threshold: Threshold used to calculate precision and recall.
        """
        if accuracy is not None:
            pulumi.set(__self__, "accuracy", accuracy)
        if f1score is not None:
            pulumi.set(__self__, "f1score", f1score)
        if precision is not None:
            pulumi.set(__self__, "precision", precision)
        if recall is not None:
            pulumi.set(__self__, "recall", recall)
        if threshold is not None:
            pulumi.set(__self__, "threshold", threshold)

    @_builtins.property
    @pulumi.getter
    def accuracy(self) -> Optional[_builtins.float]:
        """
        accuracy under the threshold
        """
        return pulumi.get(self, "accuracy")

    @_builtins.property
    @pulumi.getter
    def f1score(self) -> Optional[_builtins.float]:
        """
        f1Score under the threshold
        """
        return pulumi.get(self, "f1score")

    @_builtins.property
    @pulumi.getter
    def precision(self) -> Optional[_builtins.float]:
        """
        Precision under the threshold
        """
        return pulumi.get(self, "precision")

    @_builtins.property
    @pulumi.getter
    def recall(self) -> Optional[_builtins.float]:
        """
        Recall under the threshold
        """
        return pulumi.get(self, "recall")

    @_builtins.property
    @pulumi.getter
    def threshold(self) -> Optional[_builtins.float]:
        """
        Threshold used to calculate precision and recall.
        """
        return pulumi.get(self, "threshold")


@pulumi.output_type
class ModelMetricOverallMetricsReport(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "confidenceEntries":
            suggest = "confidence_entries"
        elif key == "documentCount":
            suggest = "document_count"
        elif key == "meanAveragePrecision":
            suggest = "mean_average_precision"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelMetricOverallMetricsReport. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelMetricOverallMetricsReport.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelMetricOverallMetricsReport.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 confidence_entries: Optional[Sequence['outputs.ModelMetricOverallMetricsReportConfidenceEntry']] = None,
                 document_count: Optional[_builtins.int] = None,
                 mean_average_precision: Optional[_builtins.float] = None):
        """
        :param Sequence['ModelMetricOverallMetricsReportConfidenceEntryArgs'] confidence_entries: List of document classification confidence report.
        :param _builtins.int document_count: Total test documents in the label.
        :param _builtins.float mean_average_precision: Mean average precision under different thresholds
        """
        if confidence_entries is not None:
            pulumi.set(__self__, "confidence_entries", confidence_entries)
        if document_count is not None:
            pulumi.set(__self__, "document_count", document_count)
        if mean_average_precision is not None:
            pulumi.set(__self__, "mean_average_precision", mean_average_precision)

    @_builtins.property
    @pulumi.getter(name="confidenceEntries")
    def confidence_entries(self) -> Optional[Sequence['outputs.ModelMetricOverallMetricsReportConfidenceEntry']]:
        """
        List of document classification confidence report.
        """
        return pulumi.get(self, "confidence_entries")

    @_builtins.property
    @pulumi.getter(name="documentCount")
    def document_count(self) -> Optional[_builtins.int]:
        """
        Total test documents in the label.
        """
        return pulumi.get(self, "document_count")

    @_builtins.property
    @pulumi.getter(name="meanAveragePrecision")
    def mean_average_precision(self) -> Optional[_builtins.float]:
        """
        Mean average precision under different thresholds
        """
        return pulumi.get(self, "mean_average_precision")


@pulumi.output_type
class ModelMetricOverallMetricsReportConfidenceEntry(dict):
    def __init__(__self__, *,
                 accuracy: Optional[_builtins.float] = None,
                 f1score: Optional[_builtins.float] = None,
                 precision: Optional[_builtins.float] = None,
                 recall: Optional[_builtins.float] = None,
                 threshold: Optional[_builtins.float] = None):
        """
        :param _builtins.float accuracy: accuracy under the threshold
        :param _builtins.float f1score: f1Score under the threshold
        :param _builtins.float precision: Precision under the threshold
        :param _builtins.float recall: Recall under the threshold
        :param _builtins.float threshold: Threshold used to calculate precision and recall.
        """
        if accuracy is not None:
            pulumi.set(__self__, "accuracy", accuracy)
        if f1score is not None:
            pulumi.set(__self__, "f1score", f1score)
        if precision is not None:
            pulumi.set(__self__, "precision", precision)
        if recall is not None:
            pulumi.set(__self__, "recall", recall)
        if threshold is not None:
            pulumi.set(__self__, "threshold", threshold)

    @_builtins.property
    @pulumi.getter
    def accuracy(self) -> Optional[_builtins.float]:
        """
        accuracy under the threshold
        """
        return pulumi.get(self, "accuracy")

    @_builtins.property
    @pulumi.getter
    def f1score(self) -> Optional[_builtins.float]:
        """
        f1Score under the threshold
        """
        return pulumi.get(self, "f1score")

    @_builtins.property
    @pulumi.getter
    def precision(self) -> Optional[_builtins.float]:
        """
        Precision under the threshold
        """
        return pulumi.get(self, "precision")

    @_builtins.property
    @pulumi.getter
    def recall(self) -> Optional[_builtins.float]:
        """
        Recall under the threshold
        """
        return pulumi.get(self, "recall")

    @_builtins.property
    @pulumi.getter
    def threshold(self) -> Optional[_builtins.float]:
        """
        Threshold used to calculate precision and recall.
        """
        return pulumi.get(self, "threshold")


@pulumi.output_type
class ModelModelSubType(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "modelSubType":
            suggest = "model_sub_type"
        elif key == "modelType":
            suggest = "model_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelModelSubType. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelModelSubType.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelModelSubType.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 model_sub_type: _builtins.str,
                 model_type: _builtins.str):
        """
        :param _builtins.str model_sub_type: The model sub type for PRE_TRAINED_KEY_VALUE_EXTRACTION The allowed values are:
               * `RECEIPT`
               * `INVOICE`
               * `PASSPORT`
               * `DRIVER_LICENSE`
               * `HEALTH_INSURANCE_ID`
        :param _builtins.str model_type: Sub type model based on the model type. The allowed values are:
               * `PRE_TRAINED_KEY_VALUE_EXTRACTION`
               * `PRE_TRAINED_DOCUMENT_ELEMENTS_EXTRACTION`
        """
        pulumi.set(__self__, "model_sub_type", model_sub_type)
        pulumi.set(__self__, "model_type", model_type)

    @_builtins.property
    @pulumi.getter(name="modelSubType")
    def model_sub_type(self) -> _builtins.str:
        """
        The model sub type for PRE_TRAINED_KEY_VALUE_EXTRACTION The allowed values are:
        * `RECEIPT`
        * `INVOICE`
        * `PASSPORT`
        * `DRIVER_LICENSE`
        * `HEALTH_INSURANCE_ID`
        """
        return pulumi.get(self, "model_sub_type")

    @_builtins.property
    @pulumi.getter(name="modelType")
    def model_type(self) -> _builtins.str:
        """
        Sub type model based on the model type. The allowed values are:
        * `PRE_TRAINED_KEY_VALUE_EXTRACTION`
        * `PRE_TRAINED_DOCUMENT_ELEMENTS_EXTRACTION`
        """
        return pulumi.get(self, "model_type")


@pulumi.output_type
class ModelTestingDataset(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "datasetType":
            suggest = "dataset_type"
        elif key == "datasetId":
            suggest = "dataset_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelTestingDataset. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelTestingDataset.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelTestingDataset.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dataset_type: _builtins.str,
                 bucket: Optional[_builtins.str] = None,
                 dataset_id: Optional[_builtins.str] = None,
                 namespace: Optional[_builtins.str] = None,
                 object: Optional[_builtins.str] = None):
        """
        :param _builtins.str dataset_type: The dataset type, based on where it is stored.
        :param _builtins.str bucket: The name of the Object Storage bucket that contains the input data file.
        :param _builtins.str dataset_id: OCID of the Data Labeling dataset.
        :param _builtins.str namespace: The namespace name of the Object Storage bucket that contains the input data file.
        :param _builtins.str object: The object name of the input data file.
        """
        pulumi.set(__self__, "dataset_type", dataset_type)
        if bucket is not None:
            pulumi.set(__self__, "bucket", bucket)
        if dataset_id is not None:
            pulumi.set(__self__, "dataset_id", dataset_id)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if object is not None:
            pulumi.set(__self__, "object", object)

    @_builtins.property
    @pulumi.getter(name="datasetType")
    def dataset_type(self) -> _builtins.str:
        """
        The dataset type, based on where it is stored.
        """
        return pulumi.get(self, "dataset_type")

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> Optional[_builtins.str]:
        """
        The name of the Object Storage bucket that contains the input data file.
        """
        return pulumi.get(self, "bucket")

    @_builtins.property
    @pulumi.getter(name="datasetId")
    def dataset_id(self) -> Optional[_builtins.str]:
        """
        OCID of the Data Labeling dataset.
        """
        return pulumi.get(self, "dataset_id")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[_builtins.str]:
        """
        The namespace name of the Object Storage bucket that contains the input data file.
        """
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter
    def object(self) -> Optional[_builtins.str]:
        """
        The object name of the input data file.
        """
        return pulumi.get(self, "object")


@pulumi.output_type
class ModelTrainingDataset(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "datasetType":
            suggest = "dataset_type"
        elif key == "datasetId":
            suggest = "dataset_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelTrainingDataset. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelTrainingDataset.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelTrainingDataset.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dataset_type: _builtins.str,
                 bucket: Optional[_builtins.str] = None,
                 dataset_id: Optional[_builtins.str] = None,
                 namespace: Optional[_builtins.str] = None,
                 object: Optional[_builtins.str] = None):
        """
        :param _builtins.str dataset_type: The dataset type, based on where it is stored.
        :param _builtins.str bucket: The name of the Object Storage bucket that contains the input data file.
        :param _builtins.str dataset_id: OCID of the Data Labeling dataset.
        :param _builtins.str namespace: The namespace name of the Object Storage bucket that contains the input data file.
        :param _builtins.str object: The object name of the input data file.
        """
        pulumi.set(__self__, "dataset_type", dataset_type)
        if bucket is not None:
            pulumi.set(__self__, "bucket", bucket)
        if dataset_id is not None:
            pulumi.set(__self__, "dataset_id", dataset_id)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if object is not None:
            pulumi.set(__self__, "object", object)

    @_builtins.property
    @pulumi.getter(name="datasetType")
    def dataset_type(self) -> _builtins.str:
        """
        The dataset type, based on where it is stored.
        """
        return pulumi.get(self, "dataset_type")

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> Optional[_builtins.str]:
        """
        The name of the Object Storage bucket that contains the input data file.
        """
        return pulumi.get(self, "bucket")

    @_builtins.property
    @pulumi.getter(name="datasetId")
    def dataset_id(self) -> Optional[_builtins.str]:
        """
        OCID of the Data Labeling dataset.
        """
        return pulumi.get(self, "dataset_id")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[_builtins.str]:
        """
        The namespace name of the Object Storage bucket that contains the input data file.
        """
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter
    def object(self) -> Optional[_builtins.str]:
        """
        The object name of the input data file.
        """
        return pulumi.get(self, "object")


@pulumi.output_type
class ModelValidationDataset(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "datasetType":
            suggest = "dataset_type"
        elif key == "datasetId":
            suggest = "dataset_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelValidationDataset. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelValidationDataset.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelValidationDataset.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dataset_type: _builtins.str,
                 bucket: Optional[_builtins.str] = None,
                 dataset_id: Optional[_builtins.str] = None,
                 namespace: Optional[_builtins.str] = None,
                 object: Optional[_builtins.str] = None):
        """
        :param _builtins.str dataset_type: The dataset type, based on where it is stored.
        :param _builtins.str bucket: The name of the Object Storage bucket that contains the input data file.
        :param _builtins.str dataset_id: OCID of the Data Labeling dataset.
        :param _builtins.str namespace: The namespace name of the Object Storage bucket that contains the input data file.
        :param _builtins.str object: The object name of the input data file.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "dataset_type", dataset_type)
        if bucket is not None:
            pulumi.set(__self__, "bucket", bucket)
        if dataset_id is not None:
            pulumi.set(__self__, "dataset_id", dataset_id)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if object is not None:
            pulumi.set(__self__, "object", object)

    @_builtins.property
    @pulumi.getter(name="datasetType")
    def dataset_type(self) -> _builtins.str:
        """
        The dataset type, based on where it is stored.
        """
        return pulumi.get(self, "dataset_type")

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> Optional[_builtins.str]:
        """
        The name of the Object Storage bucket that contains the input data file.
        """
        return pulumi.get(self, "bucket")

    @_builtins.property
    @pulumi.getter(name="datasetId")
    def dataset_id(self) -> Optional[_builtins.str]:
        """
        OCID of the Data Labeling dataset.
        """
        return pulumi.get(self, "dataset_id")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[_builtins.str]:
        """
        The namespace name of the Object Storage bucket that contains the input data file.
        """
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter
    def object(self) -> Optional[_builtins.str]:
        """
        The object name of the input data file.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "object")


@pulumi.output_type
class ProcessorJobInputLocation(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourceType":
            suggest = "source_type"
        elif key == "objectLocations":
            suggest = "object_locations"
        elif key == "pageRanges":
            suggest = "page_ranges"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProcessorJobInputLocation. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProcessorJobInputLocation.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProcessorJobInputLocation.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 source_type: _builtins.str,
                 data: Optional[_builtins.str] = None,
                 object_locations: Optional[Sequence['outputs.ProcessorJobInputLocationObjectLocation']] = None,
                 page_ranges: Optional[Sequence[_builtins.str]] = None):
        """
        :param _builtins.str source_type: The type of input location. The allowed values are:
               * `OBJECT_STORAGE_LOCATIONS`: A list of object locations in Object Storage.
               * `INLINE_DOCUMENT_CONTENT`: The content of an inline document.
        :param _builtins.str data: Raw document data with Base64 encoding.
        :param Sequence['ProcessorJobInputLocationObjectLocationArgs'] object_locations: The list of ObjectLocations.
        :param Sequence[_builtins.str] page_ranges: The page ranges to be analysed.
        """
        pulumi.set(__self__, "source_type", source_type)
        if data is not None:
            pulumi.set(__self__, "data", data)
        if object_locations is not None:
            pulumi.set(__self__, "object_locations", object_locations)
        if page_ranges is not None:
            pulumi.set(__self__, "page_ranges", page_ranges)

    @_builtins.property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> _builtins.str:
        """
        The type of input location. The allowed values are:
        * `OBJECT_STORAGE_LOCATIONS`: A list of object locations in Object Storage.
        * `INLINE_DOCUMENT_CONTENT`: The content of an inline document.
        """
        return pulumi.get(self, "source_type")

    @_builtins.property
    @pulumi.getter
    def data(self) -> Optional[_builtins.str]:
        """
        Raw document data with Base64 encoding.
        """
        return pulumi.get(self, "data")

    @_builtins.property
    @pulumi.getter(name="objectLocations")
    def object_locations(self) -> Optional[Sequence['outputs.ProcessorJobInputLocationObjectLocation']]:
        """
        The list of ObjectLocations.
        """
        return pulumi.get(self, "object_locations")

    @_builtins.property
    @pulumi.getter(name="pageRanges")
    def page_ranges(self) -> Optional[Sequence[_builtins.str]]:
        """
        The page ranges to be analysed.
        """
        return pulumi.get(self, "page_ranges")


@pulumi.output_type
class ProcessorJobInputLocationObjectLocation(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "pageRanges":
            suggest = "page_ranges"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProcessorJobInputLocationObjectLocation. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProcessorJobInputLocationObjectLocation.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProcessorJobInputLocationObjectLocation.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket: Optional[_builtins.str] = None,
                 namespace: Optional[_builtins.str] = None,
                 object: Optional[_builtins.str] = None,
                 page_ranges: Optional[Sequence[_builtins.str]] = None):
        """
        :param _builtins.str bucket: The Object Storage bucket name.
        :param _builtins.str namespace: The Object Storage namespace name.
        :param _builtins.str object: The Object Storage object name.
        :param Sequence[_builtins.str] page_ranges: The page ranges to be analysed.
        """
        if bucket is not None:
            pulumi.set(__self__, "bucket", bucket)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if object is not None:
            pulumi.set(__self__, "object", object)
        if page_ranges is not None:
            pulumi.set(__self__, "page_ranges", page_ranges)

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> Optional[_builtins.str]:
        """
        The Object Storage bucket name.
        """
        return pulumi.get(self, "bucket")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[_builtins.str]:
        """
        The Object Storage namespace name.
        """
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter
    def object(self) -> Optional[_builtins.str]:
        """
        The Object Storage object name.
        """
        return pulumi.get(self, "object")

    @_builtins.property
    @pulumi.getter(name="pageRanges")
    def page_ranges(self) -> Optional[Sequence[_builtins.str]]:
        """
        The page ranges to be analysed.
        """
        return pulumi.get(self, "page_ranges")


@pulumi.output_type
class ProcessorJobOutputLocation(dict):
    def __init__(__self__, *,
                 bucket: _builtins.str,
                 namespace: _builtins.str,
                 prefix: _builtins.str):
        """
        :param _builtins.str bucket: The Object Storage bucket name.
        :param _builtins.str namespace: The Object Storage namespace.
        :param _builtins.str prefix: The Object Storage folder name.
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "prefix", prefix)

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> _builtins.str:
        """
        The Object Storage bucket name.
        """
        return pulumi.get(self, "bucket")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> _builtins.str:
        """
        The Object Storage namespace.
        """
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter
    def prefix(self) -> _builtins.str:
        """
        The Object Storage folder name.
        """
        return pulumi.get(self, "prefix")


@pulumi.output_type
class ProcessorJobProcessorConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "processorType":
            suggest = "processor_type"
        elif key == "documentType":
            suggest = "document_type"
        elif key == "isZipOutputEnabled":
            suggest = "is_zip_output_enabled"
        elif key == "modelId":
            suggest = "model_id"
        elif key == "normalizationFields":
            suggest = "normalization_fields"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProcessorJobProcessorConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProcessorJobProcessorConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProcessorJobProcessorConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 features: Sequence['outputs.ProcessorJobProcessorConfigFeature'],
                 processor_type: _builtins.str,
                 document_type: Optional[_builtins.str] = None,
                 is_zip_output_enabled: Optional[_builtins.bool] = None,
                 language: Optional[_builtins.str] = None,
                 model_id: Optional[_builtins.str] = None,
                 normalization_fields: Optional[Sequence['outputs.ProcessorJobProcessorConfigNormalizationField']] = None):
        """
        :param Sequence['ProcessorJobProcessorConfigFeatureArgs'] features: The types of document analysis requested.
        :param _builtins.str processor_type: The type of the processor.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param _builtins.str document_type: The document type.
        :param _builtins.bool is_zip_output_enabled: Whether or not to generate a ZIP file containing the results.
        :param _builtins.str language: The document language, abbreviated according to the BCP 47 Language-Tag syntax.
        :param _builtins.str model_id: Unique identifier custom model OCID that should be used for inference.
        :param Sequence['ProcessorJobProcessorConfigNormalizationFieldArgs'] normalization_fields: A string-to-object map where the key is the normalization field and the object contains information about the field.
        """
        pulumi.set(__self__, "features", features)
        pulumi.set(__self__, "processor_type", processor_type)
        if document_type is not None:
            pulumi.set(__self__, "document_type", document_type)
        if is_zip_output_enabled is not None:
            pulumi.set(__self__, "is_zip_output_enabled", is_zip_output_enabled)
        if language is not None:
            pulumi.set(__self__, "language", language)
        if model_id is not None:
            pulumi.set(__self__, "model_id", model_id)
        if normalization_fields is not None:
            pulumi.set(__self__, "normalization_fields", normalization_fields)

    @_builtins.property
    @pulumi.getter
    def features(self) -> Sequence['outputs.ProcessorJobProcessorConfigFeature']:
        """
        The types of document analysis requested.
        """
        return pulumi.get(self, "features")

    @_builtins.property
    @pulumi.getter(name="processorType")
    def processor_type(self) -> _builtins.str:
        """
        The type of the processor.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "processor_type")

    @_builtins.property
    @pulumi.getter(name="documentType")
    def document_type(self) -> Optional[_builtins.str]:
        """
        The document type.
        """
        return pulumi.get(self, "document_type")

    @_builtins.property
    @pulumi.getter(name="isZipOutputEnabled")
    def is_zip_output_enabled(self) -> Optional[_builtins.bool]:
        """
        Whether or not to generate a ZIP file containing the results.
        """
        return pulumi.get(self, "is_zip_output_enabled")

    @_builtins.property
    @pulumi.getter
    def language(self) -> Optional[_builtins.str]:
        """
        The document language, abbreviated according to the BCP 47 Language-Tag syntax.
        """
        return pulumi.get(self, "language")

    @_builtins.property
    @pulumi.getter(name="modelId")
    def model_id(self) -> Optional[_builtins.str]:
        """
        Unique identifier custom model OCID that should be used for inference.
        """
        return pulumi.get(self, "model_id")

    @_builtins.property
    @pulumi.getter(name="normalizationFields")
    def normalization_fields(self) -> Optional[Sequence['outputs.ProcessorJobProcessorConfigNormalizationField']]:
        """
        A string-to-object map where the key is the normalization field and the object contains information about the field.
        """
        return pulumi.get(self, "normalization_fields")


@pulumi.output_type
class ProcessorJobProcessorConfigFeature(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "featureType":
            suggest = "feature_type"
        elif key == "generateSearchablePdf":
            suggest = "generate_searchable_pdf"
        elif key == "maxResults":
            suggest = "max_results"
        elif key == "modelId":
            suggest = "model_id"
        elif key == "selectionMarkDetection":
            suggest = "selection_mark_detection"
        elif key == "tenancyId":
            suggest = "tenancy_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProcessorJobProcessorConfigFeature. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProcessorJobProcessorConfigFeature.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProcessorJobProcessorConfigFeature.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 feature_type: _builtins.str,
                 generate_searchable_pdf: Optional[_builtins.bool] = None,
                 max_results: Optional[_builtins.int] = None,
                 model_id: Optional[_builtins.str] = None,
                 selection_mark_detection: Optional[_builtins.bool] = None,
                 tenancy_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str feature_type: The type of document analysis requested. The allowed values are:
               * `LANGUAGE_CLASSIFICATION`: Detect the language.
               * `TEXT_EXTRACTION`: Recognize text.
               * `TABLE_EXTRACTION`: Detect and extract data in tables.
               * `KEY_VALUE_EXTRACTION`: Extract form fields.
               * `DOCUMENT_CLASSIFICATION`: Identify the type of document.
               * `DOCUMENT_ELEMENTS_EXTRACTION`: Extract information from bar code
        :param _builtins.bool generate_searchable_pdf: Whether or not to generate a searchable PDF file.
        :param _builtins.int max_results: The maximum number of results to return.
        :param _builtins.str model_id: Unique identifier custom model OCID that should be used for inference.
        :param _builtins.bool selection_mark_detection: Whether checkbox detection feature is enabled or disabled.
        :param _builtins.str tenancy_id: The custom model tenancy ID when modelId represents aliasName.
        """
        pulumi.set(__self__, "feature_type", feature_type)
        if generate_searchable_pdf is not None:
            pulumi.set(__self__, "generate_searchable_pdf", generate_searchable_pdf)
        if max_results is not None:
            pulumi.set(__self__, "max_results", max_results)
        if model_id is not None:
            pulumi.set(__self__, "model_id", model_id)
        if selection_mark_detection is not None:
            pulumi.set(__self__, "selection_mark_detection", selection_mark_detection)
        if tenancy_id is not None:
            pulumi.set(__self__, "tenancy_id", tenancy_id)

    @_builtins.property
    @pulumi.getter(name="featureType")
    def feature_type(self) -> _builtins.str:
        """
        The type of document analysis requested. The allowed values are:
        * `LANGUAGE_CLASSIFICATION`: Detect the language.
        * `TEXT_EXTRACTION`: Recognize text.
        * `TABLE_EXTRACTION`: Detect and extract data in tables.
        * `KEY_VALUE_EXTRACTION`: Extract form fields.
        * `DOCUMENT_CLASSIFICATION`: Identify the type of document.
        * `DOCUMENT_ELEMENTS_EXTRACTION`: Extract information from bar code
        """
        return pulumi.get(self, "feature_type")

    @_builtins.property
    @pulumi.getter(name="generateSearchablePdf")
    def generate_searchable_pdf(self) -> Optional[_builtins.bool]:
        """
        Whether or not to generate a searchable PDF file.
        """
        return pulumi.get(self, "generate_searchable_pdf")

    @_builtins.property
    @pulumi.getter(name="maxResults")
    def max_results(self) -> Optional[_builtins.int]:
        """
        The maximum number of results to return.
        """
        return pulumi.get(self, "max_results")

    @_builtins.property
    @pulumi.getter(name="modelId")
    def model_id(self) -> Optional[_builtins.str]:
        """
        Unique identifier custom model OCID that should be used for inference.
        """
        return pulumi.get(self, "model_id")

    @_builtins.property
    @pulumi.getter(name="selectionMarkDetection")
    def selection_mark_detection(self) -> Optional[_builtins.bool]:
        """
        Whether checkbox detection feature is enabled or disabled.
        """
        return pulumi.get(self, "selection_mark_detection")

    @_builtins.property
    @pulumi.getter(name="tenancyId")
    def tenancy_id(self) -> Optional[_builtins.str]:
        """
        The custom model tenancy ID when modelId represents aliasName.
        """
        return pulumi.get(self, "tenancy_id")


@pulumi.output_type
class ProcessorJobProcessorConfigNormalizationField(dict):
    def __init__(__self__, *,
                 maps: Optional[Sequence['outputs.ProcessorJobProcessorConfigNormalizationFieldMap']] = None):
        """
        :param Sequence['ProcessorJobProcessorConfigNormalizationFieldMapArgs'] maps: A wrapped map.
        """
        if maps is not None:
            pulumi.set(__self__, "maps", maps)

    @_builtins.property
    @pulumi.getter
    def maps(self) -> Optional[Sequence['outputs.ProcessorJobProcessorConfigNormalizationFieldMap']]:
        """
        A wrapped map.
        """
        return pulumi.get(self, "maps")


@pulumi.output_type
class ProcessorJobProcessorConfigNormalizationFieldMap(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "normalizationType":
            suggest = "normalization_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProcessorJobProcessorConfigNormalizationFieldMap. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProcessorJobProcessorConfigNormalizationFieldMap.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProcessorJobProcessorConfigNormalizationFieldMap.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 normalization_type: Optional[_builtins.str] = None):
        """
        :param _builtins.str normalization_type: A string mapping to the normalization type.
        """
        if normalization_type is not None:
            pulumi.set(__self__, "normalization_type", normalization_type)

    @_builtins.property
    @pulumi.getter(name="normalizationType")
    def normalization_type(self) -> Optional[_builtins.str]:
        """
        A string mapping to the normalization type.
        """
        return pulumi.get(self, "normalization_type")


@pulumi.output_type
class ProjectLock(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "compartmentId":
            suggest = "compartment_id"
        elif key == "relatedResourceId":
            suggest = "related_resource_id"
        elif key == "timeCreated":
            suggest = "time_created"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProjectLock. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProjectLock.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProjectLock.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: _builtins.str,
                 compartment_id: Optional[_builtins.str] = None,
                 message: Optional[_builtins.str] = None,
                 related_resource_id: Optional[_builtins.str] = None,
                 time_created: Optional[_builtins.str] = None):
        """
        :param _builtins.str type: Lock type.
        :param _builtins.str compartment_id: (Updatable) The compartment identifier.
        :param _builtins.str message: A message added by the lock creator. The message typically gives an indication of why the resource is locked.
        :param _builtins.str related_resource_id: The resource ID that is locking this resource. Indicates that deleting this resource removes the lock.
        :param _builtins.str time_created: When the project was created, as an RFC3339 datetime string.
        """
        pulumi.set(__self__, "type", type)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if related_resource_id is not None:
            pulumi.set(__self__, "related_resource_id", related_resource_id)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Lock type.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[_builtins.str]:
        """
        (Updatable) The compartment identifier.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter
    def message(self) -> Optional[_builtins.str]:
        """
        A message added by the lock creator. The message typically gives an indication of why the resource is locked.
        """
        return pulumi.get(self, "message")

    @_builtins.property
    @pulumi.getter(name="relatedResourceId")
    def related_resource_id(self) -> Optional[_builtins.str]:
        """
        The resource ID that is locking this resource. Indicates that deleting this resource removes the lock.
        """
        return pulumi.get(self, "related_resource_id")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[_builtins.str]:
        """
        When the project was created, as an RFC3339 datetime string.
        """
        return pulumi.get(self, "time_created")


@pulumi.output_type
class GetModelComponentModelResult(dict):
    def __init__(__self__, *,
                 model_id: _builtins.str):
        """
        :param _builtins.str model_id: A unique model identifier.
        """
        pulumi.set(__self__, "model_id", model_id)

    @_builtins.property
    @pulumi.getter(name="modelId")
    def model_id(self) -> _builtins.str:
        """
        A unique model identifier.
        """
        return pulumi.get(self, "model_id")


@pulumi.output_type
class GetModelLockResult(dict):
    def __init__(__self__, *,
                 compartment_id: _builtins.str,
                 message: _builtins.str,
                 related_resource_id: _builtins.str,
                 time_created: _builtins.str,
                 type: _builtins.str):
        """
        :param _builtins.str compartment_id: The lock compartment ID.
        :param _builtins.str message: A message added by the lock creator. The message typically gives an indication of why the resource is locked.
        :param _builtins.str related_resource_id: The resource ID that is locking this resource. Indicates that deleting this resource removes the lock.
        :param _builtins.str time_created: When the model was created, as an RFC3339 datetime string.
        :param _builtins.str type: Lock type.
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "message", message)
        pulumi.set(__self__, "related_resource_id", related_resource_id)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The lock compartment ID.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter
    def message(self) -> _builtins.str:
        """
        A message added by the lock creator. The message typically gives an indication of why the resource is locked.
        """
        return pulumi.get(self, "message")

    @_builtins.property
    @pulumi.getter(name="relatedResourceId")
    def related_resource_id(self) -> _builtins.str:
        """
        The resource ID that is locking this resource. Indicates that deleting this resource removes the lock.
        """
        return pulumi.get(self, "related_resource_id")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        When the model was created, as an RFC3339 datetime string.
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Lock type.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetModelMetricResult(dict):
    def __init__(__self__, *,
                 dataset_summaries: Sequence['outputs.GetModelMetricDatasetSummaryResult'],
                 label_metrics_reports: Sequence['outputs.GetModelMetricLabelMetricsReportResult'],
                 model_type: _builtins.str,
                 overall_metrics_reports: Sequence['outputs.GetModelMetricOverallMetricsReportResult']):
        """
        :param Sequence['GetModelMetricDatasetSummaryArgs'] dataset_summaries: Summary of count of samples used during model training.
        :param Sequence['GetModelMetricLabelMetricsReportArgs'] label_metrics_reports: List of metrics entries per label.
        :param _builtins.str model_type: The type of the Document model.
        :param Sequence['GetModelMetricOverallMetricsReportArgs'] overall_metrics_reports: Overall Metrics report for Document Classification Model.
        """
        pulumi.set(__self__, "dataset_summaries", dataset_summaries)
        pulumi.set(__self__, "label_metrics_reports", label_metrics_reports)
        pulumi.set(__self__, "model_type", model_type)
        pulumi.set(__self__, "overall_metrics_reports", overall_metrics_reports)

    @_builtins.property
    @pulumi.getter(name="datasetSummaries")
    def dataset_summaries(self) -> Sequence['outputs.GetModelMetricDatasetSummaryResult']:
        """
        Summary of count of samples used during model training.
        """
        return pulumi.get(self, "dataset_summaries")

    @_builtins.property
    @pulumi.getter(name="labelMetricsReports")
    def label_metrics_reports(self) -> Sequence['outputs.GetModelMetricLabelMetricsReportResult']:
        """
        List of metrics entries per label.
        """
        return pulumi.get(self, "label_metrics_reports")

    @_builtins.property
    @pulumi.getter(name="modelType")
    def model_type(self) -> _builtins.str:
        """
        The type of the Document model.
        """
        return pulumi.get(self, "model_type")

    @_builtins.property
    @pulumi.getter(name="overallMetricsReports")
    def overall_metrics_reports(self) -> Sequence['outputs.GetModelMetricOverallMetricsReportResult']:
        """
        Overall Metrics report for Document Classification Model.
        """
        return pulumi.get(self, "overall_metrics_reports")


@pulumi.output_type
class GetModelMetricDatasetSummaryResult(dict):
    def __init__(__self__, *,
                 test_sample_count: _builtins.int,
                 training_sample_count: _builtins.int,
                 validation_sample_count: _builtins.int):
        """
        :param _builtins.int test_sample_count: Number of samples used for testing the model.
        :param _builtins.int training_sample_count: Number of samples used for training the model.
        :param _builtins.int validation_sample_count: Number of samples used for validating the model.
        """
        pulumi.set(__self__, "test_sample_count", test_sample_count)
        pulumi.set(__self__, "training_sample_count", training_sample_count)
        pulumi.set(__self__, "validation_sample_count", validation_sample_count)

    @_builtins.property
    @pulumi.getter(name="testSampleCount")
    def test_sample_count(self) -> _builtins.int:
        """
        Number of samples used for testing the model.
        """
        return pulumi.get(self, "test_sample_count")

    @_builtins.property
    @pulumi.getter(name="trainingSampleCount")
    def training_sample_count(self) -> _builtins.int:
        """
        Number of samples used for training the model.
        """
        return pulumi.get(self, "training_sample_count")

    @_builtins.property
    @pulumi.getter(name="validationSampleCount")
    def validation_sample_count(self) -> _builtins.int:
        """
        Number of samples used for validating the model.
        """
        return pulumi.get(self, "validation_sample_count")


@pulumi.output_type
class GetModelMetricLabelMetricsReportResult(dict):
    def __init__(__self__, *,
                 confidence_entries: Sequence['outputs.GetModelMetricLabelMetricsReportConfidenceEntryResult'],
                 document_count: _builtins.int,
                 label: _builtins.str,
                 mean_average_precision: _builtins.float):
        """
        :param Sequence['GetModelMetricLabelMetricsReportConfidenceEntryArgs'] confidence_entries: List of document classification confidence report.
        :param _builtins.int document_count: Total test documents in the label.
        :param _builtins.str label: Label name
        :param _builtins.float mean_average_precision: Mean average precision under different thresholds
        """
        pulumi.set(__self__, "confidence_entries", confidence_entries)
        pulumi.set(__self__, "document_count", document_count)
        pulumi.set(__self__, "label", label)
        pulumi.set(__self__, "mean_average_precision", mean_average_precision)

    @_builtins.property
    @pulumi.getter(name="confidenceEntries")
    def confidence_entries(self) -> Sequence['outputs.GetModelMetricLabelMetricsReportConfidenceEntryResult']:
        """
        List of document classification confidence report.
        """
        return pulumi.get(self, "confidence_entries")

    @_builtins.property
    @pulumi.getter(name="documentCount")
    def document_count(self) -> _builtins.int:
        """
        Total test documents in the label.
        """
        return pulumi.get(self, "document_count")

    @_builtins.property
    @pulumi.getter
    def label(self) -> _builtins.str:
        """
        Label name
        """
        return pulumi.get(self, "label")

    @_builtins.property
    @pulumi.getter(name="meanAveragePrecision")
    def mean_average_precision(self) -> _builtins.float:
        """
        Mean average precision under different thresholds
        """
        return pulumi.get(self, "mean_average_precision")


@pulumi.output_type
class GetModelMetricLabelMetricsReportConfidenceEntryResult(dict):
    def __init__(__self__, *,
                 accuracy: _builtins.float,
                 f1score: _builtins.float,
                 precision: _builtins.float,
                 recall: _builtins.float,
                 threshold: _builtins.float):
        """
        :param _builtins.float accuracy: accuracy under the threshold
        :param _builtins.float f1score: f1Score under the threshold
        :param _builtins.float precision: Precision under the threshold
        :param _builtins.float recall: Recall under the threshold
        :param _builtins.float threshold: Threshold used to calculate precision and recall.
        """
        pulumi.set(__self__, "accuracy", accuracy)
        pulumi.set(__self__, "f1score", f1score)
        pulumi.set(__self__, "precision", precision)
        pulumi.set(__self__, "recall", recall)
        pulumi.set(__self__, "threshold", threshold)

    @_builtins.property
    @pulumi.getter
    def accuracy(self) -> _builtins.float:
        """
        accuracy under the threshold
        """
        return pulumi.get(self, "accuracy")

    @_builtins.property
    @pulumi.getter
    def f1score(self) -> _builtins.float:
        """
        f1Score under the threshold
        """
        return pulumi.get(self, "f1score")

    @_builtins.property
    @pulumi.getter
    def precision(self) -> _builtins.float:
        """
        Precision under the threshold
        """
        return pulumi.get(self, "precision")

    @_builtins.property
    @pulumi.getter
    def recall(self) -> _builtins.float:
        """
        Recall under the threshold
        """
        return pulumi.get(self, "recall")

    @_builtins.property
    @pulumi.getter
    def threshold(self) -> _builtins.float:
        """
        Threshold used to calculate precision and recall.
        """
        return pulumi.get(self, "threshold")


@pulumi.output_type
class GetModelMetricOverallMetricsReportResult(dict):
    def __init__(__self__, *,
                 confidence_entries: Sequence['outputs.GetModelMetricOverallMetricsReportConfidenceEntryResult'],
                 document_count: _builtins.int,
                 mean_average_precision: _builtins.float):
        """
        :param Sequence['GetModelMetricOverallMetricsReportConfidenceEntryArgs'] confidence_entries: List of document classification confidence report.
        :param _builtins.int document_count: Total test documents in the label.
        :param _builtins.float mean_average_precision: Mean average precision under different thresholds
        """
        pulumi.set(__self__, "confidence_entries", confidence_entries)
        pulumi.set(__self__, "document_count", document_count)
        pulumi.set(__self__, "mean_average_precision", mean_average_precision)

    @_builtins.property
    @pulumi.getter(name="confidenceEntries")
    def confidence_entries(self) -> Sequence['outputs.GetModelMetricOverallMetricsReportConfidenceEntryResult']:
        """
        List of document classification confidence report.
        """
        return pulumi.get(self, "confidence_entries")

    @_builtins.property
    @pulumi.getter(name="documentCount")
    def document_count(self) -> _builtins.int:
        """
        Total test documents in the label.
        """
        return pulumi.get(self, "document_count")

    @_builtins.property
    @pulumi.getter(name="meanAveragePrecision")
    def mean_average_precision(self) -> _builtins.float:
        """
        Mean average precision under different thresholds
        """
        return pulumi.get(self, "mean_average_precision")


@pulumi.output_type
class GetModelMetricOverallMetricsReportConfidenceEntryResult(dict):
    def __init__(__self__, *,
                 accuracy: _builtins.float,
                 f1score: _builtins.float,
                 precision: _builtins.float,
                 recall: _builtins.float,
                 threshold: _builtins.float):
        """
        :param _builtins.float accuracy: accuracy under the threshold
        :param _builtins.float f1score: f1Score under the threshold
        :param _builtins.float precision: Precision under the threshold
        :param _builtins.float recall: Recall under the threshold
        :param _builtins.float threshold: Threshold used to calculate precision and recall.
        """
        pulumi.set(__self__, "accuracy", accuracy)
        pulumi.set(__self__, "f1score", f1score)
        pulumi.set(__self__, "precision", precision)
        pulumi.set(__self__, "recall", recall)
        pulumi.set(__self__, "threshold", threshold)

    @_builtins.property
    @pulumi.getter
    def accuracy(self) -> _builtins.float:
        """
        accuracy under the threshold
        """
        return pulumi.get(self, "accuracy")

    @_builtins.property
    @pulumi.getter
    def f1score(self) -> _builtins.float:
        """
        f1Score under the threshold
        """
        return pulumi.get(self, "f1score")

    @_builtins.property
    @pulumi.getter
    def precision(self) -> _builtins.float:
        """
        Precision under the threshold
        """
        return pulumi.get(self, "precision")

    @_builtins.property
    @pulumi.getter
    def recall(self) -> _builtins.float:
        """
        Recall under the threshold
        """
        return pulumi.get(self, "recall")

    @_builtins.property
    @pulumi.getter
    def threshold(self) -> _builtins.float:
        """
        Threshold used to calculate precision and recall.
        """
        return pulumi.get(self, "threshold")


@pulumi.output_type
class GetModelModelSubTypeResult(dict):
    def __init__(__self__, *,
                 model_sub_type: _builtins.str,
                 model_type: _builtins.str):
        """
        :param _builtins.str model_sub_type: The model sub type for PRE_TRAINED_KEY_VALUE_EXTRACTION The allowed values are:
               * `RECEIPT`
               * `INVOICE`
               * `PASSPORT`
               * `DRIVER_LICENSE`
               * `HEALTH_INSURANCE_ID`
        :param _builtins.str model_type: The type of the Document model.
        """
        pulumi.set(__self__, "model_sub_type", model_sub_type)
        pulumi.set(__self__, "model_type", model_type)

    @_builtins.property
    @pulumi.getter(name="modelSubType")
    def model_sub_type(self) -> _builtins.str:
        """
        The model sub type for PRE_TRAINED_KEY_VALUE_EXTRACTION The allowed values are:
        * `RECEIPT`
        * `INVOICE`
        * `PASSPORT`
        * `DRIVER_LICENSE`
        * `HEALTH_INSURANCE_ID`
        """
        return pulumi.get(self, "model_sub_type")

    @_builtins.property
    @pulumi.getter(name="modelType")
    def model_type(self) -> _builtins.str:
        """
        The type of the Document model.
        """
        return pulumi.get(self, "model_type")


@pulumi.output_type
class GetModelTestingDatasetResult(dict):
    def __init__(__self__, *,
                 bucket: _builtins.str,
                 dataset_id: _builtins.str,
                 dataset_type: _builtins.str,
                 namespace: _builtins.str,
                 object: _builtins.str):
        """
        :param _builtins.str bucket: The name of the Object Storage bucket that contains the input data file.
        :param _builtins.str dataset_id: OCID of the Data Labeling dataset.
        :param _builtins.str dataset_type: The dataset type, based on where it is stored.
        :param _builtins.str namespace: The namespace name of the Object Storage bucket that contains the input data file.
        :param _builtins.str object: The object name of the input data file.
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "dataset_id", dataset_id)
        pulumi.set(__self__, "dataset_type", dataset_type)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "object", object)

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> _builtins.str:
        """
        The name of the Object Storage bucket that contains the input data file.
        """
        return pulumi.get(self, "bucket")

    @_builtins.property
    @pulumi.getter(name="datasetId")
    def dataset_id(self) -> _builtins.str:
        """
        OCID of the Data Labeling dataset.
        """
        return pulumi.get(self, "dataset_id")

    @_builtins.property
    @pulumi.getter(name="datasetType")
    def dataset_type(self) -> _builtins.str:
        """
        The dataset type, based on where it is stored.
        """
        return pulumi.get(self, "dataset_type")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> _builtins.str:
        """
        The namespace name of the Object Storage bucket that contains the input data file.
        """
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter
    def object(self) -> _builtins.str:
        """
        The object name of the input data file.
        """
        return pulumi.get(self, "object")


@pulumi.output_type
class GetModelTrainingDatasetResult(dict):
    def __init__(__self__, *,
                 bucket: _builtins.str,
                 dataset_id: _builtins.str,
                 dataset_type: _builtins.str,
                 namespace: _builtins.str,
                 object: _builtins.str):
        """
        :param _builtins.str bucket: The name of the Object Storage bucket that contains the input data file.
        :param _builtins.str dataset_id: OCID of the Data Labeling dataset.
        :param _builtins.str dataset_type: The dataset type, based on where it is stored.
        :param _builtins.str namespace: The namespace name of the Object Storage bucket that contains the input data file.
        :param _builtins.str object: The object name of the input data file.
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "dataset_id", dataset_id)
        pulumi.set(__self__, "dataset_type", dataset_type)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "object", object)

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> _builtins.str:
        """
        The name of the Object Storage bucket that contains the input data file.
        """
        return pulumi.get(self, "bucket")

    @_builtins.property
    @pulumi.getter(name="datasetId")
    def dataset_id(self) -> _builtins.str:
        """
        OCID of the Data Labeling dataset.
        """
        return pulumi.get(self, "dataset_id")

    @_builtins.property
    @pulumi.getter(name="datasetType")
    def dataset_type(self) -> _builtins.str:
        """
        The dataset type, based on where it is stored.
        """
        return pulumi.get(self, "dataset_type")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> _builtins.str:
        """
        The namespace name of the Object Storage bucket that contains the input data file.
        """
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter
    def object(self) -> _builtins.str:
        """
        The object name of the input data file.
        """
        return pulumi.get(self, "object")


@pulumi.output_type
class GetModelValidationDatasetResult(dict):
    def __init__(__self__, *,
                 bucket: _builtins.str,
                 dataset_id: _builtins.str,
                 dataset_type: _builtins.str,
                 namespace: _builtins.str,
                 object: _builtins.str):
        """
        :param _builtins.str bucket: The name of the Object Storage bucket that contains the input data file.
        :param _builtins.str dataset_id: OCID of the Data Labeling dataset.
        :param _builtins.str dataset_type: The dataset type, based on where it is stored.
        :param _builtins.str namespace: The namespace name of the Object Storage bucket that contains the input data file.
        :param _builtins.str object: The object name of the input data file.
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "dataset_id", dataset_id)
        pulumi.set(__self__, "dataset_type", dataset_type)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "object", object)

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> _builtins.str:
        """
        The name of the Object Storage bucket that contains the input data file.
        """
        return pulumi.get(self, "bucket")

    @_builtins.property
    @pulumi.getter(name="datasetId")
    def dataset_id(self) -> _builtins.str:
        """
        OCID of the Data Labeling dataset.
        """
        return pulumi.get(self, "dataset_id")

    @_builtins.property
    @pulumi.getter(name="datasetType")
    def dataset_type(self) -> _builtins.str:
        """
        The dataset type, based on where it is stored.
        """
        return pulumi.get(self, "dataset_type")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> _builtins.str:
        """
        The namespace name of the Object Storage bucket that contains the input data file.
        """
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter
    def object(self) -> _builtins.str:
        """
        The object name of the input data file.
        """
        return pulumi.get(self, "object")


@pulumi.output_type
class GetModelsFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetModelsModelCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetModelsModelCollectionItemResult']):
        pulumi.set(__self__, "items", items)

    @_builtins.property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetModelsModelCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetModelsModelCollectionItemResult(dict):
    def __init__(__self__, *,
                 compartment_id: _builtins.str,
                 component_models: Sequence['outputs.GetModelsModelCollectionItemComponentModelResult'],
                 defined_tags: Mapping[str, _builtins.str],
                 description: _builtins.str,
                 display_name: _builtins.str,
                 freeform_tags: Mapping[str, _builtins.str],
                 id: _builtins.str,
                 inference_units: _builtins.int,
                 is_composed_model: _builtins.bool,
                 is_quick_mode: _builtins.bool,
                 labels: Sequence[_builtins.str],
                 language: _builtins.str,
                 lifecycle_details: _builtins.str,
                 locks: Sequence['outputs.GetModelsModelCollectionItemLockResult'],
                 max_training_time_in_hours: _builtins.float,
                 metrics: Sequence['outputs.GetModelsModelCollectionItemMetricResult'],
                 model_id: _builtins.str,
                 model_sub_types: Sequence['outputs.GetModelsModelCollectionItemModelSubTypeResult'],
                 model_type: _builtins.str,
                 model_version: _builtins.str,
                 project_id: _builtins.str,
                 state: _builtins.str,
                 system_tags: Mapping[str, _builtins.str],
                 tenancy_id: _builtins.str,
                 testing_datasets: Sequence['outputs.GetModelsModelCollectionItemTestingDatasetResult'],
                 time_created: _builtins.str,
                 time_updated: _builtins.str,
                 trained_time_in_hours: _builtins.float,
                 training_datasets: Sequence['outputs.GetModelsModelCollectionItemTrainingDatasetResult'],
                 validation_datasets: Sequence['outputs.GetModelsModelCollectionItemValidationDatasetResult']):
        """
        :param _builtins.str compartment_id: The ID of the compartment in which to list resources.
        :param Sequence['GetModelsModelCollectionItemComponentModelArgs'] component_models: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) collection of active custom Key Value models that need to be composed.
        :param Mapping[str, _builtins.str] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For example: `{"foo-namespace": {"bar-key": "value"}}`
        :param _builtins.str description: An optional description of the model.
        :param _builtins.str display_name: A filter to return only resources that match the entire display name given.
        :param Mapping[str, _builtins.str] freeform_tags: A simple key-value pair that is applied without any predefined name, type, or scope. It exists for cross-compatibility only. For example: `{"bar-key": "value"}`
        :param _builtins.str id: The filter to find the model with the given identifier.
        :param _builtins.int inference_units: Number of replicas required for this model.
        :param _builtins.bool is_composed_model: Set to true when the model is created by using multiple key value extraction models.
        :param _builtins.bool is_quick_mode: Set to true when experimenting with a new model type or dataset, so model training is quick, with a predefined low number of passes through the training data.
        :param Sequence[_builtins.str] labels: The collection of labels used to train the custom model.
        :param _builtins.str language: The document language for model training, abbreviated according to the BCP 47 syntax.
        :param _builtins.str lifecycle_details: A message describing the current state in more detail, that can provide actionable information if training failed.
        :param Sequence['GetModelsModelCollectionItemLockArgs'] locks: Locks associated with this resource.
        :param _builtins.float max_training_time_in_hours: The maximum model training time in hours, expressed as a decimal fraction.
        :param Sequence['GetModelsModelCollectionItemMetricArgs'] metrics: Trained Model Metrics.
        :param _builtins.str model_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of active custom Key Value model that need to be composed.
        :param Sequence['GetModelsModelCollectionItemModelSubTypeArgs'] model_sub_types: The model sub type for PRE_TRAINED_KEY_VALUE_EXTRACTION The allowed values are:
               * `RECEIPT`
               * `INVOICE`
               * `PASSPORT`
               * `DRIVER_LICENSE`
               * `HEALTH_INSURANCE_ID`
        :param _builtins.str model_type: The type of the Document model.
        :param _builtins.str model_version: The version of the model.
        :param _builtins.str project_id: The ID of the project for which to list the objects.
        :param _builtins.str state: The filter to match models with the given lifecycleState.
        :param Mapping[str, _builtins.str] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. For example: `{"orcl-cloud": {"free-tier-retained": "true"}}`
        :param _builtins.str tenancy_id: The tenancy id of the model.
        :param Sequence['GetModelsModelCollectionItemTestingDatasetArgs'] testing_datasets: The base entity which is the input for creating and training a model.
        :param _builtins.str time_created: When the model was created, as an RFC3339 datetime string.
        :param _builtins.str time_updated: When the model was updated, as an RFC3339 datetime string.
        :param _builtins.float trained_time_in_hours: The total hours actually used for model training.
        :param Sequence['GetModelsModelCollectionItemTrainingDatasetArgs'] training_datasets: The base entity which is the input for creating and training a model.
        :param Sequence['GetModelsModelCollectionItemValidationDatasetArgs'] validation_datasets: The base entity which is the input for creating and training a model.
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "component_models", component_models)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "inference_units", inference_units)
        pulumi.set(__self__, "is_composed_model", is_composed_model)
        pulumi.set(__self__, "is_quick_mode", is_quick_mode)
        pulumi.set(__self__, "labels", labels)
        pulumi.set(__self__, "language", language)
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        pulumi.set(__self__, "locks", locks)
        pulumi.set(__self__, "max_training_time_in_hours", max_training_time_in_hours)
        pulumi.set(__self__, "metrics", metrics)
        pulumi.set(__self__, "model_id", model_id)
        pulumi.set(__self__, "model_sub_types", model_sub_types)
        pulumi.set(__self__, "model_type", model_type)
        pulumi.set(__self__, "model_version", model_version)
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "system_tags", system_tags)
        pulumi.set(__self__, "tenancy_id", tenancy_id)
        pulumi.set(__self__, "testing_datasets", testing_datasets)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_updated", time_updated)
        pulumi.set(__self__, "trained_time_in_hours", trained_time_in_hours)
        pulumi.set(__self__, "training_datasets", training_datasets)
        pulumi.set(__self__, "validation_datasets", validation_datasets)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The ID of the compartment in which to list resources.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="componentModels")
    def component_models(self) -> Sequence['outputs.GetModelsModelCollectionItemComponentModelResult']:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) collection of active custom Key Value models that need to be composed.
        """
        return pulumi.get(self, "component_models")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, _builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For example: `{"foo-namespace": {"bar-key": "value"}}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        An optional description of the model.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        A filter to return only resources that match the entire display name given.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, _builtins.str]:
        """
        A simple key-value pair that is applied without any predefined name, type, or scope. It exists for cross-compatibility only. For example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The filter to find the model with the given identifier.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="inferenceUnits")
    def inference_units(self) -> _builtins.int:
        """
        Number of replicas required for this model.
        """
        return pulumi.get(self, "inference_units")

    @_builtins.property
    @pulumi.getter(name="isComposedModel")
    def is_composed_model(self) -> _builtins.bool:
        """
        Set to true when the model is created by using multiple key value extraction models.
        """
        return pulumi.get(self, "is_composed_model")

    @_builtins.property
    @pulumi.getter(name="isQuickMode")
    def is_quick_mode(self) -> _builtins.bool:
        """
        Set to true when experimenting with a new model type or dataset, so model training is quick, with a predefined low number of passes through the training data.
        """
        return pulumi.get(self, "is_quick_mode")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Sequence[_builtins.str]:
        """
        The collection of labels used to train the custom model.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def language(self) -> _builtins.str:
        """
        The document language for model training, abbreviated according to the BCP 47 syntax.
        """
        return pulumi.get(self, "language")

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> _builtins.str:
        """
        A message describing the current state in more detail, that can provide actionable information if training failed.
        """
        return pulumi.get(self, "lifecycle_details")

    @_builtins.property
    @pulumi.getter
    def locks(self) -> Sequence['outputs.GetModelsModelCollectionItemLockResult']:
        """
        Locks associated with this resource.
        """
        return pulumi.get(self, "locks")

    @_builtins.property
    @pulumi.getter(name="maxTrainingTimeInHours")
    def max_training_time_in_hours(self) -> _builtins.float:
        """
        The maximum model training time in hours, expressed as a decimal fraction.
        """
        return pulumi.get(self, "max_training_time_in_hours")

    @_builtins.property
    @pulumi.getter
    def metrics(self) -> Sequence['outputs.GetModelsModelCollectionItemMetricResult']:
        """
        Trained Model Metrics.
        """
        return pulumi.get(self, "metrics")

    @_builtins.property
    @pulumi.getter(name="modelId")
    def model_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of active custom Key Value model that need to be composed.
        """
        return pulumi.get(self, "model_id")

    @_builtins.property
    @pulumi.getter(name="modelSubTypes")
    def model_sub_types(self) -> Sequence['outputs.GetModelsModelCollectionItemModelSubTypeResult']:
        """
        The model sub type for PRE_TRAINED_KEY_VALUE_EXTRACTION The allowed values are:
        * `RECEIPT`
        * `INVOICE`
        * `PASSPORT`
        * `DRIVER_LICENSE`
        * `HEALTH_INSURANCE_ID`
        """
        return pulumi.get(self, "model_sub_types")

    @_builtins.property
    @pulumi.getter(name="modelType")
    def model_type(self) -> _builtins.str:
        """
        The type of the Document model.
        """
        return pulumi.get(self, "model_type")

    @_builtins.property
    @pulumi.getter(name="modelVersion")
    def model_version(self) -> _builtins.str:
        """
        The version of the model.
        """
        return pulumi.get(self, "model_version")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> _builtins.str:
        """
        The ID of the project for which to list the objects.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        The filter to match models with the given lifecycleState.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, _builtins.str]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. For example: `{"orcl-cloud": {"free-tier-retained": "true"}}`
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="tenancyId")
    def tenancy_id(self) -> _builtins.str:
        """
        The tenancy id of the model.
        """
        return pulumi.get(self, "tenancy_id")

    @_builtins.property
    @pulumi.getter(name="testingDatasets")
    def testing_datasets(self) -> Sequence['outputs.GetModelsModelCollectionItemTestingDatasetResult']:
        """
        The base entity which is the input for creating and training a model.
        """
        return pulumi.get(self, "testing_datasets")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        When the model was created, as an RFC3339 datetime string.
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> _builtins.str:
        """
        When the model was updated, as an RFC3339 datetime string.
        """
        return pulumi.get(self, "time_updated")

    @_builtins.property
    @pulumi.getter(name="trainedTimeInHours")
    def trained_time_in_hours(self) -> _builtins.float:
        """
        The total hours actually used for model training.
        """
        return pulumi.get(self, "trained_time_in_hours")

    @_builtins.property
    @pulumi.getter(name="trainingDatasets")
    def training_datasets(self) -> Sequence['outputs.GetModelsModelCollectionItemTrainingDatasetResult']:
        """
        The base entity which is the input for creating and training a model.
        """
        return pulumi.get(self, "training_datasets")

    @_builtins.property
    @pulumi.getter(name="validationDatasets")
    def validation_datasets(self) -> Sequence['outputs.GetModelsModelCollectionItemValidationDatasetResult']:
        """
        The base entity which is the input for creating and training a model.
        """
        return pulumi.get(self, "validation_datasets")


@pulumi.output_type
class GetModelsModelCollectionItemComponentModelResult(dict):
    def __init__(__self__, *,
                 model_id: _builtins.str):
        """
        :param _builtins.str model_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of active custom Key Value model that need to be composed.
        """
        pulumi.set(__self__, "model_id", model_id)

    @_builtins.property
    @pulumi.getter(name="modelId")
    def model_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of active custom Key Value model that need to be composed.
        """
        return pulumi.get(self, "model_id")


@pulumi.output_type
class GetModelsModelCollectionItemLockResult(dict):
    def __init__(__self__, *,
                 compartment_id: _builtins.str,
                 message: _builtins.str,
                 related_resource_id: _builtins.str,
                 time_created: _builtins.str,
                 type: _builtins.str):
        """
        :param _builtins.str compartment_id: The ID of the compartment in which to list resources.
        :param _builtins.str message: A message added by the lock creator. The message typically gives an indication of why the resource is locked.
        :param _builtins.str related_resource_id: The resource ID that is locking this resource. Indicates that deleting this resource removes the lock.
        :param _builtins.str time_created: When the model was created, as an RFC3339 datetime string.
        :param _builtins.str type: Lock type.
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "message", message)
        pulumi.set(__self__, "related_resource_id", related_resource_id)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The ID of the compartment in which to list resources.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter
    def message(self) -> _builtins.str:
        """
        A message added by the lock creator. The message typically gives an indication of why the resource is locked.
        """
        return pulumi.get(self, "message")

    @_builtins.property
    @pulumi.getter(name="relatedResourceId")
    def related_resource_id(self) -> _builtins.str:
        """
        The resource ID that is locking this resource. Indicates that deleting this resource removes the lock.
        """
        return pulumi.get(self, "related_resource_id")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        When the model was created, as an RFC3339 datetime string.
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Lock type.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetModelsModelCollectionItemMetricResult(dict):
    def __init__(__self__, *,
                 dataset_summaries: Sequence['outputs.GetModelsModelCollectionItemMetricDatasetSummaryResult'],
                 label_metrics_reports: Sequence['outputs.GetModelsModelCollectionItemMetricLabelMetricsReportResult'],
                 model_type: _builtins.str,
                 overall_metrics_reports: Sequence['outputs.GetModelsModelCollectionItemMetricOverallMetricsReportResult']):
        """
        :param Sequence['GetModelsModelCollectionItemMetricDatasetSummaryArgs'] dataset_summaries: Summary of count of samples used during model training.
        :param Sequence['GetModelsModelCollectionItemMetricLabelMetricsReportArgs'] label_metrics_reports: List of metrics entries per label.
        :param _builtins.str model_type: The type of the Document model.
        :param Sequence['GetModelsModelCollectionItemMetricOverallMetricsReportArgs'] overall_metrics_reports: Overall Metrics report for Document Classification Model.
        """
        pulumi.set(__self__, "dataset_summaries", dataset_summaries)
        pulumi.set(__self__, "label_metrics_reports", label_metrics_reports)
        pulumi.set(__self__, "model_type", model_type)
        pulumi.set(__self__, "overall_metrics_reports", overall_metrics_reports)

    @_builtins.property
    @pulumi.getter(name="datasetSummaries")
    def dataset_summaries(self) -> Sequence['outputs.GetModelsModelCollectionItemMetricDatasetSummaryResult']:
        """
        Summary of count of samples used during model training.
        """
        return pulumi.get(self, "dataset_summaries")

    @_builtins.property
    @pulumi.getter(name="labelMetricsReports")
    def label_metrics_reports(self) -> Sequence['outputs.GetModelsModelCollectionItemMetricLabelMetricsReportResult']:
        """
        List of metrics entries per label.
        """
        return pulumi.get(self, "label_metrics_reports")

    @_builtins.property
    @pulumi.getter(name="modelType")
    def model_type(self) -> _builtins.str:
        """
        The type of the Document model.
        """
        return pulumi.get(self, "model_type")

    @_builtins.property
    @pulumi.getter(name="overallMetricsReports")
    def overall_metrics_reports(self) -> Sequence['outputs.GetModelsModelCollectionItemMetricOverallMetricsReportResult']:
        """
        Overall Metrics report for Document Classification Model.
        """
        return pulumi.get(self, "overall_metrics_reports")


@pulumi.output_type
class GetModelsModelCollectionItemMetricDatasetSummaryResult(dict):
    def __init__(__self__, *,
                 test_sample_count: _builtins.int,
                 training_sample_count: _builtins.int,
                 validation_sample_count: _builtins.int):
        """
        :param _builtins.int test_sample_count: Number of samples used for testing the model.
        :param _builtins.int training_sample_count: Number of samples used for training the model.
        :param _builtins.int validation_sample_count: Number of samples used for validating the model.
        """
        pulumi.set(__self__, "test_sample_count", test_sample_count)
        pulumi.set(__self__, "training_sample_count", training_sample_count)
        pulumi.set(__self__, "validation_sample_count", validation_sample_count)

    @_builtins.property
    @pulumi.getter(name="testSampleCount")
    def test_sample_count(self) -> _builtins.int:
        """
        Number of samples used for testing the model.
        """
        return pulumi.get(self, "test_sample_count")

    @_builtins.property
    @pulumi.getter(name="trainingSampleCount")
    def training_sample_count(self) -> _builtins.int:
        """
        Number of samples used for training the model.
        """
        return pulumi.get(self, "training_sample_count")

    @_builtins.property
    @pulumi.getter(name="validationSampleCount")
    def validation_sample_count(self) -> _builtins.int:
        """
        Number of samples used for validating the model.
        """
        return pulumi.get(self, "validation_sample_count")


@pulumi.output_type
class GetModelsModelCollectionItemMetricLabelMetricsReportResult(dict):
    def __init__(__self__, *,
                 confidence_entries: Sequence['outputs.GetModelsModelCollectionItemMetricLabelMetricsReportConfidenceEntryResult'],
                 document_count: _builtins.int,
                 label: _builtins.str,
                 mean_average_precision: _builtins.float):
        """
        :param Sequence['GetModelsModelCollectionItemMetricLabelMetricsReportConfidenceEntryArgs'] confidence_entries: List of document classification confidence report.
        :param _builtins.int document_count: Total test documents in the label.
        :param _builtins.str label: Label name
        :param _builtins.float mean_average_precision: Mean average precision under different thresholds
        """
        pulumi.set(__self__, "confidence_entries", confidence_entries)
        pulumi.set(__self__, "document_count", document_count)
        pulumi.set(__self__, "label", label)
        pulumi.set(__self__, "mean_average_precision", mean_average_precision)

    @_builtins.property
    @pulumi.getter(name="confidenceEntries")
    def confidence_entries(self) -> Sequence['outputs.GetModelsModelCollectionItemMetricLabelMetricsReportConfidenceEntryResult']:
        """
        List of document classification confidence report.
        """
        return pulumi.get(self, "confidence_entries")

    @_builtins.property
    @pulumi.getter(name="documentCount")
    def document_count(self) -> _builtins.int:
        """
        Total test documents in the label.
        """
        return pulumi.get(self, "document_count")

    @_builtins.property
    @pulumi.getter
    def label(self) -> _builtins.str:
        """
        Label name
        """
        return pulumi.get(self, "label")

    @_builtins.property
    @pulumi.getter(name="meanAveragePrecision")
    def mean_average_precision(self) -> _builtins.float:
        """
        Mean average precision under different thresholds
        """
        return pulumi.get(self, "mean_average_precision")


@pulumi.output_type
class GetModelsModelCollectionItemMetricLabelMetricsReportConfidenceEntryResult(dict):
    def __init__(__self__, *,
                 accuracy: _builtins.float,
                 f1score: _builtins.float,
                 precision: _builtins.float,
                 recall: _builtins.float,
                 threshold: _builtins.float):
        """
        :param _builtins.float accuracy: accuracy under the threshold
        :param _builtins.float f1score: f1Score under the threshold
        :param _builtins.float precision: Precision under the threshold
        :param _builtins.float recall: Recall under the threshold
        :param _builtins.float threshold: Threshold used to calculate precision and recall.
        """
        pulumi.set(__self__, "accuracy", accuracy)
        pulumi.set(__self__, "f1score", f1score)
        pulumi.set(__self__, "precision", precision)
        pulumi.set(__self__, "recall", recall)
        pulumi.set(__self__, "threshold", threshold)

    @_builtins.property
    @pulumi.getter
    def accuracy(self) -> _builtins.float:
        """
        accuracy under the threshold
        """
        return pulumi.get(self, "accuracy")

    @_builtins.property
    @pulumi.getter
    def f1score(self) -> _builtins.float:
        """
        f1Score under the threshold
        """
        return pulumi.get(self, "f1score")

    @_builtins.property
    @pulumi.getter
    def precision(self) -> _builtins.float:
        """
        Precision under the threshold
        """
        return pulumi.get(self, "precision")

    @_builtins.property
    @pulumi.getter
    def recall(self) -> _builtins.float:
        """
        Recall under the threshold
        """
        return pulumi.get(self, "recall")

    @_builtins.property
    @pulumi.getter
    def threshold(self) -> _builtins.float:
        """
        Threshold used to calculate precision and recall.
        """
        return pulumi.get(self, "threshold")


@pulumi.output_type
class GetModelsModelCollectionItemMetricOverallMetricsReportResult(dict):
    def __init__(__self__, *,
                 confidence_entries: Sequence['outputs.GetModelsModelCollectionItemMetricOverallMetricsReportConfidenceEntryResult'],
                 document_count: _builtins.int,
                 mean_average_precision: _builtins.float):
        """
        :param Sequence['GetModelsModelCollectionItemMetricOverallMetricsReportConfidenceEntryArgs'] confidence_entries: List of document classification confidence report.
        :param _builtins.int document_count: Total test documents in the label.
        :param _builtins.float mean_average_precision: Mean average precision under different thresholds
        """
        pulumi.set(__self__, "confidence_entries", confidence_entries)
        pulumi.set(__self__, "document_count", document_count)
        pulumi.set(__self__, "mean_average_precision", mean_average_precision)

    @_builtins.property
    @pulumi.getter(name="confidenceEntries")
    def confidence_entries(self) -> Sequence['outputs.GetModelsModelCollectionItemMetricOverallMetricsReportConfidenceEntryResult']:
        """
        List of document classification confidence report.
        """
        return pulumi.get(self, "confidence_entries")

    @_builtins.property
    @pulumi.getter(name="documentCount")
    def document_count(self) -> _builtins.int:
        """
        Total test documents in the label.
        """
        return pulumi.get(self, "document_count")

    @_builtins.property
    @pulumi.getter(name="meanAveragePrecision")
    def mean_average_precision(self) -> _builtins.float:
        """
        Mean average precision under different thresholds
        """
        return pulumi.get(self, "mean_average_precision")


@pulumi.output_type
class GetModelsModelCollectionItemMetricOverallMetricsReportConfidenceEntryResult(dict):
    def __init__(__self__, *,
                 accuracy: _builtins.float,
                 f1score: _builtins.float,
                 precision: _builtins.float,
                 recall: _builtins.float,
                 threshold: _builtins.float):
        """
        :param _builtins.float accuracy: accuracy under the threshold
        :param _builtins.float f1score: f1Score under the threshold
        :param _builtins.float precision: Precision under the threshold
        :param _builtins.float recall: Recall under the threshold
        :param _builtins.float threshold: Threshold used to calculate precision and recall.
        """
        pulumi.set(__self__, "accuracy", accuracy)
        pulumi.set(__self__, "f1score", f1score)
        pulumi.set(__self__, "precision", precision)
        pulumi.set(__self__, "recall", recall)
        pulumi.set(__self__, "threshold", threshold)

    @_builtins.property
    @pulumi.getter
    def accuracy(self) -> _builtins.float:
        """
        accuracy under the threshold
        """
        return pulumi.get(self, "accuracy")

    @_builtins.property
    @pulumi.getter
    def f1score(self) -> _builtins.float:
        """
        f1Score under the threshold
        """
        return pulumi.get(self, "f1score")

    @_builtins.property
    @pulumi.getter
    def precision(self) -> _builtins.float:
        """
        Precision under the threshold
        """
        return pulumi.get(self, "precision")

    @_builtins.property
    @pulumi.getter
    def recall(self) -> _builtins.float:
        """
        Recall under the threshold
        """
        return pulumi.get(self, "recall")

    @_builtins.property
    @pulumi.getter
    def threshold(self) -> _builtins.float:
        """
        Threshold used to calculate precision and recall.
        """
        return pulumi.get(self, "threshold")


@pulumi.output_type
class GetModelsModelCollectionItemModelSubTypeResult(dict):
    def __init__(__self__, *,
                 model_sub_type: _builtins.str,
                 model_type: _builtins.str):
        """
        :param _builtins.str model_sub_type: The model sub type for PRE_TRAINED_KEY_VALUE_EXTRACTION The allowed values are:
               * `RECEIPT`
               * `INVOICE`
               * `PASSPORT`
               * `DRIVER_LICENSE`
               * `HEALTH_INSURANCE_ID`
        :param _builtins.str model_type: The type of the Document model.
        """
        pulumi.set(__self__, "model_sub_type", model_sub_type)
        pulumi.set(__self__, "model_type", model_type)

    @_builtins.property
    @pulumi.getter(name="modelSubType")
    def model_sub_type(self) -> _builtins.str:
        """
        The model sub type for PRE_TRAINED_KEY_VALUE_EXTRACTION The allowed values are:
        * `RECEIPT`
        * `INVOICE`
        * `PASSPORT`
        * `DRIVER_LICENSE`
        * `HEALTH_INSURANCE_ID`
        """
        return pulumi.get(self, "model_sub_type")

    @_builtins.property
    @pulumi.getter(name="modelType")
    def model_type(self) -> _builtins.str:
        """
        The type of the Document model.
        """
        return pulumi.get(self, "model_type")


@pulumi.output_type
class GetModelsModelCollectionItemTestingDatasetResult(dict):
    def __init__(__self__, *,
                 bucket: _builtins.str,
                 dataset_id: _builtins.str,
                 dataset_type: _builtins.str,
                 namespace: _builtins.str,
                 object: _builtins.str):
        """
        :param _builtins.str bucket: The name of the Object Storage bucket that contains the input data file.
        :param _builtins.str dataset_id: OCID of the Data Labeling dataset.
        :param _builtins.str dataset_type: The dataset type, based on where it is stored.
        :param _builtins.str namespace: The namespace name of the Object Storage bucket that contains the input data file.
        :param _builtins.str object: The object name of the input data file.
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "dataset_id", dataset_id)
        pulumi.set(__self__, "dataset_type", dataset_type)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "object", object)

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> _builtins.str:
        """
        The name of the Object Storage bucket that contains the input data file.
        """
        return pulumi.get(self, "bucket")

    @_builtins.property
    @pulumi.getter(name="datasetId")
    def dataset_id(self) -> _builtins.str:
        """
        OCID of the Data Labeling dataset.
        """
        return pulumi.get(self, "dataset_id")

    @_builtins.property
    @pulumi.getter(name="datasetType")
    def dataset_type(self) -> _builtins.str:
        """
        The dataset type, based on where it is stored.
        """
        return pulumi.get(self, "dataset_type")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> _builtins.str:
        """
        The namespace name of the Object Storage bucket that contains the input data file.
        """
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter
    def object(self) -> _builtins.str:
        """
        The object name of the input data file.
        """
        return pulumi.get(self, "object")


@pulumi.output_type
class GetModelsModelCollectionItemTrainingDatasetResult(dict):
    def __init__(__self__, *,
                 bucket: _builtins.str,
                 dataset_id: _builtins.str,
                 dataset_type: _builtins.str,
                 namespace: _builtins.str,
                 object: _builtins.str):
        """
        :param _builtins.str bucket: The name of the Object Storage bucket that contains the input data file.
        :param _builtins.str dataset_id: OCID of the Data Labeling dataset.
        :param _builtins.str dataset_type: The dataset type, based on where it is stored.
        :param _builtins.str namespace: The namespace name of the Object Storage bucket that contains the input data file.
        :param _builtins.str object: The object name of the input data file.
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "dataset_id", dataset_id)
        pulumi.set(__self__, "dataset_type", dataset_type)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "object", object)

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> _builtins.str:
        """
        The name of the Object Storage bucket that contains the input data file.
        """
        return pulumi.get(self, "bucket")

    @_builtins.property
    @pulumi.getter(name="datasetId")
    def dataset_id(self) -> _builtins.str:
        """
        OCID of the Data Labeling dataset.
        """
        return pulumi.get(self, "dataset_id")

    @_builtins.property
    @pulumi.getter(name="datasetType")
    def dataset_type(self) -> _builtins.str:
        """
        The dataset type, based on where it is stored.
        """
        return pulumi.get(self, "dataset_type")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> _builtins.str:
        """
        The namespace name of the Object Storage bucket that contains the input data file.
        """
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter
    def object(self) -> _builtins.str:
        """
        The object name of the input data file.
        """
        return pulumi.get(self, "object")


@pulumi.output_type
class GetModelsModelCollectionItemValidationDatasetResult(dict):
    def __init__(__self__, *,
                 bucket: _builtins.str,
                 dataset_id: _builtins.str,
                 dataset_type: _builtins.str,
                 namespace: _builtins.str,
                 object: _builtins.str):
        """
        :param _builtins.str bucket: The name of the Object Storage bucket that contains the input data file.
        :param _builtins.str dataset_id: OCID of the Data Labeling dataset.
        :param _builtins.str dataset_type: The dataset type, based on where it is stored.
        :param _builtins.str namespace: The namespace name of the Object Storage bucket that contains the input data file.
        :param _builtins.str object: The object name of the input data file.
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "dataset_id", dataset_id)
        pulumi.set(__self__, "dataset_type", dataset_type)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "object", object)

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> _builtins.str:
        """
        The name of the Object Storage bucket that contains the input data file.
        """
        return pulumi.get(self, "bucket")

    @_builtins.property
    @pulumi.getter(name="datasetId")
    def dataset_id(self) -> _builtins.str:
        """
        OCID of the Data Labeling dataset.
        """
        return pulumi.get(self, "dataset_id")

    @_builtins.property
    @pulumi.getter(name="datasetType")
    def dataset_type(self) -> _builtins.str:
        """
        The dataset type, based on where it is stored.
        """
        return pulumi.get(self, "dataset_type")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> _builtins.str:
        """
        The namespace name of the Object Storage bucket that contains the input data file.
        """
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter
    def object(self) -> _builtins.str:
        """
        The object name of the input data file.
        """
        return pulumi.get(self, "object")


@pulumi.output_type
class GetProcessorJobInputLocationResult(dict):
    def __init__(__self__, *,
                 data: _builtins.str,
                 object_locations: Sequence['outputs.GetProcessorJobInputLocationObjectLocationResult'],
                 page_ranges: Sequence[_builtins.str],
                 source_type: _builtins.str):
        """
        :param _builtins.str data: Raw document data with Base64 encoding.
        :param Sequence['GetProcessorJobInputLocationObjectLocationArgs'] object_locations: The list of ObjectLocations.
        :param Sequence[_builtins.str] page_ranges: The page ranges to be analysed.
        :param _builtins.str source_type: The type of input location. The allowed values are:
               * `OBJECT_STORAGE_LOCATIONS`: A list of object locations in Object Storage.
               * `INLINE_DOCUMENT_CONTENT`: The content of an inline document.
        """
        pulumi.set(__self__, "data", data)
        pulumi.set(__self__, "object_locations", object_locations)
        pulumi.set(__self__, "page_ranges", page_ranges)
        pulumi.set(__self__, "source_type", source_type)

    @_builtins.property
    @pulumi.getter
    def data(self) -> _builtins.str:
        """
        Raw document data with Base64 encoding.
        """
        return pulumi.get(self, "data")

    @_builtins.property
    @pulumi.getter(name="objectLocations")
    def object_locations(self) -> Sequence['outputs.GetProcessorJobInputLocationObjectLocationResult']:
        """
        The list of ObjectLocations.
        """
        return pulumi.get(self, "object_locations")

    @_builtins.property
    @pulumi.getter(name="pageRanges")
    def page_ranges(self) -> Sequence[_builtins.str]:
        """
        The page ranges to be analysed.
        """
        return pulumi.get(self, "page_ranges")

    @_builtins.property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> _builtins.str:
        """
        The type of input location. The allowed values are:
        * `OBJECT_STORAGE_LOCATIONS`: A list of object locations in Object Storage.
        * `INLINE_DOCUMENT_CONTENT`: The content of an inline document.
        """
        return pulumi.get(self, "source_type")


@pulumi.output_type
class GetProcessorJobInputLocationObjectLocationResult(dict):
    def __init__(__self__, *,
                 bucket: _builtins.str,
                 namespace: _builtins.str,
                 object: _builtins.str,
                 page_ranges: Sequence[_builtins.str]):
        """
        :param _builtins.str bucket: The Object Storage bucket name.
        :param _builtins.str namespace: The Object Storage namespace.
        :param _builtins.str object: The Object Storage object name.
        :param Sequence[_builtins.str] page_ranges: The page ranges to be analysed.
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "object", object)
        pulumi.set(__self__, "page_ranges", page_ranges)

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> _builtins.str:
        """
        The Object Storage bucket name.
        """
        return pulumi.get(self, "bucket")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> _builtins.str:
        """
        The Object Storage namespace.
        """
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter
    def object(self) -> _builtins.str:
        """
        The Object Storage object name.
        """
        return pulumi.get(self, "object")

    @_builtins.property
    @pulumi.getter(name="pageRanges")
    def page_ranges(self) -> Sequence[_builtins.str]:
        """
        The page ranges to be analysed.
        """
        return pulumi.get(self, "page_ranges")


@pulumi.output_type
class GetProcessorJobOutputLocationResult(dict):
    def __init__(__self__, *,
                 bucket: _builtins.str,
                 namespace: _builtins.str,
                 prefix: _builtins.str):
        """
        :param _builtins.str bucket: The Object Storage bucket name.
        :param _builtins.str namespace: The Object Storage namespace.
        :param _builtins.str prefix: The Object Storage folder name.
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "prefix", prefix)

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> _builtins.str:
        """
        The Object Storage bucket name.
        """
        return pulumi.get(self, "bucket")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> _builtins.str:
        """
        The Object Storage namespace.
        """
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter
    def prefix(self) -> _builtins.str:
        """
        The Object Storage folder name.
        """
        return pulumi.get(self, "prefix")


@pulumi.output_type
class GetProcessorJobProcessorConfigResult(dict):
    def __init__(__self__, *,
                 document_type: _builtins.str,
                 features: Sequence['outputs.GetProcessorJobProcessorConfigFeatureResult'],
                 is_zip_output_enabled: _builtins.bool,
                 language: _builtins.str,
                 model_id: _builtins.str,
                 normalization_fields: Sequence['outputs.GetProcessorJobProcessorConfigNormalizationFieldResult'],
                 processor_type: _builtins.str):
        """
        :param _builtins.str document_type: The document type.
        :param Sequence['GetProcessorJobProcessorConfigFeatureArgs'] features: The types of document analysis requested.
        :param _builtins.bool is_zip_output_enabled: Whether or not to generate a ZIP file containing the results.
        :param _builtins.str language: The document language, abbreviated according to the BCP 47 Language-Tag syntax.
        :param _builtins.str model_id: Unique identifier custom model OCID that should be used for inference.
        :param Sequence['GetProcessorJobProcessorConfigNormalizationFieldArgs'] normalization_fields: A string-to-object map where the key is the normalization field and the object contains information about the field.
        :param _builtins.str processor_type: The type of the processor.
        """
        pulumi.set(__self__, "document_type", document_type)
        pulumi.set(__self__, "features", features)
        pulumi.set(__self__, "is_zip_output_enabled", is_zip_output_enabled)
        pulumi.set(__self__, "language", language)
        pulumi.set(__self__, "model_id", model_id)
        pulumi.set(__self__, "normalization_fields", normalization_fields)
        pulumi.set(__self__, "processor_type", processor_type)

    @_builtins.property
    @pulumi.getter(name="documentType")
    def document_type(self) -> _builtins.str:
        """
        The document type.
        """
        return pulumi.get(self, "document_type")

    @_builtins.property
    @pulumi.getter
    def features(self) -> Sequence['outputs.GetProcessorJobProcessorConfigFeatureResult']:
        """
        The types of document analysis requested.
        """
        return pulumi.get(self, "features")

    @_builtins.property
    @pulumi.getter(name="isZipOutputEnabled")
    def is_zip_output_enabled(self) -> _builtins.bool:
        """
        Whether or not to generate a ZIP file containing the results.
        """
        return pulumi.get(self, "is_zip_output_enabled")

    @_builtins.property
    @pulumi.getter
    def language(self) -> _builtins.str:
        """
        The document language, abbreviated according to the BCP 47 Language-Tag syntax.
        """
        return pulumi.get(self, "language")

    @_builtins.property
    @pulumi.getter(name="modelId")
    def model_id(self) -> _builtins.str:
        """
        Unique identifier custom model OCID that should be used for inference.
        """
        return pulumi.get(self, "model_id")

    @_builtins.property
    @pulumi.getter(name="normalizationFields")
    def normalization_fields(self) -> Sequence['outputs.GetProcessorJobProcessorConfigNormalizationFieldResult']:
        """
        A string-to-object map where the key is the normalization field and the object contains information about the field.
        """
        return pulumi.get(self, "normalization_fields")

    @_builtins.property
    @pulumi.getter(name="processorType")
    def processor_type(self) -> _builtins.str:
        """
        The type of the processor.
        """
        return pulumi.get(self, "processor_type")


@pulumi.output_type
class GetProcessorJobProcessorConfigFeatureResult(dict):
    def __init__(__self__, *,
                 feature_type: _builtins.str,
                 generate_searchable_pdf: _builtins.bool,
                 max_results: _builtins.int,
                 model_id: _builtins.str,
                 selection_mark_detection: _builtins.bool,
                 tenancy_id: _builtins.str):
        """
        :param _builtins.str feature_type: The type of document analysis requested. The allowed values are:
               * `LANGUAGE_CLASSIFICATION`: Detect the language.
               * `TEXT_EXTRACTION`: Recognize text.
               * `TABLE_EXTRACTION`: Detect and extract data in tables.
               * `KEY_VALUE_EXTRACTION`: Extract form fields.
               * `DOCUMENT_CLASSIFICATION`: Identify the type of document.
               * `DOCUMENT_ELEMENTS_EXTRACTION`: Extract information from bar code
        :param _builtins.bool generate_searchable_pdf: Whether or not to generate a searchable PDF file.
        :param _builtins.int max_results: The maximum number of results to return.
        :param _builtins.str model_id: Unique identifier custom model OCID that should be used for inference.
        :param _builtins.bool selection_mark_detection: Whether checkbox detection feature is enabled or disabled.
        :param _builtins.str tenancy_id: The custom model tenancy ID when modelId represents aliasName.
        """
        pulumi.set(__self__, "feature_type", feature_type)
        pulumi.set(__self__, "generate_searchable_pdf", generate_searchable_pdf)
        pulumi.set(__self__, "max_results", max_results)
        pulumi.set(__self__, "model_id", model_id)
        pulumi.set(__self__, "selection_mark_detection", selection_mark_detection)
        pulumi.set(__self__, "tenancy_id", tenancy_id)

    @_builtins.property
    @pulumi.getter(name="featureType")
    def feature_type(self) -> _builtins.str:
        """
        The type of document analysis requested. The allowed values are:
        * `LANGUAGE_CLASSIFICATION`: Detect the language.
        * `TEXT_EXTRACTION`: Recognize text.
        * `TABLE_EXTRACTION`: Detect and extract data in tables.
        * `KEY_VALUE_EXTRACTION`: Extract form fields.
        * `DOCUMENT_CLASSIFICATION`: Identify the type of document.
        * `DOCUMENT_ELEMENTS_EXTRACTION`: Extract information from bar code
        """
        return pulumi.get(self, "feature_type")

    @_builtins.property
    @pulumi.getter(name="generateSearchablePdf")
    def generate_searchable_pdf(self) -> _builtins.bool:
        """
        Whether or not to generate a searchable PDF file.
        """
        return pulumi.get(self, "generate_searchable_pdf")

    @_builtins.property
    @pulumi.getter(name="maxResults")
    def max_results(self) -> _builtins.int:
        """
        The maximum number of results to return.
        """
        return pulumi.get(self, "max_results")

    @_builtins.property
    @pulumi.getter(name="modelId")
    def model_id(self) -> _builtins.str:
        """
        Unique identifier custom model OCID that should be used for inference.
        """
        return pulumi.get(self, "model_id")

    @_builtins.property
    @pulumi.getter(name="selectionMarkDetection")
    def selection_mark_detection(self) -> _builtins.bool:
        """
        Whether checkbox detection feature is enabled or disabled.
        """
        return pulumi.get(self, "selection_mark_detection")

    @_builtins.property
    @pulumi.getter(name="tenancyId")
    def tenancy_id(self) -> _builtins.str:
        """
        The custom model tenancy ID when modelId represents aliasName.
        """
        return pulumi.get(self, "tenancy_id")


@pulumi.output_type
class GetProcessorJobProcessorConfigNormalizationFieldResult(dict):
    def __init__(__self__, *,
                 maps: Sequence['outputs.GetProcessorJobProcessorConfigNormalizationFieldMapResult']):
        """
        :param Sequence['GetProcessorJobProcessorConfigNormalizationFieldMapArgs'] maps: A wrapped map.
        """
        pulumi.set(__self__, "maps", maps)

    @_builtins.property
    @pulumi.getter
    def maps(self) -> Sequence['outputs.GetProcessorJobProcessorConfigNormalizationFieldMapResult']:
        """
        A wrapped map.
        """
        return pulumi.get(self, "maps")


@pulumi.output_type
class GetProcessorJobProcessorConfigNormalizationFieldMapResult(dict):
    def __init__(__self__, *,
                 normalization_type: _builtins.str):
        """
        :param _builtins.str normalization_type: A string mapping to the normalization type.
        """
        pulumi.set(__self__, "normalization_type", normalization_type)

    @_builtins.property
    @pulumi.getter(name="normalizationType")
    def normalization_type(self) -> _builtins.str:
        """
        A string mapping to the normalization type.
        """
        return pulumi.get(self, "normalization_type")


@pulumi.output_type
class GetProjectLockResult(dict):
    def __init__(__self__, *,
                 compartment_id: _builtins.str,
                 message: _builtins.str,
                 related_resource_id: _builtins.str,
                 time_created: _builtins.str,
                 type: _builtins.str):
        """
        :param _builtins.str compartment_id: The lock compartment ID.
        :param _builtins.str message: A message added by the lock creator. The message typically gives an indication of why the resource is locked.
        :param _builtins.str related_resource_id: The resource ID that is locking this resource. Indicates that deleting this resource removes the lock.
        :param _builtins.str time_created: When the project was created, as an RFC3339 datetime string.
        :param _builtins.str type: Lock type.
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "message", message)
        pulumi.set(__self__, "related_resource_id", related_resource_id)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The lock compartment ID.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter
    def message(self) -> _builtins.str:
        """
        A message added by the lock creator. The message typically gives an indication of why the resource is locked.
        """
        return pulumi.get(self, "message")

    @_builtins.property
    @pulumi.getter(name="relatedResourceId")
    def related_resource_id(self) -> _builtins.str:
        """
        The resource ID that is locking this resource. Indicates that deleting this resource removes the lock.
        """
        return pulumi.get(self, "related_resource_id")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        When the project was created, as an RFC3339 datetime string.
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Lock type.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetProjectsFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetProjectsProjectCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetProjectsProjectCollectionItemResult']):
        pulumi.set(__self__, "items", items)

    @_builtins.property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetProjectsProjectCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetProjectsProjectCollectionItemResult(dict):
    def __init__(__self__, *,
                 compartment_id: _builtins.str,
                 defined_tags: Mapping[str, _builtins.str],
                 description: _builtins.str,
                 display_name: _builtins.str,
                 freeform_tags: Mapping[str, _builtins.str],
                 id: _builtins.str,
                 lifecycle_details: _builtins.str,
                 locks: Sequence['outputs.GetProjectsProjectCollectionItemLockResult'],
                 state: _builtins.str,
                 system_tags: Mapping[str, _builtins.str],
                 time_created: _builtins.str,
                 time_updated: _builtins.str):
        """
        :param _builtins.str compartment_id: The ID of the compartment in which to list resources.
        :param Mapping[str, _builtins.str] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For example: `{"foo-namespace": {"bar-key": "value"}}`
        :param _builtins.str description: An optional description of the project.
        :param _builtins.str display_name: A filter to return only resources that match the entire display name given.
        :param Mapping[str, _builtins.str] freeform_tags: A simple key-value pair that is applied without any predefined name, type, or scope. It exists for cross-compatibility only. For example: `{"bar-key": "value"}`
        :param _builtins.str id: The filter to find the project with the given identifier.
        :param _builtins.str lifecycle_details: A message describing the current state in more detail, that can provide actionable information if creation failed.
        :param Sequence['GetProjectsProjectCollectionItemLockArgs'] locks: Locks associated with this resource.
        :param _builtins.str state: The filter to match projects with the given lifecycleState.
        :param Mapping[str, _builtins.str] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. For example: `{"orcl-cloud": {"free-tier-retained": "true"}}`
        :param _builtins.str time_created: When the project was created, as an RFC3339 datetime string.
        :param _builtins.str time_updated: When the project was updated, as an RFC3339 datetime string.
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        pulumi.set(__self__, "locks", locks)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "system_tags", system_tags)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_updated", time_updated)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The ID of the compartment in which to list resources.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, _builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For example: `{"foo-namespace": {"bar-key": "value"}}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        An optional description of the project.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        A filter to return only resources that match the entire display name given.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, _builtins.str]:
        """
        A simple key-value pair that is applied without any predefined name, type, or scope. It exists for cross-compatibility only. For example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The filter to find the project with the given identifier.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> _builtins.str:
        """
        A message describing the current state in more detail, that can provide actionable information if creation failed.
        """
        return pulumi.get(self, "lifecycle_details")

    @_builtins.property
    @pulumi.getter
    def locks(self) -> Sequence['outputs.GetProjectsProjectCollectionItemLockResult']:
        """
        Locks associated with this resource.
        """
        return pulumi.get(self, "locks")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        The filter to match projects with the given lifecycleState.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, _builtins.str]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. For example: `{"orcl-cloud": {"free-tier-retained": "true"}}`
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        When the project was created, as an RFC3339 datetime string.
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> _builtins.str:
        """
        When the project was updated, as an RFC3339 datetime string.
        """
        return pulumi.get(self, "time_updated")


@pulumi.output_type
class GetProjectsProjectCollectionItemLockResult(dict):
    def __init__(__self__, *,
                 compartment_id: _builtins.str,
                 message: _builtins.str,
                 related_resource_id: _builtins.str,
                 time_created: _builtins.str,
                 type: _builtins.str):
        """
        :param _builtins.str compartment_id: The ID of the compartment in which to list resources.
        :param _builtins.str message: A message added by the lock creator. The message typically gives an indication of why the resource is locked.
        :param _builtins.str related_resource_id: The resource ID that is locking this resource. Indicates that deleting this resource removes the lock.
        :param _builtins.str time_created: When the project was created, as an RFC3339 datetime string.
        :param _builtins.str type: Lock type.
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "message", message)
        pulumi.set(__self__, "related_resource_id", related_resource_id)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The ID of the compartment in which to list resources.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter
    def message(self) -> _builtins.str:
        """
        A message added by the lock creator. The message typically gives an indication of why the resource is locked.
        """
        return pulumi.get(self, "message")

    @_builtins.property
    @pulumi.getter(name="relatedResourceId")
    def related_resource_id(self) -> _builtins.str:
        """
        The resource ID that is locking this resource. Indicates that deleting this resource removes the lock.
        """
        return pulumi.get(self, "related_resource_id")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        When the project was created, as an RFC3339 datetime string.
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Lock type.
        """
        return pulumi.get(self, "type")


