# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetVisionPrivateEndpointsResult',
    'AwaitableGetVisionPrivateEndpointsResult',
    'get_vision_private_endpoints',
    'get_vision_private_endpoints_output',
]

@pulumi.output_type
class GetVisionPrivateEndpointsResult:
    """
    A collection of values returned by getVisionPrivateEndpoints.
    """
    def __init__(__self__, compartment_id=None, display_name=None, filters=None, id=None, state=None, vision_private_endpoint_collections=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if vision_private_endpoint_collections and not isinstance(vision_private_endpoint_collections, list):
            raise TypeError("Expected argument 'vision_private_endpoint_collections' to be a list")
        pulumi.set(__self__, "vision_private_endpoint_collections", vision_private_endpoint_collections)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[_builtins.str]:
        """
        A compartment identifier.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[_builtins.str]:
        """
        A human-friendly name for the visionPrivateEndpoint, which can be changed.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetVisionPrivateEndpointsFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of private endpoint
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[_builtins.str]:
        """
        The current state of the visionPrivateEndpoint.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="visionPrivateEndpointCollections")
    def vision_private_endpoint_collections(self) -> Sequence['outputs.GetVisionPrivateEndpointsVisionPrivateEndpointCollectionResult']:
        """
        The list of vision_private_endpoint_collection.
        """
        return pulumi.get(self, "vision_private_endpoint_collections")


class AwaitableGetVisionPrivateEndpointsResult(GetVisionPrivateEndpointsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetVisionPrivateEndpointsResult(
            compartment_id=self.compartment_id,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            state=self.state,
            vision_private_endpoint_collections=self.vision_private_endpoint_collections)


def get_vision_private_endpoints(compartment_id: Optional[_builtins.str] = None,
                                 display_name: Optional[_builtins.str] = None,
                                 filters: Optional[Sequence[Union['GetVisionPrivateEndpointsFilterArgs', 'GetVisionPrivateEndpointsFilterArgsDict']]] = None,
                                 id: Optional[_builtins.str] = None,
                                 state: Optional[_builtins.str] = None,
                                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetVisionPrivateEndpointsResult:
    """
    This data source provides the list of Vision Private Endpoints in Oracle Cloud Infrastructure Ai Vision service.

    Returns a list of visionPrivateEndpoints.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_vision_private_endpoints = oci.AiVision.get_vision_private_endpoints(compartment_id=compartment_id,
        display_name=vision_private_endpoint_display_name,
        id=vision_private_endpoint_id,
        state=vision_private_endpoint_state)
    ```


    :param _builtins.str compartment_id: The ID of the compartment in which to list resources.
    :param _builtins.str display_name: A filter to return only resources that match the entire display name given.
    :param _builtins.str id: The filter to find the device with the given identifier.
    :param _builtins.str state: The filter to match projects with the given lifecycleState.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:AiVision/getVisionPrivateEndpoints:getVisionPrivateEndpoints', __args__, opts=opts, typ=GetVisionPrivateEndpointsResult).value

    return AwaitableGetVisionPrivateEndpointsResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        state=pulumi.get(__ret__, 'state'),
        vision_private_endpoint_collections=pulumi.get(__ret__, 'vision_private_endpoint_collections'))
def get_vision_private_endpoints_output(compartment_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                        display_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                        filters: Optional[pulumi.Input[Optional[Sequence[Union['GetVisionPrivateEndpointsFilterArgs', 'GetVisionPrivateEndpointsFilterArgsDict']]]]] = None,
                                        id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                        state: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetVisionPrivateEndpointsResult]:
    """
    This data source provides the list of Vision Private Endpoints in Oracle Cloud Infrastructure Ai Vision service.

    Returns a list of visionPrivateEndpoints.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_vision_private_endpoints = oci.AiVision.get_vision_private_endpoints(compartment_id=compartment_id,
        display_name=vision_private_endpoint_display_name,
        id=vision_private_endpoint_id,
        state=vision_private_endpoint_state)
    ```


    :param _builtins.str compartment_id: The ID of the compartment in which to list resources.
    :param _builtins.str display_name: A filter to return only resources that match the entire display name given.
    :param _builtins.str id: The filter to find the device with the given identifier.
    :param _builtins.str state: The filter to match projects with the given lifecycleState.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['state'] = state
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:AiVision/getVisionPrivateEndpoints:getVisionPrivateEndpoints', __args__, opts=opts, typ=GetVisionPrivateEndpointsResult)
    return __ret__.apply(lambda __response__: GetVisionPrivateEndpointsResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        display_name=pulumi.get(__response__, 'display_name'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        state=pulumi.get(__response__, 'state'),
        vision_private_endpoint_collections=pulumi.get(__response__, 'vision_private_endpoint_collections')))
