# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetScheduledQueriesResult',
    'AwaitableGetScheduledQueriesResult',
    'get_scheduled_queries',
    'get_scheduled_queries_output',
]

@pulumi.output_type
class GetScheduledQueriesResult:
    """
    A collection of values returned by getScheduledQueries.
    """
    def __init__(__self__, apm_domain_id=None, display_name=None, filters=None, id=None, scheduled_query_collections=None):
        if apm_domain_id and not isinstance(apm_domain_id, str):
            raise TypeError("Expected argument 'apm_domain_id' to be a str")
        pulumi.set(__self__, "apm_domain_id", apm_domain_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if scheduled_query_collections and not isinstance(scheduled_query_collections, list):
            raise TypeError("Expected argument 'scheduled_query_collections' to be a list")
        pulumi.set(__self__, "scheduled_query_collections", scheduled_query_collections)

    @_builtins.property
    @pulumi.getter(name="apmDomainId")
    def apm_domain_id(self) -> _builtins.str:
        return pulumi.get(self, "apm_domain_id")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetScheduledQueriesFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="scheduledQueryCollections")
    def scheduled_query_collections(self) -> Sequence['outputs.GetScheduledQueriesScheduledQueryCollectionResult']:
        """
        The list of scheduled_query_collection.
        """
        return pulumi.get(self, "scheduled_query_collections")


class AwaitableGetScheduledQueriesResult(GetScheduledQueriesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetScheduledQueriesResult(
            apm_domain_id=self.apm_domain_id,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            scheduled_query_collections=self.scheduled_query_collections)


def get_scheduled_queries(apm_domain_id: Optional[_builtins.str] = None,
                          display_name: Optional[_builtins.str] = None,
                          filters: Optional[Sequence[Union['GetScheduledQueriesFilterArgs', 'GetScheduledQueriesFilterArgsDict']]] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetScheduledQueriesResult:
    """
    This data source provides the list of Scheduled Queries in Oracle Cloud Infrastructure Apm Traces service.

    Returns a list of all scheduled queries in the APM Domain.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_scheduled_queries = oci.ApmTraces.get_scheduled_queries(apm_domain_id=test_apm_domain["id"],
        display_name=scheduled_query_display_name)
    ```


    :param _builtins.str apm_domain_id: The APM Domain ID for the intended request.
    :param _builtins.str display_name: A filter to return resources that match the given display name.  This will return resources that have name starting with this filter.
    """
    __args__ = dict()
    __args__['apmDomainId'] = apm_domain_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:ApmTraces/getScheduledQueries:getScheduledQueries', __args__, opts=opts, typ=GetScheduledQueriesResult).value

    return AwaitableGetScheduledQueriesResult(
        apm_domain_id=pulumi.get(__ret__, 'apm_domain_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        scheduled_query_collections=pulumi.get(__ret__, 'scheduled_query_collections'))
def get_scheduled_queries_output(apm_domain_id: Optional[pulumi.Input[_builtins.str]] = None,
                                 display_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                 filters: Optional[pulumi.Input[Optional[Sequence[Union['GetScheduledQueriesFilterArgs', 'GetScheduledQueriesFilterArgsDict']]]]] = None,
                                 opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetScheduledQueriesResult]:
    """
    This data source provides the list of Scheduled Queries in Oracle Cloud Infrastructure Apm Traces service.

    Returns a list of all scheduled queries in the APM Domain.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_scheduled_queries = oci.ApmTraces.get_scheduled_queries(apm_domain_id=test_apm_domain["id"],
        display_name=scheduled_query_display_name)
    ```


    :param _builtins.str apm_domain_id: The APM Domain ID for the intended request.
    :param _builtins.str display_name: A filter to return resources that match the given display name.  This will return resources that have name starting with this filter.
    """
    __args__ = dict()
    __args__['apmDomainId'] = apm_domain_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:ApmTraces/getScheduledQueries:getScheduledQueries', __args__, opts=opts, typ=GetScheduledQueriesResult)
    return __ret__.apply(lambda __response__: GetScheduledQueriesResult(
        apm_domain_id=pulumi.get(__response__, 'apm_domain_id'),
        display_name=pulumi.get(__response__, 'display_name'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        scheduled_query_collections=pulumi.get(__response__, 'scheduled_query_collections')))
