# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetBdsInstanceIdentityConfigurationResult',
    'AwaitableGetBdsInstanceIdentityConfigurationResult',
    'get_bds_instance_identity_configuration',
    'get_bds_instance_identity_configuration_output',
]

@pulumi.output_type
class GetBdsInstanceIdentityConfigurationResult:
    """
    A collection of values returned by getBdsInstanceIdentityConfiguration.
    """
    def __init__(__self__, activate_iam_user_sync_configuration_trigger=None, activate_upst_configuration_trigger=None, bds_instance_id=None, cluster_admin_password=None, confidential_application_id=None, display_name=None, iam_user_sync_configuration_details=None, iam_user_sync_configurations=None, id=None, identity_configuration_id=None, identity_domain_id=None, refresh_confidential_application_trigger=None, refresh_upst_token_exchange_keytab_trigger=None, state=None, time_created=None, time_updated=None, upst_configuration_details=None, upst_configurations=None):
        if activate_iam_user_sync_configuration_trigger and not isinstance(activate_iam_user_sync_configuration_trigger, str):
            raise TypeError("Expected argument 'activate_iam_user_sync_configuration_trigger' to be a str")
        pulumi.set(__self__, "activate_iam_user_sync_configuration_trigger", activate_iam_user_sync_configuration_trigger)
        if activate_upst_configuration_trigger and not isinstance(activate_upst_configuration_trigger, str):
            raise TypeError("Expected argument 'activate_upst_configuration_trigger' to be a str")
        pulumi.set(__self__, "activate_upst_configuration_trigger", activate_upst_configuration_trigger)
        if bds_instance_id and not isinstance(bds_instance_id, str):
            raise TypeError("Expected argument 'bds_instance_id' to be a str")
        pulumi.set(__self__, "bds_instance_id", bds_instance_id)
        if cluster_admin_password and not isinstance(cluster_admin_password, str):
            raise TypeError("Expected argument 'cluster_admin_password' to be a str")
        pulumi.set(__self__, "cluster_admin_password", cluster_admin_password)
        if confidential_application_id and not isinstance(confidential_application_id, str):
            raise TypeError("Expected argument 'confidential_application_id' to be a str")
        pulumi.set(__self__, "confidential_application_id", confidential_application_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if iam_user_sync_configuration_details and not isinstance(iam_user_sync_configuration_details, list):
            raise TypeError("Expected argument 'iam_user_sync_configuration_details' to be a list")
        pulumi.set(__self__, "iam_user_sync_configuration_details", iam_user_sync_configuration_details)
        if iam_user_sync_configurations and not isinstance(iam_user_sync_configurations, list):
            raise TypeError("Expected argument 'iam_user_sync_configurations' to be a list")
        pulumi.set(__self__, "iam_user_sync_configurations", iam_user_sync_configurations)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if identity_configuration_id and not isinstance(identity_configuration_id, str):
            raise TypeError("Expected argument 'identity_configuration_id' to be a str")
        pulumi.set(__self__, "identity_configuration_id", identity_configuration_id)
        if identity_domain_id and not isinstance(identity_domain_id, str):
            raise TypeError("Expected argument 'identity_domain_id' to be a str")
        pulumi.set(__self__, "identity_domain_id", identity_domain_id)
        if refresh_confidential_application_trigger and not isinstance(refresh_confidential_application_trigger, str):
            raise TypeError("Expected argument 'refresh_confidential_application_trigger' to be a str")
        pulumi.set(__self__, "refresh_confidential_application_trigger", refresh_confidential_application_trigger)
        if refresh_upst_token_exchange_keytab_trigger and not isinstance(refresh_upst_token_exchange_keytab_trigger, str):
            raise TypeError("Expected argument 'refresh_upst_token_exchange_keytab_trigger' to be a str")
        pulumi.set(__self__, "refresh_upst_token_exchange_keytab_trigger", refresh_upst_token_exchange_keytab_trigger)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)
        if upst_configuration_details and not isinstance(upst_configuration_details, list):
            raise TypeError("Expected argument 'upst_configuration_details' to be a list")
        pulumi.set(__self__, "upst_configuration_details", upst_configuration_details)
        if upst_configurations and not isinstance(upst_configurations, list):
            raise TypeError("Expected argument 'upst_configurations' to be a list")
        pulumi.set(__self__, "upst_configurations", upst_configurations)

    @_builtins.property
    @pulumi.getter(name="activateIamUserSyncConfigurationTrigger")
    def activate_iam_user_sync_configuration_trigger(self) -> _builtins.str:
        return pulumi.get(self, "activate_iam_user_sync_configuration_trigger")

    @_builtins.property
    @pulumi.getter(name="activateUpstConfigurationTrigger")
    def activate_upst_configuration_trigger(self) -> _builtins.str:
        return pulumi.get(self, "activate_upst_configuration_trigger")

    @_builtins.property
    @pulumi.getter(name="bdsInstanceId")
    def bds_instance_id(self) -> _builtins.str:
        return pulumi.get(self, "bds_instance_id")

    @_builtins.property
    @pulumi.getter(name="clusterAdminPassword")
    def cluster_admin_password(self) -> _builtins.str:
        return pulumi.get(self, "cluster_admin_password")

    @_builtins.property
    @pulumi.getter(name="confidentialApplicationId")
    def confidential_application_id(self) -> _builtins.str:
        """
        identity domain confidential application ID for the identity config
        """
        return pulumi.get(self, "confidential_application_id")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        the display name of the identity configuration
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="iamUserSyncConfigurationDetails")
    def iam_user_sync_configuration_details(self) -> Sequence['outputs.GetBdsInstanceIdentityConfigurationIamUserSyncConfigurationDetailResult']:
        return pulumi.get(self, "iam_user_sync_configuration_details")

    @_builtins.property
    @pulumi.getter(name="iamUserSyncConfigurations")
    def iam_user_sync_configurations(self) -> Sequence['outputs.GetBdsInstanceIdentityConfigurationIamUserSyncConfigurationResult']:
        """
        Information about the IAM user sync configuration.
        """
        return pulumi.get(self, "iam_user_sync_configurations")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The id of the identity config
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="identityConfigurationId")
    def identity_configuration_id(self) -> _builtins.str:
        return pulumi.get(self, "identity_configuration_id")

    @_builtins.property
    @pulumi.getter(name="identityDomainId")
    def identity_domain_id(self) -> _builtins.str:
        """
        Identity domain to use for identity config
        """
        return pulumi.get(self, "identity_domain_id")

    @_builtins.property
    @pulumi.getter(name="refreshConfidentialApplicationTrigger")
    def refresh_confidential_application_trigger(self) -> _builtins.str:
        return pulumi.get(self, "refresh_confidential_application_trigger")

    @_builtins.property
    @pulumi.getter(name="refreshUpstTokenExchangeKeytabTrigger")
    def refresh_upst_token_exchange_keytab_trigger(self) -> _builtins.str:
        return pulumi.get(self, "refresh_upst_token_exchange_keytab_trigger")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        Lifecycle state of the UPST config
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        Time when this UPST config was created, shown as an RFC 3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> _builtins.str:
        """
        Time when this UPST config was updated, shown as an RFC 3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")

    @_builtins.property
    @pulumi.getter(name="upstConfigurationDetails")
    def upst_configuration_details(self) -> Sequence['outputs.GetBdsInstanceIdentityConfigurationUpstConfigurationDetailResult']:
        return pulumi.get(self, "upst_configuration_details")

    @_builtins.property
    @pulumi.getter(name="upstConfigurations")
    def upst_configurations(self) -> Sequence['outputs.GetBdsInstanceIdentityConfigurationUpstConfigurationResult']:
        """
        Information about the UPST configuration.
        """
        return pulumi.get(self, "upst_configurations")


class AwaitableGetBdsInstanceIdentityConfigurationResult(GetBdsInstanceIdentityConfigurationResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetBdsInstanceIdentityConfigurationResult(
            activate_iam_user_sync_configuration_trigger=self.activate_iam_user_sync_configuration_trigger,
            activate_upst_configuration_trigger=self.activate_upst_configuration_trigger,
            bds_instance_id=self.bds_instance_id,
            cluster_admin_password=self.cluster_admin_password,
            confidential_application_id=self.confidential_application_id,
            display_name=self.display_name,
            iam_user_sync_configuration_details=self.iam_user_sync_configuration_details,
            iam_user_sync_configurations=self.iam_user_sync_configurations,
            id=self.id,
            identity_configuration_id=self.identity_configuration_id,
            identity_domain_id=self.identity_domain_id,
            refresh_confidential_application_trigger=self.refresh_confidential_application_trigger,
            refresh_upst_token_exchange_keytab_trigger=self.refresh_upst_token_exchange_keytab_trigger,
            state=self.state,
            time_created=self.time_created,
            time_updated=self.time_updated,
            upst_configuration_details=self.upst_configuration_details,
            upst_configurations=self.upst_configurations)


def get_bds_instance_identity_configuration(bds_instance_id: Optional[_builtins.str] = None,
                                            identity_configuration_id: Optional[_builtins.str] = None,
                                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetBdsInstanceIdentityConfigurationResult:
    """
    This data source provides details about a specific Bds Instance Identity Configuration resource in Oracle Cloud Infrastructure Big Data Service service.

    Get details of one identity config on the cluster

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_bds_instance_identity_configuration = oci.BigDataService.get_bds_instance_identity_configuration(bds_instance_id=test_bds_instance["id"],
        identity_configuration_id=test_configuration["id"])
    ```


    :param _builtins.str bds_instance_id: The OCID of the cluster.
    :param _builtins.str identity_configuration_id: The OCID of the identity configuration
    """
    __args__ = dict()
    __args__['bdsInstanceId'] = bds_instance_id
    __args__['identityConfigurationId'] = identity_configuration_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:BigDataService/getBdsInstanceIdentityConfiguration:getBdsInstanceIdentityConfiguration', __args__, opts=opts, typ=GetBdsInstanceIdentityConfigurationResult).value

    return AwaitableGetBdsInstanceIdentityConfigurationResult(
        activate_iam_user_sync_configuration_trigger=pulumi.get(__ret__, 'activate_iam_user_sync_configuration_trigger'),
        activate_upst_configuration_trigger=pulumi.get(__ret__, 'activate_upst_configuration_trigger'),
        bds_instance_id=pulumi.get(__ret__, 'bds_instance_id'),
        cluster_admin_password=pulumi.get(__ret__, 'cluster_admin_password'),
        confidential_application_id=pulumi.get(__ret__, 'confidential_application_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        iam_user_sync_configuration_details=pulumi.get(__ret__, 'iam_user_sync_configuration_details'),
        iam_user_sync_configurations=pulumi.get(__ret__, 'iam_user_sync_configurations'),
        id=pulumi.get(__ret__, 'id'),
        identity_configuration_id=pulumi.get(__ret__, 'identity_configuration_id'),
        identity_domain_id=pulumi.get(__ret__, 'identity_domain_id'),
        refresh_confidential_application_trigger=pulumi.get(__ret__, 'refresh_confidential_application_trigger'),
        refresh_upst_token_exchange_keytab_trigger=pulumi.get(__ret__, 'refresh_upst_token_exchange_keytab_trigger'),
        state=pulumi.get(__ret__, 'state'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'),
        upst_configuration_details=pulumi.get(__ret__, 'upst_configuration_details'),
        upst_configurations=pulumi.get(__ret__, 'upst_configurations'))
def get_bds_instance_identity_configuration_output(bds_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                                                   identity_configuration_id: Optional[pulumi.Input[_builtins.str]] = None,
                                                   opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetBdsInstanceIdentityConfigurationResult]:
    """
    This data source provides details about a specific Bds Instance Identity Configuration resource in Oracle Cloud Infrastructure Big Data Service service.

    Get details of one identity config on the cluster

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_bds_instance_identity_configuration = oci.BigDataService.get_bds_instance_identity_configuration(bds_instance_id=test_bds_instance["id"],
        identity_configuration_id=test_configuration["id"])
    ```


    :param _builtins.str bds_instance_id: The OCID of the cluster.
    :param _builtins.str identity_configuration_id: The OCID of the identity configuration
    """
    __args__ = dict()
    __args__['bdsInstanceId'] = bds_instance_id
    __args__['identityConfigurationId'] = identity_configuration_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:BigDataService/getBdsInstanceIdentityConfiguration:getBdsInstanceIdentityConfiguration', __args__, opts=opts, typ=GetBdsInstanceIdentityConfigurationResult)
    return __ret__.apply(lambda __response__: GetBdsInstanceIdentityConfigurationResult(
        activate_iam_user_sync_configuration_trigger=pulumi.get(__response__, 'activate_iam_user_sync_configuration_trigger'),
        activate_upst_configuration_trigger=pulumi.get(__response__, 'activate_upst_configuration_trigger'),
        bds_instance_id=pulumi.get(__response__, 'bds_instance_id'),
        cluster_admin_password=pulumi.get(__response__, 'cluster_admin_password'),
        confidential_application_id=pulumi.get(__response__, 'confidential_application_id'),
        display_name=pulumi.get(__response__, 'display_name'),
        iam_user_sync_configuration_details=pulumi.get(__response__, 'iam_user_sync_configuration_details'),
        iam_user_sync_configurations=pulumi.get(__response__, 'iam_user_sync_configurations'),
        id=pulumi.get(__response__, 'id'),
        identity_configuration_id=pulumi.get(__response__, 'identity_configuration_id'),
        identity_domain_id=pulumi.get(__response__, 'identity_domain_id'),
        refresh_confidential_application_trigger=pulumi.get(__response__, 'refresh_confidential_application_trigger'),
        refresh_upst_token_exchange_keytab_trigger=pulumi.get(__response__, 'refresh_upst_token_exchange_keytab_trigger'),
        state=pulumi.get(__response__, 'state'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_updated=pulumi.get(__response__, 'time_updated'),
        upst_configuration_details=pulumi.get(__response__, 'upst_configuration_details'),
        upst_configurations=pulumi.get(__response__, 'upst_configurations')))
