# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['OsnArgs', 'Osn']

@pulumi.input_type
class OsnArgs:
    def __init__(__self__, *,
                 ad: pulumi.Input[_builtins.str],
                 blockchain_platform_id: pulumi.Input[_builtins.str],
                 ocpu_allocation_param: Optional[pulumi.Input['OsnOcpuAllocationParamArgs']] = None):
        """
        The set of arguments for constructing a Osn resource.
        :param pulumi.Input[_builtins.str] ad: Availability Domain to place new OSN
        :param pulumi.Input[_builtins.str] blockchain_platform_id: Unique service identifier.
        :param pulumi.Input['OsnOcpuAllocationParamArgs'] ocpu_allocation_param: (Updatable) OCPU allocation parameter
        """
        pulumi.set(__self__, "ad", ad)
        pulumi.set(__self__, "blockchain_platform_id", blockchain_platform_id)
        if ocpu_allocation_param is not None:
            pulumi.set(__self__, "ocpu_allocation_param", ocpu_allocation_param)

    @_builtins.property
    @pulumi.getter
    def ad(self) -> pulumi.Input[_builtins.str]:
        """
        Availability Domain to place new OSN
        """
        return pulumi.get(self, "ad")

    @ad.setter
    def ad(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "ad", value)

    @_builtins.property
    @pulumi.getter(name="blockchainPlatformId")
    def blockchain_platform_id(self) -> pulumi.Input[_builtins.str]:
        """
        Unique service identifier.
        """
        return pulumi.get(self, "blockchain_platform_id")

    @blockchain_platform_id.setter
    def blockchain_platform_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "blockchain_platform_id", value)

    @_builtins.property
    @pulumi.getter(name="ocpuAllocationParam")
    def ocpu_allocation_param(self) -> Optional[pulumi.Input['OsnOcpuAllocationParamArgs']]:
        """
        (Updatable) OCPU allocation parameter
        """
        return pulumi.get(self, "ocpu_allocation_param")

    @ocpu_allocation_param.setter
    def ocpu_allocation_param(self, value: Optional[pulumi.Input['OsnOcpuAllocationParamArgs']]):
        pulumi.set(self, "ocpu_allocation_param", value)


@pulumi.input_type
class _OsnState:
    def __init__(__self__, *,
                 ad: Optional[pulumi.Input[_builtins.str]] = None,
                 blockchain_platform_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ocpu_allocation_param: Optional[pulumi.Input['OsnOcpuAllocationParamArgs']] = None,
                 osn_key: Optional[pulumi.Input[_builtins.str]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Osn resources.
        :param pulumi.Input[_builtins.str] ad: Availability Domain to place new OSN
        :param pulumi.Input[_builtins.str] blockchain_platform_id: Unique service identifier.
        :param pulumi.Input['OsnOcpuAllocationParamArgs'] ocpu_allocation_param: (Updatable) OCPU allocation parameter
        :param pulumi.Input[_builtins.str] osn_key: OSN identifier
        :param pulumi.Input[_builtins.str] state: The current state of the OSN.
        """
        if ad is not None:
            pulumi.set(__self__, "ad", ad)
        if blockchain_platform_id is not None:
            pulumi.set(__self__, "blockchain_platform_id", blockchain_platform_id)
        if ocpu_allocation_param is not None:
            pulumi.set(__self__, "ocpu_allocation_param", ocpu_allocation_param)
        if osn_key is not None:
            pulumi.set(__self__, "osn_key", osn_key)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @_builtins.property
    @pulumi.getter
    def ad(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Availability Domain to place new OSN
        """
        return pulumi.get(self, "ad")

    @ad.setter
    def ad(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ad", value)

    @_builtins.property
    @pulumi.getter(name="blockchainPlatformId")
    def blockchain_platform_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unique service identifier.
        """
        return pulumi.get(self, "blockchain_platform_id")

    @blockchain_platform_id.setter
    def blockchain_platform_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "blockchain_platform_id", value)

    @_builtins.property
    @pulumi.getter(name="ocpuAllocationParam")
    def ocpu_allocation_param(self) -> Optional[pulumi.Input['OsnOcpuAllocationParamArgs']]:
        """
        (Updatable) OCPU allocation parameter
        """
        return pulumi.get(self, "ocpu_allocation_param")

    @ocpu_allocation_param.setter
    def ocpu_allocation_param(self, value: Optional[pulumi.Input['OsnOcpuAllocationParamArgs']]):
        pulumi.set(self, "ocpu_allocation_param", value)

    @_builtins.property
    @pulumi.getter(name="osnKey")
    def osn_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        OSN identifier
        """
        return pulumi.get(self, "osn_key")

    @osn_key.setter
    def osn_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "osn_key", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The current state of the OSN.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)


@pulumi.type_token("oci:Blockchain/osn:Osn")
class Osn(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ad: Optional[pulumi.Input[_builtins.str]] = None,
                 blockchain_platform_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ocpu_allocation_param: Optional[pulumi.Input[Union['OsnOcpuAllocationParamArgs', 'OsnOcpuAllocationParamArgsDict']]] = None,
                 __props__=None):
        """
        This resource provides the Osn resource in Oracle Cloud Infrastructure Blockchain service.

        Create Blockchain Platform Osn

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_osn = oci.blockchain.Osn("test_osn",
            ad=osn_ad,
            blockchain_platform_id=test_blockchain_platform["id"],
            ocpu_allocation_param={
                "ocpu_allocation_number": osn_ocpu_allocation_param_ocpu_allocation_number,
            })
        ```

        ## Import

        Osns can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Blockchain/osn:Osn test_osn "blockchainPlatforms/{blockchainPlatformId}/osns/{osnId}"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] ad: Availability Domain to place new OSN
        :param pulumi.Input[_builtins.str] blockchain_platform_id: Unique service identifier.
        :param pulumi.Input[Union['OsnOcpuAllocationParamArgs', 'OsnOcpuAllocationParamArgsDict']] ocpu_allocation_param: (Updatable) OCPU allocation parameter
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: OsnArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Osn resource in Oracle Cloud Infrastructure Blockchain service.

        Create Blockchain Platform Osn

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_osn = oci.blockchain.Osn("test_osn",
            ad=osn_ad,
            blockchain_platform_id=test_blockchain_platform["id"],
            ocpu_allocation_param={
                "ocpu_allocation_number": osn_ocpu_allocation_param_ocpu_allocation_number,
            })
        ```

        ## Import

        Osns can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Blockchain/osn:Osn test_osn "blockchainPlatforms/{blockchainPlatformId}/osns/{osnId}"
        ```

        :param str resource_name: The name of the resource.
        :param OsnArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(OsnArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ad: Optional[pulumi.Input[_builtins.str]] = None,
                 blockchain_platform_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ocpu_allocation_param: Optional[pulumi.Input[Union['OsnOcpuAllocationParamArgs', 'OsnOcpuAllocationParamArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = OsnArgs.__new__(OsnArgs)

            if ad is None and not opts.urn:
                raise TypeError("Missing required property 'ad'")
            __props__.__dict__["ad"] = ad
            if blockchain_platform_id is None and not opts.urn:
                raise TypeError("Missing required property 'blockchain_platform_id'")
            __props__.__dict__["blockchain_platform_id"] = blockchain_platform_id
            __props__.__dict__["ocpu_allocation_param"] = ocpu_allocation_param
            __props__.__dict__["osn_key"] = None
            __props__.__dict__["state"] = None
        super(Osn, __self__).__init__(
            'oci:Blockchain/osn:Osn',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            ad: Optional[pulumi.Input[_builtins.str]] = None,
            blockchain_platform_id: Optional[pulumi.Input[_builtins.str]] = None,
            ocpu_allocation_param: Optional[pulumi.Input[Union['OsnOcpuAllocationParamArgs', 'OsnOcpuAllocationParamArgsDict']]] = None,
            osn_key: Optional[pulumi.Input[_builtins.str]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None) -> 'Osn':
        """
        Get an existing Osn resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] ad: Availability Domain to place new OSN
        :param pulumi.Input[_builtins.str] blockchain_platform_id: Unique service identifier.
        :param pulumi.Input[Union['OsnOcpuAllocationParamArgs', 'OsnOcpuAllocationParamArgsDict']] ocpu_allocation_param: (Updatable) OCPU allocation parameter
        :param pulumi.Input[_builtins.str] osn_key: OSN identifier
        :param pulumi.Input[_builtins.str] state: The current state of the OSN.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _OsnState.__new__(_OsnState)

        __props__.__dict__["ad"] = ad
        __props__.__dict__["blockchain_platform_id"] = blockchain_platform_id
        __props__.__dict__["ocpu_allocation_param"] = ocpu_allocation_param
        __props__.__dict__["osn_key"] = osn_key
        __props__.__dict__["state"] = state
        return Osn(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def ad(self) -> pulumi.Output[_builtins.str]:
        """
        Availability Domain to place new OSN
        """
        return pulumi.get(self, "ad")

    @_builtins.property
    @pulumi.getter(name="blockchainPlatformId")
    def blockchain_platform_id(self) -> pulumi.Output[_builtins.str]:
        """
        Unique service identifier.
        """
        return pulumi.get(self, "blockchain_platform_id")

    @_builtins.property
    @pulumi.getter(name="ocpuAllocationParam")
    def ocpu_allocation_param(self) -> pulumi.Output['outputs.OsnOcpuAllocationParam']:
        """
        (Updatable) OCPU allocation parameter
        """
        return pulumi.get(self, "ocpu_allocation_param")

    @_builtins.property
    @pulumi.getter(name="osnKey")
    def osn_key(self) -> pulumi.Output[_builtins.str]:
        """
        OSN identifier
        """
        return pulumi.get(self, "osn_key")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        The current state of the OSN.
        """
        return pulumi.get(self, "state")

