# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetResponderRecipesResult',
    'AwaitableGetResponderRecipesResult',
    'get_responder_recipes',
    'get_responder_recipes_output',
]

@pulumi.output_type
class GetResponderRecipesResult:
    """
    A collection of values returned by getResponderRecipes.
    """
    def __init__(__self__, access_level=None, compartment_id=None, compartment_id_in_subtree=None, display_name=None, filters=None, id=None, resource_metadata_only=None, responder_recipe_collections=None, state=None):
        if access_level and not isinstance(access_level, str):
            raise TypeError("Expected argument 'access_level' to be a str")
        pulumi.set(__self__, "access_level", access_level)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if compartment_id_in_subtree and not isinstance(compartment_id_in_subtree, bool):
            raise TypeError("Expected argument 'compartment_id_in_subtree' to be a bool")
        pulumi.set(__self__, "compartment_id_in_subtree", compartment_id_in_subtree)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if resource_metadata_only and not isinstance(resource_metadata_only, bool):
            raise TypeError("Expected argument 'resource_metadata_only' to be a bool")
        pulumi.set(__self__, "resource_metadata_only", resource_metadata_only)
        if responder_recipe_collections and not isinstance(responder_recipe_collections, list):
            raise TypeError("Expected argument 'responder_recipe_collections' to be a list")
        pulumi.set(__self__, "responder_recipe_collections", responder_recipe_collections)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @_builtins.property
    @pulumi.getter(name="accessLevel")
    def access_level(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "access_level")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        Compartment OCID
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="compartmentIdInSubtree")
    def compartment_id_in_subtree(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "compartment_id_in_subtree")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[_builtins.str]:
        """
        Responder rule display name
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetResponderRecipesFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="resourceMetadataOnly")
    def resource_metadata_only(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "resource_metadata_only")

    @_builtins.property
    @pulumi.getter(name="responderRecipeCollections")
    def responder_recipe_collections(self) -> Sequence['outputs.GetResponderRecipesResponderRecipeCollectionResult']:
        """
        The list of responder_recipe_collection.
        """
        return pulumi.get(self, "responder_recipe_collections")

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[_builtins.str]:
        """
        The current lifecycle state of the example
        """
        return pulumi.get(self, "state")


class AwaitableGetResponderRecipesResult(GetResponderRecipesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetResponderRecipesResult(
            access_level=self.access_level,
            compartment_id=self.compartment_id,
            compartment_id_in_subtree=self.compartment_id_in_subtree,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            resource_metadata_only=self.resource_metadata_only,
            responder_recipe_collections=self.responder_recipe_collections,
            state=self.state)


def get_responder_recipes(access_level: Optional[_builtins.str] = None,
                          compartment_id: Optional[_builtins.str] = None,
                          compartment_id_in_subtree: Optional[_builtins.bool] = None,
                          display_name: Optional[_builtins.str] = None,
                          filters: Optional[Sequence[Union['GetResponderRecipesFilterArgs', 'GetResponderRecipesFilterArgsDict']]] = None,
                          resource_metadata_only: Optional[_builtins.bool] = None,
                          state: Optional[_builtins.str] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetResponderRecipesResult:
    """
    This data source provides the list of Responder Recipes in Oracle Cloud Infrastructure Cloud Guard service.

    Returns a list (ResponderRecipeCollection resource, with a page of ResponderRecipeSummary resources)
    of all responder recipes (RespponderRecipe resources) in a compartment, identified by compartmentId.
    The ListResponderRecipe operation returns only the targets in `compartmentId` passed.
    The list does not include any subcompartments of the compartmentId passed.

    The parameter `accessLevel` specifies whether to return only those compartments for which the
    requestor has INSPECT permissions on at least one resource directly
    or indirectly (ACCESSIBLE) (the resource can be in a subcompartment) or to return Not Authorized if
    Principal doesn't have access to even one of the child compartments. This is valid only when
    `compartmentIdInSubtree` is set to `true`.

    The parameter `compartmentIdInSubtree` applies when you perform ListResponderRecipe on the
    `compartmentId` passed and when it is set to true, the entire hierarchy of compartments can be returned.
    To get a full list of all compartments and subcompartments in the tenancy (root compartment),
    set the parameter `compartmentIdInSubtree` to true and `accessLevel` to ACCESSIBLE.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_responder_recipes = oci.CloudGuard.get_responder_recipes(compartment_id=compartment_id,
        access_level=responder_recipe_access_level,
        compartment_id_in_subtree=responder_recipe_compartment_id_in_subtree,
        display_name=responder_recipe_display_name,
        resource_metadata_only=responder_recipe_resource_metadata_only,
        state=responder_recipe_state)
    ```


    :param _builtins.str access_level: Valid values are `RESTRICTED` and `ACCESSIBLE`. Default is `RESTRICTED`. Setting this to `ACCESSIBLE` returns only those compartments for which the user has INSPECT permissions directly or indirectly (permissions can be on a resource in a subcompartment). When set to `RESTRICTED` permissions are checked and no partial results are displayed.
    :param _builtins.str compartment_id: The OCID of the compartment in which to list resources.
    :param _builtins.bool compartment_id_in_subtree: Default is false. When set to true, the hierarchy of compartments is traversed and all compartments and subcompartments in the tenancy are returned depending on the setting of `accessLevel`.
    :param _builtins.str display_name: A filter to return only resources that match the entire display name given.
    :param _builtins.bool resource_metadata_only: Default is false. When set to true, the list of all Oracle-managed resources metadata supported by Cloud Guard is returned.
    :param _builtins.str state: The field lifecycle state. Only one state can be provided. Default value for state is active. If no value is specified state is active.
    """
    __args__ = dict()
    __args__['accessLevel'] = access_level
    __args__['compartmentId'] = compartment_id
    __args__['compartmentIdInSubtree'] = compartment_id_in_subtree
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['resourceMetadataOnly'] = resource_metadata_only
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:CloudGuard/getResponderRecipes:getResponderRecipes', __args__, opts=opts, typ=GetResponderRecipesResult).value

    return AwaitableGetResponderRecipesResult(
        access_level=pulumi.get(__ret__, 'access_level'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        compartment_id_in_subtree=pulumi.get(__ret__, 'compartment_id_in_subtree'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        resource_metadata_only=pulumi.get(__ret__, 'resource_metadata_only'),
        responder_recipe_collections=pulumi.get(__ret__, 'responder_recipe_collections'),
        state=pulumi.get(__ret__, 'state'))
def get_responder_recipes_output(access_level: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                                 compartment_id_in_subtree: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                                 display_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                 filters: Optional[pulumi.Input[Optional[Sequence[Union['GetResponderRecipesFilterArgs', 'GetResponderRecipesFilterArgsDict']]]]] = None,
                                 resource_metadata_only: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                                 state: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                 opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetResponderRecipesResult]:
    """
    This data source provides the list of Responder Recipes in Oracle Cloud Infrastructure Cloud Guard service.

    Returns a list (ResponderRecipeCollection resource, with a page of ResponderRecipeSummary resources)
    of all responder recipes (RespponderRecipe resources) in a compartment, identified by compartmentId.
    The ListResponderRecipe operation returns only the targets in `compartmentId` passed.
    The list does not include any subcompartments of the compartmentId passed.

    The parameter `accessLevel` specifies whether to return only those compartments for which the
    requestor has INSPECT permissions on at least one resource directly
    or indirectly (ACCESSIBLE) (the resource can be in a subcompartment) or to return Not Authorized if
    Principal doesn't have access to even one of the child compartments. This is valid only when
    `compartmentIdInSubtree` is set to `true`.

    The parameter `compartmentIdInSubtree` applies when you perform ListResponderRecipe on the
    `compartmentId` passed and when it is set to true, the entire hierarchy of compartments can be returned.
    To get a full list of all compartments and subcompartments in the tenancy (root compartment),
    set the parameter `compartmentIdInSubtree` to true and `accessLevel` to ACCESSIBLE.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_responder_recipes = oci.CloudGuard.get_responder_recipes(compartment_id=compartment_id,
        access_level=responder_recipe_access_level,
        compartment_id_in_subtree=responder_recipe_compartment_id_in_subtree,
        display_name=responder_recipe_display_name,
        resource_metadata_only=responder_recipe_resource_metadata_only,
        state=responder_recipe_state)
    ```


    :param _builtins.str access_level: Valid values are `RESTRICTED` and `ACCESSIBLE`. Default is `RESTRICTED`. Setting this to `ACCESSIBLE` returns only those compartments for which the user has INSPECT permissions directly or indirectly (permissions can be on a resource in a subcompartment). When set to `RESTRICTED` permissions are checked and no partial results are displayed.
    :param _builtins.str compartment_id: The OCID of the compartment in which to list resources.
    :param _builtins.bool compartment_id_in_subtree: Default is false. When set to true, the hierarchy of compartments is traversed and all compartments and subcompartments in the tenancy are returned depending on the setting of `accessLevel`.
    :param _builtins.str display_name: A filter to return only resources that match the entire display name given.
    :param _builtins.bool resource_metadata_only: Default is false. When set to true, the list of all Oracle-managed resources metadata supported by Cloud Guard is returned.
    :param _builtins.str state: The field lifecycle state. Only one state can be provided. Default value for state is active. If no value is specified state is active.
    """
    __args__ = dict()
    __args__['accessLevel'] = access_level
    __args__['compartmentId'] = compartment_id
    __args__['compartmentIdInSubtree'] = compartment_id_in_subtree
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['resourceMetadataOnly'] = resource_metadata_only
    __args__['state'] = state
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:CloudGuard/getResponderRecipes:getResponderRecipes', __args__, opts=opts, typ=GetResponderRecipesResult)
    return __ret__.apply(lambda __response__: GetResponderRecipesResult(
        access_level=pulumi.get(__response__, 'access_level'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        compartment_id_in_subtree=pulumi.get(__response__, 'compartment_id_in_subtree'),
        display_name=pulumi.get(__response__, 'display_name'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        resource_metadata_only=pulumi.get(__response__, 'resource_metadata_only'),
        responder_recipe_collections=pulumi.get(__response__, 'responder_recipe_collections'),
        state=pulumi.get(__response__, 'state')))
