# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetMigrationPlanAvailableShapeResult',
    'AwaitableGetMigrationPlanAvailableShapeResult',
    'get_migration_plan_available_shape',
    'get_migration_plan_available_shape_output',
]

@pulumi.output_type
class GetMigrationPlanAvailableShapeResult:
    """
    A collection of values returned by getMigrationPlanAvailableShape.
    """
    def __init__(__self__, availability_domain=None, compartment_id=None, dvh_host_id=None, id=None, items=None, migration_plan_id=None, reserved_capacity_id=None):
        if availability_domain and not isinstance(availability_domain, str):
            raise TypeError("Expected argument 'availability_domain' to be a str")
        pulumi.set(__self__, "availability_domain", availability_domain)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if dvh_host_id and not isinstance(dvh_host_id, str):
            raise TypeError("Expected argument 'dvh_host_id' to be a str")
        pulumi.set(__self__, "dvh_host_id", dvh_host_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if items and not isinstance(items, list):
            raise TypeError("Expected argument 'items' to be a list")
        pulumi.set(__self__, "items", items)
        if migration_plan_id and not isinstance(migration_plan_id, str):
            raise TypeError("Expected argument 'migration_plan_id' to be a str")
        pulumi.set(__self__, "migration_plan_id", migration_plan_id)
        if reserved_capacity_id and not isinstance(reserved_capacity_id, str):
            raise TypeError("Expected argument 'reserved_capacity_id' to be a str")
        pulumi.set(__self__, "reserved_capacity_id", reserved_capacity_id)

    @_builtins.property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> Optional[_builtins.str]:
        """
        Availability domain of the shape.
        """
        return pulumi.get(self, "availability_domain")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="dvhHostId")
    def dvh_host_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "dvh_host_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetMigrationPlanAvailableShapeItemResult']:
        """
        Available shapes list.
        """
        return pulumi.get(self, "items")

    @_builtins.property
    @pulumi.getter(name="migrationPlanId")
    def migration_plan_id(self) -> _builtins.str:
        return pulumi.get(self, "migration_plan_id")

    @_builtins.property
    @pulumi.getter(name="reservedCapacityId")
    def reserved_capacity_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "reserved_capacity_id")


class AwaitableGetMigrationPlanAvailableShapeResult(GetMigrationPlanAvailableShapeResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetMigrationPlanAvailableShapeResult(
            availability_domain=self.availability_domain,
            compartment_id=self.compartment_id,
            dvh_host_id=self.dvh_host_id,
            id=self.id,
            items=self.items,
            migration_plan_id=self.migration_plan_id,
            reserved_capacity_id=self.reserved_capacity_id)


def get_migration_plan_available_shape(availability_domain: Optional[_builtins.str] = None,
                                       compartment_id: Optional[_builtins.str] = None,
                                       dvh_host_id: Optional[_builtins.str] = None,
                                       migration_plan_id: Optional[_builtins.str] = None,
                                       reserved_capacity_id: Optional[_builtins.str] = None,
                                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetMigrationPlanAvailableShapeResult:
    """
    This data source provides details about a specific Migration Plan Available Shape resource in Oracle Cloud Infrastructure Cloud Migrations service.

    List of shapes by parameters.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_migration_plan_available_shape = oci.CloudMigrations.get_migration_plan_available_shape(migration_plan_id=test_migration_plan["id"],
        availability_domain=migration_plan_available_shape_availability_domain,
        compartment_id=compartment_id,
        dvh_host_id=test_dvh_host["id"],
        reserved_capacity_id=test_reserved_capacity["id"])
    ```


    :param _builtins.str availability_domain: The availability domain in which to list resources.
    :param _builtins.str compartment_id: The ID of the compartment in which to list resources.
    :param _builtins.str dvh_host_id: The ID of the Dvh in which to list resources.
    :param _builtins.str migration_plan_id: Unique migration plan identifier
    :param _builtins.str reserved_capacity_id: The reserved capacity ID for which to list resources.
    """
    __args__ = dict()
    __args__['availabilityDomain'] = availability_domain
    __args__['compartmentId'] = compartment_id
    __args__['dvhHostId'] = dvh_host_id
    __args__['migrationPlanId'] = migration_plan_id
    __args__['reservedCapacityId'] = reserved_capacity_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:CloudMigrations/getMigrationPlanAvailableShape:getMigrationPlanAvailableShape', __args__, opts=opts, typ=GetMigrationPlanAvailableShapeResult).value

    return AwaitableGetMigrationPlanAvailableShapeResult(
        availability_domain=pulumi.get(__ret__, 'availability_domain'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        dvh_host_id=pulumi.get(__ret__, 'dvh_host_id'),
        id=pulumi.get(__ret__, 'id'),
        items=pulumi.get(__ret__, 'items'),
        migration_plan_id=pulumi.get(__ret__, 'migration_plan_id'),
        reserved_capacity_id=pulumi.get(__ret__, 'reserved_capacity_id'))
def get_migration_plan_available_shape_output(availability_domain: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                              compartment_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                              dvh_host_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                              migration_plan_id: Optional[pulumi.Input[_builtins.str]] = None,
                                              reserved_capacity_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                              opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetMigrationPlanAvailableShapeResult]:
    """
    This data source provides details about a specific Migration Plan Available Shape resource in Oracle Cloud Infrastructure Cloud Migrations service.

    List of shapes by parameters.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_migration_plan_available_shape = oci.CloudMigrations.get_migration_plan_available_shape(migration_plan_id=test_migration_plan["id"],
        availability_domain=migration_plan_available_shape_availability_domain,
        compartment_id=compartment_id,
        dvh_host_id=test_dvh_host["id"],
        reserved_capacity_id=test_reserved_capacity["id"])
    ```


    :param _builtins.str availability_domain: The availability domain in which to list resources.
    :param _builtins.str compartment_id: The ID of the compartment in which to list resources.
    :param _builtins.str dvh_host_id: The ID of the Dvh in which to list resources.
    :param _builtins.str migration_plan_id: Unique migration plan identifier
    :param _builtins.str reserved_capacity_id: The reserved capacity ID for which to list resources.
    """
    __args__ = dict()
    __args__['availabilityDomain'] = availability_domain
    __args__['compartmentId'] = compartment_id
    __args__['dvhHostId'] = dvh_host_id
    __args__['migrationPlanId'] = migration_plan_id
    __args__['reservedCapacityId'] = reserved_capacity_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:CloudMigrations/getMigrationPlanAvailableShape:getMigrationPlanAvailableShape', __args__, opts=opts, typ=GetMigrationPlanAvailableShapeResult)
    return __ret__.apply(lambda __response__: GetMigrationPlanAvailableShapeResult(
        availability_domain=pulumi.get(__response__, 'availability_domain'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        dvh_host_id=pulumi.get(__response__, 'dvh_host_id'),
        id=pulumi.get(__response__, 'id'),
        items=pulumi.get(__response__, 'items'),
        migration_plan_id=pulumi.get(__response__, 'migration_plan_id'),
        reserved_capacity_id=pulumi.get(__response__, 'reserved_capacity_id')))
