# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetLibraryMaskingFormatResult',
    'AwaitableGetLibraryMaskingFormatResult',
    'get_library_masking_format',
    'get_library_masking_format_output',
]

@pulumi.output_type
class GetLibraryMaskingFormatResult:
    """
    A collection of values returned by getLibraryMaskingFormat.
    """
    def __init__(__self__, compartment_id=None, defined_tags=None, description=None, display_name=None, format_entries=None, freeform_tags=None, id=None, library_masking_format_id=None, sensitive_type_ids=None, source=None, state=None, time_created=None, time_updated=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if format_entries and not isinstance(format_entries, list):
            raise TypeError("Expected argument 'format_entries' to be a list")
        pulumi.set(__self__, "format_entries", format_entries)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if library_masking_format_id and not isinstance(library_masking_format_id, str):
            raise TypeError("Expected argument 'library_masking_format_id' to be a str")
        pulumi.set(__self__, "library_masking_format_id", library_masking_format_id)
        if sensitive_type_ids and not isinstance(sensitive_type_ids, list):
            raise TypeError("Expected argument 'sensitive_type_ids' to be a list")
        pulumi.set(__self__, "sensitive_type_ids", sensitive_type_ids)
        if source and not isinstance(source, str):
            raise TypeError("Expected argument 'source' to be a str")
        pulumi.set(__self__, "source", source)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The OCID of the compartment that contains the library masking format.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, _builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm) Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The description of the format entry.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        The display name of the library masking format.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="formatEntries")
    def format_entries(self) -> Sequence['outputs.GetLibraryMaskingFormatFormatEntryResult']:
        """
        An array of format entries. The combined output of all the format entries is used for masking.
        """
        return pulumi.get(self, "format_entries")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, _builtins.str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The OCID of the library masking format.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="libraryMaskingFormatId")
    def library_masking_format_id(self) -> _builtins.str:
        """
        The OCID of the library masking format.
        """
        return pulumi.get(self, "library_masking_format_id")

    @_builtins.property
    @pulumi.getter(name="sensitiveTypeIds")
    def sensitive_type_ids(self) -> Sequence[_builtins.str]:
        """
        An array of OCIDs of the sensitive types compatible with the library masking format.
        """
        return pulumi.get(self, "sensitive_type_ids")

    @_builtins.property
    @pulumi.getter
    def source(self) -> _builtins.str:
        """
        Specifies whether the library masking format is user-defined or predefined.
        """
        return pulumi.get(self, "source")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        The current state of the library masking format.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        The date and time the library masking format was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339)
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> _builtins.str:
        """
        The date and time the library masking format was updated, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339)
        """
        return pulumi.get(self, "time_updated")


class AwaitableGetLibraryMaskingFormatResult(GetLibraryMaskingFormatResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetLibraryMaskingFormatResult(
            compartment_id=self.compartment_id,
            defined_tags=self.defined_tags,
            description=self.description,
            display_name=self.display_name,
            format_entries=self.format_entries,
            freeform_tags=self.freeform_tags,
            id=self.id,
            library_masking_format_id=self.library_masking_format_id,
            sensitive_type_ids=self.sensitive_type_ids,
            source=self.source,
            state=self.state,
            time_created=self.time_created,
            time_updated=self.time_updated)


def get_library_masking_format(library_masking_format_id: Optional[_builtins.str] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetLibraryMaskingFormatResult:
    """
    This data source provides details about a specific Library Masking Format resource in Oracle Cloud Infrastructure Data Safe service.

    Gets the details of the specified library masking format.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_library_masking_format = oci.DataSafe.get_library_masking_format(library_masking_format_id=test_library_masking_format_oci_data_safe_library_masking_format["id"])
    ```


    :param _builtins.str library_masking_format_id: The OCID of the library masking format.
    """
    __args__ = dict()
    __args__['libraryMaskingFormatId'] = library_masking_format_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DataSafe/getLibraryMaskingFormat:getLibraryMaskingFormat', __args__, opts=opts, typ=GetLibraryMaskingFormatResult).value

    return AwaitableGetLibraryMaskingFormatResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        description=pulumi.get(__ret__, 'description'),
        display_name=pulumi.get(__ret__, 'display_name'),
        format_entries=pulumi.get(__ret__, 'format_entries'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        library_masking_format_id=pulumi.get(__ret__, 'library_masking_format_id'),
        sensitive_type_ids=pulumi.get(__ret__, 'sensitive_type_ids'),
        source=pulumi.get(__ret__, 'source'),
        state=pulumi.get(__ret__, 'state'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'))
def get_library_masking_format_output(library_masking_format_id: Optional[pulumi.Input[_builtins.str]] = None,
                                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetLibraryMaskingFormatResult]:
    """
    This data source provides details about a specific Library Masking Format resource in Oracle Cloud Infrastructure Data Safe service.

    Gets the details of the specified library masking format.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_library_masking_format = oci.DataSafe.get_library_masking_format(library_masking_format_id=test_library_masking_format_oci_data_safe_library_masking_format["id"])
    ```


    :param _builtins.str library_masking_format_id: The OCID of the library masking format.
    """
    __args__ = dict()
    __args__['libraryMaskingFormatId'] = library_masking_format_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:DataSafe/getLibraryMaskingFormat:getLibraryMaskingFormat', __args__, opts=opts, typ=GetLibraryMaskingFormatResult)
    return __ret__.apply(lambda __response__: GetLibraryMaskingFormatResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        description=pulumi.get(__response__, 'description'),
        display_name=pulumi.get(__response__, 'display_name'),
        format_entries=pulumi.get(__response__, 'format_entries'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        id=pulumi.get(__response__, 'id'),
        library_masking_format_id=pulumi.get(__response__, 'library_masking_format_id'),
        sensitive_type_ids=pulumi.get(__response__, 'sensitive_type_ids'),
        source=pulumi.get(__response__, 'source'),
        state=pulumi.get(__response__, 'state'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_updated=pulumi.get(__response__, 'time_updated')))
