# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetTargetDatabaseGroupsResult',
    'AwaitableGetTargetDatabaseGroupsResult',
    'get_target_database_groups',
    'get_target_database_groups_output',
]

@pulumi.output_type
class GetTargetDatabaseGroupsResult:
    """
    A collection of values returned by getTargetDatabaseGroups.
    """
    def __init__(__self__, access_level=None, compartment_id=None, compartment_id_in_subtree=None, display_name=None, filters=None, id=None, state=None, target_database_group_collections=None, target_database_group_filter=None, target_database_group_id=None, time_created_greater_than_or_equal_to=None, time_created_less_than=None):
        if access_level and not isinstance(access_level, str):
            raise TypeError("Expected argument 'access_level' to be a str")
        pulumi.set(__self__, "access_level", access_level)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if compartment_id_in_subtree and not isinstance(compartment_id_in_subtree, bool):
            raise TypeError("Expected argument 'compartment_id_in_subtree' to be a bool")
        pulumi.set(__self__, "compartment_id_in_subtree", compartment_id_in_subtree)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if target_database_group_collections and not isinstance(target_database_group_collections, list):
            raise TypeError("Expected argument 'target_database_group_collections' to be a list")
        pulumi.set(__self__, "target_database_group_collections", target_database_group_collections)
        if target_database_group_filter and not isinstance(target_database_group_filter, str):
            raise TypeError("Expected argument 'target_database_group_filter' to be a str")
        pulumi.set(__self__, "target_database_group_filter", target_database_group_filter)
        if target_database_group_id and not isinstance(target_database_group_id, str):
            raise TypeError("Expected argument 'target_database_group_id' to be a str")
        pulumi.set(__self__, "target_database_group_id", target_database_group_id)
        if time_created_greater_than_or_equal_to and not isinstance(time_created_greater_than_or_equal_to, str):
            raise TypeError("Expected argument 'time_created_greater_than_or_equal_to' to be a str")
        pulumi.set(__self__, "time_created_greater_than_or_equal_to", time_created_greater_than_or_equal_to)
        if time_created_less_than and not isinstance(time_created_less_than, str):
            raise TypeError("Expected argument 'time_created_less_than' to be a str")
        pulumi.set(__self__, "time_created_less_than", time_created_less_than)

    @_builtins.property
    @pulumi.getter(name="accessLevel")
    def access_level(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "access_level")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The OCID for the compartment containing the target database group.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="compartmentIdInSubtree")
    def compartment_id_in_subtree(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "compartment_id_in_subtree")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[_builtins.str]:
        """
        The name of the target database group.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetTargetDatabaseGroupsFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[_builtins.str]:
        """
        The lifecycle status of the target database group.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="targetDatabaseGroupCollections")
    def target_database_group_collections(self) -> Sequence['outputs.GetTargetDatabaseGroupsTargetDatabaseGroupCollectionResult']:
        """
        The list of target_database_group_collection.
        """
        return pulumi.get(self, "target_database_group_collections")

    @_builtins.property
    @pulumi.getter(name="targetDatabaseGroupFilter")
    def target_database_group_filter(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "target_database_group_filter")

    @_builtins.property
    @pulumi.getter(name="targetDatabaseGroupId")
    def target_database_group_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "target_database_group_id")

    @_builtins.property
    @pulumi.getter(name="timeCreatedGreaterThanOrEqualTo")
    def time_created_greater_than_or_equal_to(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "time_created_greater_than_or_equal_to")

    @_builtins.property
    @pulumi.getter(name="timeCreatedLessThan")
    def time_created_less_than(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "time_created_less_than")


class AwaitableGetTargetDatabaseGroupsResult(GetTargetDatabaseGroupsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetTargetDatabaseGroupsResult(
            access_level=self.access_level,
            compartment_id=self.compartment_id,
            compartment_id_in_subtree=self.compartment_id_in_subtree,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            state=self.state,
            target_database_group_collections=self.target_database_group_collections,
            target_database_group_filter=self.target_database_group_filter,
            target_database_group_id=self.target_database_group_id,
            time_created_greater_than_or_equal_to=self.time_created_greater_than_or_equal_to,
            time_created_less_than=self.time_created_less_than)


def get_target_database_groups(access_level: Optional[_builtins.str] = None,
                               compartment_id: Optional[_builtins.str] = None,
                               compartment_id_in_subtree: Optional[_builtins.bool] = None,
                               display_name: Optional[_builtins.str] = None,
                               filters: Optional[Sequence[Union['GetTargetDatabaseGroupsFilterArgs', 'GetTargetDatabaseGroupsFilterArgsDict']]] = None,
                               state: Optional[_builtins.str] = None,
                               target_database_group_filter: Optional[_builtins.str] = None,
                               target_database_group_id: Optional[_builtins.str] = None,
                               time_created_greater_than_or_equal_to: Optional[_builtins.str] = None,
                               time_created_less_than: Optional[_builtins.str] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetTargetDatabaseGroupsResult:
    """
    This data source provides the list of Target Database Groups in Oracle Cloud Infrastructure Data Safe service.

    Retrieves a list of target database groups according to the specified query parameters.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_target_database_groups = oci.DataSafe.get_target_database_groups(compartment_id=compartment_id,
        access_level=target_database_group_access_level,
        compartment_id_in_subtree=target_database_group_compartment_id_in_subtree,
        display_name=target_database_group_display_name,
        state=target_database_group_state,
        target_database_group_id=test_target_database_group["id"],
        target_database_group_filter=target_database_group_target_database_group_filter,
        time_created_greater_than_or_equal_to=target_database_group_time_created_greater_than_or_equal_to,
        time_created_less_than=target_database_group_time_created_less_than)
    ```


    :param _builtins.str access_level: Valid values are RESTRICTED and ACCESSIBLE. Default is RESTRICTED. Setting this to ACCESSIBLE returns only those compartments for which the user has INSPECT permissions directly or indirectly (permissions can be on a resource in a subcompartment). When set to RESTRICTED permissions are checked and no partial results are displayed.
    :param _builtins.str compartment_id: A filter to return only resources that match the specified compartment OCID.
    :param _builtins.bool compartment_id_in_subtree: Default is false. When set to true, the hierarchy of compartments is traversed and all compartments and subcompartments in the tenancy are returned. Depends on the 'accessLevel' setting.
    :param _builtins.str display_name: A filter to return only resources that match the specified display name.
    :param _builtins.str state: A filter to retrieve resources that exclusively align with the designated lifecycle state.
    :param _builtins.str target_database_group_filter: The scim query filter parameter accepts filter expressions that use the syntax described in Section 3.2.2.2 of the System for Cross-Domain Identity Management (SCIM) specification, which is available at [RFC3339](https://tools.ietf.org/html/draft-ietf-scim-api-12). In SCIM filtering expressions, text, date, and time values must be enclosed in quotation marks, with date and time values using ISO-8601 format. (Numeric and boolean values should not be quoted.) Ex:** filter=(targetDatabaseId eq 'ocid1.datasafetargetdatabase.oc1.iad.abuwcljr3u2va4ba5wek53idpe5qq5kkbigzclscc6mysfecxzjt5dgmxqza')
    :param _builtins.str target_database_group_id: A filter to return the target database group that matches the specified OCID.
    :param _builtins.str time_created_greater_than_or_equal_to: A filter to return only the resources that were created after the specified date and time, as defined by [RFC3339](https://tools.ietf.org/html/rfc3339). Using TimeCreatedGreaterThanOrEqualToQueryParam parameter retrieves all resources created after that date.
           
           **Example:** 2016-12-19T16:39:57.600Z
    :param _builtins.str time_created_less_than: Search for resources that were created before a specific date. Specifying this parameter corresponding `timeCreatedLessThan` parameter will retrieve all resources created before the specified created date, in "YYYY-MM-ddThh:mmZ" format with a Z offset, as defined by RFC 3339.
           
           **Example:** 2016-12-19T16:39:57.600Z
    """
    __args__ = dict()
    __args__['accessLevel'] = access_level
    __args__['compartmentId'] = compartment_id
    __args__['compartmentIdInSubtree'] = compartment_id_in_subtree
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['state'] = state
    __args__['targetDatabaseGroupFilter'] = target_database_group_filter
    __args__['targetDatabaseGroupId'] = target_database_group_id
    __args__['timeCreatedGreaterThanOrEqualTo'] = time_created_greater_than_or_equal_to
    __args__['timeCreatedLessThan'] = time_created_less_than
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DataSafe/getTargetDatabaseGroups:getTargetDatabaseGroups', __args__, opts=opts, typ=GetTargetDatabaseGroupsResult).value

    return AwaitableGetTargetDatabaseGroupsResult(
        access_level=pulumi.get(__ret__, 'access_level'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        compartment_id_in_subtree=pulumi.get(__ret__, 'compartment_id_in_subtree'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        state=pulumi.get(__ret__, 'state'),
        target_database_group_collections=pulumi.get(__ret__, 'target_database_group_collections'),
        target_database_group_filter=pulumi.get(__ret__, 'target_database_group_filter'),
        target_database_group_id=pulumi.get(__ret__, 'target_database_group_id'),
        time_created_greater_than_or_equal_to=pulumi.get(__ret__, 'time_created_greater_than_or_equal_to'),
        time_created_less_than=pulumi.get(__ret__, 'time_created_less_than'))
def get_target_database_groups_output(access_level: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                      compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                                      compartment_id_in_subtree: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                                      display_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                      filters: Optional[pulumi.Input[Optional[Sequence[Union['GetTargetDatabaseGroupsFilterArgs', 'GetTargetDatabaseGroupsFilterArgsDict']]]]] = None,
                                      state: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                      target_database_group_filter: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                      target_database_group_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                      time_created_greater_than_or_equal_to: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                      time_created_less_than: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetTargetDatabaseGroupsResult]:
    """
    This data source provides the list of Target Database Groups in Oracle Cloud Infrastructure Data Safe service.

    Retrieves a list of target database groups according to the specified query parameters.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_target_database_groups = oci.DataSafe.get_target_database_groups(compartment_id=compartment_id,
        access_level=target_database_group_access_level,
        compartment_id_in_subtree=target_database_group_compartment_id_in_subtree,
        display_name=target_database_group_display_name,
        state=target_database_group_state,
        target_database_group_id=test_target_database_group["id"],
        target_database_group_filter=target_database_group_target_database_group_filter,
        time_created_greater_than_or_equal_to=target_database_group_time_created_greater_than_or_equal_to,
        time_created_less_than=target_database_group_time_created_less_than)
    ```


    :param _builtins.str access_level: Valid values are RESTRICTED and ACCESSIBLE. Default is RESTRICTED. Setting this to ACCESSIBLE returns only those compartments for which the user has INSPECT permissions directly or indirectly (permissions can be on a resource in a subcompartment). When set to RESTRICTED permissions are checked and no partial results are displayed.
    :param _builtins.str compartment_id: A filter to return only resources that match the specified compartment OCID.
    :param _builtins.bool compartment_id_in_subtree: Default is false. When set to true, the hierarchy of compartments is traversed and all compartments and subcompartments in the tenancy are returned. Depends on the 'accessLevel' setting.
    :param _builtins.str display_name: A filter to return only resources that match the specified display name.
    :param _builtins.str state: A filter to retrieve resources that exclusively align with the designated lifecycle state.
    :param _builtins.str target_database_group_filter: The scim query filter parameter accepts filter expressions that use the syntax described in Section 3.2.2.2 of the System for Cross-Domain Identity Management (SCIM) specification, which is available at [RFC3339](https://tools.ietf.org/html/draft-ietf-scim-api-12). In SCIM filtering expressions, text, date, and time values must be enclosed in quotation marks, with date and time values using ISO-8601 format. (Numeric and boolean values should not be quoted.) Ex:** filter=(targetDatabaseId eq 'ocid1.datasafetargetdatabase.oc1.iad.abuwcljr3u2va4ba5wek53idpe5qq5kkbigzclscc6mysfecxzjt5dgmxqza')
    :param _builtins.str target_database_group_id: A filter to return the target database group that matches the specified OCID.
    :param _builtins.str time_created_greater_than_or_equal_to: A filter to return only the resources that were created after the specified date and time, as defined by [RFC3339](https://tools.ietf.org/html/rfc3339). Using TimeCreatedGreaterThanOrEqualToQueryParam parameter retrieves all resources created after that date.
           
           **Example:** 2016-12-19T16:39:57.600Z
    :param _builtins.str time_created_less_than: Search for resources that were created before a specific date. Specifying this parameter corresponding `timeCreatedLessThan` parameter will retrieve all resources created before the specified created date, in "YYYY-MM-ddThh:mmZ" format with a Z offset, as defined by RFC 3339.
           
           **Example:** 2016-12-19T16:39:57.600Z
    """
    __args__ = dict()
    __args__['accessLevel'] = access_level
    __args__['compartmentId'] = compartment_id
    __args__['compartmentIdInSubtree'] = compartment_id_in_subtree
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['state'] = state
    __args__['targetDatabaseGroupFilter'] = target_database_group_filter
    __args__['targetDatabaseGroupId'] = target_database_group_id
    __args__['timeCreatedGreaterThanOrEqualTo'] = time_created_greater_than_or_equal_to
    __args__['timeCreatedLessThan'] = time_created_less_than
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:DataSafe/getTargetDatabaseGroups:getTargetDatabaseGroups', __args__, opts=opts, typ=GetTargetDatabaseGroupsResult)
    return __ret__.apply(lambda __response__: GetTargetDatabaseGroupsResult(
        access_level=pulumi.get(__response__, 'access_level'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        compartment_id_in_subtree=pulumi.get(__response__, 'compartment_id_in_subtree'),
        display_name=pulumi.get(__response__, 'display_name'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        state=pulumi.get(__response__, 'state'),
        target_database_group_collections=pulumi.get(__response__, 'target_database_group_collections'),
        target_database_group_filter=pulumi.get(__response__, 'target_database_group_filter'),
        target_database_group_id=pulumi.get(__response__, 'target_database_group_id'),
        time_created_greater_than_or_equal_to=pulumi.get(__response__, 'time_created_greater_than_or_equal_to'),
        time_created_less_than=pulumi.get(__response__, 'time_created_less_than')))
