# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SecurityPolicyConfigArgs', 'SecurityPolicyConfig']

@pulumi.input_type
class SecurityPolicyConfigArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[_builtins.str],
                 security_policy_id: pulumi.Input[_builtins.str],
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 firewall_config: Optional[pulumi.Input['SecurityPolicyConfigFirewallConfigArgs']] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 unified_audit_policy_config: Optional[pulumi.Input['SecurityPolicyConfigUnifiedAuditPolicyConfigArgs']] = None):
        """
        The set of arguments for constructing a SecurityPolicyConfig resource.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The OCID of the compartment containing the security policy configuration.
        :param pulumi.Input[_builtins.str] security_policy_id: The OCID of the security policy corresponding to the security policy configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm) Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[_builtins.str] description: (Updatable) The description of the security policy.
        :param pulumi.Input[_builtins.str] display_name: (Updatable) The display name of the security policy configuration. The name does not have to be unique, and it is changeable.
        :param pulumi.Input['SecurityPolicyConfigFirewallConfigArgs'] firewall_config: (Updatable) Details to update the SQL Firewall configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        :param pulumi.Input['SecurityPolicyConfigUnifiedAuditPolicyConfigArgs'] unified_audit_policy_config: (Updatable) The unified audit policy related configurations.
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "security_policy_id", security_policy_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if firewall_config is not None:
            pulumi.set(__self__, "firewall_config", firewall_config)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if unified_audit_policy_config is not None:
            pulumi.set(__self__, "unified_audit_policy_config", unified_audit_policy_config)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) The OCID of the compartment containing the security policy configuration.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="securityPolicyId")
    def security_policy_id(self) -> pulumi.Input[_builtins.str]:
        """
        The OCID of the security policy corresponding to the security policy configuration.
        """
        return pulumi.get(self, "security_policy_id")

    @security_policy_id.setter
    def security_policy_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "security_policy_id", value)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm) Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The description of the security policy.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The display name of the security policy configuration. The name does not have to be unique, and it is changeable.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="firewallConfig")
    def firewall_config(self) -> Optional[pulumi.Input['SecurityPolicyConfigFirewallConfigArgs']]:
        """
        (Updatable) Details to update the SQL Firewall configuration.
        """
        return pulumi.get(self, "firewall_config")

    @firewall_config.setter
    def firewall_config(self, value: Optional[pulumi.Input['SecurityPolicyConfigFirewallConfigArgs']]):
        pulumi.set(self, "firewall_config", value)

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @_builtins.property
    @pulumi.getter(name="unifiedAuditPolicyConfig")
    def unified_audit_policy_config(self) -> Optional[pulumi.Input['SecurityPolicyConfigUnifiedAuditPolicyConfigArgs']]:
        """
        (Updatable) The unified audit policy related configurations.
        """
        return pulumi.get(self, "unified_audit_policy_config")

    @unified_audit_policy_config.setter
    def unified_audit_policy_config(self, value: Optional[pulumi.Input['SecurityPolicyConfigUnifiedAuditPolicyConfigArgs']]):
        pulumi.set(self, "unified_audit_policy_config", value)


@pulumi.input_type
class _SecurityPolicyConfigState:
    def __init__(__self__, *,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 firewall_config: Optional[pulumi.Input['SecurityPolicyConfigFirewallConfigArgs']] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 lifecycle_details: Optional[pulumi.Input[_builtins.str]] = None,
                 security_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 time_created: Optional[pulumi.Input[_builtins.str]] = None,
                 time_updated: Optional[pulumi.Input[_builtins.str]] = None,
                 unified_audit_policy_config: Optional[pulumi.Input['SecurityPolicyConfigUnifiedAuditPolicyConfigArgs']] = None):
        """
        Input properties used for looking up and filtering SecurityPolicyConfig resources.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The OCID of the compartment containing the security policy configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm) Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[_builtins.str] description: (Updatable) The description of the security policy.
        :param pulumi.Input[_builtins.str] display_name: (Updatable) The display name of the security policy configuration. The name does not have to be unique, and it is changeable.
        :param pulumi.Input['SecurityPolicyConfigFirewallConfigArgs'] firewall_config: (Updatable) Details to update the SQL Firewall configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        :param pulumi.Input[_builtins.str] lifecycle_details: Details about the current state of the security policy configuration.
        :param pulumi.Input[_builtins.str] security_policy_id: The OCID of the security policy corresponding to the security policy configuration.
        :param pulumi.Input[_builtins.str] state: The current state of the security policy configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see Resource Tags. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[_builtins.str] time_created: The time the security policy configuration was created, in the format defined by RFC3339.
        :param pulumi.Input[_builtins.str] time_updated: The date and time the security policy configuration was last updated, in the format defined by RFC3339.
        :param pulumi.Input['SecurityPolicyConfigUnifiedAuditPolicyConfigArgs'] unified_audit_policy_config: (Updatable) The unified audit policy related configurations.
        """
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if firewall_config is not None:
            pulumi.set(__self__, "firewall_config", firewall_config)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if security_policy_id is not None:
            pulumi.set(__self__, "security_policy_id", security_policy_id)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)
        if unified_audit_policy_config is not None:
            pulumi.set(__self__, "unified_audit_policy_config", unified_audit_policy_config)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The OCID of the compartment containing the security policy configuration.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm) Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The description of the security policy.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The display name of the security policy configuration. The name does not have to be unique, and it is changeable.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="firewallConfig")
    def firewall_config(self) -> Optional[pulumi.Input['SecurityPolicyConfigFirewallConfigArgs']]:
        """
        (Updatable) Details to update the SQL Firewall configuration.
        """
        return pulumi.get(self, "firewall_config")

    @firewall_config.setter
    def firewall_config(self, value: Optional[pulumi.Input['SecurityPolicyConfigFirewallConfigArgs']]):
        pulumi.set(self, "firewall_config", value)

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Details about the current state of the security policy configuration.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "lifecycle_details", value)

    @_builtins.property
    @pulumi.getter(name="securityPolicyId")
    def security_policy_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The OCID of the security policy corresponding to the security policy configuration.
        """
        return pulumi.get(self, "security_policy_id")

    @security_policy_id.setter
    def security_policy_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "security_policy_id", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The current state of the security policy configuration.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see Resource Tags. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "system_tags", value)

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time the security policy configuration was created, in the format defined by RFC3339.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_created", value)

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time the security policy configuration was last updated, in the format defined by RFC3339.
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_updated", value)

    @_builtins.property
    @pulumi.getter(name="unifiedAuditPolicyConfig")
    def unified_audit_policy_config(self) -> Optional[pulumi.Input['SecurityPolicyConfigUnifiedAuditPolicyConfigArgs']]:
        """
        (Updatable) The unified audit policy related configurations.
        """
        return pulumi.get(self, "unified_audit_policy_config")

    @unified_audit_policy_config.setter
    def unified_audit_policy_config(self, value: Optional[pulumi.Input['SecurityPolicyConfigUnifiedAuditPolicyConfigArgs']]):
        pulumi.set(self, "unified_audit_policy_config", value)


@pulumi.type_token("oci:DataSafe/securityPolicyConfig:SecurityPolicyConfig")
class SecurityPolicyConfig(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 firewall_config: Optional[pulumi.Input[Union['SecurityPolicyConfigFirewallConfigArgs', 'SecurityPolicyConfigFirewallConfigArgsDict']]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 security_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 unified_audit_policy_config: Optional[pulumi.Input[Union['SecurityPolicyConfigUnifiedAuditPolicyConfigArgs', 'SecurityPolicyConfigUnifiedAuditPolicyConfigArgsDict']]] = None,
                 __props__=None):
        """
        This resource provides the Security Policy Config resource in Oracle Cloud Infrastructure Data Safe service.

        Creates a new security policy configuration resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_security_policy_config = oci.datasafe.SecurityPolicyConfig("test_security_policy_config",
            compartment_id=compartment_id,
            security_policy_id=test_security_policy["id"],
            defined_tags={
                "Operations.CostCenter": "42",
            },
            description=security_policy_config_description,
            display_name=security_policy_config_display_name,
            firewall_config={
                "exclude_job": security_policy_config_firewall_config_exclude_job,
                "status": security_policy_config_firewall_config_status,
                "violation_log_auto_purge": security_policy_config_firewall_config_violation_log_auto_purge,
            },
            freeform_tags={
                "Department": "Finance",
            },
            unified_audit_policy_config={
                "exclude_datasafe_user": security_policy_config_unified_audit_policy_config_exclude_datasafe_user,
            })
        ```

        ## Import

        SecurityPolicyConfigs can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:DataSafe/securityPolicyConfig:SecurityPolicyConfig test_security_policy_config "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The OCID of the compartment containing the security policy configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm) Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[_builtins.str] description: (Updatable) The description of the security policy.
        :param pulumi.Input[_builtins.str] display_name: (Updatable) The display name of the security policy configuration. The name does not have to be unique, and it is changeable.
        :param pulumi.Input[Union['SecurityPolicyConfigFirewallConfigArgs', 'SecurityPolicyConfigFirewallConfigArgsDict']] firewall_config: (Updatable) Details to update the SQL Firewall configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        :param pulumi.Input[_builtins.str] security_policy_id: The OCID of the security policy corresponding to the security policy configuration.
        :param pulumi.Input[Union['SecurityPolicyConfigUnifiedAuditPolicyConfigArgs', 'SecurityPolicyConfigUnifiedAuditPolicyConfigArgsDict']] unified_audit_policy_config: (Updatable) The unified audit policy related configurations.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SecurityPolicyConfigArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Security Policy Config resource in Oracle Cloud Infrastructure Data Safe service.

        Creates a new security policy configuration resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_security_policy_config = oci.datasafe.SecurityPolicyConfig("test_security_policy_config",
            compartment_id=compartment_id,
            security_policy_id=test_security_policy["id"],
            defined_tags={
                "Operations.CostCenter": "42",
            },
            description=security_policy_config_description,
            display_name=security_policy_config_display_name,
            firewall_config={
                "exclude_job": security_policy_config_firewall_config_exclude_job,
                "status": security_policy_config_firewall_config_status,
                "violation_log_auto_purge": security_policy_config_firewall_config_violation_log_auto_purge,
            },
            freeform_tags={
                "Department": "Finance",
            },
            unified_audit_policy_config={
                "exclude_datasafe_user": security_policy_config_unified_audit_policy_config_exclude_datasafe_user,
            })
        ```

        ## Import

        SecurityPolicyConfigs can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:DataSafe/securityPolicyConfig:SecurityPolicyConfig test_security_policy_config "id"
        ```

        :param str resource_name: The name of the resource.
        :param SecurityPolicyConfigArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SecurityPolicyConfigArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 firewall_config: Optional[pulumi.Input[Union['SecurityPolicyConfigFirewallConfigArgs', 'SecurityPolicyConfigFirewallConfigArgsDict']]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 security_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 unified_audit_policy_config: Optional[pulumi.Input[Union['SecurityPolicyConfigUnifiedAuditPolicyConfigArgs', 'SecurityPolicyConfigUnifiedAuditPolicyConfigArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SecurityPolicyConfigArgs.__new__(SecurityPolicyConfigArgs)

            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["description"] = description
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["firewall_config"] = firewall_config
            __props__.__dict__["freeform_tags"] = freeform_tags
            if security_policy_id is None and not opts.urn:
                raise TypeError("Missing required property 'security_policy_id'")
            __props__.__dict__["security_policy_id"] = security_policy_id
            __props__.__dict__["unified_audit_policy_config"] = unified_audit_policy_config
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
        super(SecurityPolicyConfig, __self__).__init__(
            'oci:DataSafe/securityPolicyConfig:SecurityPolicyConfig',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            firewall_config: Optional[pulumi.Input[Union['SecurityPolicyConfigFirewallConfigArgs', 'SecurityPolicyConfigFirewallConfigArgsDict']]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            lifecycle_details: Optional[pulumi.Input[_builtins.str]] = None,
            security_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            time_created: Optional[pulumi.Input[_builtins.str]] = None,
            time_updated: Optional[pulumi.Input[_builtins.str]] = None,
            unified_audit_policy_config: Optional[pulumi.Input[Union['SecurityPolicyConfigUnifiedAuditPolicyConfigArgs', 'SecurityPolicyConfigUnifiedAuditPolicyConfigArgsDict']]] = None) -> 'SecurityPolicyConfig':
        """
        Get an existing SecurityPolicyConfig resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The OCID of the compartment containing the security policy configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm) Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[_builtins.str] description: (Updatable) The description of the security policy.
        :param pulumi.Input[_builtins.str] display_name: (Updatable) The display name of the security policy configuration. The name does not have to be unique, and it is changeable.
        :param pulumi.Input[Union['SecurityPolicyConfigFirewallConfigArgs', 'SecurityPolicyConfigFirewallConfigArgsDict']] firewall_config: (Updatable) Details to update the SQL Firewall configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        :param pulumi.Input[_builtins.str] lifecycle_details: Details about the current state of the security policy configuration.
        :param pulumi.Input[_builtins.str] security_policy_id: The OCID of the security policy corresponding to the security policy configuration.
        :param pulumi.Input[_builtins.str] state: The current state of the security policy configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see Resource Tags. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[_builtins.str] time_created: The time the security policy configuration was created, in the format defined by RFC3339.
        :param pulumi.Input[_builtins.str] time_updated: The date and time the security policy configuration was last updated, in the format defined by RFC3339.
        :param pulumi.Input[Union['SecurityPolicyConfigUnifiedAuditPolicyConfigArgs', 'SecurityPolicyConfigUnifiedAuditPolicyConfigArgsDict']] unified_audit_policy_config: (Updatable) The unified audit policy related configurations.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SecurityPolicyConfigState.__new__(_SecurityPolicyConfigState)

        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["firewall_config"] = firewall_config
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["security_policy_id"] = security_policy_id
        __props__.__dict__["state"] = state
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        __props__.__dict__["unified_audit_policy_config"] = unified_audit_policy_config
        return SecurityPolicyConfig(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The OCID of the compartment containing the security policy configuration.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm) Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The description of the security policy.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The display name of the security policy configuration. The name does not have to be unique, and it is changeable.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="firewallConfig")
    def firewall_config(self) -> pulumi.Output['outputs.SecurityPolicyConfigFirewallConfig']:
        """
        (Updatable) Details to update the SQL Firewall configuration.
        """
        return pulumi.get(self, "firewall_config")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[_builtins.str]:
        """
        Details about the current state of the security policy configuration.
        """
        return pulumi.get(self, "lifecycle_details")

    @_builtins.property
    @pulumi.getter(name="securityPolicyId")
    def security_policy_id(self) -> pulumi.Output[_builtins.str]:
        """
        The OCID of the security policy corresponding to the security policy configuration.
        """
        return pulumi.get(self, "security_policy_id")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        The current state of the security policy configuration.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see Resource Tags. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[_builtins.str]:
        """
        The time the security policy configuration was created, in the format defined by RFC3339.
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time the security policy configuration was last updated, in the format defined by RFC3339.
        """
        return pulumi.get(self, "time_updated")

    @_builtins.property
    @pulumi.getter(name="unifiedAuditPolicyConfig")
    def unified_audit_policy_config(self) -> pulumi.Output['outputs.SecurityPolicyConfigUnifiedAuditPolicyConfig']:
        """
        (Updatable) The unified audit policy related configurations.
        """
        return pulumi.get(self, "unified_audit_policy_config")

