# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['PatchArgs', 'Patch']

@pulumi.input_type
class PatchArgs:
    def __init__(__self__, *,
                 artifact_details: pulumi.Input['PatchArtifactDetailsArgs'],
                 compartment_id: pulumi.Input[_builtins.str],
                 patch_type: pulumi.Input['PatchPatchTypeArgs'],
                 product: pulumi.Input['PatchProductArgs'],
                 severity: pulumi.Input[_builtins.str],
                 time_released: pulumi.Input[_builtins.str],
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 dependent_patches: Optional[pulumi.Input[Sequence[pulumi.Input['PatchDependentPatchArgs']]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Patch resource.
        :param pulumi.Input['PatchArtifactDetailsArgs'] artifact_details: (Updatable) Patch artifact description and content details.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable)
        :param pulumi.Input['PatchPatchTypeArgs'] patch_type: (Updatable) Patch Type
        :param pulumi.Input['PatchProductArgs'] product: (Updatable) Product
        :param pulumi.Input[_builtins.str] severity: (Updatable) Patch Severity.
        :param pulumi.Input[_builtins.str] time_released: (Updatable) Date when the patch was released.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[Sequence[pulumi.Input['PatchDependentPatchArgs']]] dependent_patches: (Updatable) Dependent Patches for this patch.
        :param pulumi.Input[_builtins.str] description: (Updatable) A user-friendly description. To provide some insight about the resource. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[_builtins.str] name: A user-friendly name. Should be unique within the tenancy, and cannot be changed after creation.  Avoid entering confidential information.
        """
        pulumi.set(__self__, "artifact_details", artifact_details)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "patch_type", patch_type)
        pulumi.set(__self__, "product", product)
        pulumi.set(__self__, "severity", severity)
        pulumi.set(__self__, "time_released", time_released)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if dependent_patches is not None:
            pulumi.set(__self__, "dependent_patches", dependent_patches)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="artifactDetails")
    def artifact_details(self) -> pulumi.Input['PatchArtifactDetailsArgs']:
        """
        (Updatable) Patch artifact description and content details.
        """
        return pulumi.get(self, "artifact_details")

    @artifact_details.setter
    def artifact_details(self, value: pulumi.Input['PatchArtifactDetailsArgs']):
        pulumi.set(self, "artifact_details", value)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable)
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="patchType")
    def patch_type(self) -> pulumi.Input['PatchPatchTypeArgs']:
        """
        (Updatable) Patch Type
        """
        return pulumi.get(self, "patch_type")

    @patch_type.setter
    def patch_type(self, value: pulumi.Input['PatchPatchTypeArgs']):
        pulumi.set(self, "patch_type", value)

    @_builtins.property
    @pulumi.getter
    def product(self) -> pulumi.Input['PatchProductArgs']:
        """
        (Updatable) Product
        """
        return pulumi.get(self, "product")

    @product.setter
    def product(self, value: pulumi.Input['PatchProductArgs']):
        pulumi.set(self, "product", value)

    @_builtins.property
    @pulumi.getter
    def severity(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) Patch Severity.
        """
        return pulumi.get(self, "severity")

    @severity.setter
    def severity(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "severity", value)

    @_builtins.property
    @pulumi.getter(name="timeReleased")
    def time_released(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) Date when the patch was released.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "time_released")

    @time_released.setter
    def time_released(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "time_released", value)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @_builtins.property
    @pulumi.getter(name="dependentPatches")
    def dependent_patches(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PatchDependentPatchArgs']]]]:
        """
        (Updatable) Dependent Patches for this patch.
        """
        return pulumi.get(self, "dependent_patches")

    @dependent_patches.setter
    def dependent_patches(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PatchDependentPatchArgs']]]]):
        pulumi.set(self, "dependent_patches", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) A user-friendly description. To provide some insight about the resource. Avoid entering confidential information.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A user-friendly name. Should be unique within the tenancy, and cannot be changed after creation.  Avoid entering confidential information.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _PatchState:
    def __init__(__self__, *,
                 artifact_details: Optional[pulumi.Input['PatchArtifactDetailsArgs']] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 dependent_patches: Optional[pulumi.Input[Sequence[pulumi.Input['PatchDependentPatchArgs']]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 lifecycle_details: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 patch_type: Optional[pulumi.Input['PatchPatchTypeArgs']] = None,
                 product: Optional[pulumi.Input['PatchProductArgs']] = None,
                 resource_region: Optional[pulumi.Input[_builtins.str]] = None,
                 severity: Optional[pulumi.Input[_builtins.str]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 time_created: Optional[pulumi.Input[_builtins.str]] = None,
                 time_released: Optional[pulumi.Input[_builtins.str]] = None,
                 time_updated: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Patch resources.
        :param pulumi.Input['PatchArtifactDetailsArgs'] artifact_details: (Updatable) Patch artifact description and content details.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable)
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[Sequence[pulumi.Input['PatchDependentPatchArgs']]] dependent_patches: (Updatable) Dependent Patches for this patch.
        :param pulumi.Input[_builtins.str] description: (Updatable) A user-friendly description. To provide some insight about the resource. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[_builtins.str] lifecycle_details: A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        :param pulumi.Input[_builtins.str] name: A user-friendly name. Should be unique within the tenancy, and cannot be changed after creation.  Avoid entering confidential information.
        :param pulumi.Input['PatchPatchTypeArgs'] patch_type: (Updatable) Patch Type
        :param pulumi.Input['PatchProductArgs'] product: (Updatable) Product
        :param pulumi.Input[_builtins.str] resource_region: Associated region
        :param pulumi.Input[_builtins.str] severity: (Updatable) Patch Severity.
        :param pulumi.Input[_builtins.str] state: The current state of the Patch.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[_builtins.str] time_created: The time this resource was created. An RFC3339 formatted datetime string.
        :param pulumi.Input[_builtins.str] time_released: (Updatable) Date when the patch was released.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.str] time_updated: The time this resource was last updated. An RFC3339 formatted datetime string.
        :param pulumi.Input[_builtins.str] type: Provide information on who defined the patch. Example: For Custom Patches the value will be USER_DEFINED For Oracle Defined Patches the value will be ORACLE_DEFINED
        """
        if artifact_details is not None:
            pulumi.set(__self__, "artifact_details", artifact_details)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if dependent_patches is not None:
            pulumi.set(__self__, "dependent_patches", dependent_patches)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if patch_type is not None:
            pulumi.set(__self__, "patch_type", patch_type)
        if product is not None:
            pulumi.set(__self__, "product", product)
        if resource_region is not None:
            pulumi.set(__self__, "resource_region", resource_region)
        if severity is not None:
            pulumi.set(__self__, "severity", severity)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_released is not None:
            pulumi.set(__self__, "time_released", time_released)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="artifactDetails")
    def artifact_details(self) -> Optional[pulumi.Input['PatchArtifactDetailsArgs']]:
        """
        (Updatable) Patch artifact description and content details.
        """
        return pulumi.get(self, "artifact_details")

    @artifact_details.setter
    def artifact_details(self, value: Optional[pulumi.Input['PatchArtifactDetailsArgs']]):
        pulumi.set(self, "artifact_details", value)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable)
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @_builtins.property
    @pulumi.getter(name="dependentPatches")
    def dependent_patches(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PatchDependentPatchArgs']]]]:
        """
        (Updatable) Dependent Patches for this patch.
        """
        return pulumi.get(self, "dependent_patches")

    @dependent_patches.setter
    def dependent_patches(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PatchDependentPatchArgs']]]]):
        pulumi.set(self, "dependent_patches", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) A user-friendly description. To provide some insight about the resource. Avoid entering confidential information.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "lifecycle_details", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A user-friendly name. Should be unique within the tenancy, and cannot be changed after creation.  Avoid entering confidential information.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="patchType")
    def patch_type(self) -> Optional[pulumi.Input['PatchPatchTypeArgs']]:
        """
        (Updatable) Patch Type
        """
        return pulumi.get(self, "patch_type")

    @patch_type.setter
    def patch_type(self, value: Optional[pulumi.Input['PatchPatchTypeArgs']]):
        pulumi.set(self, "patch_type", value)

    @_builtins.property
    @pulumi.getter
    def product(self) -> Optional[pulumi.Input['PatchProductArgs']]:
        """
        (Updatable) Product
        """
        return pulumi.get(self, "product")

    @product.setter
    def product(self, value: Optional[pulumi.Input['PatchProductArgs']]):
        pulumi.set(self, "product", value)

    @_builtins.property
    @pulumi.getter(name="resourceRegion")
    def resource_region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Associated region
        """
        return pulumi.get(self, "resource_region")

    @resource_region.setter
    def resource_region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_region", value)

    @_builtins.property
    @pulumi.getter
    def severity(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Patch Severity.
        """
        return pulumi.get(self, "severity")

    @severity.setter
    def severity(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "severity", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The current state of the Patch.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "system_tags", value)

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time this resource was created. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_created", value)

    @_builtins.property
    @pulumi.getter(name="timeReleased")
    def time_released(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Date when the patch was released.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "time_released")

    @time_released.setter
    def time_released(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_released", value)

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time this resource was last updated. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_updated", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Provide information on who defined the patch. Example: For Custom Patches the value will be USER_DEFINED For Oracle Defined Patches the value will be ORACLE_DEFINED
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.type_token("oci:FleetAppsManagement/patch:Patch")
class Patch(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 artifact_details: Optional[pulumi.Input[Union['PatchArtifactDetailsArgs', 'PatchArtifactDetailsArgsDict']]] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 dependent_patches: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PatchDependentPatchArgs', 'PatchDependentPatchArgsDict']]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 patch_type: Optional[pulumi.Input[Union['PatchPatchTypeArgs', 'PatchPatchTypeArgsDict']]] = None,
                 product: Optional[pulumi.Input[Union['PatchProductArgs', 'PatchProductArgsDict']]] = None,
                 severity: Optional[pulumi.Input[_builtins.str]] = None,
                 time_released: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        This resource provides the Patch resource in Oracle Cloud Infrastructure Fleet Apps Management service.

        Creates a new Patch.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_patch = oci.fleetappsmanagement.Patch("test_patch",
            artifact_details={
                "category": patch_artifact_details_category,
                "artifact": {
                    "content": {
                        "bucket": patch_artifact_details_artifact_content_bucket,
                        "checksum": patch_artifact_details_artifact_content_checksum,
                        "namespace": patch_artifact_details_artifact_content_namespace,
                        "object": patch_artifact_details_artifact_content_object,
                        "source_type": patch_artifact_details_artifact_content_source_type,
                    },
                },
                "artifacts": [{
                    "architecture": patch_artifact_details_artifacts_architecture,
                    "content": {
                        "bucket": patch_artifact_details_artifacts_content_bucket,
                        "checksum": patch_artifact_details_artifacts_content_checksum,
                        "namespace": patch_artifact_details_artifacts_content_namespace,
                        "object": patch_artifact_details_artifacts_content_object,
                        "source_type": patch_artifact_details_artifacts_content_source_type,
                    },
                    "os_type": patch_artifact_details_artifacts_os_type,
                }],
            },
            compartment_id=compartment_id,
            name=patch_name,
            patch_type={
                "platform_configuration_id": test_platform_configuration["id"],
            },
            product={
                "platform_configuration_id": test_platform_configuration["id"],
                "version": patch_product_version,
            },
            severity=patch_severity,
            time_released=patch_time_released,
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            dependent_patches=[{
                "id": patch_dependent_patches_id,
            }],
            description=patch_description,
            freeform_tags={
                "bar-key": "value",
            })
        ```

        ## Import

        Patches can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:FleetAppsManagement/patch:Patch test_patch "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['PatchArtifactDetailsArgs', 'PatchArtifactDetailsArgsDict']] artifact_details: (Updatable) Patch artifact description and content details.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable)
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[Sequence[pulumi.Input[Union['PatchDependentPatchArgs', 'PatchDependentPatchArgsDict']]]] dependent_patches: (Updatable) Dependent Patches for this patch.
        :param pulumi.Input[_builtins.str] description: (Updatable) A user-friendly description. To provide some insight about the resource. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[_builtins.str] name: A user-friendly name. Should be unique within the tenancy, and cannot be changed after creation.  Avoid entering confidential information.
        :param pulumi.Input[Union['PatchPatchTypeArgs', 'PatchPatchTypeArgsDict']] patch_type: (Updatable) Patch Type
        :param pulumi.Input[Union['PatchProductArgs', 'PatchProductArgsDict']] product: (Updatable) Product
        :param pulumi.Input[_builtins.str] severity: (Updatable) Patch Severity.
        :param pulumi.Input[_builtins.str] time_released: (Updatable) Date when the patch was released.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PatchArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Patch resource in Oracle Cloud Infrastructure Fleet Apps Management service.

        Creates a new Patch.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_patch = oci.fleetappsmanagement.Patch("test_patch",
            artifact_details={
                "category": patch_artifact_details_category,
                "artifact": {
                    "content": {
                        "bucket": patch_artifact_details_artifact_content_bucket,
                        "checksum": patch_artifact_details_artifact_content_checksum,
                        "namespace": patch_artifact_details_artifact_content_namespace,
                        "object": patch_artifact_details_artifact_content_object,
                        "source_type": patch_artifact_details_artifact_content_source_type,
                    },
                },
                "artifacts": [{
                    "architecture": patch_artifact_details_artifacts_architecture,
                    "content": {
                        "bucket": patch_artifact_details_artifacts_content_bucket,
                        "checksum": patch_artifact_details_artifacts_content_checksum,
                        "namespace": patch_artifact_details_artifacts_content_namespace,
                        "object": patch_artifact_details_artifacts_content_object,
                        "source_type": patch_artifact_details_artifacts_content_source_type,
                    },
                    "os_type": patch_artifact_details_artifacts_os_type,
                }],
            },
            compartment_id=compartment_id,
            name=patch_name,
            patch_type={
                "platform_configuration_id": test_platform_configuration["id"],
            },
            product={
                "platform_configuration_id": test_platform_configuration["id"],
                "version": patch_product_version,
            },
            severity=patch_severity,
            time_released=patch_time_released,
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            dependent_patches=[{
                "id": patch_dependent_patches_id,
            }],
            description=patch_description,
            freeform_tags={
                "bar-key": "value",
            })
        ```

        ## Import

        Patches can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:FleetAppsManagement/patch:Patch test_patch "id"
        ```

        :param str resource_name: The name of the resource.
        :param PatchArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PatchArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 artifact_details: Optional[pulumi.Input[Union['PatchArtifactDetailsArgs', 'PatchArtifactDetailsArgsDict']]] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 dependent_patches: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PatchDependentPatchArgs', 'PatchDependentPatchArgsDict']]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 patch_type: Optional[pulumi.Input[Union['PatchPatchTypeArgs', 'PatchPatchTypeArgsDict']]] = None,
                 product: Optional[pulumi.Input[Union['PatchProductArgs', 'PatchProductArgsDict']]] = None,
                 severity: Optional[pulumi.Input[_builtins.str]] = None,
                 time_released: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PatchArgs.__new__(PatchArgs)

            if artifact_details is None and not opts.urn:
                raise TypeError("Missing required property 'artifact_details'")
            __props__.__dict__["artifact_details"] = artifact_details
            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["dependent_patches"] = dependent_patches
            __props__.__dict__["description"] = description
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["name"] = name
            if patch_type is None and not opts.urn:
                raise TypeError("Missing required property 'patch_type'")
            __props__.__dict__["patch_type"] = patch_type
            if product is None and not opts.urn:
                raise TypeError("Missing required property 'product'")
            __props__.__dict__["product"] = product
            if severity is None and not opts.urn:
                raise TypeError("Missing required property 'severity'")
            __props__.__dict__["severity"] = severity
            if time_released is None and not opts.urn:
                raise TypeError("Missing required property 'time_released'")
            __props__.__dict__["time_released"] = time_released
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["resource_region"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
            __props__.__dict__["type"] = None
        super(Patch, __self__).__init__(
            'oci:FleetAppsManagement/patch:Patch',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            artifact_details: Optional[pulumi.Input[Union['PatchArtifactDetailsArgs', 'PatchArtifactDetailsArgsDict']]] = None,
            compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            dependent_patches: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PatchDependentPatchArgs', 'PatchDependentPatchArgsDict']]]]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            lifecycle_details: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            patch_type: Optional[pulumi.Input[Union['PatchPatchTypeArgs', 'PatchPatchTypeArgsDict']]] = None,
            product: Optional[pulumi.Input[Union['PatchProductArgs', 'PatchProductArgsDict']]] = None,
            resource_region: Optional[pulumi.Input[_builtins.str]] = None,
            severity: Optional[pulumi.Input[_builtins.str]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            time_created: Optional[pulumi.Input[_builtins.str]] = None,
            time_released: Optional[pulumi.Input[_builtins.str]] = None,
            time_updated: Optional[pulumi.Input[_builtins.str]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None) -> 'Patch':
        """
        Get an existing Patch resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['PatchArtifactDetailsArgs', 'PatchArtifactDetailsArgsDict']] artifact_details: (Updatable) Patch artifact description and content details.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable)
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[Sequence[pulumi.Input[Union['PatchDependentPatchArgs', 'PatchDependentPatchArgsDict']]]] dependent_patches: (Updatable) Dependent Patches for this patch.
        :param pulumi.Input[_builtins.str] description: (Updatable) A user-friendly description. To provide some insight about the resource. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[_builtins.str] lifecycle_details: A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        :param pulumi.Input[_builtins.str] name: A user-friendly name. Should be unique within the tenancy, and cannot be changed after creation.  Avoid entering confidential information.
        :param pulumi.Input[Union['PatchPatchTypeArgs', 'PatchPatchTypeArgsDict']] patch_type: (Updatable) Patch Type
        :param pulumi.Input[Union['PatchProductArgs', 'PatchProductArgsDict']] product: (Updatable) Product
        :param pulumi.Input[_builtins.str] resource_region: Associated region
        :param pulumi.Input[_builtins.str] severity: (Updatable) Patch Severity.
        :param pulumi.Input[_builtins.str] state: The current state of the Patch.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[_builtins.str] time_created: The time this resource was created. An RFC3339 formatted datetime string.
        :param pulumi.Input[_builtins.str] time_released: (Updatable) Date when the patch was released.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.str] time_updated: The time this resource was last updated. An RFC3339 formatted datetime string.
        :param pulumi.Input[_builtins.str] type: Provide information on who defined the patch. Example: For Custom Patches the value will be USER_DEFINED For Oracle Defined Patches the value will be ORACLE_DEFINED
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PatchState.__new__(_PatchState)

        __props__.__dict__["artifact_details"] = artifact_details
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["dependent_patches"] = dependent_patches
        __props__.__dict__["description"] = description
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["name"] = name
        __props__.__dict__["patch_type"] = patch_type
        __props__.__dict__["product"] = product
        __props__.__dict__["resource_region"] = resource_region
        __props__.__dict__["severity"] = severity
        __props__.__dict__["state"] = state
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_released"] = time_released
        __props__.__dict__["time_updated"] = time_updated
        __props__.__dict__["type"] = type
        return Patch(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="artifactDetails")
    def artifact_details(self) -> pulumi.Output['outputs.PatchArtifactDetails']:
        """
        (Updatable) Patch artifact description and content details.
        """
        return pulumi.get(self, "artifact_details")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable)
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter(name="dependentPatches")
    def dependent_patches(self) -> pulumi.Output[Sequence['outputs.PatchDependentPatch']]:
        """
        (Updatable) Dependent Patches for this patch.
        """
        return pulumi.get(self, "dependent_patches")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) A user-friendly description. To provide some insight about the resource. Avoid entering confidential information.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[_builtins.str]:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        A user-friendly name. Should be unique within the tenancy, and cannot be changed after creation.  Avoid entering confidential information.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="patchType")
    def patch_type(self) -> pulumi.Output['outputs.PatchPatchType']:
        """
        (Updatable) Patch Type
        """
        return pulumi.get(self, "patch_type")

    @_builtins.property
    @pulumi.getter
    def product(self) -> pulumi.Output['outputs.PatchProduct']:
        """
        (Updatable) Product
        """
        return pulumi.get(self, "product")

    @_builtins.property
    @pulumi.getter(name="resourceRegion")
    def resource_region(self) -> pulumi.Output[_builtins.str]:
        """
        Associated region
        """
        return pulumi.get(self, "resource_region")

    @_builtins.property
    @pulumi.getter
    def severity(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) Patch Severity.
        """
        return pulumi.get(self, "severity")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        The current state of the Patch.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[_builtins.str]:
        """
        The time this resource was created. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeReleased")
    def time_released(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) Date when the patch was released.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "time_released")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[_builtins.str]:
        """
        The time this resource was last updated. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        Provide information on who defined the patch. Example: For Custom Patches the value will be USER_DEFINED For Oracle Defined Patches the value will be ORACLE_DEFINED
        """
        return pulumi.get(self, "type")

