# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetIntegrationInstancesResult',
    'AwaitableGetIntegrationInstancesResult',
    'get_integration_instances',
    'get_integration_instances_output',
]

@pulumi.output_type
class GetIntegrationInstancesResult:
    """
    A collection of values returned by getIntegrationInstances.
    """
    def __init__(__self__, compartment_id=None, display_name=None, filters=None, id=None, integration_instances=None, state=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if integration_instances and not isinstance(integration_instances, list):
            raise TypeError("Expected argument 'integration_instances' to be a list")
        pulumi.set(__self__, "integration_instances", integration_instances)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        Compartment Identifier.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[_builtins.str]:
        """
        Integration Instance Identifier, can be renamed.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetIntegrationInstancesFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="integrationInstances")
    def integration_instances(self) -> Sequence['outputs.GetIntegrationInstancesIntegrationInstanceResult']:
        """
        The list of integration_instances.
        """
        return pulumi.get(self, "integration_instances")

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[_builtins.str]:
        """
        The current state of the integration instance.
        """
        return pulumi.get(self, "state")


class AwaitableGetIntegrationInstancesResult(GetIntegrationInstancesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetIntegrationInstancesResult(
            compartment_id=self.compartment_id,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            integration_instances=self.integration_instances,
            state=self.state)


def get_integration_instances(compartment_id: Optional[_builtins.str] = None,
                              display_name: Optional[_builtins.str] = None,
                              filters: Optional[Sequence[Union['GetIntegrationInstancesFilterArgs', 'GetIntegrationInstancesFilterArgsDict']]] = None,
                              state: Optional[_builtins.str] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetIntegrationInstancesResult:
    """
    This data source provides the list of Integration Instances in Oracle Cloud Infrastructure Integration service.

    Returns a list of Integration Instances.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_integration_instances = oci.Integration.get_integration_instances(compartment_id=compartment_id,
        display_name=integration_instance_display_name,
        state=integration_instance_state)
    ```


    :param _builtins.str compartment_id: The ID of the compartment in which to list resources.
    :param _builtins.str display_name: A user-friendly name. Does not have to be unique, and it's changeable.  Example: `My new resource`
    :param _builtins.str state: Life cycle state to query on.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Integration/getIntegrationInstances:getIntegrationInstances', __args__, opts=opts, typ=GetIntegrationInstancesResult).value

    return AwaitableGetIntegrationInstancesResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        integration_instances=pulumi.get(__ret__, 'integration_instances'),
        state=pulumi.get(__ret__, 'state'))
def get_integration_instances_output(compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                                     display_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                     filters: Optional[pulumi.Input[Optional[Sequence[Union['GetIntegrationInstancesFilterArgs', 'GetIntegrationInstancesFilterArgsDict']]]]] = None,
                                     state: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetIntegrationInstancesResult]:
    """
    This data source provides the list of Integration Instances in Oracle Cloud Infrastructure Integration service.

    Returns a list of Integration Instances.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_integration_instances = oci.Integration.get_integration_instances(compartment_id=compartment_id,
        display_name=integration_instance_display_name,
        state=integration_instance_state)
    ```


    :param _builtins.str compartment_id: The ID of the compartment in which to list resources.
    :param _builtins.str display_name: A user-friendly name. Does not have to be unique, and it's changeable.  Example: `My new resource`
    :param _builtins.str state: Life cycle state to query on.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['state'] = state
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Integration/getIntegrationInstances:getIntegrationInstances', __args__, opts=opts, typ=GetIntegrationInstancesResult)
    return __ret__.apply(lambda __response__: GetIntegrationInstancesResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        display_name=pulumi.get(__response__, 'display_name'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        integration_instances=pulumi.get(__response__, 'integration_instances'),
        state=pulumi.get(__response__, 'state')))
