# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetLogAnalyticsCategoryResult',
    'AwaitableGetLogAnalyticsCategoryResult',
    'get_log_analytics_category',
    'get_log_analytics_category_output',
]

@pulumi.output_type
class GetLogAnalyticsCategoryResult:
    """
    A collection of values returned by getLogAnalyticsCategory.
    """
    def __init__(__self__, description=None, display_name=None, id=None, is_system=None, name=None, namespace=None, type=None):
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_system and not isinstance(is_system, bool):
            raise TypeError("Expected argument 'is_system' to be a bool")
        pulumi.set(__self__, "is_system", is_system)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if namespace and not isinstance(namespace, str):
            raise TypeError("Expected argument 'namespace' to be a str")
        pulumi.set(__self__, "namespace", namespace)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The category description.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        The category display name.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="isSystem")
    def is_system(self) -> _builtins.bool:
        """
        The system flag. A value of false denotes a user-created category. A value of true denotes an Oracle-defined category.
        """
        return pulumi.get(self, "is_system")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The unique name that identifies the category.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> _builtins.str:
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The category type. Values include "PRODUCT", "TIER", "VENDOR" and "GENERIC".
        """
        return pulumi.get(self, "type")


class AwaitableGetLogAnalyticsCategoryResult(GetLogAnalyticsCategoryResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetLogAnalyticsCategoryResult(
            description=self.description,
            display_name=self.display_name,
            id=self.id,
            is_system=self.is_system,
            name=self.name,
            namespace=self.namespace,
            type=self.type)


def get_log_analytics_category(name: Optional[_builtins.str] = None,
                               namespace: Optional[_builtins.str] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetLogAnalyticsCategoryResult:
    """
    This data source provides details about a specific Log Analytics Category resource in Oracle Cloud Infrastructure Log Analytics service.

    Gets detailed information about the category with the specified name.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_log_analytics_category = oci.LogAnalytics.get_log_analytics_category(name=log_analytics_category_name,
        namespace=log_analytics_category_namespace)
    ```


    :param _builtins.str name: The category name.
    :param _builtins.str namespace: The Logging Analytics namespace used for the request.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['namespace'] = namespace
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:LogAnalytics/getLogAnalyticsCategory:getLogAnalyticsCategory', __args__, opts=opts, typ=GetLogAnalyticsCategoryResult).value

    return AwaitableGetLogAnalyticsCategoryResult(
        description=pulumi.get(__ret__, 'description'),
        display_name=pulumi.get(__ret__, 'display_name'),
        id=pulumi.get(__ret__, 'id'),
        is_system=pulumi.get(__ret__, 'is_system'),
        name=pulumi.get(__ret__, 'name'),
        namespace=pulumi.get(__ret__, 'namespace'),
        type=pulumi.get(__ret__, 'type'))
def get_log_analytics_category_output(name: Optional[pulumi.Input[_builtins.str]] = None,
                                      namespace: Optional[pulumi.Input[_builtins.str]] = None,
                                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetLogAnalyticsCategoryResult]:
    """
    This data source provides details about a specific Log Analytics Category resource in Oracle Cloud Infrastructure Log Analytics service.

    Gets detailed information about the category with the specified name.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_log_analytics_category = oci.LogAnalytics.get_log_analytics_category(name=log_analytics_category_name,
        namespace=log_analytics_category_namespace)
    ```


    :param _builtins.str name: The category name.
    :param _builtins.str namespace: The Logging Analytics namespace used for the request.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['namespace'] = namespace
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:LogAnalytics/getLogAnalyticsCategory:getLogAnalyticsCategory', __args__, opts=opts, typ=GetLogAnalyticsCategoryResult)
    return __ret__.apply(lambda __response__: GetLogAnalyticsCategoryResult(
        description=pulumi.get(__response__, 'description'),
        display_name=pulumi.get(__response__, 'display_name'),
        id=pulumi.get(__response__, 'id'),
        is_system=pulumi.get(__response__, 'is_system'),
        name=pulumi.get(__response__, 'name'),
        namespace=pulumi.get(__response__, 'namespace'),
        type=pulumi.get(__response__, 'type')))
