# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetStreamCdnConfigResult',
    'AwaitableGetStreamCdnConfigResult',
    'get_stream_cdn_config',
    'get_stream_cdn_config_output',
]

@pulumi.output_type
class GetStreamCdnConfigResult:
    """
    A collection of values returned by getStreamCdnConfig.
    """
    def __init__(__self__, compartment_id=None, configs=None, defined_tags=None, display_name=None, distribution_channel_id=None, freeform_tags=None, id=None, is_enabled=None, is_lock_override=None, lifecyle_details=None, locks=None, state=None, stream_cdn_config_id=None, system_tags=None, time_created=None, time_updated=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if configs and not isinstance(configs, list):
            raise TypeError("Expected argument 'configs' to be a list")
        pulumi.set(__self__, "configs", configs)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if distribution_channel_id and not isinstance(distribution_channel_id, str):
            raise TypeError("Expected argument 'distribution_channel_id' to be a str")
        pulumi.set(__self__, "distribution_channel_id", distribution_channel_id)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_enabled and not isinstance(is_enabled, bool):
            raise TypeError("Expected argument 'is_enabled' to be a bool")
        pulumi.set(__self__, "is_enabled", is_enabled)
        if is_lock_override and not isinstance(is_lock_override, bool):
            raise TypeError("Expected argument 'is_lock_override' to be a bool")
        pulumi.set(__self__, "is_lock_override", is_lock_override)
        if lifecyle_details and not isinstance(lifecyle_details, str):
            raise TypeError("Expected argument 'lifecyle_details' to be a str")
        pulumi.set(__self__, "lifecyle_details", lifecyle_details)
        if locks and not isinstance(locks, list):
            raise TypeError("Expected argument 'locks' to be a list")
        pulumi.set(__self__, "locks", locks)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if stream_cdn_config_id and not isinstance(stream_cdn_config_id, str):
            raise TypeError("Expected argument 'stream_cdn_config_id' to be a str")
        pulumi.set(__self__, "stream_cdn_config_id", stream_cdn_config_id)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The compartment ID of the lock.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter
    def configs(self) -> Sequence['outputs.GetStreamCdnConfigConfigResult']:
        """
        Base fields of the StreamCdnConfig configuration object.
        """
        return pulumi.get(self, "configs")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, _builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        The CDN Configuration identifier or display name, which can be renamed and is not necessarily unique. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="distributionChannelId")
    def distribution_channel_id(self) -> _builtins.str:
        """
        Distribution Channel Identifier.
        """
        return pulumi.get(self, "distribution_channel_id")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, _builtins.str]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        Unique identifier that is immutable on creation.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> _builtins.bool:
        """
        Whether publishing to CDN is enabled.
        """
        return pulumi.get(self, "is_enabled")

    @_builtins.property
    @pulumi.getter(name="isLockOverride")
    def is_lock_override(self) -> _builtins.bool:
        return pulumi.get(self, "is_lock_override")

    @_builtins.property
    @pulumi.getter(name="lifecyleDetails")
    def lifecyle_details(self) -> _builtins.str:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecyle_details")

    @_builtins.property
    @pulumi.getter
    def locks(self) -> Sequence['outputs.GetStreamCdnConfigLockResult']:
        """
        Locks associated with this resource.
        """
        return pulumi.get(self, "locks")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        The current state of the CDN Configuration.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="streamCdnConfigId")
    def stream_cdn_config_id(self) -> _builtins.str:
        return pulumi.get(self, "stream_cdn_config_id")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, _builtins.str]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        The time when the CDN Config was created. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> _builtins.str:
        """
        The time when the CDN Config was updated. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")


class AwaitableGetStreamCdnConfigResult(GetStreamCdnConfigResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetStreamCdnConfigResult(
            compartment_id=self.compartment_id,
            configs=self.configs,
            defined_tags=self.defined_tags,
            display_name=self.display_name,
            distribution_channel_id=self.distribution_channel_id,
            freeform_tags=self.freeform_tags,
            id=self.id,
            is_enabled=self.is_enabled,
            is_lock_override=self.is_lock_override,
            lifecyle_details=self.lifecyle_details,
            locks=self.locks,
            state=self.state,
            stream_cdn_config_id=self.stream_cdn_config_id,
            system_tags=self.system_tags,
            time_created=self.time_created,
            time_updated=self.time_updated)


def get_stream_cdn_config(stream_cdn_config_id: Optional[_builtins.str] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetStreamCdnConfigResult:
    """
    This data source provides details about a specific Stream Cdn Config resource in Oracle Cloud Infrastructure Media Services service.

    Gets a StreamCdnConfig by identifier.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_stream_cdn_config = oci.MediaServices.get_stream_cdn_config(stream_cdn_config_id=test_stream_cdn_config_oci_media_services_stream_cdn_config["id"])
    ```


    :param _builtins.str stream_cdn_config_id: Unique StreamCdnConfig identifier.
    """
    __args__ = dict()
    __args__['streamCdnConfigId'] = stream_cdn_config_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:MediaServices/getStreamCdnConfig:getStreamCdnConfig', __args__, opts=opts, typ=GetStreamCdnConfigResult).value

    return AwaitableGetStreamCdnConfigResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        configs=pulumi.get(__ret__, 'configs'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        display_name=pulumi.get(__ret__, 'display_name'),
        distribution_channel_id=pulumi.get(__ret__, 'distribution_channel_id'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        is_enabled=pulumi.get(__ret__, 'is_enabled'),
        is_lock_override=pulumi.get(__ret__, 'is_lock_override'),
        lifecyle_details=pulumi.get(__ret__, 'lifecyle_details'),
        locks=pulumi.get(__ret__, 'locks'),
        state=pulumi.get(__ret__, 'state'),
        stream_cdn_config_id=pulumi.get(__ret__, 'stream_cdn_config_id'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'))
def get_stream_cdn_config_output(stream_cdn_config_id: Optional[pulumi.Input[_builtins.str]] = None,
                                 opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetStreamCdnConfigResult]:
    """
    This data source provides details about a specific Stream Cdn Config resource in Oracle Cloud Infrastructure Media Services service.

    Gets a StreamCdnConfig by identifier.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_stream_cdn_config = oci.MediaServices.get_stream_cdn_config(stream_cdn_config_id=test_stream_cdn_config_oci_media_services_stream_cdn_config["id"])
    ```


    :param _builtins.str stream_cdn_config_id: Unique StreamCdnConfig identifier.
    """
    __args__ = dict()
    __args__['streamCdnConfigId'] = stream_cdn_config_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:MediaServices/getStreamCdnConfig:getStreamCdnConfig', __args__, opts=opts, typ=GetStreamCdnConfigResult)
    return __ret__.apply(lambda __response__: GetStreamCdnConfigResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        configs=pulumi.get(__response__, 'configs'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        display_name=pulumi.get(__response__, 'display_name'),
        distribution_channel_id=pulumi.get(__response__, 'distribution_channel_id'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        id=pulumi.get(__response__, 'id'),
        is_enabled=pulumi.get(__response__, 'is_enabled'),
        is_lock_override=pulumi.get(__response__, 'is_lock_override'),
        lifecyle_details=pulumi.get(__response__, 'lifecyle_details'),
        locks=pulumi.get(__response__, 'locks'),
        state=pulumi.get(__response__, 'state'),
        stream_cdn_config_id=pulumi.get(__response__, 'stream_cdn_config_id'),
        system_tags=pulumi.get(__response__, 'system_tags'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_updated=pulumi.get(__response__, 'time_updated')))
