# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'ProfileLevelsConfiguration',
    'ProfileLevelsConfigurationItem',
    'ProfileTargetCompartments',
    'ProfileTargetTags',
    'ProfileTargetTagsItem',
    'RecommendationResourceCount',
    'RecommendationSupportedLevel',
    'RecommendationSupportedLevelItem',
    'ResourceActionAction',
    'GetCategoriesCategoryCollectionResult',
    'GetCategoriesCategoryCollectionItemResult',
    'GetCategoriesCategoryCollectionItemRecommendationCountResult',
    'GetCategoriesCategoryCollectionItemResourceCountResult',
    'GetCategoriesFilterResult',
    'GetCategoryRecommendationCountResult',
    'GetCategoryResourceCountResult',
    'GetEnrollmentStatusesEnrollmentStatusCollectionResult',
    'GetEnrollmentStatusesEnrollmentStatusCollectionItemResult',
    'GetEnrollmentStatusesFilterResult',
    'GetHistoriesFilterResult',
    'GetHistoriesHistoryCollectionResult',
    'GetHistoriesHistoryCollectionItemResult',
    'GetHistoriesHistoryCollectionItemActionResult',
    'GetProfileLevelItemResult',
    'GetProfileLevelItemMetricResult',
    'GetProfileLevelsConfigurationResult',
    'GetProfileLevelsConfigurationItemResult',
    'GetProfileLevelsFilterResult',
    'GetProfileLevelsProfileLevelCollectionResult',
    'GetProfileLevelsProfileLevelCollectionItemResult',
    'GetProfileLevelsProfileLevelCollectionItemMetricResult',
    'GetProfileTargetCompartmentResult',
    'GetProfileTargetTagResult',
    'GetProfileTargetTagItemResult',
    'GetProfilesFilterResult',
    'GetProfilesProfileCollectionResult',
    'GetProfilesProfileCollectionItemResult',
    'GetProfilesProfileCollectionItemLevelsConfigurationResult',
    'GetProfilesProfileCollectionItemLevelsConfigurationItemResult',
    'GetProfilesProfileCollectionItemTargetCompartmentResult',
    'GetProfilesProfileCollectionItemTargetTagResult',
    'GetProfilesProfileCollectionItemTargetTagItemResult',
    'GetRecommendationResourceCountResult',
    'GetRecommendationStrategiesFilterResult',
    'GetRecommendationStrategiesRecommendationStrategyCollectionResult',
    'GetRecommendationStrategiesRecommendationStrategyCollectionItemResult',
    'GetRecommendationStrategiesRecommendationStrategyCollectionItemStrategyResult',
    'GetRecommendationStrategiesRecommendationStrategyCollectionItemStrategyParametersDefinitionResult',
    'GetRecommendationStrategyItemResult',
    'GetRecommendationStrategyItemStrategyResult',
    'GetRecommendationStrategyItemStrategyParametersDefinitionResult',
    'GetRecommendationSupportedLevelResult',
    'GetRecommendationSupportedLevelItemResult',
    'GetRecommendationsFilterResult',
    'GetRecommendationsRecommendationCollectionResult',
    'GetRecommendationsRecommendationCollectionItemResult',
    'GetRecommendationsRecommendationCollectionItemResourceCountResult',
    'GetRecommendationsRecommendationCollectionItemSupportedLevelResult',
    'GetRecommendationsRecommendationCollectionItemSupportedLevelItemResult',
    'GetResourceActionActionResult',
    'GetResourceActionsFilterResult',
    'GetResourceActionsResourceActionCollectionResult',
    'GetResourceActionsResourceActionCollectionItemResult',
    'GetResourceActionsResourceActionCollectionItemActionResult',
]

@pulumi.output_type
class ProfileLevelsConfiguration(dict):
    def __init__(__self__, *,
                 items: Optional[Sequence['outputs.ProfileLevelsConfigurationItem']] = None):
        """
        :param Sequence['ProfileLevelsConfigurationItemArgs'] items: (Updatable) The array of configuration levels.
        """
        if items is not None:
            pulumi.set(__self__, "items", items)

    @_builtins.property
    @pulumi.getter
    def items(self) -> Optional[Sequence['outputs.ProfileLevelsConfigurationItem']]:
        """
        (Updatable) The array of configuration levels.
        """
        return pulumi.get(self, "items")


@pulumi.output_type
class ProfileLevelsConfigurationItem(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "recommendationId":
            suggest = "recommendation_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProfileLevelsConfigurationItem. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProfileLevelsConfigurationItem.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProfileLevelsConfigurationItem.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 level: Optional[_builtins.str] = None,
                 recommendation_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str level: (Updatable) The pre-defined profile level.
        :param _builtins.str recommendation_id: (Updatable) The unique OCID of the recommendation.
        """
        if level is not None:
            pulumi.set(__self__, "level", level)
        if recommendation_id is not None:
            pulumi.set(__self__, "recommendation_id", recommendation_id)

    @_builtins.property
    @pulumi.getter
    def level(self) -> Optional[_builtins.str]:
        """
        (Updatable) The pre-defined profile level.
        """
        return pulumi.get(self, "level")

    @_builtins.property
    @pulumi.getter(name="recommendationId")
    def recommendation_id(self) -> Optional[_builtins.str]:
        """
        (Updatable) The unique OCID of the recommendation.
        """
        return pulumi.get(self, "recommendation_id")


@pulumi.output_type
class ProfileTargetCompartments(dict):
    def __init__(__self__, *,
                 items: Sequence[_builtins.str]):
        """
        :param Sequence[_builtins.str] items: (Updatable) The list of OCIDs attached to the compartments specified in the current profile override.
        """
        pulumi.set(__self__, "items", items)

    @_builtins.property
    @pulumi.getter
    def items(self) -> Sequence[_builtins.str]:
        """
        (Updatable) The list of OCIDs attached to the compartments specified in the current profile override.
        """
        return pulumi.get(self, "items")


@pulumi.output_type
class ProfileTargetTags(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.ProfileTargetTagsItem']):
        """
        :param Sequence['ProfileTargetTagsItemArgs'] items: (Updatable) The list of tags specified in the current profile override.
        """
        pulumi.set(__self__, "items", items)

    @_builtins.property
    @pulumi.getter
    def items(self) -> Sequence['outputs.ProfileTargetTagsItem']:
        """
        (Updatable) The list of tags specified in the current profile override.
        """
        return pulumi.get(self, "items")


@pulumi.output_type
class ProfileTargetTagsItem(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "tagDefinitionName":
            suggest = "tag_definition_name"
        elif key == "tagNamespaceName":
            suggest = "tag_namespace_name"
        elif key == "tagValueType":
            suggest = "tag_value_type"
        elif key == "tagValues":
            suggest = "tag_values"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProfileTargetTagsItem. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProfileTargetTagsItem.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProfileTargetTagsItem.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 tag_definition_name: _builtins.str,
                 tag_namespace_name: _builtins.str,
                 tag_value_type: _builtins.str,
                 tag_values: Optional[Sequence[_builtins.str]] = None):
        """
        :param _builtins.str tag_definition_name: (Updatable) The name you use to refer to the tag, also known as the tag key.
        :param _builtins.str tag_namespace_name: (Updatable) The name of the tag namespace.
        :param _builtins.str tag_value_type: (Updatable) Specifies which tag value types in the `tagValues` field result in overrides of the recommendation criteria.
               
               When the value for this field is `ANY`, the `tagValues` field should be empty, which enforces overrides to the recommendation for resources with any tag values attached to them.
               
               When the value for this field value is `VALUE`, the `tagValues` field must include a specific value or list of values. Overrides to the recommendation criteria only occur for resources that match the values in the `tagValues` fields.
        :param Sequence[_builtins.str] tag_values: (Updatable) The list of tag values. The tag value is the value that the user applying the tag adds to the tag key.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "tag_definition_name", tag_definition_name)
        pulumi.set(__self__, "tag_namespace_name", tag_namespace_name)
        pulumi.set(__self__, "tag_value_type", tag_value_type)
        if tag_values is not None:
            pulumi.set(__self__, "tag_values", tag_values)

    @_builtins.property
    @pulumi.getter(name="tagDefinitionName")
    def tag_definition_name(self) -> _builtins.str:
        """
        (Updatable) The name you use to refer to the tag, also known as the tag key.
        """
        return pulumi.get(self, "tag_definition_name")

    @_builtins.property
    @pulumi.getter(name="tagNamespaceName")
    def tag_namespace_name(self) -> _builtins.str:
        """
        (Updatable) The name of the tag namespace.
        """
        return pulumi.get(self, "tag_namespace_name")

    @_builtins.property
    @pulumi.getter(name="tagValueType")
    def tag_value_type(self) -> _builtins.str:
        """
        (Updatable) Specifies which tag value types in the `tagValues` field result in overrides of the recommendation criteria.

        When the value for this field is `ANY`, the `tagValues` field should be empty, which enforces overrides to the recommendation for resources with any tag values attached to them.

        When the value for this field value is `VALUE`, the `tagValues` field must include a specific value or list of values. Overrides to the recommendation criteria only occur for resources that match the values in the `tagValues` fields.
        """
        return pulumi.get(self, "tag_value_type")

    @_builtins.property
    @pulumi.getter(name="tagValues")
    def tag_values(self) -> Optional[Sequence[_builtins.str]]:
        """
        (Updatable) The list of tag values. The tag value is the value that the user applying the tag adds to the tag key.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "tag_values")


@pulumi.output_type
class RecommendationResourceCount(dict):
    def __init__(__self__, *,
                 count: Optional[_builtins.int] = None,
                 status: Optional[_builtins.str] = None):
        """
        :param _builtins.int count: The count of resources.
        :param _builtins.str status: (Updatable) The status of the recommendation.
        """
        if count is not None:
            pulumi.set(__self__, "count", count)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter
    def count(self) -> Optional[_builtins.int]:
        """
        The count of resources.
        """
        return pulumi.get(self, "count")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.str]:
        """
        (Updatable) The status of the recommendation.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class RecommendationSupportedLevel(dict):
    def __init__(__self__, *,
                 items: Optional[Sequence['outputs.RecommendationSupportedLevelItem']] = None):
        """
        :param Sequence['RecommendationSupportedLevelItemArgs'] items: The list of supported levels.
        """
        if items is not None:
            pulumi.set(__self__, "items", items)

    @_builtins.property
    @pulumi.getter
    def items(self) -> Optional[Sequence['outputs.RecommendationSupportedLevelItem']]:
        """
        The list of supported levels.
        """
        return pulumi.get(self, "items")


@pulumi.output_type
class RecommendationSupportedLevelItem(dict):
    def __init__(__self__, *,
                 name: Optional[_builtins.str] = None):
        """
        :param _builtins.str name: The name of the profile level.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        The name of the profile level.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class ResourceActionAction(dict):
    def __init__(__self__, *,
                 description: Optional[_builtins.str] = None,
                 type: Optional[_builtins.str] = None,
                 url: Optional[_builtins.str] = None):
        """
        :param _builtins.str description: Text describing the recommended action.
        :param _builtins.str type: The status of the resource action.
        :param _builtins.str url: The URL path to documentation that explains how to perform the action.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        """
        Text describing the recommended action.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        The status of the resource action.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def url(self) -> Optional[_builtins.str]:
        """
        The URL path to documentation that explains how to perform the action.
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class GetCategoriesCategoryCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetCategoriesCategoryCollectionItemResult']):
        pulumi.set(__self__, "items", items)

    @_builtins.property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetCategoriesCategoryCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetCategoriesCategoryCollectionItemResult(dict):
    def __init__(__self__, *,
                 compartment_id: _builtins.str,
                 compartment_name: _builtins.str,
                 description: _builtins.str,
                 estimated_cost_saving: _builtins.float,
                 extended_metadata: Mapping[str, _builtins.str],
                 id: _builtins.str,
                 name: _builtins.str,
                 recommendation_counts: Sequence['outputs.GetCategoriesCategoryCollectionItemRecommendationCountResult'],
                 resource_counts: Sequence['outputs.GetCategoriesCategoryCollectionItemResourceCountResult'],
                 state: _builtins.str,
                 time_created: _builtins.str,
                 time_updated: _builtins.str):
        """
        :param _builtins.str compartment_id: The OCID of the compartment.
        :param _builtins.str compartment_name: The name associated with the compartment.
        :param _builtins.str description: Text describing the category.
        :param _builtins.float estimated_cost_saving: The estimated cost savings, in dollars, for the category.
        :param Mapping[str, _builtins.str] extended_metadata: Additional metadata key/value pairs for the category.
        :param _builtins.str id: The unique OCID of the category.
        :param _builtins.str name: Optional. A filter that returns results that match the name specified.
        :param Sequence['GetCategoriesCategoryCollectionItemRecommendationCountArgs'] recommendation_counts: An array of `RecommendationCount` objects grouped by the level of importance assigned to the recommendation.
        :param Sequence['GetCategoriesCategoryCollectionItemResourceCountArgs'] resource_counts: An array of `ResourceCount` objects grouped by the status of the recommendation.
        :param _builtins.str state: A filter that returns results that match the lifecycle state specified.
        :param _builtins.str time_created: The date and time the category details were created, in the format defined by RFC3339.
        :param _builtins.str time_updated: The date and time the category details were last updated, in the format defined by RFC3339.
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "compartment_name", compartment_name)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "estimated_cost_saving", estimated_cost_saving)
        pulumi.set(__self__, "extended_metadata", extended_metadata)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "recommendation_counts", recommendation_counts)
        pulumi.set(__self__, "resource_counts", resource_counts)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_updated", time_updated)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The OCID of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="compartmentName")
    def compartment_name(self) -> _builtins.str:
        """
        The name associated with the compartment.
        """
        return pulumi.get(self, "compartment_name")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Text describing the category.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="estimatedCostSaving")
    def estimated_cost_saving(self) -> _builtins.float:
        """
        The estimated cost savings, in dollars, for the category.
        """
        return pulumi.get(self, "estimated_cost_saving")

    @_builtins.property
    @pulumi.getter(name="extendedMetadata")
    def extended_metadata(self) -> Mapping[str, _builtins.str]:
        """
        Additional metadata key/value pairs for the category.
        """
        return pulumi.get(self, "extended_metadata")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The unique OCID of the category.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Optional. A filter that returns results that match the name specified.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="recommendationCounts")
    def recommendation_counts(self) -> Sequence['outputs.GetCategoriesCategoryCollectionItemRecommendationCountResult']:
        """
        An array of `RecommendationCount` objects grouped by the level of importance assigned to the recommendation.
        """
        return pulumi.get(self, "recommendation_counts")

    @_builtins.property
    @pulumi.getter(name="resourceCounts")
    def resource_counts(self) -> Sequence['outputs.GetCategoriesCategoryCollectionItemResourceCountResult']:
        """
        An array of `ResourceCount` objects grouped by the status of the recommendation.
        """
        return pulumi.get(self, "resource_counts")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        A filter that returns results that match the lifecycle state specified.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        The date and time the category details were created, in the format defined by RFC3339.
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> _builtins.str:
        """
        The date and time the category details were last updated, in the format defined by RFC3339.
        """
        return pulumi.get(self, "time_updated")


@pulumi.output_type
class GetCategoriesCategoryCollectionItemRecommendationCountResult(dict):
    def __init__(__self__, *,
                 count: _builtins.int,
                 importance: _builtins.str):
        """
        :param _builtins.int count: The count of resources.
        :param _builtins.str importance: The level of importance assigned to the recommendation.
        """
        pulumi.set(__self__, "count", count)
        pulumi.set(__self__, "importance", importance)

    @_builtins.property
    @pulumi.getter
    def count(self) -> _builtins.int:
        """
        The count of resources.
        """
        return pulumi.get(self, "count")

    @_builtins.property
    @pulumi.getter
    def importance(self) -> _builtins.str:
        """
        The level of importance assigned to the recommendation.
        """
        return pulumi.get(self, "importance")


@pulumi.output_type
class GetCategoriesCategoryCollectionItemResourceCountResult(dict):
    def __init__(__self__, *,
                 count: _builtins.int,
                 status: _builtins.str):
        """
        :param _builtins.int count: The count of resources.
        :param _builtins.str status: The recommendation status of the resource.
        """
        pulumi.set(__self__, "count", count)
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter
    def count(self) -> _builtins.int:
        """
        The count of resources.
        """
        return pulumi.get(self, "count")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The recommendation status of the resource.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetCategoriesFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        """
        :param _builtins.str name: Optional. A filter that returns results that match the name specified.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Optional. A filter that returns results that match the name specified.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetCategoryRecommendationCountResult(dict):
    def __init__(__self__, *,
                 count: _builtins.int,
                 importance: _builtins.str):
        """
        :param _builtins.int count: The count of resources.
        :param _builtins.str importance: The level of importance assigned to the recommendation.
        """
        pulumi.set(__self__, "count", count)
        pulumi.set(__self__, "importance", importance)

    @_builtins.property
    @pulumi.getter
    def count(self) -> _builtins.int:
        """
        The count of resources.
        """
        return pulumi.get(self, "count")

    @_builtins.property
    @pulumi.getter
    def importance(self) -> _builtins.str:
        """
        The level of importance assigned to the recommendation.
        """
        return pulumi.get(self, "importance")


@pulumi.output_type
class GetCategoryResourceCountResult(dict):
    def __init__(__self__, *,
                 count: _builtins.int,
                 status: _builtins.str):
        """
        :param _builtins.int count: The count of resources.
        :param _builtins.str status: The recommendation status of the resource.
        """
        pulumi.set(__self__, "count", count)
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter
    def count(self) -> _builtins.int:
        """
        The count of resources.
        """
        return pulumi.get(self, "count")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The recommendation status of the resource.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetEnrollmentStatusesEnrollmentStatusCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetEnrollmentStatusesEnrollmentStatusCollectionItemResult']):
        pulumi.set(__self__, "items", items)

    @_builtins.property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetEnrollmentStatusesEnrollmentStatusCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetEnrollmentStatusesEnrollmentStatusCollectionItemResult(dict):
    def __init__(__self__, *,
                 compartment_id: _builtins.str,
                 enrollment_status_id: _builtins.str,
                 id: _builtins.str,
                 state: _builtins.str,
                 status: _builtins.str,
                 status_reason: _builtins.str,
                 time_created: _builtins.str,
                 time_updated: _builtins.str):
        """
        :param _builtins.str compartment_id: The OCID of the compartment.
        :param _builtins.str id: The OCID of the enrollment status.
        :param _builtins.str state: A filter that returns results that match the lifecycle state specified.
        :param _builtins.str status: A filter that returns results that match the Cloud Advisor enrollment status specified.
        :param _builtins.str status_reason: The reason for the enrollment status of the tenancy.
        :param _builtins.str time_created: The date and time the enrollment status was created, in the format defined by RFC3339.
        :param _builtins.str time_updated: The date and time the enrollment status was last updated, in the format defined by RFC3339.
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "enrollment_status_id", enrollment_status_id)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "status_reason", status_reason)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_updated", time_updated)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The OCID of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="enrollmentStatusId")
    def enrollment_status_id(self) -> _builtins.str:
        return pulumi.get(self, "enrollment_status_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The OCID of the enrollment status.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        A filter that returns results that match the lifecycle state specified.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        A filter that returns results that match the Cloud Advisor enrollment status specified.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="statusReason")
    def status_reason(self) -> _builtins.str:
        """
        The reason for the enrollment status of the tenancy.
        """
        return pulumi.get(self, "status_reason")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        The date and time the enrollment status was created, in the format defined by RFC3339.
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> _builtins.str:
        """
        The date and time the enrollment status was last updated, in the format defined by RFC3339.
        """
        return pulumi.get(self, "time_updated")


@pulumi.output_type
class GetEnrollmentStatusesFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetHistoriesFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        """
        :param _builtins.str name: Optional. A filter that returns results that match the name specified.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Optional. A filter that returns results that match the name specified.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetHistoriesHistoryCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetHistoriesHistoryCollectionItemResult']):
        """
        :param Sequence['GetHistoriesHistoryCollectionItemArgs'] items: A collection of history summaries.
        """
        pulumi.set(__self__, "items", items)

    @_builtins.property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetHistoriesHistoryCollectionItemResult']:
        """
        A collection of history summaries.
        """
        return pulumi.get(self, "items")


@pulumi.output_type
class GetHistoriesHistoryCollectionItemResult(dict):
    def __init__(__self__, *,
                 actions: Sequence['outputs.GetHistoriesHistoryCollectionItemActionResult'],
                 category_id: _builtins.str,
                 compartment_id: _builtins.str,
                 compartment_name: _builtins.str,
                 estimated_cost_saving: _builtins.float,
                 extended_metadata: Mapping[str, _builtins.str],
                 id: _builtins.str,
                 metadata: Mapping[str, _builtins.str],
                 name: _builtins.str,
                 recommendation_id: _builtins.str,
                 recommendation_name: _builtins.str,
                 resource_action_id: _builtins.str,
                 resource_id: _builtins.str,
                 resource_type: _builtins.str,
                 state: _builtins.str,
                 status: _builtins.str,
                 time_created: _builtins.str):
        """
        :param Sequence['GetHistoriesHistoryCollectionItemActionArgs'] actions: Details about the recommended action.
        :param _builtins.str category_id: The unique OCID associated with the category.
        :param _builtins.str compartment_id: The OCID of the compartment.
        :param _builtins.str compartment_name: The name assigned to the compartment.
        :param _builtins.float estimated_cost_saving: The estimated cost savings, in dollars, for the resource action.
        :param Mapping[str, _builtins.str] extended_metadata: Additional metadata key/value pairs that you provide. They serve the same purpose and functionality as fields in the `metadata` object.
        :param _builtins.str id: The unique OCID associated with the recommendation history.
        :param Mapping[str, _builtins.str] metadata: Custom metadata key/value pairs for the resource action.
        :param _builtins.str name: Optional. A filter that returns results that match the name specified.
        :param _builtins.str recommendation_id: The unique OCID associated with the recommendation.
        :param _builtins.str recommendation_name: Optional. A filter that returns results that match the recommendation name specified.
        :param _builtins.str resource_action_id: The unique OCID associated with the resource action.
        :param _builtins.str resource_id: The unique OCID associated with the resource.
        :param _builtins.str resource_type: Optional. A filter that returns results that match the resource type specified.
        :param _builtins.str state: A filter that returns results that match the lifecycle state specified.
        :param _builtins.str status: A filter that returns recommendations that match the status specified.
        :param _builtins.str time_created: The date and time the recommendation history was created, in the format defined by RFC3339.
        """
        pulumi.set(__self__, "actions", actions)
        pulumi.set(__self__, "category_id", category_id)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "compartment_name", compartment_name)
        pulumi.set(__self__, "estimated_cost_saving", estimated_cost_saving)
        pulumi.set(__self__, "extended_metadata", extended_metadata)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "metadata", metadata)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "recommendation_id", recommendation_id)
        pulumi.set(__self__, "recommendation_name", recommendation_name)
        pulumi.set(__self__, "resource_action_id", resource_action_id)
        pulumi.set(__self__, "resource_id", resource_id)
        pulumi.set(__self__, "resource_type", resource_type)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "time_created", time_created)

    @_builtins.property
    @pulumi.getter
    def actions(self) -> Sequence['outputs.GetHistoriesHistoryCollectionItemActionResult']:
        """
        Details about the recommended action.
        """
        return pulumi.get(self, "actions")

    @_builtins.property
    @pulumi.getter(name="categoryId")
    def category_id(self) -> _builtins.str:
        """
        The unique OCID associated with the category.
        """
        return pulumi.get(self, "category_id")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The OCID of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="compartmentName")
    def compartment_name(self) -> _builtins.str:
        """
        The name assigned to the compartment.
        """
        return pulumi.get(self, "compartment_name")

    @_builtins.property
    @pulumi.getter(name="estimatedCostSaving")
    def estimated_cost_saving(self) -> _builtins.float:
        """
        The estimated cost savings, in dollars, for the resource action.
        """
        return pulumi.get(self, "estimated_cost_saving")

    @_builtins.property
    @pulumi.getter(name="extendedMetadata")
    def extended_metadata(self) -> Mapping[str, _builtins.str]:
        """
        Additional metadata key/value pairs that you provide. They serve the same purpose and functionality as fields in the `metadata` object.
        """
        return pulumi.get(self, "extended_metadata")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The unique OCID associated with the recommendation history.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> Mapping[str, _builtins.str]:
        """
        Custom metadata key/value pairs for the resource action.
        """
        return pulumi.get(self, "metadata")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Optional. A filter that returns results that match the name specified.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="recommendationId")
    def recommendation_id(self) -> _builtins.str:
        """
        The unique OCID associated with the recommendation.
        """
        return pulumi.get(self, "recommendation_id")

    @_builtins.property
    @pulumi.getter(name="recommendationName")
    def recommendation_name(self) -> _builtins.str:
        """
        Optional. A filter that returns results that match the recommendation name specified.
        """
        return pulumi.get(self, "recommendation_name")

    @_builtins.property
    @pulumi.getter(name="resourceActionId")
    def resource_action_id(self) -> _builtins.str:
        """
        The unique OCID associated with the resource action.
        """
        return pulumi.get(self, "resource_action_id")

    @_builtins.property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> _builtins.str:
        """
        The unique OCID associated with the resource.
        """
        return pulumi.get(self, "resource_id")

    @_builtins.property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> _builtins.str:
        """
        Optional. A filter that returns results that match the resource type specified.
        """
        return pulumi.get(self, "resource_type")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        A filter that returns results that match the lifecycle state specified.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        A filter that returns recommendations that match the status specified.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        The date and time the recommendation history was created, in the format defined by RFC3339.
        """
        return pulumi.get(self, "time_created")


@pulumi.output_type
class GetHistoriesHistoryCollectionItemActionResult(dict):
    def __init__(__self__, *,
                 description: _builtins.str,
                 type: _builtins.str,
                 url: _builtins.str):
        """
        :param _builtins.str description: Text describing the recommended action.
        :param _builtins.str type: The status of the resource action.
        :param _builtins.str url: The URL path to documentation that explains how to perform the action.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "url", url)

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Text describing the recommended action.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The status of the resource action.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def url(self) -> _builtins.str:
        """
        The URL path to documentation that explains how to perform the action.
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class GetProfileLevelItemResult(dict):
    def __init__(__self__, *,
                 default_interval: _builtins.int,
                 metrics: Sequence['outputs.GetProfileLevelItemMetricResult'],
                 name: _builtins.str,
                 recommendation_name: _builtins.str,
                 time_created: _builtins.str,
                 time_updated: _builtins.str,
                 valid_intervals: Sequence[_builtins.int]):
        """
        :param _builtins.int default_interval: The default aggregation interval (in days) for profiles using this profile level.
        :param Sequence['GetProfileLevelItemMetricArgs'] metrics: The metrics that will be evaluated by profiles using this profile level.
        :param _builtins.str name: Optional. A filter that returns results that match the name specified.
        :param _builtins.str recommendation_name: Optional. A filter that returns results that match the recommendation name specified.
        :param _builtins.str time_created: The date and time the category details were created, in the format defined by RFC3339.
        :param _builtins.str time_updated: The date and time the category details were last updated, in the format defined by RFC3339.
        :param Sequence[_builtins.int] valid_intervals: An array of aggregation intervals (in days) allowed for profiles using this profile level.
        """
        pulumi.set(__self__, "default_interval", default_interval)
        pulumi.set(__self__, "metrics", metrics)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "recommendation_name", recommendation_name)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_updated", time_updated)
        pulumi.set(__self__, "valid_intervals", valid_intervals)

    @_builtins.property
    @pulumi.getter(name="defaultInterval")
    def default_interval(self) -> _builtins.int:
        """
        The default aggregation interval (in days) for profiles using this profile level.
        """
        return pulumi.get(self, "default_interval")

    @_builtins.property
    @pulumi.getter
    def metrics(self) -> Sequence['outputs.GetProfileLevelItemMetricResult']:
        """
        The metrics that will be evaluated by profiles using this profile level.
        """
        return pulumi.get(self, "metrics")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Optional. A filter that returns results that match the name specified.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="recommendationName")
    def recommendation_name(self) -> _builtins.str:
        """
        Optional. A filter that returns results that match the recommendation name specified.
        """
        return pulumi.get(self, "recommendation_name")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        The date and time the category details were created, in the format defined by RFC3339.
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> _builtins.str:
        """
        The date and time the category details were last updated, in the format defined by RFC3339.
        """
        return pulumi.get(self, "time_updated")

    @_builtins.property
    @pulumi.getter(name="validIntervals")
    def valid_intervals(self) -> Sequence[_builtins.int]:
        """
        An array of aggregation intervals (in days) allowed for profiles using this profile level.
        """
        return pulumi.get(self, "valid_intervals")


@pulumi.output_type
class GetProfileLevelItemMetricResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 statistic: _builtins.str,
                 target: _builtins.float,
                 threshold: _builtins.float):
        """
        :param _builtins.str name: Optional. A filter that returns results that match the name specified.
        :param _builtins.str statistic: The name of the statistic (e.g., `p95`).
        :param _builtins.float target: Optional. The metric value that the recommendation will target.
        :param _builtins.float threshold: The threshold that must be crossed for the recommendation to appear.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "statistic", statistic)
        pulumi.set(__self__, "target", target)
        pulumi.set(__self__, "threshold", threshold)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Optional. A filter that returns results that match the name specified.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def statistic(self) -> _builtins.str:
        """
        The name of the statistic (e.g., `p95`).
        """
        return pulumi.get(self, "statistic")

    @_builtins.property
    @pulumi.getter
    def target(self) -> _builtins.float:
        """
        Optional. The metric value that the recommendation will target.
        """
        return pulumi.get(self, "target")

    @_builtins.property
    @pulumi.getter
    def threshold(self) -> _builtins.float:
        """
        The threshold that must be crossed for the recommendation to appear.
        """
        return pulumi.get(self, "threshold")


@pulumi.output_type
class GetProfileLevelsConfigurationResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetProfileLevelsConfigurationItemResult']):
        """
        :param Sequence['GetProfileLevelsConfigurationItemArgs'] items: The list of tags specified in the current profile override.
        """
        pulumi.set(__self__, "items", items)

    @_builtins.property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetProfileLevelsConfigurationItemResult']:
        """
        The list of tags specified in the current profile override.
        """
        return pulumi.get(self, "items")


@pulumi.output_type
class GetProfileLevelsConfigurationItemResult(dict):
    def __init__(__self__, *,
                 level: _builtins.str,
                 recommendation_id: _builtins.str):
        """
        :param _builtins.str level: The pre-defined profile level.
        :param _builtins.str recommendation_id: The unique OCID of the recommendation.
        """
        pulumi.set(__self__, "level", level)
        pulumi.set(__self__, "recommendation_id", recommendation_id)

    @_builtins.property
    @pulumi.getter
    def level(self) -> _builtins.str:
        """
        The pre-defined profile level.
        """
        return pulumi.get(self, "level")

    @_builtins.property
    @pulumi.getter(name="recommendationId")
    def recommendation_id(self) -> _builtins.str:
        """
        The unique OCID of the recommendation.
        """
        return pulumi.get(self, "recommendation_id")


@pulumi.output_type
class GetProfileLevelsFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        """
        :param _builtins.str name: Optional. A filter that returns results that match the name specified.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Optional. A filter that returns results that match the name specified.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetProfileLevelsProfileLevelCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetProfileLevelsProfileLevelCollectionItemResult']):
        """
        :param Sequence['GetProfileLevelsProfileLevelCollectionItemArgs'] items: A collection of profile levels.
        """
        pulumi.set(__self__, "items", items)

    @_builtins.property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetProfileLevelsProfileLevelCollectionItemResult']:
        """
        A collection of profile levels.
        """
        return pulumi.get(self, "items")


@pulumi.output_type
class GetProfileLevelsProfileLevelCollectionItemResult(dict):
    def __init__(__self__, *,
                 default_interval: _builtins.int,
                 metrics: Sequence['outputs.GetProfileLevelsProfileLevelCollectionItemMetricResult'],
                 name: _builtins.str,
                 recommendation_name: _builtins.str,
                 time_created: _builtins.str,
                 time_updated: _builtins.str,
                 valid_intervals: Sequence[_builtins.int]):
        """
        :param _builtins.int default_interval: The default aggregation interval (in days) for profiles using this profile level.
        :param Sequence['GetProfileLevelsProfileLevelCollectionItemMetricArgs'] metrics: The metrics that will be evaluated by profiles using this profile level.
        :param _builtins.str name: Optional. A filter that returns results that match the name specified.
        :param _builtins.str recommendation_name: Optional. A filter that returns results that match the recommendation name specified.
        :param _builtins.str time_created: The date and time the category details were created, in the format defined by RFC3339.
        :param _builtins.str time_updated: The date and time the category details were last updated, in the format defined by RFC3339.
        :param Sequence[_builtins.int] valid_intervals: An array of aggregation intervals (in days) allowed for profiles using this profile level.
        """
        pulumi.set(__self__, "default_interval", default_interval)
        pulumi.set(__self__, "metrics", metrics)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "recommendation_name", recommendation_name)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_updated", time_updated)
        pulumi.set(__self__, "valid_intervals", valid_intervals)

    @_builtins.property
    @pulumi.getter(name="defaultInterval")
    def default_interval(self) -> _builtins.int:
        """
        The default aggregation interval (in days) for profiles using this profile level.
        """
        return pulumi.get(self, "default_interval")

    @_builtins.property
    @pulumi.getter
    def metrics(self) -> Sequence['outputs.GetProfileLevelsProfileLevelCollectionItemMetricResult']:
        """
        The metrics that will be evaluated by profiles using this profile level.
        """
        return pulumi.get(self, "metrics")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Optional. A filter that returns results that match the name specified.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="recommendationName")
    def recommendation_name(self) -> _builtins.str:
        """
        Optional. A filter that returns results that match the recommendation name specified.
        """
        return pulumi.get(self, "recommendation_name")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        The date and time the category details were created, in the format defined by RFC3339.
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> _builtins.str:
        """
        The date and time the category details were last updated, in the format defined by RFC3339.
        """
        return pulumi.get(self, "time_updated")

    @_builtins.property
    @pulumi.getter(name="validIntervals")
    def valid_intervals(self) -> Sequence[_builtins.int]:
        """
        An array of aggregation intervals (in days) allowed for profiles using this profile level.
        """
        return pulumi.get(self, "valid_intervals")


@pulumi.output_type
class GetProfileLevelsProfileLevelCollectionItemMetricResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 statistic: _builtins.str,
                 target: _builtins.float,
                 threshold: _builtins.float):
        """
        :param _builtins.str name: Optional. A filter that returns results that match the name specified.
        :param _builtins.str statistic: The name of the statistic (e.g., `p95`).
        :param _builtins.float target: Optional. The metric value that the recommendation will target.
        :param _builtins.float threshold: The threshold that must be crossed for the recommendation to appear.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "statistic", statistic)
        pulumi.set(__self__, "target", target)
        pulumi.set(__self__, "threshold", threshold)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Optional. A filter that returns results that match the name specified.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def statistic(self) -> _builtins.str:
        """
        The name of the statistic (e.g., `p95`).
        """
        return pulumi.get(self, "statistic")

    @_builtins.property
    @pulumi.getter
    def target(self) -> _builtins.float:
        """
        Optional. The metric value that the recommendation will target.
        """
        return pulumi.get(self, "target")

    @_builtins.property
    @pulumi.getter
    def threshold(self) -> _builtins.float:
        """
        The threshold that must be crossed for the recommendation to appear.
        """
        return pulumi.get(self, "threshold")


@pulumi.output_type
class GetProfileTargetCompartmentResult(dict):
    def __init__(__self__, *,
                 items: Sequence[_builtins.str]):
        """
        :param Sequence[_builtins.str] items: The list of tags specified in the current profile override.
        """
        pulumi.set(__self__, "items", items)

    @_builtins.property
    @pulumi.getter
    def items(self) -> Sequence[_builtins.str]:
        """
        The list of tags specified in the current profile override.
        """
        return pulumi.get(self, "items")


@pulumi.output_type
class GetProfileTargetTagResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetProfileTargetTagItemResult']):
        """
        :param Sequence['GetProfileTargetTagItemArgs'] items: The list of tags specified in the current profile override.
        """
        pulumi.set(__self__, "items", items)

    @_builtins.property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetProfileTargetTagItemResult']:
        """
        The list of tags specified in the current profile override.
        """
        return pulumi.get(self, "items")


@pulumi.output_type
class GetProfileTargetTagItemResult(dict):
    def __init__(__self__, *,
                 tag_definition_name: _builtins.str,
                 tag_namespace_name: _builtins.str,
                 tag_value_type: _builtins.str,
                 tag_values: Sequence[_builtins.str]):
        """
        :param _builtins.str tag_definition_name: The name you use to refer to the tag, also known as the tag key.
        :param _builtins.str tag_namespace_name: The name of the tag namespace.
        :param _builtins.str tag_value_type: Specifies which tag value types in the `tagValues` field result in overrides of the recommendation criteria.
        :param Sequence[_builtins.str] tag_values: The list of tag values. The tag value is the value that the user applying the tag adds to the tag key.
        """
        pulumi.set(__self__, "tag_definition_name", tag_definition_name)
        pulumi.set(__self__, "tag_namespace_name", tag_namespace_name)
        pulumi.set(__self__, "tag_value_type", tag_value_type)
        pulumi.set(__self__, "tag_values", tag_values)

    @_builtins.property
    @pulumi.getter(name="tagDefinitionName")
    def tag_definition_name(self) -> _builtins.str:
        """
        The name you use to refer to the tag, also known as the tag key.
        """
        return pulumi.get(self, "tag_definition_name")

    @_builtins.property
    @pulumi.getter(name="tagNamespaceName")
    def tag_namespace_name(self) -> _builtins.str:
        """
        The name of the tag namespace.
        """
        return pulumi.get(self, "tag_namespace_name")

    @_builtins.property
    @pulumi.getter(name="tagValueType")
    def tag_value_type(self) -> _builtins.str:
        """
        Specifies which tag value types in the `tagValues` field result in overrides of the recommendation criteria.
        """
        return pulumi.get(self, "tag_value_type")

    @_builtins.property
    @pulumi.getter(name="tagValues")
    def tag_values(self) -> Sequence[_builtins.str]:
        """
        The list of tag values. The tag value is the value that the user applying the tag adds to the tag key.
        """
        return pulumi.get(self, "tag_values")


@pulumi.output_type
class GetProfilesFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        """
        :param _builtins.str name: Optional. A filter that returns results that match the name specified.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Optional. A filter that returns results that match the name specified.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetProfilesProfileCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetProfilesProfileCollectionItemResult']):
        """
        :param Sequence['GetProfilesProfileCollectionItemArgs'] items: The list of tags specified in the current profile override.
        """
        pulumi.set(__self__, "items", items)

    @_builtins.property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetProfilesProfileCollectionItemResult']:
        """
        The list of tags specified in the current profile override.
        """
        return pulumi.get(self, "items")


@pulumi.output_type
class GetProfilesProfileCollectionItemResult(dict):
    def __init__(__self__, *,
                 aggregation_interval_in_days: _builtins.int,
                 compartment_id: _builtins.str,
                 defined_tags: Mapping[str, _builtins.str],
                 description: _builtins.str,
                 freeform_tags: Mapping[str, _builtins.str],
                 id: _builtins.str,
                 levels_configurations: Sequence['outputs.GetProfilesProfileCollectionItemLevelsConfigurationResult'],
                 name: _builtins.str,
                 state: _builtins.str,
                 system_tags: Mapping[str, _builtins.str],
                 target_compartments: Sequence['outputs.GetProfilesProfileCollectionItemTargetCompartmentResult'],
                 target_tags: Sequence['outputs.GetProfilesProfileCollectionItemTargetTagResult'],
                 time_created: _builtins.str,
                 time_updated: _builtins.str):
        """
        :param _builtins.int aggregation_interval_in_days: The time period over which to collect data for the recommendations, measured in number of days.
        :param _builtins.str compartment_id: The OCID of the compartment.
        :param Mapping[str, _builtins.str] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"foo-namespace.bar-key": "value"}`
        :param _builtins.str description: Text describing the profile. Avoid entering confidential information.
        :param Mapping[str, _builtins.str] freeform_tags: Simple key-value pair applied without any predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Exists for cross-compatibility only.  Example: `{"bar-key": "value"}`
        :param _builtins.str id: The unique OCID of the profile.
        :param Sequence['GetProfilesProfileCollectionItemLevelsConfigurationArgs'] levels_configurations: A list of configuration levels for each recommendation.
        :param _builtins.str name: Optional. A filter that returns results that match the name specified.
        :param _builtins.str state: A filter that returns results that match the lifecycle state specified.
        :param Sequence['GetProfilesProfileCollectionItemTargetCompartmentArgs'] target_compartments: Optional. The compartments specified in the profile override for a recommendation.
        :param Sequence['GetProfilesProfileCollectionItemTargetTagArgs'] target_tags: Optional. The tags specified in the profile override for a recommendation.
        :param _builtins.str time_created: The date and time the profile was created, in the format defined by RFC3339.
        :param _builtins.str time_updated: The date and time the profile was last updated, in the format defined by RFC3339.
        """
        pulumi.set(__self__, "aggregation_interval_in_days", aggregation_interval_in_days)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "levels_configurations", levels_configurations)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "system_tags", system_tags)
        pulumi.set(__self__, "target_compartments", target_compartments)
        pulumi.set(__self__, "target_tags", target_tags)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_updated", time_updated)

    @_builtins.property
    @pulumi.getter(name="aggregationIntervalInDays")
    def aggregation_interval_in_days(self) -> _builtins.int:
        """
        The time period over which to collect data for the recommendations, measured in number of days.
        """
        return pulumi.get(self, "aggregation_interval_in_days")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The OCID of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, _builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Text describing the profile. Avoid entering confidential information.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, _builtins.str]:
        """
        Simple key-value pair applied without any predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Exists for cross-compatibility only.  Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The unique OCID of the profile.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="levelsConfigurations")
    def levels_configurations(self) -> Sequence['outputs.GetProfilesProfileCollectionItemLevelsConfigurationResult']:
        """
        A list of configuration levels for each recommendation.
        """
        return pulumi.get(self, "levels_configurations")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Optional. A filter that returns results that match the name specified.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        A filter that returns results that match the lifecycle state specified.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, _builtins.str]:
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="targetCompartments")
    def target_compartments(self) -> Sequence['outputs.GetProfilesProfileCollectionItemTargetCompartmentResult']:
        """
        Optional. The compartments specified in the profile override for a recommendation.
        """
        return pulumi.get(self, "target_compartments")

    @_builtins.property
    @pulumi.getter(name="targetTags")
    def target_tags(self) -> Sequence['outputs.GetProfilesProfileCollectionItemTargetTagResult']:
        """
        Optional. The tags specified in the profile override for a recommendation.
        """
        return pulumi.get(self, "target_tags")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        The date and time the profile was created, in the format defined by RFC3339.
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> _builtins.str:
        """
        The date and time the profile was last updated, in the format defined by RFC3339.
        """
        return pulumi.get(self, "time_updated")


@pulumi.output_type
class GetProfilesProfileCollectionItemLevelsConfigurationResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetProfilesProfileCollectionItemLevelsConfigurationItemResult']):
        """
        :param Sequence['GetProfilesProfileCollectionItemLevelsConfigurationItemArgs'] items: The list of tags specified in the current profile override.
        """
        pulumi.set(__self__, "items", items)

    @_builtins.property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetProfilesProfileCollectionItemLevelsConfigurationItemResult']:
        """
        The list of tags specified in the current profile override.
        """
        return pulumi.get(self, "items")


@pulumi.output_type
class GetProfilesProfileCollectionItemLevelsConfigurationItemResult(dict):
    def __init__(__self__, *,
                 level: _builtins.str,
                 recommendation_id: _builtins.str):
        """
        :param _builtins.str level: The pre-defined profile level.
        :param _builtins.str recommendation_id: The unique OCID of the recommendation.
        """
        pulumi.set(__self__, "level", level)
        pulumi.set(__self__, "recommendation_id", recommendation_id)

    @_builtins.property
    @pulumi.getter
    def level(self) -> _builtins.str:
        """
        The pre-defined profile level.
        """
        return pulumi.get(self, "level")

    @_builtins.property
    @pulumi.getter(name="recommendationId")
    def recommendation_id(self) -> _builtins.str:
        """
        The unique OCID of the recommendation.
        """
        return pulumi.get(self, "recommendation_id")


@pulumi.output_type
class GetProfilesProfileCollectionItemTargetCompartmentResult(dict):
    def __init__(__self__, *,
                 items: Sequence[_builtins.str]):
        """
        :param Sequence[_builtins.str] items: The list of tags specified in the current profile override.
        """
        pulumi.set(__self__, "items", items)

    @_builtins.property
    @pulumi.getter
    def items(self) -> Sequence[_builtins.str]:
        """
        The list of tags specified in the current profile override.
        """
        return pulumi.get(self, "items")


@pulumi.output_type
class GetProfilesProfileCollectionItemTargetTagResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetProfilesProfileCollectionItemTargetTagItemResult']):
        """
        :param Sequence['GetProfilesProfileCollectionItemTargetTagItemArgs'] items: The list of tags specified in the current profile override.
        """
        pulumi.set(__self__, "items", items)

    @_builtins.property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetProfilesProfileCollectionItemTargetTagItemResult']:
        """
        The list of tags specified in the current profile override.
        """
        return pulumi.get(self, "items")


@pulumi.output_type
class GetProfilesProfileCollectionItemTargetTagItemResult(dict):
    def __init__(__self__, *,
                 tag_definition_name: _builtins.str,
                 tag_namespace_name: _builtins.str,
                 tag_value_type: _builtins.str,
                 tag_values: Sequence[_builtins.str]):
        """
        :param _builtins.str tag_definition_name: The name you use to refer to the tag, also known as the tag key.
        :param _builtins.str tag_namespace_name: The name of the tag namespace.
        :param _builtins.str tag_value_type: Specifies which tag value types in the `tagValues` field result in overrides of the recommendation criteria.
        :param Sequence[_builtins.str] tag_values: The list of tag values. The tag value is the value that the user applying the tag adds to the tag key.
        """
        pulumi.set(__self__, "tag_definition_name", tag_definition_name)
        pulumi.set(__self__, "tag_namespace_name", tag_namespace_name)
        pulumi.set(__self__, "tag_value_type", tag_value_type)
        pulumi.set(__self__, "tag_values", tag_values)

    @_builtins.property
    @pulumi.getter(name="tagDefinitionName")
    def tag_definition_name(self) -> _builtins.str:
        """
        The name you use to refer to the tag, also known as the tag key.
        """
        return pulumi.get(self, "tag_definition_name")

    @_builtins.property
    @pulumi.getter(name="tagNamespaceName")
    def tag_namespace_name(self) -> _builtins.str:
        """
        The name of the tag namespace.
        """
        return pulumi.get(self, "tag_namespace_name")

    @_builtins.property
    @pulumi.getter(name="tagValueType")
    def tag_value_type(self) -> _builtins.str:
        """
        Specifies which tag value types in the `tagValues` field result in overrides of the recommendation criteria.
        """
        return pulumi.get(self, "tag_value_type")

    @_builtins.property
    @pulumi.getter(name="tagValues")
    def tag_values(self) -> Sequence[_builtins.str]:
        """
        The list of tag values. The tag value is the value that the user applying the tag adds to the tag key.
        """
        return pulumi.get(self, "tag_values")


@pulumi.output_type
class GetRecommendationResourceCountResult(dict):
    def __init__(__self__, *,
                 count: _builtins.int,
                 status: _builtins.str):
        """
        :param _builtins.int count: The count of resources.
        :param _builtins.str status: The current status of the recommendation.
        """
        pulumi.set(__self__, "count", count)
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter
    def count(self) -> _builtins.int:
        """
        The count of resources.
        """
        return pulumi.get(self, "count")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The current status of the recommendation.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetRecommendationStrategiesFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        """
        :param _builtins.str name: Optional. A filter that returns results that match the name specified.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Optional. A filter that returns results that match the name specified.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetRecommendationStrategiesRecommendationStrategyCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetRecommendationStrategiesRecommendationStrategyCollectionItemResult']):
        """
        :param Sequence['GetRecommendationStrategiesRecommendationStrategyCollectionItemArgs'] items: A collection of recommendation strategy summaries.
        """
        pulumi.set(__self__, "items", items)

    @_builtins.property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetRecommendationStrategiesRecommendationStrategyCollectionItemResult']:
        """
        A collection of recommendation strategy summaries.
        """
        return pulumi.get(self, "items")


@pulumi.output_type
class GetRecommendationStrategiesRecommendationStrategyCollectionItemResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 strategies: Sequence['outputs.GetRecommendationStrategiesRecommendationStrategyCollectionItemStrategyResult']):
        """
        :param _builtins.str name: Optional. A filter that returns results that match the name specified.
        :param Sequence['GetRecommendationStrategiesRecommendationStrategyCollectionItemStrategyArgs'] strategies: The list of strategies used.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "strategies", strategies)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Optional. A filter that returns results that match the name specified.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def strategies(self) -> Sequence['outputs.GetRecommendationStrategiesRecommendationStrategyCollectionItemStrategyResult']:
        """
        The list of strategies used.
        """
        return pulumi.get(self, "strategies")


@pulumi.output_type
class GetRecommendationStrategiesRecommendationStrategyCollectionItemStrategyResult(dict):
    def __init__(__self__, *,
                 is_default: _builtins.bool,
                 parameters_definitions: Sequence['outputs.GetRecommendationStrategiesRecommendationStrategyCollectionItemStrategyParametersDefinitionResult'],
                 strategy_name: _builtins.str):
        """
        :param _builtins.bool is_default: Whether this is the default recommendation strategy.
        :param Sequence['GetRecommendationStrategiesRecommendationStrategyCollectionItemStrategyParametersDefinitionArgs'] parameters_definitions: The list of strategies for the parameters.
        :param _builtins.str strategy_name: The name of the strategy.
        """
        pulumi.set(__self__, "is_default", is_default)
        pulumi.set(__self__, "parameters_definitions", parameters_definitions)
        pulumi.set(__self__, "strategy_name", strategy_name)

    @_builtins.property
    @pulumi.getter(name="isDefault")
    def is_default(self) -> _builtins.bool:
        """
        Whether this is the default recommendation strategy.
        """
        return pulumi.get(self, "is_default")

    @_builtins.property
    @pulumi.getter(name="parametersDefinitions")
    def parameters_definitions(self) -> Sequence['outputs.GetRecommendationStrategiesRecommendationStrategyCollectionItemStrategyParametersDefinitionResult']:
        """
        The list of strategies for the parameters.
        """
        return pulumi.get(self, "parameters_definitions")

    @_builtins.property
    @pulumi.getter(name="strategyName")
    def strategy_name(self) -> _builtins.str:
        """
        The name of the strategy.
        """
        return pulumi.get(self, "strategy_name")


@pulumi.output_type
class GetRecommendationStrategiesRecommendationStrategyCollectionItemStrategyParametersDefinitionResult(dict):
    def __init__(__self__, *,
                 default_values: Sequence[Any],
                 description: _builtins.str,
                 is_required: _builtins.bool,
                 name: _builtins.str,
                 possible_values: Sequence[Any],
                 type: _builtins.str):
        """
        :param Sequence[Any] default_values: A default value used for the strategy parameter.
        :param _builtins.str description: Text describing the strategy parameter.
        :param _builtins.bool is_required: Whether this parameter is required.
        :param _builtins.str name: Optional. A filter that returns results that match the name specified.
        :param Sequence[Any] possible_values: The list of possible values used for these strategy parameters.
        :param _builtins.str type: The type of strategy parameter.
        """
        pulumi.set(__self__, "default_values", default_values)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "is_required", is_required)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "possible_values", possible_values)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="defaultValues")
    def default_values(self) -> Sequence[Any]:
        """
        A default value used for the strategy parameter.
        """
        return pulumi.get(self, "default_values")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Text describing the strategy parameter.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="isRequired")
    def is_required(self) -> _builtins.bool:
        """
        Whether this parameter is required.
        """
        return pulumi.get(self, "is_required")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Optional. A filter that returns results that match the name specified.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="possibleValues")
    def possible_values(self) -> Sequence[Any]:
        """
        The list of possible values used for these strategy parameters.
        """
        return pulumi.get(self, "possible_values")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The type of strategy parameter.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetRecommendationStrategyItemResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 strategies: Sequence['outputs.GetRecommendationStrategyItemStrategyResult']):
        """
        :param _builtins.str name: Optional. A filter that returns results that match the name specified.
        :param Sequence['GetRecommendationStrategyItemStrategyArgs'] strategies: The list of strategies used.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "strategies", strategies)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Optional. A filter that returns results that match the name specified.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def strategies(self) -> Sequence['outputs.GetRecommendationStrategyItemStrategyResult']:
        """
        The list of strategies used.
        """
        return pulumi.get(self, "strategies")


@pulumi.output_type
class GetRecommendationStrategyItemStrategyResult(dict):
    def __init__(__self__, *,
                 is_default: _builtins.bool,
                 parameters_definitions: Sequence['outputs.GetRecommendationStrategyItemStrategyParametersDefinitionResult'],
                 strategy_name: _builtins.str):
        """
        :param _builtins.bool is_default: Whether this is the default recommendation strategy.
        :param Sequence['GetRecommendationStrategyItemStrategyParametersDefinitionArgs'] parameters_definitions: The list of strategies for the parameters.
        :param _builtins.str strategy_name: The name of the strategy.
        """
        pulumi.set(__self__, "is_default", is_default)
        pulumi.set(__self__, "parameters_definitions", parameters_definitions)
        pulumi.set(__self__, "strategy_name", strategy_name)

    @_builtins.property
    @pulumi.getter(name="isDefault")
    def is_default(self) -> _builtins.bool:
        """
        Whether this is the default recommendation strategy.
        """
        return pulumi.get(self, "is_default")

    @_builtins.property
    @pulumi.getter(name="parametersDefinitions")
    def parameters_definitions(self) -> Sequence['outputs.GetRecommendationStrategyItemStrategyParametersDefinitionResult']:
        """
        The list of strategies for the parameters.
        """
        return pulumi.get(self, "parameters_definitions")

    @_builtins.property
    @pulumi.getter(name="strategyName")
    def strategy_name(self) -> _builtins.str:
        """
        The name of the strategy.
        """
        return pulumi.get(self, "strategy_name")


@pulumi.output_type
class GetRecommendationStrategyItemStrategyParametersDefinitionResult(dict):
    def __init__(__self__, *,
                 default_values: Sequence[Any],
                 description: _builtins.str,
                 is_required: _builtins.bool,
                 name: _builtins.str,
                 possible_values: Sequence[Any],
                 type: _builtins.str):
        """
        :param Sequence[Any] default_values: A default value used for the strategy parameter.
        :param _builtins.str description: Text describing the strategy parameter.
        :param _builtins.bool is_required: Whether this parameter is required.
        :param _builtins.str name: Optional. A filter that returns results that match the name specified.
        :param Sequence[Any] possible_values: The list of possible values used for these strategy parameters.
        :param _builtins.str type: The type of strategy parameter.
        """
        pulumi.set(__self__, "default_values", default_values)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "is_required", is_required)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "possible_values", possible_values)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="defaultValues")
    def default_values(self) -> Sequence[Any]:
        """
        A default value used for the strategy parameter.
        """
        return pulumi.get(self, "default_values")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Text describing the strategy parameter.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="isRequired")
    def is_required(self) -> _builtins.bool:
        """
        Whether this parameter is required.
        """
        return pulumi.get(self, "is_required")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Optional. A filter that returns results that match the name specified.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="possibleValues")
    def possible_values(self) -> Sequence[Any]:
        """
        The list of possible values used for these strategy parameters.
        """
        return pulumi.get(self, "possible_values")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The type of strategy parameter.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetRecommendationSupportedLevelResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetRecommendationSupportedLevelItemResult']):
        """
        :param Sequence['GetRecommendationSupportedLevelItemArgs'] items: The list of supported levels.
        """
        pulumi.set(__self__, "items", items)

    @_builtins.property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetRecommendationSupportedLevelItemResult']:
        """
        The list of supported levels.
        """
        return pulumi.get(self, "items")


@pulumi.output_type
class GetRecommendationSupportedLevelItemResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str):
        """
        :param _builtins.str name: The name of the profile level.
        """
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the profile level.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetRecommendationsFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        """
        :param _builtins.str name: Optional. A filter that returns results that match the name specified.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Optional. A filter that returns results that match the name specified.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetRecommendationsRecommendationCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetRecommendationsRecommendationCollectionItemResult']):
        """
        :param Sequence['GetRecommendationsRecommendationCollectionItemArgs'] items: The list of supported levels.
        """
        pulumi.set(__self__, "items", items)

    @_builtins.property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetRecommendationsRecommendationCollectionItemResult']:
        """
        The list of supported levels.
        """
        return pulumi.get(self, "items")


@pulumi.output_type
class GetRecommendationsRecommendationCollectionItemResult(dict):
    def __init__(__self__, *,
                 category_id: _builtins.str,
                 compartment_id: _builtins.str,
                 description: _builtins.str,
                 estimated_cost_saving: _builtins.float,
                 extended_metadata: Mapping[str, _builtins.str],
                 id: _builtins.str,
                 importance: _builtins.str,
                 name: _builtins.str,
                 recommendation_id: _builtins.str,
                 resource_counts: Sequence['outputs.GetRecommendationsRecommendationCollectionItemResourceCountResult'],
                 state: _builtins.str,
                 status: _builtins.str,
                 supported_levels: Sequence['outputs.GetRecommendationsRecommendationCollectionItemSupportedLevelResult'],
                 time_created: _builtins.str,
                 time_status_begin: _builtins.str,
                 time_status_end: _builtins.str,
                 time_updated: _builtins.str):
        """
        :param _builtins.str category_id: The unique OCID associated with the category.
        :param _builtins.str compartment_id: The OCID of the compartment.
        :param _builtins.str description: Text describing the recommendation.
        :param _builtins.float estimated_cost_saving: The estimated cost savings, in dollars, for the recommendation.
        :param Mapping[str, _builtins.str] extended_metadata: Additional metadata key/value pairs for the recommendation.
        :param _builtins.str id: The unique OCID associated with the recommendation.
        :param _builtins.str importance: The level of importance assigned to the recommendation.
        :param _builtins.str name: Optional. A filter that returns results that match the name specified.
        :param Sequence['GetRecommendationsRecommendationCollectionItemResourceCountArgs'] resource_counts: An array of `ResourceCount` objects grouped by the status of the resource actions.
        :param _builtins.str state: A filter that returns results that match the lifecycle state specified.
        :param _builtins.str status: A filter that returns recommendations that match the status specified.
        :param Sequence['GetRecommendationsRecommendationCollectionItemSupportedLevelArgs'] supported_levels: Optional. The profile levels supported by a recommendation. For example, profile level values could be `Low`, `Medium`, and `High`. Not all recommendations support this field.
        :param _builtins.str time_created: The date and time the recommendation details were created, in the format defined by RFC3339.
        :param _builtins.str time_status_begin: The date and time that the recommendation entered its current status. The format is defined by RFC3339.
        :param _builtins.str time_status_end: The date and time the current status will change. The format is defined by RFC3339.
        :param _builtins.str time_updated: The date and time the recommendation details were last updated, in the format defined by RFC3339.
        """
        pulumi.set(__self__, "category_id", category_id)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "estimated_cost_saving", estimated_cost_saving)
        pulumi.set(__self__, "extended_metadata", extended_metadata)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "importance", importance)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "recommendation_id", recommendation_id)
        pulumi.set(__self__, "resource_counts", resource_counts)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "supported_levels", supported_levels)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_status_begin", time_status_begin)
        pulumi.set(__self__, "time_status_end", time_status_end)
        pulumi.set(__self__, "time_updated", time_updated)

    @_builtins.property
    @pulumi.getter(name="categoryId")
    def category_id(self) -> _builtins.str:
        """
        The unique OCID associated with the category.
        """
        return pulumi.get(self, "category_id")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The OCID of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Text describing the recommendation.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="estimatedCostSaving")
    def estimated_cost_saving(self) -> _builtins.float:
        """
        The estimated cost savings, in dollars, for the recommendation.
        """
        return pulumi.get(self, "estimated_cost_saving")

    @_builtins.property
    @pulumi.getter(name="extendedMetadata")
    def extended_metadata(self) -> Mapping[str, _builtins.str]:
        """
        Additional metadata key/value pairs for the recommendation.
        """
        return pulumi.get(self, "extended_metadata")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The unique OCID associated with the recommendation.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def importance(self) -> _builtins.str:
        """
        The level of importance assigned to the recommendation.
        """
        return pulumi.get(self, "importance")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Optional. A filter that returns results that match the name specified.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="recommendationId")
    def recommendation_id(self) -> _builtins.str:
        return pulumi.get(self, "recommendation_id")

    @_builtins.property
    @pulumi.getter(name="resourceCounts")
    def resource_counts(self) -> Sequence['outputs.GetRecommendationsRecommendationCollectionItemResourceCountResult']:
        """
        An array of `ResourceCount` objects grouped by the status of the resource actions.
        """
        return pulumi.get(self, "resource_counts")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        A filter that returns results that match the lifecycle state specified.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        A filter that returns recommendations that match the status specified.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="supportedLevels")
    def supported_levels(self) -> Sequence['outputs.GetRecommendationsRecommendationCollectionItemSupportedLevelResult']:
        """
        Optional. The profile levels supported by a recommendation. For example, profile level values could be `Low`, `Medium`, and `High`. Not all recommendations support this field.
        """
        return pulumi.get(self, "supported_levels")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        The date and time the recommendation details were created, in the format defined by RFC3339.
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeStatusBegin")
    def time_status_begin(self) -> _builtins.str:
        """
        The date and time that the recommendation entered its current status. The format is defined by RFC3339.
        """
        return pulumi.get(self, "time_status_begin")

    @_builtins.property
    @pulumi.getter(name="timeStatusEnd")
    def time_status_end(self) -> _builtins.str:
        """
        The date and time the current status will change. The format is defined by RFC3339.
        """
        return pulumi.get(self, "time_status_end")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> _builtins.str:
        """
        The date and time the recommendation details were last updated, in the format defined by RFC3339.
        """
        return pulumi.get(self, "time_updated")


@pulumi.output_type
class GetRecommendationsRecommendationCollectionItemResourceCountResult(dict):
    def __init__(__self__, *,
                 count: _builtins.int,
                 status: _builtins.str):
        """
        :param _builtins.int count: The count of resources.
        :param _builtins.str status: A filter that returns recommendations that match the status specified.
        """
        pulumi.set(__self__, "count", count)
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter
    def count(self) -> _builtins.int:
        """
        The count of resources.
        """
        return pulumi.get(self, "count")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        A filter that returns recommendations that match the status specified.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetRecommendationsRecommendationCollectionItemSupportedLevelResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetRecommendationsRecommendationCollectionItemSupportedLevelItemResult']):
        """
        :param Sequence['GetRecommendationsRecommendationCollectionItemSupportedLevelItemArgs'] items: The list of supported levels.
        """
        pulumi.set(__self__, "items", items)

    @_builtins.property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetRecommendationsRecommendationCollectionItemSupportedLevelItemResult']:
        """
        The list of supported levels.
        """
        return pulumi.get(self, "items")


@pulumi.output_type
class GetRecommendationsRecommendationCollectionItemSupportedLevelItemResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str):
        """
        :param _builtins.str name: Optional. A filter that returns results that match the name specified.
        """
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Optional. A filter that returns results that match the name specified.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetResourceActionActionResult(dict):
    def __init__(__self__, *,
                 description: _builtins.str,
                 type: _builtins.str,
                 url: _builtins.str):
        """
        :param _builtins.str description: Text describing the recommended action.
        :param _builtins.str type: The status of the resource action.
        :param _builtins.str url: The URL path to documentation that explains how to perform the action.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "url", url)

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Text describing the recommended action.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The status of the resource action.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def url(self) -> _builtins.str:
        """
        The URL path to documentation that explains how to perform the action.
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class GetResourceActionsFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        """
        :param _builtins.str name: Optional. A filter that returns results that match the name specified.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Optional. A filter that returns results that match the name specified.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetResourceActionsResourceActionCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetResourceActionsResourceActionCollectionItemResult']):
        pulumi.set(__self__, "items", items)

    @_builtins.property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetResourceActionsResourceActionCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetResourceActionsResourceActionCollectionItemResult(dict):
    def __init__(__self__, *,
                 actions: Sequence['outputs.GetResourceActionsResourceActionCollectionItemActionResult'],
                 category_id: _builtins.str,
                 compartment_id: _builtins.str,
                 compartment_name: _builtins.str,
                 estimated_cost_saving: _builtins.float,
                 extended_metadata: Mapping[str, _builtins.str],
                 id: _builtins.str,
                 metadata: Mapping[str, _builtins.str],
                 name: _builtins.str,
                 recommendation_id: _builtins.str,
                 resource_action_id: _builtins.str,
                 resource_id: _builtins.str,
                 resource_type: _builtins.str,
                 state: _builtins.str,
                 status: _builtins.str,
                 time_created: _builtins.str,
                 time_status_begin: _builtins.str,
                 time_status_end: _builtins.str,
                 time_updated: _builtins.str):
        """
        :param Sequence['GetResourceActionsResourceActionCollectionItemActionArgs'] actions: Details about the recommended action.
        :param _builtins.str category_id: The unique OCID associated with the category.
        :param _builtins.str compartment_id: The OCID of the compartment.
        :param _builtins.str compartment_name: The name associated with the compartment.
        :param _builtins.float estimated_cost_saving: The estimated cost savings, in dollars, for the resource action.
        :param Mapping[str, _builtins.str] extended_metadata: Additional metadata key/value pairs that you provide. They serve the same purpose and functionality as fields in the `metadata` object.
        :param _builtins.str id: The unique OCID associated with the resource action.
        :param Mapping[str, _builtins.str] metadata: Custom metadata key/value pairs for the resource action.
        :param _builtins.str name: Optional. A filter that returns results that match the name specified.
        :param _builtins.str recommendation_id: The unique OCID associated with the recommendation.
        :param _builtins.str resource_id: The unique OCID associated with the resource.
        :param _builtins.str resource_type: Optional. A filter that returns results that match the resource type specified.
        :param _builtins.str state: A filter that returns results that match the lifecycle state specified.
        :param _builtins.str status: A filter that returns recommendations that match the status specified.
        :param _builtins.str time_created: The date and time the resource action details were created, in the format defined by RFC3339.
        :param _builtins.str time_status_begin: The date and time that the resource action entered its current status. The format is defined by RFC3339.
        :param _builtins.str time_status_end: The date and time the current status will change. The format is defined by RFC3339.
        :param _builtins.str time_updated: The date and time the resource action details were last updated, in the format defined by RFC3339.
        """
        pulumi.set(__self__, "actions", actions)
        pulumi.set(__self__, "category_id", category_id)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "compartment_name", compartment_name)
        pulumi.set(__self__, "estimated_cost_saving", estimated_cost_saving)
        pulumi.set(__self__, "extended_metadata", extended_metadata)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "metadata", metadata)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "recommendation_id", recommendation_id)
        pulumi.set(__self__, "resource_action_id", resource_action_id)
        pulumi.set(__self__, "resource_id", resource_id)
        pulumi.set(__self__, "resource_type", resource_type)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_status_begin", time_status_begin)
        pulumi.set(__self__, "time_status_end", time_status_end)
        pulumi.set(__self__, "time_updated", time_updated)

    @_builtins.property
    @pulumi.getter
    def actions(self) -> Sequence['outputs.GetResourceActionsResourceActionCollectionItemActionResult']:
        """
        Details about the recommended action.
        """
        return pulumi.get(self, "actions")

    @_builtins.property
    @pulumi.getter(name="categoryId")
    def category_id(self) -> _builtins.str:
        """
        The unique OCID associated with the category.
        """
        return pulumi.get(self, "category_id")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The OCID of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="compartmentName")
    def compartment_name(self) -> _builtins.str:
        """
        The name associated with the compartment.
        """
        return pulumi.get(self, "compartment_name")

    @_builtins.property
    @pulumi.getter(name="estimatedCostSaving")
    def estimated_cost_saving(self) -> _builtins.float:
        """
        The estimated cost savings, in dollars, for the resource action.
        """
        return pulumi.get(self, "estimated_cost_saving")

    @_builtins.property
    @pulumi.getter(name="extendedMetadata")
    def extended_metadata(self) -> Mapping[str, _builtins.str]:
        """
        Additional metadata key/value pairs that you provide. They serve the same purpose and functionality as fields in the `metadata` object.
        """
        return pulumi.get(self, "extended_metadata")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The unique OCID associated with the resource action.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> Mapping[str, _builtins.str]:
        """
        Custom metadata key/value pairs for the resource action.
        """
        return pulumi.get(self, "metadata")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Optional. A filter that returns results that match the name specified.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="recommendationId")
    def recommendation_id(self) -> _builtins.str:
        """
        The unique OCID associated with the recommendation.
        """
        return pulumi.get(self, "recommendation_id")

    @_builtins.property
    @pulumi.getter(name="resourceActionId")
    def resource_action_id(self) -> _builtins.str:
        return pulumi.get(self, "resource_action_id")

    @_builtins.property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> _builtins.str:
        """
        The unique OCID associated with the resource.
        """
        return pulumi.get(self, "resource_id")

    @_builtins.property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> _builtins.str:
        """
        Optional. A filter that returns results that match the resource type specified.
        """
        return pulumi.get(self, "resource_type")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        A filter that returns results that match the lifecycle state specified.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        A filter that returns recommendations that match the status specified.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        The date and time the resource action details were created, in the format defined by RFC3339.
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeStatusBegin")
    def time_status_begin(self) -> _builtins.str:
        """
        The date and time that the resource action entered its current status. The format is defined by RFC3339.
        """
        return pulumi.get(self, "time_status_begin")

    @_builtins.property
    @pulumi.getter(name="timeStatusEnd")
    def time_status_end(self) -> _builtins.str:
        """
        The date and time the current status will change. The format is defined by RFC3339.
        """
        return pulumi.get(self, "time_status_end")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> _builtins.str:
        """
        The date and time the resource action details were last updated, in the format defined by RFC3339.
        """
        return pulumi.get(self, "time_updated")


@pulumi.output_type
class GetResourceActionsResourceActionCollectionItemActionResult(dict):
    def __init__(__self__, *,
                 description: _builtins.str,
                 type: _builtins.str,
                 url: _builtins.str):
        """
        :param _builtins.str description: Text describing the recommended action.
        :param _builtins.str type: The status of the resource action.
        :param _builtins.str url: The URL path to documentation that explains how to perform the action.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "url", url)

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Text describing the recommended action.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The status of the resource action.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def url(self) -> _builtins.str:
        """
        The URL path to documentation that explains how to perform the action.
        """
        return pulumi.get(self, "url")


