# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['ProfileDetachSoftwareSourcesManagementArgs', 'ProfileDetachSoftwareSourcesManagement']

@pulumi.input_type
class ProfileDetachSoftwareSourcesManagementArgs:
    def __init__(__self__, *,
                 profile_id: pulumi.Input[_builtins.str],
                 software_sources: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        """
        The set of arguments for constructing a ProfileDetachSoftwareSourcesManagement resource.
        :param pulumi.Input[_builtins.str] profile_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the registration profile.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] software_sources: List of software source [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) to detach from the profile.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "profile_id", profile_id)
        pulumi.set(__self__, "software_sources", software_sources)

    @_builtins.property
    @pulumi.getter(name="profileId")
    def profile_id(self) -> pulumi.Input[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the registration profile.
        """
        return pulumi.get(self, "profile_id")

    @profile_id.setter
    def profile_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "profile_id", value)

    @_builtins.property
    @pulumi.getter(name="softwareSources")
    def software_sources(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        List of software source [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) to detach from the profile.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "software_sources")

    @software_sources.setter
    def software_sources(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "software_sources", value)


@pulumi.input_type
class _ProfileDetachSoftwareSourcesManagementState:
    def __init__(__self__, *,
                 profile_id: Optional[pulumi.Input[_builtins.str]] = None,
                 software_sources: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering ProfileDetachSoftwareSourcesManagement resources.
        :param pulumi.Input[_builtins.str] profile_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the registration profile.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] software_sources: List of software source [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) to detach from the profile.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        if profile_id is not None:
            pulumi.set(__self__, "profile_id", profile_id)
        if software_sources is not None:
            pulumi.set(__self__, "software_sources", software_sources)

    @_builtins.property
    @pulumi.getter(name="profileId")
    def profile_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the registration profile.
        """
        return pulumi.get(self, "profile_id")

    @profile_id.setter
    def profile_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "profile_id", value)

    @_builtins.property
    @pulumi.getter(name="softwareSources")
    def software_sources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of software source [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) to detach from the profile.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "software_sources")

    @software_sources.setter
    def software_sources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "software_sources", value)


@pulumi.type_token("oci:OsManagementHub/profileDetachSoftwareSourcesManagement:ProfileDetachSoftwareSourcesManagement")
class ProfileDetachSoftwareSourcesManagement(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 profile_id: Optional[pulumi.Input[_builtins.str]] = None,
                 software_sources: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        This resource provides the Profile Detach Software Sources Management resource in Oracle Cloud Infrastructure Os Management Hub service.

        Detaches the specified software sources from a profile.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_profile_detach_software_sources_management = oci.osmanagementhub.ProfileDetachSoftwareSourcesManagement("test_profile_detach_software_sources_management",
            profile_id=test_profile["id"],
            software_sources=profile_detach_software_sources_management_software_sources)
        ```

        ## Import

        ProfileDetachSoftwareSourcesManagement can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:OsManagementHub/profileDetachSoftwareSourcesManagement:ProfileDetachSoftwareSourcesManagement test_profile_detach_software_sources_management "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] profile_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the registration profile.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] software_sources: List of software source [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) to detach from the profile.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ProfileDetachSoftwareSourcesManagementArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Profile Detach Software Sources Management resource in Oracle Cloud Infrastructure Os Management Hub service.

        Detaches the specified software sources from a profile.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_profile_detach_software_sources_management = oci.osmanagementhub.ProfileDetachSoftwareSourcesManagement("test_profile_detach_software_sources_management",
            profile_id=test_profile["id"],
            software_sources=profile_detach_software_sources_management_software_sources)
        ```

        ## Import

        ProfileDetachSoftwareSourcesManagement can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:OsManagementHub/profileDetachSoftwareSourcesManagement:ProfileDetachSoftwareSourcesManagement test_profile_detach_software_sources_management "id"
        ```

        :param str resource_name: The name of the resource.
        :param ProfileDetachSoftwareSourcesManagementArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProfileDetachSoftwareSourcesManagementArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 profile_id: Optional[pulumi.Input[_builtins.str]] = None,
                 software_sources: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProfileDetachSoftwareSourcesManagementArgs.__new__(ProfileDetachSoftwareSourcesManagementArgs)

            if profile_id is None and not opts.urn:
                raise TypeError("Missing required property 'profile_id'")
            __props__.__dict__["profile_id"] = profile_id
            if software_sources is None and not opts.urn:
                raise TypeError("Missing required property 'software_sources'")
            __props__.__dict__["software_sources"] = software_sources
        super(ProfileDetachSoftwareSourcesManagement, __self__).__init__(
            'oci:OsManagementHub/profileDetachSoftwareSourcesManagement:ProfileDetachSoftwareSourcesManagement',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            profile_id: Optional[pulumi.Input[_builtins.str]] = None,
            software_sources: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None) -> 'ProfileDetachSoftwareSourcesManagement':
        """
        Get an existing ProfileDetachSoftwareSourcesManagement resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] profile_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the registration profile.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] software_sources: List of software source [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) to detach from the profile.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ProfileDetachSoftwareSourcesManagementState.__new__(_ProfileDetachSoftwareSourcesManagementState)

        __props__.__dict__["profile_id"] = profile_id
        __props__.__dict__["software_sources"] = software_sources
        return ProfileDetachSoftwareSourcesManagement(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="profileId")
    def profile_id(self) -> pulumi.Output[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the registration profile.
        """
        return pulumi.get(self, "profile_id")

    @_builtins.property
    @pulumi.getter(name="softwareSources")
    def software_sources(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        List of software source [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) to detach from the profile.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "software_sources")

