# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetOciCacheConfigSetsResult',
    'AwaitableGetOciCacheConfigSetsResult',
    'get_oci_cache_config_sets',
    'get_oci_cache_config_sets_output',
]

@pulumi.output_type
class GetOciCacheConfigSetsResult:
    """
    A collection of values returned by getOciCacheConfigSets.
    """
    def __init__(__self__, compartment_id=None, display_name=None, filters=None, id=None, oci_cache_config_set_collections=None, software_version=None, state=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if oci_cache_config_set_collections and not isinstance(oci_cache_config_set_collections, list):
            raise TypeError("Expected argument 'oci_cache_config_set_collections' to be a list")
        pulumi.set(__self__, "oci_cache_config_set_collections", oci_cache_config_set_collections)
        if software_version and not isinstance(software_version, str):
            raise TypeError("Expected argument 'software_version' to be a str")
        pulumi.set(__self__, "software_version", software_version)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm#Oracle) of the compartment that contains the Oracle Cloud Infrastructure Cache Config Set.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[_builtins.str]:
        """
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetOciCacheConfigSetsFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm#Oracle) of the Oracle Cloud Infrastructure Cache Config Set.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="ociCacheConfigSetCollections")
    def oci_cache_config_set_collections(self) -> Sequence['outputs.GetOciCacheConfigSetsOciCacheConfigSetCollectionResult']:
        """
        The list of oci_cache_config_set_collection.
        """
        return pulumi.get(self, "oci_cache_config_set_collections")

    @_builtins.property
    @pulumi.getter(name="softwareVersion")
    def software_version(self) -> Optional[_builtins.str]:
        """
        The Oracle Cloud Infrastructure Cache engine version that the cluster is running.
        """
        return pulumi.get(self, "software_version")

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[_builtins.str]:
        """
        The current state of the Oracle Cloud Infrastructure Cache Config Set.
        """
        return pulumi.get(self, "state")


class AwaitableGetOciCacheConfigSetsResult(GetOciCacheConfigSetsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetOciCacheConfigSetsResult(
            compartment_id=self.compartment_id,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            oci_cache_config_set_collections=self.oci_cache_config_set_collections,
            software_version=self.software_version,
            state=self.state)


def get_oci_cache_config_sets(compartment_id: Optional[_builtins.str] = None,
                              display_name: Optional[_builtins.str] = None,
                              filters: Optional[Sequence[Union['GetOciCacheConfigSetsFilterArgs', 'GetOciCacheConfigSetsFilterArgsDict']]] = None,
                              id: Optional[_builtins.str] = None,
                              software_version: Optional[_builtins.str] = None,
                              state: Optional[_builtins.str] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetOciCacheConfigSetsResult:
    """
    This data source provides the list of Oci Cache Config Sets in Oracle Cloud Infrastructure Redis service.

    Lists the Oracle Cloud Infrastructure Cache Config Sets in the specified compartment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_oci_cache_config_sets = oci.Redis.get_oci_cache_config_sets(compartment_id=compartment_id,
        display_name=oci_cache_config_set_display_name,
        id=oci_cache_config_set_id,
        software_version=oci_cache_config_set_software_version,
        state=oci_cache_config_set_state)
    ```


    :param _builtins.str compartment_id: The ID of the compartment in which to list resources.
    :param _builtins.str display_name: A filter to return only resources that match the entire display name given.
    :param _builtins.str id: Unique Oracle Cloud Infrastructure Cache Config Set identifier.
    :param _builtins.str software_version: A filter to return the Oracle Cloud Infrastructure Cache Config Set resources, whose software version matches with the given software version.
    :param _builtins.str state: A filter to return the Oracle Cloud Infrastructure Cache Config Set resources, whose lifecycle state matches with the given lifecycle state.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['softwareVersion'] = software_version
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Redis/getOciCacheConfigSets:getOciCacheConfigSets', __args__, opts=opts, typ=GetOciCacheConfigSetsResult).value

    return AwaitableGetOciCacheConfigSetsResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        oci_cache_config_set_collections=pulumi.get(__ret__, 'oci_cache_config_set_collections'),
        software_version=pulumi.get(__ret__, 'software_version'),
        state=pulumi.get(__ret__, 'state'))
def get_oci_cache_config_sets_output(compartment_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                     display_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                     filters: Optional[pulumi.Input[Optional[Sequence[Union['GetOciCacheConfigSetsFilterArgs', 'GetOciCacheConfigSetsFilterArgsDict']]]]] = None,
                                     id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                     software_version: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                     state: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetOciCacheConfigSetsResult]:
    """
    This data source provides the list of Oci Cache Config Sets in Oracle Cloud Infrastructure Redis service.

    Lists the Oracle Cloud Infrastructure Cache Config Sets in the specified compartment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_oci_cache_config_sets = oci.Redis.get_oci_cache_config_sets(compartment_id=compartment_id,
        display_name=oci_cache_config_set_display_name,
        id=oci_cache_config_set_id,
        software_version=oci_cache_config_set_software_version,
        state=oci_cache_config_set_state)
    ```


    :param _builtins.str compartment_id: The ID of the compartment in which to list resources.
    :param _builtins.str display_name: A filter to return only resources that match the entire display name given.
    :param _builtins.str id: Unique Oracle Cloud Infrastructure Cache Config Set identifier.
    :param _builtins.str software_version: A filter to return the Oracle Cloud Infrastructure Cache Config Set resources, whose software version matches with the given software version.
    :param _builtins.str state: A filter to return the Oracle Cloud Infrastructure Cache Config Set resources, whose lifecycle state matches with the given lifecycle state.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['softwareVersion'] = software_version
    __args__['state'] = state
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Redis/getOciCacheConfigSets:getOciCacheConfigSets', __args__, opts=opts, typ=GetOciCacheConfigSetsResult)
    return __ret__.apply(lambda __response__: GetOciCacheConfigSetsResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        display_name=pulumi.get(__response__, 'display_name'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        oci_cache_config_set_collections=pulumi.get(__response__, 'oci_cache_config_set_collections'),
        software_version=pulumi.get(__response__, 'software_version'),
        state=pulumi.get(__response__, 'state')))
