# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetSubscriptionProductsResult',
    'AwaitableGetSubscriptionProductsResult',
    'get_subscription_products',
    'get_subscription_products_output',
]

@pulumi.output_type
class GetSubscriptionProductsResult:
    """
    A collection of values returned by getSubscriptionProducts.
    """
    def __init__(__self__, filters=None, id=None, product_collections=None, producttype=None, subscription_id=None, tenancy_id=None, usage_period_key=None):
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if product_collections and not isinstance(product_collections, list):
            raise TypeError("Expected argument 'product_collections' to be a list")
        pulumi.set(__self__, "product_collections", product_collections)
        if producttype and not isinstance(producttype, str):
            raise TypeError("Expected argument 'producttype' to be a str")
        pulumi.set(__self__, "producttype", producttype)
        if subscription_id and not isinstance(subscription_id, str):
            raise TypeError("Expected argument 'subscription_id' to be a str")
        pulumi.set(__self__, "subscription_id", subscription_id)
        if tenancy_id and not isinstance(tenancy_id, str):
            raise TypeError("Expected argument 'tenancy_id' to be a str")
        pulumi.set(__self__, "tenancy_id", tenancy_id)
        if usage_period_key and not isinstance(usage_period_key, str):
            raise TypeError("Expected argument 'usage_period_key' to be a str")
        pulumi.set(__self__, "usage_period_key", usage_period_key)

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetSubscriptionProductsFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="productCollections")
    def product_collections(self) -> Sequence['outputs.GetSubscriptionProductsProductCollectionResult']:
        """
        The list of product_collection.
        """
        return pulumi.get(self, "product_collections")

    @_builtins.property
    @pulumi.getter
    def producttype(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "producttype")

    @_builtins.property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> _builtins.str:
        return pulumi.get(self, "subscription_id")

    @_builtins.property
    @pulumi.getter(name="tenancyId")
    def tenancy_id(self) -> _builtins.str:
        return pulumi.get(self, "tenancy_id")

    @_builtins.property
    @pulumi.getter(name="usagePeriodKey")
    def usage_period_key(self) -> _builtins.str:
        return pulumi.get(self, "usage_period_key")


class AwaitableGetSubscriptionProductsResult(GetSubscriptionProductsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSubscriptionProductsResult(
            filters=self.filters,
            id=self.id,
            product_collections=self.product_collections,
            producttype=self.producttype,
            subscription_id=self.subscription_id,
            tenancy_id=self.tenancy_id,
            usage_period_key=self.usage_period_key)


def get_subscription_products(filters: Optional[Sequence[Union['GetSubscriptionProductsFilterArgs', 'GetSubscriptionProductsFilterArgsDict']]] = None,
                              producttype: Optional[_builtins.str] = None,
                              subscription_id: Optional[_builtins.str] = None,
                              tenancy_id: Optional[_builtins.str] = None,
                              usage_period_key: Optional[_builtins.str] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSubscriptionProductsResult:
    """
    This data source provides the list of Subscription Products in Oracle Cloud Infrastructure Usage Proxy service.

    Provides product information that is specific to a reward usage period and its usage details.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_subscription_products = oci.UsageProxy.get_subscription_products(subscription_id=test_subscription["id"],
        tenancy_id=test_tenancy["id"],
        usage_period_key=subscription_product_usage_period_key,
        producttype=subscription_product_producttype)
    ```


    :param _builtins.str producttype: The field to specify the type of product.
    :param _builtins.str subscription_id: The subscription ID for which rewards information is requested for.
    :param _builtins.str tenancy_id: The OCID of the tenancy.
    :param _builtins.str usage_period_key: The SPM Identifier for the usage period.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['producttype'] = producttype
    __args__['subscriptionId'] = subscription_id
    __args__['tenancyId'] = tenancy_id
    __args__['usagePeriodKey'] = usage_period_key
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:UsageProxy/getSubscriptionProducts:getSubscriptionProducts', __args__, opts=opts, typ=GetSubscriptionProductsResult).value

    return AwaitableGetSubscriptionProductsResult(
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        product_collections=pulumi.get(__ret__, 'product_collections'),
        producttype=pulumi.get(__ret__, 'producttype'),
        subscription_id=pulumi.get(__ret__, 'subscription_id'),
        tenancy_id=pulumi.get(__ret__, 'tenancy_id'),
        usage_period_key=pulumi.get(__ret__, 'usage_period_key'))
def get_subscription_products_output(filters: Optional[pulumi.Input[Optional[Sequence[Union['GetSubscriptionProductsFilterArgs', 'GetSubscriptionProductsFilterArgsDict']]]]] = None,
                                     producttype: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                     subscription_id: Optional[pulumi.Input[_builtins.str]] = None,
                                     tenancy_id: Optional[pulumi.Input[_builtins.str]] = None,
                                     usage_period_key: Optional[pulumi.Input[_builtins.str]] = None,
                                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSubscriptionProductsResult]:
    """
    This data source provides the list of Subscription Products in Oracle Cloud Infrastructure Usage Proxy service.

    Provides product information that is specific to a reward usage period and its usage details.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_subscription_products = oci.UsageProxy.get_subscription_products(subscription_id=test_subscription["id"],
        tenancy_id=test_tenancy["id"],
        usage_period_key=subscription_product_usage_period_key,
        producttype=subscription_product_producttype)
    ```


    :param _builtins.str producttype: The field to specify the type of product.
    :param _builtins.str subscription_id: The subscription ID for which rewards information is requested for.
    :param _builtins.str tenancy_id: The OCID of the tenancy.
    :param _builtins.str usage_period_key: The SPM Identifier for the usage period.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['producttype'] = producttype
    __args__['subscriptionId'] = subscription_id
    __args__['tenancyId'] = tenancy_id
    __args__['usagePeriodKey'] = usage_period_key
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:UsageProxy/getSubscriptionProducts:getSubscriptionProducts', __args__, opts=opts, typ=GetSubscriptionProductsResult)
    return __ret__.apply(lambda __response__: GetSubscriptionProductsResult(
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        product_collections=pulumi.get(__response__, 'product_collections'),
        producttype=pulumi.get(__response__, 'producttype'),
        subscription_id=pulumi.get(__response__, 'subscription_id'),
        tenancy_id=pulumi.get(__response__, 'tenancy_id'),
        usage_period_key=pulumi.get(__response__, 'usage_period_key')))
