# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetPathAnalyzerTestsResult',
    'AwaitableGetPathAnalyzerTestsResult',
    'get_path_analyzer_tests',
    'get_path_analyzer_tests_output',
]

@pulumi.output_type
class GetPathAnalyzerTestsResult:
    """
    A collection of values returned by GetPathAnalyzerTests.
    """
    def __init__(__self__, compartment_id=None, display_name=None, filters=None, id=None, path_analyzer_test_collections=None, state=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if path_analyzer_test_collections and not isinstance(path_analyzer_test_collections, list):
            raise TypeError("Expected argument 'path_analyzer_test_collections' to be a list")
        pulumi.set(__self__, "path_analyzer_test_collections", path_analyzer_test_collections)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the `PathAnalyzerTest` resource's compartment.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[_builtins.str]:
        """
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetPathAnalyzerTestsFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="pathAnalyzerTestCollections")
    def path_analyzer_test_collections(self) -> Sequence['outputs.GetPathAnalyzerTestsPathAnalyzerTestCollectionResult']:
        """
        The list of path_analyzer_test_collection.
        """
        return pulumi.get(self, "path_analyzer_test_collections")

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[_builtins.str]:
        """
        The current state of the `PathAnalyzerTest` resource.
        """
        return pulumi.get(self, "state")


class AwaitableGetPathAnalyzerTestsResult(GetPathAnalyzerTestsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPathAnalyzerTestsResult(
            compartment_id=self.compartment_id,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            path_analyzer_test_collections=self.path_analyzer_test_collections,
            state=self.state)


def get_path_analyzer_tests(compartment_id: Optional[_builtins.str] = None,
                            display_name: Optional[_builtins.str] = None,
                            filters: Optional[Sequence[Union['GetPathAnalyzerTestsFilterArgs', 'GetPathAnalyzerTestsFilterArgsDict']]] = None,
                            state: Optional[_builtins.str] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPathAnalyzerTestsResult:
    """
    This data source provides the list of Path Analyzer Tests in Oracle Cloud Infrastructure Vn Monitoring service.

    Returns a list of all `PathAnalyzerTests` in a compartment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_path_analyzer_tests = oci.VnMonitoring.get_path_analyzer_tests(compartment_id=compartment_id,
        display_name=path_analyzer_test_display_name,
        state=path_analyzer_test_state)
    ```


    :param _builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param _builtins.str display_name: A filter that returns only resources that match the entire display name given.
    :param _builtins.str state: A filter that returns only resources whose `lifecycleState` matches the given `lifecycleState`.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:VnMonitoring/getPathAnalyzerTests:GetPathAnalyzerTests', __args__, opts=opts, typ=GetPathAnalyzerTestsResult).value

    return AwaitableGetPathAnalyzerTestsResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        path_analyzer_test_collections=pulumi.get(__ret__, 'path_analyzer_test_collections'),
        state=pulumi.get(__ret__, 'state'))
def get_path_analyzer_tests_output(compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                                   display_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                   filters: Optional[pulumi.Input[Optional[Sequence[Union['GetPathAnalyzerTestsFilterArgs', 'GetPathAnalyzerTestsFilterArgsDict']]]]] = None,
                                   state: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                   opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetPathAnalyzerTestsResult]:
    """
    This data source provides the list of Path Analyzer Tests in Oracle Cloud Infrastructure Vn Monitoring service.

    Returns a list of all `PathAnalyzerTests` in a compartment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_path_analyzer_tests = oci.VnMonitoring.get_path_analyzer_tests(compartment_id=compartment_id,
        display_name=path_analyzer_test_display_name,
        state=path_analyzer_test_state)
    ```


    :param _builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param _builtins.str display_name: A filter that returns only resources that match the entire display name given.
    :param _builtins.str state: A filter that returns only resources whose `lifecycleState` matches the given `lifecycleState`.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['state'] = state
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:VnMonitoring/getPathAnalyzerTests:GetPathAnalyzerTests', __args__, opts=opts, typ=GetPathAnalyzerTestsResult)
    return __ret__.apply(lambda __response__: GetPathAnalyzerTestsResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        display_name=pulumi.get(__response__, 'display_name'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        path_analyzer_test_collections=pulumi.get(__response__, 'path_analyzer_test_collections'),
        state=pulumi.get(__response__, 'state')))
