"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PythonFunction = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const fs = require("fs");
const path = require("path");
const aws_lambda_1 = require("aws-cdk-lib/aws-lambda");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const bundling_1 = require("./bundling");
/**
 * A Python Lambda function
 */
class PythonFunction extends aws_lambda_1.Function {
    constructor(scope, id, props) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_lambda_python_alpha_PythonFunctionProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, PythonFunction);
            }
            throw error;
        }
        const { index = 'index.py', handler = 'handler', runtime } = props;
        if (props.index && !/\.py$/.test(props.index)) {
            throw new Error('Only Python (.py) index files are supported.');
        }
        // Entry
        const entry = path.resolve(props.entry);
        const resolvedIndex = path.resolve(entry, index);
        if (!fs.existsSync(resolvedIndex)) {
            throw new Error(`Cannot find index file at ${resolvedIndex}`);
        }
        const resolvedHandler = `${index.slice(0, -3)}.${handler}`.replace(/\//g, '.');
        if (props.runtime && props.runtime.family !== aws_lambda_1.RuntimeFamily.PYTHON) {
            throw new Error('Only `PYTHON` runtimes are supported.');
        }
        super(scope, id, {
            ...props,
            runtime,
            code: bundling_1.Bundling.bundle({
                entry,
                runtime,
                skip: !aws_cdk_lib_1.Stack.of(scope).bundlingRequired,
                ...props.bundling,
            }),
            handler: resolvedHandler,
        });
    }
}
_a = JSII_RTTI_SYMBOL_1;
PythonFunction[_a] = { fqn: "@aws-cdk/aws-lambda-python-alpha.PythonFunction", version: "2.82.0-alpha.0" };
exports.PythonFunction = PythonFunction;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZnVuY3Rpb24uanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJmdW5jdGlvbi50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7Ozs7QUFBQSx5QkFBeUI7QUFDekIsNkJBQTZCO0FBQzdCLHVEQUEyRjtBQUMzRiw2Q0FBb0M7QUFFcEMseUNBQXNDO0FBMkN0Qzs7R0FFRztBQUNILE1BQWEsY0FBZSxTQUFRLHFCQUFRO0lBQzFDLFlBQVksS0FBZ0IsRUFBRSxFQUFVLEVBQUUsS0FBMEI7Ozs7OzsrQ0FEekQsY0FBYzs7OztRQUV2QixNQUFNLEVBQUUsS0FBSyxHQUFHLFVBQVUsRUFBRSxPQUFPLEdBQUcsU0FBUyxFQUFFLE9BQU8sRUFBRSxHQUFHLEtBQUssQ0FBQztRQUNuRSxJQUFJLEtBQUssQ0FBQyxLQUFLLElBQUksQ0FBQyxPQUFPLENBQUMsSUFBSSxDQUFDLEtBQUssQ0FBQyxLQUFLLENBQUMsRUFBRTtZQUM3QyxNQUFNLElBQUksS0FBSyxDQUFDLDhDQUE4QyxDQUFDLENBQUM7U0FDakU7UUFFRCxRQUFRO1FBQ1IsTUFBTSxLQUFLLEdBQUcsSUFBSSxDQUFDLE9BQU8sQ0FBQyxLQUFLLENBQUMsS0FBSyxDQUFDLENBQUM7UUFDeEMsTUFBTSxhQUFhLEdBQUcsSUFBSSxDQUFDLE9BQU8sQ0FBQyxLQUFLLEVBQUUsS0FBSyxDQUFDLENBQUM7UUFDakQsSUFBSSxDQUFDLEVBQUUsQ0FBQyxVQUFVLENBQUMsYUFBYSxDQUFDLEVBQUU7WUFDakMsTUFBTSxJQUFJLEtBQUssQ0FBQyw2QkFBNkIsYUFBYSxFQUFFLENBQUMsQ0FBQztTQUMvRDtRQUVELE1BQU0sZUFBZSxHQUFFLEdBQUcsS0FBSyxDQUFDLEtBQUssQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsSUFBSSxPQUFPLEVBQUUsQ0FBQyxPQUFPLENBQUMsS0FBSyxFQUFFLEdBQUcsQ0FBQyxDQUFDO1FBRTlFLElBQUksS0FBSyxDQUFDLE9BQU8sSUFBSSxLQUFLLENBQUMsT0FBTyxDQUFDLE1BQU0sS0FBSywwQkFBYSxDQUFDLE1BQU0sRUFBRTtZQUNsRSxNQUFNLElBQUksS0FBSyxDQUFDLHVDQUF1QyxDQUFDLENBQUM7U0FDMUQ7UUFFRCxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsRUFBRTtZQUNmLEdBQUcsS0FBSztZQUNSLE9BQU87WUFDUCxJQUFJLEVBQUUsbUJBQVEsQ0FBQyxNQUFNLENBQUM7Z0JBQ3BCLEtBQUs7Z0JBQ0wsT0FBTztnQkFDUCxJQUFJLEVBQUUsQ0FBQyxtQkFBSyxDQUFDLEVBQUUsQ0FBQyxLQUFLLENBQUMsQ0FBQyxnQkFBZ0I7Z0JBQ3ZDLEdBQUcsS0FBSyxDQUFDLFFBQVE7YUFDbEIsQ0FBQztZQUNGLE9BQU8sRUFBRSxlQUFlO1NBQ3pCLENBQUMsQ0FBQztLQUNKOzs7O0FBL0JVLHdDQUFjIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0ICogYXMgZnMgZnJvbSAnZnMnO1xuaW1wb3J0ICogYXMgcGF0aCBmcm9tICdwYXRoJztcbmltcG9ydCB7IEZ1bmN0aW9uLCBGdW5jdGlvbk9wdGlvbnMsIFJ1bnRpbWUsIFJ1bnRpbWVGYW1pbHkgfSBmcm9tICdhd3MtY2RrLWxpYi9hd3MtbGFtYmRhJztcbmltcG9ydCB7IFN0YWNrIH0gZnJvbSAnYXdzLWNkay1saWInO1xuaW1wb3J0IHsgQ29uc3RydWN0IH0gZnJvbSAnY29uc3RydWN0cyc7XG5pbXBvcnQgeyBCdW5kbGluZyB9IGZyb20gJy4vYnVuZGxpbmcnO1xuaW1wb3J0IHsgQnVuZGxpbmdPcHRpb25zIH0gZnJvbSAnLi90eXBlcyc7XG5cbi8qKlxuICogUHJvcGVydGllcyBmb3IgYSBQeXRob25GdW5jdGlvblxuICovXG5leHBvcnQgaW50ZXJmYWNlIFB5dGhvbkZ1bmN0aW9uUHJvcHMgZXh0ZW5kcyBGdW5jdGlvbk9wdGlvbnMge1xuICAvKipcbiAgICogUGF0aCB0byB0aGUgc291cmNlIG9mIHRoZSBmdW5jdGlvbiBvciB0aGUgbG9jYXRpb24gZm9yIGRlcGVuZGVuY2llcy5cbiAgICovXG4gIHJlYWRvbmx5IGVudHJ5OiBzdHJpbmc7XG5cbiAgLyoqXG4gICAqIFRoZSBydW50aW1lIGVudmlyb25tZW50LiBPbmx5IHJ1bnRpbWVzIG9mIHRoZSBQeXRob24gZmFtaWx5IGFyZVxuICAgKiBzdXBwb3J0ZWQuXG4gICAqXG4gICAqIEBkZWZhdWx0IFJ1bnRpbWUuUFlUSE9OXzNfN1xuICAgKi9cbiAgcmVhZG9ubHkgcnVudGltZTogUnVudGltZTtcblxuICAvKipcbiAgICogVGhlIHBhdGggKHJlbGF0aXZlIHRvIGVudHJ5KSB0byB0aGUgaW5kZXggZmlsZSBjb250YWluaW5nIHRoZSBleHBvcnRlZCBoYW5kbGVyLlxuICAgKlxuICAgKiBAZGVmYXVsdCBpbmRleC5weVxuICAgKi9cbiAgcmVhZG9ubHkgaW5kZXg/OiBzdHJpbmc7XG5cbiAgLyoqXG4gICAqIFRoZSBuYW1lIG9mIHRoZSBleHBvcnRlZCBoYW5kbGVyIGluIHRoZSBpbmRleCBmaWxlLlxuICAgKlxuICAgKiBAZGVmYXVsdCBoYW5kbGVyXG4gICAqL1xuICByZWFkb25seSBoYW5kbGVyPzogc3RyaW5nO1xuXG4gIC8qKlxuICAgKiBCdW5kbGluZyBvcHRpb25zIHRvIHVzZSBmb3IgdGhpcyBmdW5jdGlvbi4gVXNlIHRoaXMgdG8gc3BlY2lmeSBjdXN0b20gYnVuZGxpbmcgb3B0aW9ucyBsaWtlXG4gICAqIHRoZSBidW5kbGluZyBEb2NrZXIgaW1hZ2UsIGFzc2V0IGhhc2ggdHlwZSwgY3VzdG9tIGhhc2gsIGFyY2hpdGVjdHVyZSwgZXRjLlxuICAgKlxuICAgKiBAZGVmYXVsdCAtIFVzZSB0aGUgZGVmYXVsdCBidW5kbGluZyBEb2NrZXIgaW1hZ2UsIHdpdGggeDg2XzY0IGFyY2hpdGVjdHVyZS5cbiAgICovXG4gIHJlYWRvbmx5IGJ1bmRsaW5nPzogQnVuZGxpbmdPcHRpb25zO1xufVxuXG4vKipcbiAqIEEgUHl0aG9uIExhbWJkYSBmdW5jdGlvblxuICovXG5leHBvcnQgY2xhc3MgUHl0aG9uRnVuY3Rpb24gZXh0ZW5kcyBGdW5jdGlvbiB7XG4gIGNvbnN0cnVjdG9yKHNjb3BlOiBDb25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHByb3BzOiBQeXRob25GdW5jdGlvblByb3BzKSB7XG4gICAgY29uc3QgeyBpbmRleCA9ICdpbmRleC5weScsIGhhbmRsZXIgPSAnaGFuZGxlcicsIHJ1bnRpbWUgfSA9IHByb3BzO1xuICAgIGlmIChwcm9wcy5pbmRleCAmJiAhL1xcLnB5JC8udGVzdChwcm9wcy5pbmRleCkpIHtcbiAgICAgIHRocm93IG5ldyBFcnJvcignT25seSBQeXRob24gKC5weSkgaW5kZXggZmlsZXMgYXJlIHN1cHBvcnRlZC4nKTtcbiAgICB9XG5cbiAgICAvLyBFbnRyeVxuICAgIGNvbnN0IGVudHJ5ID0gcGF0aC5yZXNvbHZlKHByb3BzLmVudHJ5KTtcbiAgICBjb25zdCByZXNvbHZlZEluZGV4ID0gcGF0aC5yZXNvbHZlKGVudHJ5LCBpbmRleCk7XG4gICAgaWYgKCFmcy5leGlzdHNTeW5jKHJlc29sdmVkSW5kZXgpKSB7XG4gICAgICB0aHJvdyBuZXcgRXJyb3IoYENhbm5vdCBmaW5kIGluZGV4IGZpbGUgYXQgJHtyZXNvbHZlZEluZGV4fWApO1xuICAgIH1cblxuICAgIGNvbnN0IHJlc29sdmVkSGFuZGxlciA9YCR7aW5kZXguc2xpY2UoMCwgLTMpfS4ke2hhbmRsZXJ9YC5yZXBsYWNlKC9cXC8vZywgJy4nKTtcblxuICAgIGlmIChwcm9wcy5ydW50aW1lICYmIHByb3BzLnJ1bnRpbWUuZmFtaWx5ICE9PSBSdW50aW1lRmFtaWx5LlBZVEhPTikge1xuICAgICAgdGhyb3cgbmV3IEVycm9yKCdPbmx5IGBQWVRIT05gIHJ1bnRpbWVzIGFyZSBzdXBwb3J0ZWQuJyk7XG4gICAgfVxuXG4gICAgc3VwZXIoc2NvcGUsIGlkLCB7XG4gICAgICAuLi5wcm9wcyxcbiAgICAgIHJ1bnRpbWUsXG4gICAgICBjb2RlOiBCdW5kbGluZy5idW5kbGUoe1xuICAgICAgICBlbnRyeSxcbiAgICAgICAgcnVudGltZSxcbiAgICAgICAgc2tpcDogIVN0YWNrLm9mKHNjb3BlKS5idW5kbGluZ1JlcXVpcmVkLFxuICAgICAgICAuLi5wcm9wcy5idW5kbGluZyxcbiAgICAgIH0pLFxuICAgICAgaGFuZGxlcjogcmVzb2x2ZWRIYW5kbGVyLFxuICAgIH0pO1xuICB9XG59XG4iXX0=