from __future__ import annotations as _annotations

"""
Profile: http://hl7.org/fhir/StructureDefinition/RatioRange
Release: R4B
Version: 4.3.0
Build ID: c475c22
Last updated: 2022-05-28T12:47:40.239+10:00
"""
from pydantic import Field

from . import element, fhirtypes


class RatioRange(element.Element):
    """Disclaimer: Any field name ends with ``__ext`` doesn't part of
    Resource StructureDefinition, instead used to enable Extensibility feature
    for FHIR Primitive Data Types.

    Range of ratio values.
    A range of ratios expressed as a low and high numerator and a denominator.
    """

    __resource_type__ = "RatioRange"

    denominator: fhirtypes.QuantityType | None = Field(  # type: ignore
        default=None,
        alias="denominator",
        title="Denominator value",
        description="The value of the denominator.",
        json_schema_extra={
            "element_property": True,
            "summary_element_property": True,
        },
    )

    highNumerator: fhirtypes.QuantityType | None = Field(  # type: ignore
        default=None,
        alias="highNumerator",
        title="High Numerator limit",
        description="The value of the high limit numerator.",
        json_schema_extra={
            "element_property": True,
            "summary_element_property": True,
        },
    )

    lowNumerator: fhirtypes.QuantityType | None = Field(  # type: ignore
        default=None,
        alias="lowNumerator",
        title="Low Numerator limit",
        description="The value of the low limit numerator.",
        json_schema_extra={
            "element_property": True,
            "summary_element_property": True,
        },
    )

    @classmethod
    def elements_sequence(cls):
        """returning all element names from
        ``RatioRange`` according to specification,
        with preserving the original sequence order.
        """
        return ["id", "extension", "lowNumerator", "highNumerator", "denominator"]

    @classmethod
    def summary_elements_sequence(cls):
        """returning all element names (those have summary mode are enabled) from ``RatioRange`` according to specification,
        with preserving the original sequence order.
        """
        return ["lowNumerator", "highNumerator", "denominator"]
