"""Welcome to the SageWorks API Classes

These class provide high-level APIs for the SageWorks package, offering easy access to its core classes:

- DataSource: Manages AWS Data Catalog and Athena
- FeatureSet: Manages AWS Feature Store and Feature Groups
- Model: Manages the training and deployment of AWS Model Groups and Packages
- Endpoint: Manages the deployment and invocations/inference on AWS Endpoints
- Meta: Provides an API to retrieve AWS Metadata for the above classes
"""

from .data_source import DataSource
from .feature_set import FeatureSet
from .model import Model
from .endpoint import Endpoint
from .meta import Meta

__all__ = ["DataSource", "FeatureSet", "Model", "Endpoint", "Meta"]
