# coding: utf-8

"""
    Resource Manager API

    API v2 to manage resource containers - organizations, folders, projects incl. labels  ### Resource Management STACKIT resource management handles the terms _Organization_, _Folder_, _Project_, _Label_, and the hierarchical structure between them. Technically, organizations,  folders, and projects are _Resource Containers_ to which a _Label_ can be attached to. The STACKIT _Resource Manager_ provides CRUD endpoints to query and to modify the state.  ### Organizations STACKIT organizations are the base element to create and to use cloud-resources. An organization is bound to one customer account. Organizations have a lifecycle. - Organizations are always the root node in resource hierarchy and do not have a parent  ### Projects STACKIT projects are needed to use cloud-resources. Projects serve as wrapper for underlying technical structures and processes. Projects have a lifecycle. Projects compared to folders may have different policies. - Projects are optional, but mandatory for cloud-resource usage - A project can be created having either an organization, or a folder as parent - A project must not have a project as parent - Project names under the same parent must not be unique - Root organization cannot be changed  ### Label STACKIT labels are key-value pairs including a resource container reference. Labels can be defined and attached freely to resource containers by which resources can be organized and queried. - Policy-based, immutable labels may exists

    The version of the OpenAPI document: 2.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501 docstring might be too long

from datetime import datetime
from typing import Any, Dict, List, Optional, Tuple, Union

from pydantic import Field, StrictBool, StrictFloat, StrictInt, StrictStr, validate_call
from stackit.core.configuration import Configuration
from typing_extensions import Annotated

from stackit.resourcemanager.api_client import ApiClient, RequestSerialized
from stackit.resourcemanager.api_response import ApiResponse
from stackit.resourcemanager.models.create_project_payload import CreateProjectPayload
from stackit.resourcemanager.models.get_project_response import GetProjectResponse
from stackit.resourcemanager.models.list_organization_containers_response import (
    ListOrganizationContainersResponse,
)
from stackit.resourcemanager.models.list_organizations_response import (
    ListOrganizationsResponse,
)
from stackit.resourcemanager.models.list_projects_response import ListProjectsResponse
from stackit.resourcemanager.models.organization_response import OrganizationResponse
from stackit.resourcemanager.models.partial_update_project_payload import (
    PartialUpdateProjectPayload,
)
from stackit.resourcemanager.models.project import Project
from stackit.resourcemanager.rest import RESTResponseType


class DefaultApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, configuration: Configuration = None) -> None:
        if configuration is None:
            configuration = Configuration()
        self.configuration = configuration
        self.api_client = ApiClient(self.configuration)

    @validate_call
    def bff_get_containers_of_a_folder(
        self,
        id: Annotated[
            StrictStr,
            Field(description="Folder identifier - UUID identifier is preferred; containerId is also supported."),
        ],
        limit: Annotated[
            Optional[
                Union[
                    Annotated[float, Field(le=100, strict=True, ge=0)], Annotated[int, Field(le=100, strict=True, ge=0)]
                ]
            ],
            Field(
                description="The maximum number of projects to return in the response. If not present, an appropriate default will be used. If maximum is exceeded, maximum is used."
            ),
        ] = None,
        cursor: Annotated[
            Optional[StrictStr],
            Field(
                description="A pagination cursor is returned on the first call of the pagination process. If given, it will start from the end of the previous position. If not given, a new pagination is started."
            ),
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ListOrganizationContainersResponse:
        """Get Containers Of A Folder

        Returns all direct resource container under this folder including their metadata.  - Response items will contain all folders first, followed by all projects - If a folder does not have any containers, an empty items list will be returned  **Note:** Recursion is not supported - meaning only the next level in hierarchy tree is considered!

        :param id: Folder identifier - UUID identifier is preferred; containerId is also supported. (required)
        :type id: str
        :param limit: The maximum number of projects to return in the response. If not present, an appropriate default will be used. If maximum is exceeded, maximum is used.
        :type limit: float
        :param cursor: A pagination cursor is returned on the first call of the pagination process. If given, it will start from the end of the previous position. If not given, a new pagination is started.
        :type cursor: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501 docstring might be too long

        _param = self._bff_get_containers_of_a_folder_serialize(
            id=id,
            limit=limit,
            cursor=cursor,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "ListOrganizationContainersResponse",
            "400": "ErrorResponse",
            "401": "ErrorResponse",
        }
        response_data = self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def bff_get_containers_of_a_folder_with_http_info(
        self,
        id: Annotated[
            StrictStr,
            Field(description="Folder identifier - UUID identifier is preferred; containerId is also supported."),
        ],
        limit: Annotated[
            Optional[
                Union[
                    Annotated[float, Field(le=100, strict=True, ge=0)], Annotated[int, Field(le=100, strict=True, ge=0)]
                ]
            ],
            Field(
                description="The maximum number of projects to return in the response. If not present, an appropriate default will be used. If maximum is exceeded, maximum is used."
            ),
        ] = None,
        cursor: Annotated[
            Optional[StrictStr],
            Field(
                description="A pagination cursor is returned on the first call of the pagination process. If given, it will start from the end of the previous position. If not given, a new pagination is started."
            ),
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[ListOrganizationContainersResponse]:
        """Get Containers Of A Folder

        Returns all direct resource container under this folder including their metadata.  - Response items will contain all folders first, followed by all projects - If a folder does not have any containers, an empty items list will be returned  **Note:** Recursion is not supported - meaning only the next level in hierarchy tree is considered!

        :param id: Folder identifier - UUID identifier is preferred; containerId is also supported. (required)
        :type id: str
        :param limit: The maximum number of projects to return in the response. If not present, an appropriate default will be used. If maximum is exceeded, maximum is used.
        :type limit: float
        :param cursor: A pagination cursor is returned on the first call of the pagination process. If given, it will start from the end of the previous position. If not given, a new pagination is started.
        :type cursor: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501 docstring might be too long

        _param = self._bff_get_containers_of_a_folder_serialize(
            id=id,
            limit=limit,
            cursor=cursor,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "ListOrganizationContainersResponse",
            "400": "ErrorResponse",
            "401": "ErrorResponse",
        }
        response_data = self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def bff_get_containers_of_a_folder_without_preload_content(
        self,
        id: Annotated[
            StrictStr,
            Field(description="Folder identifier - UUID identifier is preferred; containerId is also supported."),
        ],
        limit: Annotated[
            Optional[
                Union[
                    Annotated[float, Field(le=100, strict=True, ge=0)], Annotated[int, Field(le=100, strict=True, ge=0)]
                ]
            ],
            Field(
                description="The maximum number of projects to return in the response. If not present, an appropriate default will be used. If maximum is exceeded, maximum is used."
            ),
        ] = None,
        cursor: Annotated[
            Optional[StrictStr],
            Field(
                description="A pagination cursor is returned on the first call of the pagination process. If given, it will start from the end of the previous position. If not given, a new pagination is started."
            ),
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get Containers Of A Folder

        Returns all direct resource container under this folder including their metadata.  - Response items will contain all folders first, followed by all projects - If a folder does not have any containers, an empty items list will be returned  **Note:** Recursion is not supported - meaning only the next level in hierarchy tree is considered!

        :param id: Folder identifier - UUID identifier is preferred; containerId is also supported. (required)
        :type id: str
        :param limit: The maximum number of projects to return in the response. If not present, an appropriate default will be used. If maximum is exceeded, maximum is used.
        :type limit: float
        :param cursor: A pagination cursor is returned on the first call of the pagination process. If given, it will start from the end of the previous position. If not given, a new pagination is started.
        :type cursor: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501 docstring might be too long

        _param = self._bff_get_containers_of_a_folder_serialize(
            id=id,
            limit=limit,
            cursor=cursor,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "ListOrganizationContainersResponse",
            "400": "ErrorResponse",
            "401": "ErrorResponse",
        }
        response_data = self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        return response_data.response

    def _bff_get_containers_of_a_folder_serialize(
        self,
        id,
        limit,
        cursor,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params["id"] = id
        # process the query parameters
        if limit is not None:

            _query_params.append(("limit", limit))

        if cursor is not None:

            _query_params.append(("cursor", cursor))

        # process the header parameters
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        if "Accept" not in _header_params:
            _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # authentication setting
        _auth_settings: List[str] = []

        return self.api_client.param_serialize(
            method="GET",
            resource_path="/bff/folders/{id}/containers",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    def bff_get_containers_of_an_organization(
        self,
        id: Annotated[
            StrictStr,
            Field(description="Organization identifier - UUID identifier is preferred; containerId is also supported."),
        ],
        limit: Annotated[
            Optional[
                Union[
                    Annotated[float, Field(le=100, strict=True, ge=0)], Annotated[int, Field(le=100, strict=True, ge=0)]
                ]
            ],
            Field(
                description="The maximum number of projects to return in the response. If not present, an appropriate default will be used. If maximum is exceeded, maximum is used."
            ),
        ] = None,
        cursor: Annotated[
            Optional[StrictStr],
            Field(
                description="A pagination cursor is returned on the first call of the pagination process. If given, it will start from the end of the previous position. If not given, a new pagination is started."
            ),
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ListOrganizationContainersResponse:
        """Get Containers Of An Organization

        Returns all direct resource container under this organization including their metadata. - Response items will contain all folders first, followed by all projects - If organization does not have any containers, an empty items list will be returned

        :param id: Organization identifier - UUID identifier is preferred; containerId is also supported. (required)
        :type id: str
        :param limit: The maximum number of projects to return in the response. If not present, an appropriate default will be used. If maximum is exceeded, maximum is used.
        :type limit: float
        :param cursor: A pagination cursor is returned on the first call of the pagination process. If given, it will start from the end of the previous position. If not given, a new pagination is started.
        :type cursor: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501 docstring might be too long

        _param = self._bff_get_containers_of_an_organization_serialize(
            id=id,
            limit=limit,
            cursor=cursor,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "ListOrganizationContainersResponse",
            "400": "ErrorResponse",
            "401": "ErrorResponse",
            "404": "ErrorResponse",
        }
        response_data = self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def bff_get_containers_of_an_organization_with_http_info(
        self,
        id: Annotated[
            StrictStr,
            Field(description="Organization identifier - UUID identifier is preferred; containerId is also supported."),
        ],
        limit: Annotated[
            Optional[
                Union[
                    Annotated[float, Field(le=100, strict=True, ge=0)], Annotated[int, Field(le=100, strict=True, ge=0)]
                ]
            ],
            Field(
                description="The maximum number of projects to return in the response. If not present, an appropriate default will be used. If maximum is exceeded, maximum is used."
            ),
        ] = None,
        cursor: Annotated[
            Optional[StrictStr],
            Field(
                description="A pagination cursor is returned on the first call of the pagination process. If given, it will start from the end of the previous position. If not given, a new pagination is started."
            ),
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[ListOrganizationContainersResponse]:
        """Get Containers Of An Organization

        Returns all direct resource container under this organization including their metadata. - Response items will contain all folders first, followed by all projects - If organization does not have any containers, an empty items list will be returned

        :param id: Organization identifier - UUID identifier is preferred; containerId is also supported. (required)
        :type id: str
        :param limit: The maximum number of projects to return in the response. If not present, an appropriate default will be used. If maximum is exceeded, maximum is used.
        :type limit: float
        :param cursor: A pagination cursor is returned on the first call of the pagination process. If given, it will start from the end of the previous position. If not given, a new pagination is started.
        :type cursor: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501 docstring might be too long

        _param = self._bff_get_containers_of_an_organization_serialize(
            id=id,
            limit=limit,
            cursor=cursor,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "ListOrganizationContainersResponse",
            "400": "ErrorResponse",
            "401": "ErrorResponse",
            "404": "ErrorResponse",
        }
        response_data = self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def bff_get_containers_of_an_organization_without_preload_content(
        self,
        id: Annotated[
            StrictStr,
            Field(description="Organization identifier - UUID identifier is preferred; containerId is also supported."),
        ],
        limit: Annotated[
            Optional[
                Union[
                    Annotated[float, Field(le=100, strict=True, ge=0)], Annotated[int, Field(le=100, strict=True, ge=0)]
                ]
            ],
            Field(
                description="The maximum number of projects to return in the response. If not present, an appropriate default will be used. If maximum is exceeded, maximum is used."
            ),
        ] = None,
        cursor: Annotated[
            Optional[StrictStr],
            Field(
                description="A pagination cursor is returned on the first call of the pagination process. If given, it will start from the end of the previous position. If not given, a new pagination is started."
            ),
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get Containers Of An Organization

        Returns all direct resource container under this organization including their metadata. - Response items will contain all folders first, followed by all projects - If organization does not have any containers, an empty items list will be returned

        :param id: Organization identifier - UUID identifier is preferred; containerId is also supported. (required)
        :type id: str
        :param limit: The maximum number of projects to return in the response. If not present, an appropriate default will be used. If maximum is exceeded, maximum is used.
        :type limit: float
        :param cursor: A pagination cursor is returned on the first call of the pagination process. If given, it will start from the end of the previous position. If not given, a new pagination is started.
        :type cursor: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501 docstring might be too long

        _param = self._bff_get_containers_of_an_organization_serialize(
            id=id,
            limit=limit,
            cursor=cursor,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "ListOrganizationContainersResponse",
            "400": "ErrorResponse",
            "401": "ErrorResponse",
            "404": "ErrorResponse",
        }
        response_data = self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        return response_data.response

    def _bff_get_containers_of_an_organization_serialize(
        self,
        id,
        limit,
        cursor,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params["id"] = id
        # process the query parameters
        if limit is not None:

            _query_params.append(("limit", limit))

        if cursor is not None:

            _query_params.append(("cursor", cursor))

        # process the header parameters
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        if "Accept" not in _header_params:
            _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # authentication setting
        _auth_settings: List[str] = []

        return self.api_client.param_serialize(
            method="GET",
            resource_path="/bff/organizations/{id}/containers",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    def create_project(
        self,
        create_project_payload: Optional[CreateProjectPayload] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> Project:
        """Create Project

        Create a new project.  - The request is synchronous, but the workflow-based creation is asynchronous. - Lifecycle state remains in CREATING, until workflow completes

        :param create_project_payload:
        :type create_project_payload: CreateProjectPayload
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501 docstring might be too long

        _param = self._create_project_serialize(
            create_project_payload=create_project_payload,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "201": "Project",
            "400": "ErrorResponse",
            "403": "ErrorResponse",
            "409": "ErrorResponse",
        }
        response_data = self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def create_project_with_http_info(
        self,
        create_project_payload: Optional[CreateProjectPayload] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[Project]:
        """Create Project

        Create a new project.  - The request is synchronous, but the workflow-based creation is asynchronous. - Lifecycle state remains in CREATING, until workflow completes

        :param create_project_payload:
        :type create_project_payload: CreateProjectPayload
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501 docstring might be too long

        _param = self._create_project_serialize(
            create_project_payload=create_project_payload,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "201": "Project",
            "400": "ErrorResponse",
            "403": "ErrorResponse",
            "409": "ErrorResponse",
        }
        response_data = self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def create_project_without_preload_content(
        self,
        create_project_payload: Optional[CreateProjectPayload] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Create Project

        Create a new project.  - The request is synchronous, but the workflow-based creation is asynchronous. - Lifecycle state remains in CREATING, until workflow completes

        :param create_project_payload:
        :type create_project_payload: CreateProjectPayload
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501 docstring might be too long

        _param = self._create_project_serialize(
            create_project_payload=create_project_payload,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "201": "Project",
            "400": "ErrorResponse",
            "403": "ErrorResponse",
            "409": "ErrorResponse",
        }
        response_data = self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        return response_data.response

    def _create_project_serialize(
        self,
        create_project_payload,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if create_project_payload is not None:
            _body_params = create_project_payload

        # set the HTTP header `Accept`
        if "Accept" not in _header_params:
            _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params["Content-Type"] = _content_type
        else:
            _default_content_type = self.api_client.select_header_content_type(["application/json"])
            if _default_content_type is not None:
                _header_params["Content-Type"] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = []

        return self.api_client.param_serialize(
            method="POST",
            resource_path="/v2/projects",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    def delete_project(
        self,
        id: Annotated[
            StrictStr, Field(description="Project identifier - containerId as well as UUID identifier is supported.")
        ],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> None:
        """Delete Project

        Triggers the deletion of a project.  - The request is synchronous, but the workflow-based deletion is asynchronous - Lifecycle state remains in DELETING, until workflow completes

        :param id: Project identifier - containerId as well as UUID identifier is supported. (required)
        :type id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501 docstring might be too long

        _param = self._delete_project_serialize(
            id=id, _request_auth=_request_auth, _content_type=_content_type, _headers=_headers, _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "202": None,
            "409": "ErrorResponse",
        }
        response_data = self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def delete_project_with_http_info(
        self,
        id: Annotated[
            StrictStr, Field(description="Project identifier - containerId as well as UUID identifier is supported.")
        ],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[None]:
        """Delete Project

        Triggers the deletion of a project.  - The request is synchronous, but the workflow-based deletion is asynchronous - Lifecycle state remains in DELETING, until workflow completes

        :param id: Project identifier - containerId as well as UUID identifier is supported. (required)
        :type id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501 docstring might be too long

        _param = self._delete_project_serialize(
            id=id, _request_auth=_request_auth, _content_type=_content_type, _headers=_headers, _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "202": None,
            "409": "ErrorResponse",
        }
        response_data = self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def delete_project_without_preload_content(
        self,
        id: Annotated[
            StrictStr, Field(description="Project identifier - containerId as well as UUID identifier is supported.")
        ],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Delete Project

        Triggers the deletion of a project.  - The request is synchronous, but the workflow-based deletion is asynchronous - Lifecycle state remains in DELETING, until workflow completes

        :param id: Project identifier - containerId as well as UUID identifier is supported. (required)
        :type id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501 docstring might be too long

        _param = self._delete_project_serialize(
            id=id, _request_auth=_request_auth, _content_type=_content_type, _headers=_headers, _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "202": None,
            "409": "ErrorResponse",
        }
        response_data = self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        return response_data.response

    def _delete_project_serialize(
        self,
        id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params["id"] = id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        if "Accept" not in _header_params:
            _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # authentication setting
        _auth_settings: List[str] = []

        return self.api_client.param_serialize(
            method="DELETE",
            resource_path="/v2/projects/{id}",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    def get_organization(
        self,
        id: Annotated[
            StrictStr,
            Field(description="Organization identifier - containerId as well as UUID identifier is supported."),
        ],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> OrganizationResponse:
        """Get Organization Details

        Returns the organization and its metadata.

        :param id: Organization identifier - containerId as well as UUID identifier is supported. (required)
        :type id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501 docstring might be too long

        _param = self._get_organization_serialize(
            id=id, _request_auth=_request_auth, _content_type=_content_type, _headers=_headers, _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "OrganizationResponse",
            "404": "ErrorResponse",
        }
        response_data = self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def get_organization_with_http_info(
        self,
        id: Annotated[
            StrictStr,
            Field(description="Organization identifier - containerId as well as UUID identifier is supported."),
        ],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[OrganizationResponse]:
        """Get Organization Details

        Returns the organization and its metadata.

        :param id: Organization identifier - containerId as well as UUID identifier is supported. (required)
        :type id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501 docstring might be too long

        _param = self._get_organization_serialize(
            id=id, _request_auth=_request_auth, _content_type=_content_type, _headers=_headers, _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "OrganizationResponse",
            "404": "ErrorResponse",
        }
        response_data = self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def get_organization_without_preload_content(
        self,
        id: Annotated[
            StrictStr,
            Field(description="Organization identifier - containerId as well as UUID identifier is supported."),
        ],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get Organization Details

        Returns the organization and its metadata.

        :param id: Organization identifier - containerId as well as UUID identifier is supported. (required)
        :type id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501 docstring might be too long

        _param = self._get_organization_serialize(
            id=id, _request_auth=_request_auth, _content_type=_content_type, _headers=_headers, _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "OrganizationResponse",
            "404": "ErrorResponse",
        }
        response_data = self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        return response_data.response

    def _get_organization_serialize(
        self,
        id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params["id"] = id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        if "Accept" not in _header_params:
            _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # authentication setting
        _auth_settings: List[str] = []

        return self.api_client.param_serialize(
            method="GET",
            resource_path="/v2/organizations/{id}",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    def get_project(
        self,
        id: Annotated[
            StrictStr, Field(description="Project identifier - containerId as well as UUID identifier is supported.")
        ],
        include_parents: Optional[StrictBool] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> GetProjectResponse:
        """Get Project Details

        Returns the project and its metadata.

        :param id: Project identifier - containerId as well as UUID identifier is supported. (required)
        :type id: str
        :param include_parents:
        :type include_parents: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501 docstring might be too long

        _param = self._get_project_serialize(
            id=id,
            include_parents=include_parents,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "GetProjectResponse",
            "403": "ErrorResponse",
            "404": "ErrorResponse",
        }
        response_data = self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def get_project_with_http_info(
        self,
        id: Annotated[
            StrictStr, Field(description="Project identifier - containerId as well as UUID identifier is supported.")
        ],
        include_parents: Optional[StrictBool] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[GetProjectResponse]:
        """Get Project Details

        Returns the project and its metadata.

        :param id: Project identifier - containerId as well as UUID identifier is supported. (required)
        :type id: str
        :param include_parents:
        :type include_parents: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501 docstring might be too long

        _param = self._get_project_serialize(
            id=id,
            include_parents=include_parents,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "GetProjectResponse",
            "403": "ErrorResponse",
            "404": "ErrorResponse",
        }
        response_data = self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def get_project_without_preload_content(
        self,
        id: Annotated[
            StrictStr, Field(description="Project identifier - containerId as well as UUID identifier is supported.")
        ],
        include_parents: Optional[StrictBool] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get Project Details

        Returns the project and its metadata.

        :param id: Project identifier - containerId as well as UUID identifier is supported. (required)
        :type id: str
        :param include_parents:
        :type include_parents: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501 docstring might be too long

        _param = self._get_project_serialize(
            id=id,
            include_parents=include_parents,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "GetProjectResponse",
            "403": "ErrorResponse",
            "404": "ErrorResponse",
        }
        response_data = self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        return response_data.response

    def _get_project_serialize(
        self,
        id,
        include_parents,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params["id"] = id
        # process the query parameters
        if include_parents is not None:

            _query_params.append(("includeParents", include_parents))

        # process the header parameters
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        if "Accept" not in _header_params:
            _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # authentication setting
        _auth_settings: List[str] = []

        return self.api_client.param_serialize(
            method="GET",
            resource_path="/v2/projects/{id}",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    def list_organizations(
        self,
        container_ids: Annotated[
            Optional[List[StrictStr]],
            Field(
                description="Organization identifiers - containerId as well as UUID identifier is supported. A combination of both is not allowed."
            ),
        ] = None,
        member: Annotated[
            Optional[StrictStr],
            Field(
                description="E-Mail address of the user for whom the visible resource containers should be filtered."
            ),
        ] = None,
        limit: Annotated[
            Optional[
                Union[
                    Annotated[float, Field(le=100, strict=True, ge=0)], Annotated[int, Field(le=100, strict=True, ge=0)]
                ]
            ],
            Field(
                description="The maximum number of projects to return in the response. If not present, an appropriate default will be used. If maximum is exceeded, maximum is used."
            ),
        ] = None,
        offset: Annotated[
            Optional[Union[Annotated[float, Field(strict=True, ge=0)], Annotated[int, Field(strict=True, ge=0)]]],
            Field(description="The offset of the first item in the collection to return."),
        ] = None,
        creation_time_start: Annotated[
            Optional[datetime],
            Field(
                description="A timestamp to specify the beginning of the creationTime from which entries should be returned. If not given, defaults to the beginning of time."
            ),
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ListOrganizationsResponse:
        """Get All Organizations

        Returns all organizations and their metadata. - If no containerIds are specified, all organizations are returned, if permitted - ContainerIds may be set to filter - Member may be set to filter - If member and containerIds are given, both are used for filtering

        :param container_ids: Organization identifiers - containerId as well as UUID identifier is supported. A combination of both is not allowed.
        :type container_ids: List[str]
        :param member: E-Mail address of the user for whom the visible resource containers should be filtered.
        :type member: str
        :param limit: The maximum number of projects to return in the response. If not present, an appropriate default will be used. If maximum is exceeded, maximum is used.
        :type limit: float
        :param offset: The offset of the first item in the collection to return.
        :type offset: float
        :param creation_time_start: A timestamp to specify the beginning of the creationTime from which entries should be returned. If not given, defaults to the beginning of time.
        :type creation_time_start: datetime
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501 docstring might be too long

        _param = self._list_organizations_serialize(
            container_ids=container_ids,
            member=member,
            limit=limit,
            offset=offset,
            creation_time_start=creation_time_start,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "ListOrganizationsResponse",
            "400": "ErrorResponse",
            "403": "ErrorResponse",
        }
        response_data = self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def list_organizations_with_http_info(
        self,
        container_ids: Annotated[
            Optional[List[StrictStr]],
            Field(
                description="Organization identifiers - containerId as well as UUID identifier is supported. A combination of both is not allowed."
            ),
        ] = None,
        member: Annotated[
            Optional[StrictStr],
            Field(
                description="E-Mail address of the user for whom the visible resource containers should be filtered."
            ),
        ] = None,
        limit: Annotated[
            Optional[
                Union[
                    Annotated[float, Field(le=100, strict=True, ge=0)], Annotated[int, Field(le=100, strict=True, ge=0)]
                ]
            ],
            Field(
                description="The maximum number of projects to return in the response. If not present, an appropriate default will be used. If maximum is exceeded, maximum is used."
            ),
        ] = None,
        offset: Annotated[
            Optional[Union[Annotated[float, Field(strict=True, ge=0)], Annotated[int, Field(strict=True, ge=0)]]],
            Field(description="The offset of the first item in the collection to return."),
        ] = None,
        creation_time_start: Annotated[
            Optional[datetime],
            Field(
                description="A timestamp to specify the beginning of the creationTime from which entries should be returned. If not given, defaults to the beginning of time."
            ),
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[ListOrganizationsResponse]:
        """Get All Organizations

        Returns all organizations and their metadata. - If no containerIds are specified, all organizations are returned, if permitted - ContainerIds may be set to filter - Member may be set to filter - If member and containerIds are given, both are used for filtering

        :param container_ids: Organization identifiers - containerId as well as UUID identifier is supported. A combination of both is not allowed.
        :type container_ids: List[str]
        :param member: E-Mail address of the user for whom the visible resource containers should be filtered.
        :type member: str
        :param limit: The maximum number of projects to return in the response. If not present, an appropriate default will be used. If maximum is exceeded, maximum is used.
        :type limit: float
        :param offset: The offset of the first item in the collection to return.
        :type offset: float
        :param creation_time_start: A timestamp to specify the beginning of the creationTime from which entries should be returned. If not given, defaults to the beginning of time.
        :type creation_time_start: datetime
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501 docstring might be too long

        _param = self._list_organizations_serialize(
            container_ids=container_ids,
            member=member,
            limit=limit,
            offset=offset,
            creation_time_start=creation_time_start,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "ListOrganizationsResponse",
            "400": "ErrorResponse",
            "403": "ErrorResponse",
        }
        response_data = self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def list_organizations_without_preload_content(
        self,
        container_ids: Annotated[
            Optional[List[StrictStr]],
            Field(
                description="Organization identifiers - containerId as well as UUID identifier is supported. A combination of both is not allowed."
            ),
        ] = None,
        member: Annotated[
            Optional[StrictStr],
            Field(
                description="E-Mail address of the user for whom the visible resource containers should be filtered."
            ),
        ] = None,
        limit: Annotated[
            Optional[
                Union[
                    Annotated[float, Field(le=100, strict=True, ge=0)], Annotated[int, Field(le=100, strict=True, ge=0)]
                ]
            ],
            Field(
                description="The maximum number of projects to return in the response. If not present, an appropriate default will be used. If maximum is exceeded, maximum is used."
            ),
        ] = None,
        offset: Annotated[
            Optional[Union[Annotated[float, Field(strict=True, ge=0)], Annotated[int, Field(strict=True, ge=0)]]],
            Field(description="The offset of the first item in the collection to return."),
        ] = None,
        creation_time_start: Annotated[
            Optional[datetime],
            Field(
                description="A timestamp to specify the beginning of the creationTime from which entries should be returned. If not given, defaults to the beginning of time."
            ),
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get All Organizations

        Returns all organizations and their metadata. - If no containerIds are specified, all organizations are returned, if permitted - ContainerIds may be set to filter - Member may be set to filter - If member and containerIds are given, both are used for filtering

        :param container_ids: Organization identifiers - containerId as well as UUID identifier is supported. A combination of both is not allowed.
        :type container_ids: List[str]
        :param member: E-Mail address of the user for whom the visible resource containers should be filtered.
        :type member: str
        :param limit: The maximum number of projects to return in the response. If not present, an appropriate default will be used. If maximum is exceeded, maximum is used.
        :type limit: float
        :param offset: The offset of the first item in the collection to return.
        :type offset: float
        :param creation_time_start: A timestamp to specify the beginning of the creationTime from which entries should be returned. If not given, defaults to the beginning of time.
        :type creation_time_start: datetime
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501 docstring might be too long

        _param = self._list_organizations_serialize(
            container_ids=container_ids,
            member=member,
            limit=limit,
            offset=offset,
            creation_time_start=creation_time_start,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "ListOrganizationsResponse",
            "400": "ErrorResponse",
            "403": "ErrorResponse",
        }
        response_data = self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        return response_data.response

    def _list_organizations_serialize(
        self,
        container_ids,
        member,
        limit,
        offset,
        creation_time_start,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            "containerIds": "multi",
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if container_ids is not None:

            _query_params.append(("containerIds", container_ids))

        if member is not None:

            _query_params.append(("member", member))

        if limit is not None:

            _query_params.append(("limit", limit))

        if offset is not None:

            _query_params.append(("offset", offset))

        if creation_time_start is not None:
            if isinstance(creation_time_start, datetime):
                _query_params.append(
                    ("creation-time-start", creation_time_start.strftime(self.api_client.configuration.datetime_format))
                )
            else:
                _query_params.append(("creation-time-start", creation_time_start))

        # process the header parameters
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        if "Accept" not in _header_params:
            _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # authentication setting
        _auth_settings: List[str] = []

        return self.api_client.param_serialize(
            method="GET",
            resource_path="/v2/organizations",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    def list_projects(
        self,
        container_parent_id: Annotated[
            Optional[StrictStr],
            Field(
                description="Identifier of the parent resource container - containerId as well as UUID identifier is supported."
            ),
        ] = None,
        container_ids: Annotated[
            Optional[List[StrictStr]],
            Field(description="List of container identifiers - containerId as well as UUID identifier is supported."),
        ] = None,
        member: Annotated[
            Optional[StrictStr],
            Field(
                description="E-Mail address of the user for whom the visible resource containers should be filtered."
            ),
        ] = None,
        offset: Annotated[
            Optional[Union[Annotated[float, Field(strict=True, ge=0)], Annotated[int, Field(strict=True, ge=0)]]],
            Field(description="The offset of the first item in the collection to return."),
        ] = None,
        limit: Annotated[
            Optional[
                Union[
                    Annotated[float, Field(le=100, strict=True, ge=0)], Annotated[int, Field(le=100, strict=True, ge=0)]
                ]
            ],
            Field(
                description="The maximum number of projects to return in the response. If not present, an appropriate default will be used. If maximum is exceeded, maximum is used."
            ),
        ] = None,
        creation_time_start: Annotated[
            Optional[datetime],
            Field(
                description="A timestamp to specify the beginning of the creationTime from which entries should be returned. If not given, defaults to the beginning of time."
            ),
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ListProjectsResponse:
        """Get All Projects

        Returns all projects and their metadata that:  - Are children of the specific containerParentId - Match the given containerIds - User is member of  Filter: - Either containerParentId OR containerIds OR member must be passed - If containerId and containerParentId are given, both are used for filtering - containers must point to the same parent - If member and containerParentId are given, both are used for filtering - If member is given, containers must not point to the same container parent

        :param container_parent_id: Identifier of the parent resource container - containerId as well as UUID identifier is supported.
        :type container_parent_id: str
        :param container_ids: List of container identifiers - containerId as well as UUID identifier is supported.
        :type container_ids: List[str]
        :param member: E-Mail address of the user for whom the visible resource containers should be filtered.
        :type member: str
        :param offset: The offset of the first item in the collection to return.
        :type offset: float
        :param limit: The maximum number of projects to return in the response. If not present, an appropriate default will be used. If maximum is exceeded, maximum is used.
        :type limit: float
        :param creation_time_start: A timestamp to specify the beginning of the creationTime from which entries should be returned. If not given, defaults to the beginning of time.
        :type creation_time_start: datetime
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501 docstring might be too long

        _param = self._list_projects_serialize(
            container_parent_id=container_parent_id,
            container_ids=container_ids,
            member=member,
            offset=offset,
            limit=limit,
            creation_time_start=creation_time_start,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "ListProjectsResponse",
            "400": "ErrorResponse",
            "403": "ErrorResponse",
        }
        response_data = self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def list_projects_with_http_info(
        self,
        container_parent_id: Annotated[
            Optional[StrictStr],
            Field(
                description="Identifier of the parent resource container - containerId as well as UUID identifier is supported."
            ),
        ] = None,
        container_ids: Annotated[
            Optional[List[StrictStr]],
            Field(description="List of container identifiers - containerId as well as UUID identifier is supported."),
        ] = None,
        member: Annotated[
            Optional[StrictStr],
            Field(
                description="E-Mail address of the user for whom the visible resource containers should be filtered."
            ),
        ] = None,
        offset: Annotated[
            Optional[Union[Annotated[float, Field(strict=True, ge=0)], Annotated[int, Field(strict=True, ge=0)]]],
            Field(description="The offset of the first item in the collection to return."),
        ] = None,
        limit: Annotated[
            Optional[
                Union[
                    Annotated[float, Field(le=100, strict=True, ge=0)], Annotated[int, Field(le=100, strict=True, ge=0)]
                ]
            ],
            Field(
                description="The maximum number of projects to return in the response. If not present, an appropriate default will be used. If maximum is exceeded, maximum is used."
            ),
        ] = None,
        creation_time_start: Annotated[
            Optional[datetime],
            Field(
                description="A timestamp to specify the beginning of the creationTime from which entries should be returned. If not given, defaults to the beginning of time."
            ),
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[ListProjectsResponse]:
        """Get All Projects

        Returns all projects and their metadata that:  - Are children of the specific containerParentId - Match the given containerIds - User is member of  Filter: - Either containerParentId OR containerIds OR member must be passed - If containerId and containerParentId are given, both are used for filtering - containers must point to the same parent - If member and containerParentId are given, both are used for filtering - If member is given, containers must not point to the same container parent

        :param container_parent_id: Identifier of the parent resource container - containerId as well as UUID identifier is supported.
        :type container_parent_id: str
        :param container_ids: List of container identifiers - containerId as well as UUID identifier is supported.
        :type container_ids: List[str]
        :param member: E-Mail address of the user for whom the visible resource containers should be filtered.
        :type member: str
        :param offset: The offset of the first item in the collection to return.
        :type offset: float
        :param limit: The maximum number of projects to return in the response. If not present, an appropriate default will be used. If maximum is exceeded, maximum is used.
        :type limit: float
        :param creation_time_start: A timestamp to specify the beginning of the creationTime from which entries should be returned. If not given, defaults to the beginning of time.
        :type creation_time_start: datetime
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501 docstring might be too long

        _param = self._list_projects_serialize(
            container_parent_id=container_parent_id,
            container_ids=container_ids,
            member=member,
            offset=offset,
            limit=limit,
            creation_time_start=creation_time_start,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "ListProjectsResponse",
            "400": "ErrorResponse",
            "403": "ErrorResponse",
        }
        response_data = self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def list_projects_without_preload_content(
        self,
        container_parent_id: Annotated[
            Optional[StrictStr],
            Field(
                description="Identifier of the parent resource container - containerId as well as UUID identifier is supported."
            ),
        ] = None,
        container_ids: Annotated[
            Optional[List[StrictStr]],
            Field(description="List of container identifiers - containerId as well as UUID identifier is supported."),
        ] = None,
        member: Annotated[
            Optional[StrictStr],
            Field(
                description="E-Mail address of the user for whom the visible resource containers should be filtered."
            ),
        ] = None,
        offset: Annotated[
            Optional[Union[Annotated[float, Field(strict=True, ge=0)], Annotated[int, Field(strict=True, ge=0)]]],
            Field(description="The offset of the first item in the collection to return."),
        ] = None,
        limit: Annotated[
            Optional[
                Union[
                    Annotated[float, Field(le=100, strict=True, ge=0)], Annotated[int, Field(le=100, strict=True, ge=0)]
                ]
            ],
            Field(
                description="The maximum number of projects to return in the response. If not present, an appropriate default will be used. If maximum is exceeded, maximum is used."
            ),
        ] = None,
        creation_time_start: Annotated[
            Optional[datetime],
            Field(
                description="A timestamp to specify the beginning of the creationTime from which entries should be returned. If not given, defaults to the beginning of time."
            ),
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get All Projects

        Returns all projects and their metadata that:  - Are children of the specific containerParentId - Match the given containerIds - User is member of  Filter: - Either containerParentId OR containerIds OR member must be passed - If containerId and containerParentId are given, both are used for filtering - containers must point to the same parent - If member and containerParentId are given, both are used for filtering - If member is given, containers must not point to the same container parent

        :param container_parent_id: Identifier of the parent resource container - containerId as well as UUID identifier is supported.
        :type container_parent_id: str
        :param container_ids: List of container identifiers - containerId as well as UUID identifier is supported.
        :type container_ids: List[str]
        :param member: E-Mail address of the user for whom the visible resource containers should be filtered.
        :type member: str
        :param offset: The offset of the first item in the collection to return.
        :type offset: float
        :param limit: The maximum number of projects to return in the response. If not present, an appropriate default will be used. If maximum is exceeded, maximum is used.
        :type limit: float
        :param creation_time_start: A timestamp to specify the beginning of the creationTime from which entries should be returned. If not given, defaults to the beginning of time.
        :type creation_time_start: datetime
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501 docstring might be too long

        _param = self._list_projects_serialize(
            container_parent_id=container_parent_id,
            container_ids=container_ids,
            member=member,
            offset=offset,
            limit=limit,
            creation_time_start=creation_time_start,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "ListProjectsResponse",
            "400": "ErrorResponse",
            "403": "ErrorResponse",
        }
        response_data = self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        return response_data.response

    def _list_projects_serialize(
        self,
        container_parent_id,
        container_ids,
        member,
        offset,
        limit,
        creation_time_start,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            "containerIds": "multi",
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if container_parent_id is not None:

            _query_params.append(("containerParentId", container_parent_id))

        if container_ids is not None:

            _query_params.append(("containerIds", container_ids))

        if member is not None:

            _query_params.append(("member", member))

        if offset is not None:

            _query_params.append(("offset", offset))

        if limit is not None:

            _query_params.append(("limit", limit))

        if creation_time_start is not None:
            if isinstance(creation_time_start, datetime):
                _query_params.append(
                    ("creation-time-start", creation_time_start.strftime(self.api_client.configuration.datetime_format))
                )
            else:
                _query_params.append(("creation-time-start", creation_time_start))

        # process the header parameters
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        if "Accept" not in _header_params:
            _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # authentication setting
        _auth_settings: List[str] = []

        return self.api_client.param_serialize(
            method="GET",
            resource_path="/v2/projects",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    def partial_update_project(
        self,
        id: Annotated[
            StrictStr, Field(description="Project identifier - containerId as well as UUID identifier is supported.")
        ],
        partial_update_project_payload: Optional[PartialUpdateProjectPayload] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> Project:
        """Update Project

        Update the project and its metadata. - Update project name  - Update project labels  - Update project parent (folder or organization)

        :param id: Project identifier - containerId as well as UUID identifier is supported. (required)
        :type id: str
        :param partial_update_project_payload:
        :type partial_update_project_payload: PartialUpdateProjectPayload
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501 docstring might be too long

        _param = self._partial_update_project_serialize(
            id=id,
            partial_update_project_payload=partial_update_project_payload,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "Project",
            "403": "ErrorResponse",
            "404": "ErrorResponse",
            "409": "ErrorResponse",
        }
        response_data = self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def partial_update_project_with_http_info(
        self,
        id: Annotated[
            StrictStr, Field(description="Project identifier - containerId as well as UUID identifier is supported.")
        ],
        partial_update_project_payload: Optional[PartialUpdateProjectPayload] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[Project]:
        """Update Project

        Update the project and its metadata. - Update project name  - Update project labels  - Update project parent (folder or organization)

        :param id: Project identifier - containerId as well as UUID identifier is supported. (required)
        :type id: str
        :param partial_update_project_payload:
        :type partial_update_project_payload: PartialUpdateProjectPayload
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501 docstring might be too long

        _param = self._partial_update_project_serialize(
            id=id,
            partial_update_project_payload=partial_update_project_payload,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "Project",
            "403": "ErrorResponse",
            "404": "ErrorResponse",
            "409": "ErrorResponse",
        }
        response_data = self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def partial_update_project_without_preload_content(
        self,
        id: Annotated[
            StrictStr, Field(description="Project identifier - containerId as well as UUID identifier is supported.")
        ],
        partial_update_project_payload: Optional[PartialUpdateProjectPayload] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Update Project

        Update the project and its metadata. - Update project name  - Update project labels  - Update project parent (folder or organization)

        :param id: Project identifier - containerId as well as UUID identifier is supported. (required)
        :type id: str
        :param partial_update_project_payload:
        :type partial_update_project_payload: PartialUpdateProjectPayload
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501 docstring might be too long

        _param = self._partial_update_project_serialize(
            id=id,
            partial_update_project_payload=partial_update_project_payload,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "Project",
            "403": "ErrorResponse",
            "404": "ErrorResponse",
            "409": "ErrorResponse",
        }
        response_data = self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        return response_data.response

    def _partial_update_project_serialize(
        self,
        id,
        partial_update_project_payload,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params["id"] = id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if partial_update_project_payload is not None:
            _body_params = partial_update_project_payload

        # set the HTTP header `Accept`
        if "Accept" not in _header_params:
            _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params["Content-Type"] = _content_type
        else:
            _default_content_type = self.api_client.select_header_content_type(["application/json"])
            if _default_content_type is not None:
                _header_params["Content-Type"] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = []

        return self.api_client.param_serialize(
            method="PATCH",
            resource_path="/v2/projects/{id}",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )
