# coding: utf-8

"""
    Resource Manager API

    API v2 to manage resource containers - organizations, folders, projects incl. labels  ### Resource Management STACKIT resource management handles the terms _Organization_, _Folder_, _Project_, _Label_, and the hierarchical structure between them. Technically, organizations,  folders, and projects are _Resource Containers_ to which a _Label_ can be attached to. The STACKIT _Resource Manager_ provides CRUD endpoints to query and to modify the state.  ### Organizations STACKIT organizations are the base element to create and to use cloud-resources. An organization is bound to one customer account. Organizations have a lifecycle. - Organizations are always the root node in resource hierarchy and do not have a parent  ### Projects STACKIT projects are needed to use cloud-resources. Projects serve as wrapper for underlying technical structures and processes. Projects have a lifecycle. Projects compared to folders may have different policies. - Projects are optional, but mandatory for cloud-resource usage - A project can be created having either an organization, or a folder as parent - A project must not have a project as parent - Project names under the same parent must not be unique - Root organization cannot be changed  ### Label STACKIT labels are key-value pairs including a resource container reference. Labels can be defined and attached freely to resource containers by which resources can be organized and queried. - Policy-based, immutable labels may exists

    The version of the OpenAPI document: 2.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501 docstring might be too long

from __future__ import annotations

import json
import pprint
from typing import TYPE_CHECKING, Any, Dict, Optional, Set, Union

from pydantic import (
    BaseModel,
    ValidationError,
    field_validator,
)
from typing_extensions import Self

from stackit.resourcemanager.models.list_organization_containers_response_items_inner_any_of import (
    ListOrganizationContainersResponseItemsInnerAnyOf,
)
from stackit.resourcemanager.models.list_organization_containers_response_items_inner_any_of1 import (
    ListOrganizationContainersResponseItemsInnerAnyOf1,
)


LISTORGANIZATIONCONTAINERSRESPONSEITEMSINNER_ANY_OF_SCHEMAS = [
    "ListOrganizationContainersResponseItemsInnerAnyOf",
    "ListOrganizationContainersResponseItemsInnerAnyOf1",
]


class ListOrganizationContainersResponseItemsInner(BaseModel):
    """
    ListOrganizationContainersResponseItemsInner
    """

    # data type: ListOrganizationContainersResponseItemsInnerAnyOf
    anyof_schema_1_validator: Optional[ListOrganizationContainersResponseItemsInnerAnyOf] = None
    # data type: ListOrganizationContainersResponseItemsInnerAnyOf1
    anyof_schema_2_validator: Optional[ListOrganizationContainersResponseItemsInnerAnyOf1] = None
    if TYPE_CHECKING:
        actual_instance: Optional[
            Union[ListOrganizationContainersResponseItemsInnerAnyOf, ListOrganizationContainersResponseItemsInnerAnyOf1]
        ] = None
    else:
        actual_instance: Any = None
    any_of_schemas: Set[str] = {
        "ListOrganizationContainersResponseItemsInnerAnyOf",
        "ListOrganizationContainersResponseItemsInnerAnyOf1",
    }

    model_config = {
        "validate_assignment": True,
        "protected_namespaces": (),
    }

    def __init__(self, *args, **kwargs) -> None:
        if args:
            if len(args) > 1:
                raise ValueError("If a position argument is used, only 1 is allowed to set `actual_instance`")
            if kwargs:
                raise ValueError("If a position argument is used, keyword arguments cannot be used.")
            super().__init__(actual_instance=args[0])
        else:
            super().__init__(**kwargs)

    @field_validator("actual_instance")
    def actual_instance_must_validate_anyof(cls, v):
        instance = ListOrganizationContainersResponseItemsInner.model_construct()
        error_messages = []
        # validate data type: ListOrganizationContainersResponseItemsInnerAnyOf
        if not isinstance(v, ListOrganizationContainersResponseItemsInnerAnyOf):
            error_messages.append(
                f"Error! Input type `{type(v)}` is not `ListOrganizationContainersResponseItemsInnerAnyOf`"
            )
        else:
            return v

        # validate data type: ListOrganizationContainersResponseItemsInnerAnyOf1
        if not isinstance(v, ListOrganizationContainersResponseItemsInnerAnyOf1):
            error_messages.append(
                f"Error! Input type `{type(v)}` is not `ListOrganizationContainersResponseItemsInnerAnyOf1`"
            )
        else:
            return v

        if error_messages:
            # no match
            raise ValueError(
                "No match found when setting the actual_instance in ListOrganizationContainersResponseItemsInner with anyOf schemas: ListOrganizationContainersResponseItemsInnerAnyOf, ListOrganizationContainersResponseItemsInnerAnyOf1. Details: "
                + ", ".join(error_messages)
            )
        else:
            return v

    @classmethod
    def from_dict(cls, obj: Dict[str, Any]) -> Self:
        return cls.from_json(json.dumps(obj))

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Returns the object represented by the json string"""
        instance = cls.model_construct()
        error_messages = []
        try:
            instance.actual_instance = ListOrganizationContainersResponseItemsInnerAnyOf.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        try:
            instance.actual_instance = ListOrganizationContainersResponseItemsInnerAnyOf1.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))

        if error_messages:
            # no match
            raise ValueError(
                "No match found when deserializing the JSON string into ListOrganizationContainersResponseItemsInner with anyOf schemas: ListOrganizationContainersResponseItemsInnerAnyOf, ListOrganizationContainersResponseItemsInnerAnyOf1. Details: "
                + ", ".join(error_messages)
            )
        else:
            return instance

    def to_json(self) -> str:
        """Returns the JSON representation of the actual instance"""
        if self.actual_instance is None:
            return "null"

        if hasattr(self.actual_instance, "to_json") and callable(self.actual_instance.to_json):
            return self.actual_instance.to_json()
        else:
            return json.dumps(self.actual_instance)

    def to_dict(
        self,
    ) -> Optional[
        Union[
            Dict[str, Any],
            ListOrganizationContainersResponseItemsInnerAnyOf,
            ListOrganizationContainersResponseItemsInnerAnyOf1,
        ]
    ]:
        """Returns the dict representation of the actual instance"""
        if self.actual_instance is None:
            return None

        if hasattr(self.actual_instance, "to_dict") and callable(self.actual_instance.to_dict):
            return self.actual_instance.to_dict()
        else:
            return self.actual_instance

    def to_str(self) -> str:
        """Returns the string representation of the actual instance"""
        return pprint.pformat(self.model_dump())
