# Copyright (c) 2021-2023, NVIDIA CORPORATION.  All rights reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Generated by the gRPC Python protocol compiler plugin. DO NOT EDIT!
"""Client and server classes corresponding to protobuf-defined services."""
import grpc

from .streamer_pb2 import Frame


class StreamerStub(object):
    """Interface exported by the server.
    """

    def __init__(self, channel):
        """Constructor.

        Args:
            channel: A grpc.Channel.
        """
        self.Stream = channel.stream_stream(
                '/streamer.Streamer/Stream',
                request_serializer=Frame.SerializeToString,
                response_deserializer=Frame.FromString,
                )


class StreamerServicer(object):
    """Interface exported by the server.
    """

    def Stream(self, request_iterator, context):
        """A Bidirectional streaming RPC.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')


def add_StreamerServicer_to_server(servicer, server):
    rpc_method_handlers = {
            'Stream': grpc.stream_stream_rpc_method_handler(
                    servicer.Stream,
                    request_deserializer=Frame.FromString,
                    response_serializer=Frame.SerializeToString,
            ),
    }
    generic_handler = grpc.method_handlers_generic_handler(
            'streamer.Streamer', rpc_method_handlers)
    server.add_generic_rpc_handlers((generic_handler,))


 # This class is part of an EXPERIMENTAL API.
class Streamer(object):
    """Interface exported by the server.
    """

    @staticmethod
    def Stream(request_iterator,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.stream_stream(request_iterator, target, '/streamer.Streamer/Stream',
            Frame.SerializeToString,
            Frame.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)
