# generated by datamodel-codegen:
#   filename:  entity/teams/teamHierarchy.json
#   timestamp: 2023-04-27T10:50:51+00:00

from __future__ import annotations

from typing import List, Optional

from pydantic import BaseModel, Extra, Field

from ...type import basic
from . import team


class TeamHierarchy(BaseModel):
    class Config:
        extra = Extra.forbid

    id: basic.Uuid
    teamType: Optional[team.TeamType] = Field(
        team.TeamType.Group, description='Team type'
    )
    name: basic.EntityName = Field(
        ...,
        description='A unique name of the team typically the team ID from an identity provider. Example - group Id from LDAP.',
    )
    fullyQualifiedName: Optional[basic.FullyQualifiedEntityName] = Field(
        None, description='FullyQualifiedName same as `name`.'
    )
    displayName: Optional[str] = Field(
        None, description="Name used for display purposes. Example 'Data Science team'."
    )
    href: Optional[basic.Href] = Field(
        None, description='Link to the resource corresponding to this entity.'
    )
    children: Optional[TeamHierarchyList] = Field(
        None,
        description='Children teams. An `Organization` can have `BusinessUnit`, `Division` or `Department` as children. A `BusinessUnit` can have `BusinessUnit`, `Division`, or `Department` as children. A `Division` can have `Division` or `Department` as children. A `Department` can have can have `Department` as children.',
    )
    isJoinable: Optional[bool] = Field(
        True,
        description='Can any user join this team during sign up? Value of true indicates yes, and false no.',
    )


class TeamHierarchyList(BaseModel):
    __root__: List[TeamHierarchy]


TeamHierarchy.update_forward_refs()
