# generated by datamodel-codegen:
#   filename:  metadataIngestion/databaseServiceMetadataPipeline.json
#   timestamp: 2023-04-27T10:50:51+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional

from pydantic import BaseModel, Extra, Field

from ..type import filterPattern


class DatabaseMetadataConfigType(Enum):
    DatabaseMetadata = 'DatabaseMetadata'


class DatabaseServiceMetadataPipeline(BaseModel):
    class Config:
        extra = Extra.forbid

    type: Optional[DatabaseMetadataConfigType] = Field(
        DatabaseMetadataConfigType.DatabaseMetadata, description='Pipeline type'
    )
    markDeletedTables: Optional[bool] = Field(
        True,
        description='This is an optional configuration for enabling soft deletion of tables. When this option is enabled, only tables that have been deleted from the source will be soft deleted, and this will apply solely to the schema that is currently being ingested via the pipeline. Any related entities such as test suites or lineage information that were associated with those tables will also be deleted.',
    )
    markAllDeletedTables: Optional[bool] = Field(
        False,
        description='This is an optional configuration for enabling soft deletion of tables. When this option is enabled, only tables that have been deleted from the source will be soft deleted, and this will apply to all the schemas available in the data source. Any related entities such as test suites or lineage information that were associated with those tables will also be deleted. Do not enable this option when you have multiple metadata ingestion pipelines. Also make sure to enable the markDeletedTables option for this to work.',
    )
    includeTables: Optional[bool] = Field(
        True,
        description='Optional configuration to turn off fetching metadata for tables.',
    )
    includeViews: Optional[bool] = Field(
        True,
        description='Optional configuration to turn off fetching metadata for views.',
    )
    includeTags: Optional[bool] = Field(
        True, description='Optional configuration to toggle the tags ingestion.'
    )
    useFqnForFiltering: Optional[bool] = Field(
        False,
        description='Regex will be applied on fully qualified name (e.g service_name.db_name.schema_name.table_name) instead of raw name (e.g. table_name)',
    )
    schemaFilterPattern: Optional[filterPattern.FilterPattern] = Field(
        None,
        description='Regex to only fetch tables or databases that matches the pattern.',
    )
    tableFilterPattern: Optional[filterPattern.FilterPattern] = Field(
        None, description='Regex exclude tables or databases that matches the pattern.'
    )
    databaseFilterPattern: Optional[filterPattern.FilterPattern] = Field(
        None, description='Regex to only fetch databases that matches the pattern.'
    )
