# generated by datamodel-codegen:
#   filename:  system/eventPublisherJob.json
#   timestamp: 2023-04-27T10:50:51+00:00

from __future__ import annotations

from enum import Enum
from typing import List, Optional

from pydantic import BaseModel, Extra, Field

from ..configuration import elasticSearchConfiguration
from ..type import basic


class Status(Enum):
    STARTED = 'STARTED'
    RUNNING = 'RUNNING'
    COMPLETED = 'COMPLETED'
    FAILED = 'FAILED'
    ACTIVE = 'ACTIVE'
    ACTIVE_WITH_ERROR = 'ACTIVE_WITH_ERROR'
    STOPPED = 'STOPPED'


class FailureDetails(BaseModel):
    class Config:
        extra = Extra.forbid

    context: Optional[str] = Field(None, description='Additional Context for Failure.')
    lastFailedAt: Optional[basic.Timestamp] = Field(
        None,
        description='Last non-successful callback time in UNIX UTC epoch time in milliseconds.',
    )
    lastFailedReason: Optional[str] = Field(
        None,
        description='Last non-successful activity response reason received during callback.',
    )


class StepStats(BaseModel):
    class Config:
        extra = Extra.forbid

    totalRecords: Optional[int] = Field(0, description='Count of Total Failed Records')
    processedRecords: Optional[int] = Field(
        0, description='Records that are processed in'
    )
    successRecords: Optional[int] = Field(
        0, description='Count of Total Successfully Records'
    )
    failedRecords: Optional[int] = Field(0, description='Count of Total Failed Records')


class Stats(BaseModel):
    class Config:
        extra = Extra.forbid

    sourceStats: Optional[StepStats] = None
    processorStats: Optional[StepStats] = None
    sinkStats: Optional[StepStats] = None
    jobStats: Optional[StepStats] = None


class RunMode(Enum):
    stream = 'stream'
    batch = 'batch'


class PublisherType(Enum):
    elasticSearch = 'elasticSearch'
    kafka = 'kafka'


class Failure(BaseModel):
    class Config:
        extra = Extra.forbid

    sourceError: Optional[FailureDetails] = None
    processorError: Optional[FailureDetails] = None
    sinkError: Optional[FailureDetails] = None
    jobError: Optional[FailureDetails] = None


class EventPublisherResult(BaseModel):
    class Config:
        extra = Extra.forbid

    id: basic.Uuid = Field(..., description='Unique identifier of the Job.')
    name: Optional[str] = Field(None, description='Name of the result')
    startedBy: Optional[str] = Field(None, description='Job started by')
    publisherType: Optional[PublisherType] = None
    runMode: RunMode
    timestamp: basic.Timestamp
    startTime: Optional[basic.Timestamp] = None
    endTime: Optional[basic.Timestamp] = None
    status: Status = Field(..., description='This schema publisher run job status.')
    failure: Optional[Failure] = Field(None, description='List of Failures in the Job')
    stats: Optional[Stats] = None
    entities: Optional[List[str]] = Field(
        None, description='List of Entities to Reindex', unique_items=True
    )
    recreateIndex: Optional[bool] = Field(
        None, description='This schema publisher run modes.'
    )
    batchSize: Optional[int] = Field(
        None, description='Maximum number of events sent in a batch (Default 10).'
    )
    searchIndexMappingLanguage: Optional[
        elasticSearchConfiguration.SearchIndexMappingLanguage
    ] = Field(
        elasticSearchConfiguration.SearchIndexMappingLanguage.EN,
        description='Recreate Indexes with updated Language',
    )
