from typing import overload, Any, Callable, TypeVar, Union
from typing import Tuple, List, Sequence, MutableSequence

Callback = Union[Callable[..., None], None]
Buffer = TypeVar('Buffer')
Pointer = TypeVar('Pointer')
Template = TypeVar('Template')

import vtkmodules.vtkCommonCore
import vtkmodules.vtkCommonDataModel

class vtkmDataSet(vtkmodules.vtkCommonDataModel.vtkDataSet):
    actual_memory_size:'getset_descriptor'
    data_object_type:'getset_descriptor'
    max_cell_size:'getset_descriptor'
    number_of_cells:'getset_descriptor'
    number_of_points:'getset_descriptor'
    def ComputeBounds(self) -> None: ...
    def CopyStructure(self, ds:'vtkDataSet') -> None: ...
    def DeepCopy(self, src:'vtkDataObject') -> None: ...
    @overload
    def FindCell(self, x:MutableSequence[float], cell:'vtkCell', cellId:int, tol2:float, subId:int, pcoords:MutableSequence[float], weights:MutableSequence[float]) -> int: ...
    @overload
    def FindCell(self, x:MutableSequence[float], cell:'vtkCell', gencell:'vtkGenericCell', cellId:int, tol2:float, subId:int, pcoords:MutableSequence[float], weights:MutableSequence[float]) -> int: ...
    def FindPoint(self, x:MutableSequence[float]) -> int: ...
    def GetActualMemorySize(self) -> int: ...
    @overload
    def GetCell(self, cellId:int) -> 'vtkCell': ...
    @overload
    def GetCell(self, cellId:int, cell:'vtkGenericCell') -> None: ...
    @overload
    def GetCell(self, i:int, j:int, k:int) -> 'vtkCell': ...
    def GetCellBounds(self, cellId:int, bounds:MutableSequence[float]) -> None: ...
    @overload
    def GetCellPoints(self, cellId:int, ptIds:'vtkIdList') -> None: ...
    @overload
    def GetCellPoints(self, cellId:int, npts:int, pts:Sequence[int], ptIds:'vtkIdList') -> None: ...
    def GetCellType(self, cellId:int) -> int: ...
    def GetDataObjectType(self) -> int: ...
    def GetMaxCellSize(self) -> int: ...
    def GetNumberOfCells(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfPoints(self) -> int: ...
    @overload
    def GetPoint(self, ptId:int) -> Tuple[float, float, float]: ...
    @overload
    def GetPoint(self, id:int, x:MutableSequence[float]) -> None: ...
    def GetPointCells(self, ptId:int, cellIds:'vtkIdList') -> None: ...
    def Initialize(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkmDataSet': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkmDataSet': ...
    def ShallowCopy(self, src:'vtkDataObject') -> None: ...
    def Squeeze(self) -> None: ...

