from typing import overload, Any, Callable, TypeVar, Union
from typing import Tuple, List, Sequence, MutableSequence

Callback = Union[Callable[..., None], None]
Buffer = TypeVar('Buffer')
Pointer = TypeVar('Pointer')
Template = TypeVar('Template')

import vtkmodules.vtkCommonCore
import vtkmodules.vtkCommonExecutionModel
import vtkmodules.vtkImagingCore

class vtkImageStencil(vtkmodules.vtkCommonExecutionModel.vtkThreadedImageAlgorithm):
    background_color:'getset_descriptor'
    background_input:'getset_descriptor'
    background_input_data:'getset_descriptor'
    background_value:'getset_descriptor'
    reverse_stencil:'getset_descriptor'
    stencil:'getset_descriptor'
    stencil_connection:'getset_descriptor'
    stencil_data:'getset_descriptor'
    def GetBackgroundColor(self) -> Tuple[float, float, float, float]: ...
    def GetBackgroundInput(self) -> 'vtkImageData': ...
    def GetBackgroundValue(self) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetReverseStencil(self) -> int: ...
    def GetStencil(self) -> 'vtkImageStencilData': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkImageStencil': ...
    def ReverseStencilOff(self) -> None: ...
    def ReverseStencilOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkImageStencil': ...
    @overload
    def SetBackgroundColor(self, _arg1:float, _arg2:float, _arg3:float, _arg4:float) -> None: ...
    @overload
    def SetBackgroundColor(self, _arg:Sequence[float]) -> None: ...
    def SetBackgroundInputData(self, input:'vtkImageData') -> None: ...
    def SetBackgroundValue(self, val:float) -> None: ...
    def SetReverseStencil(self, _arg:int) -> None: ...
    def SetStencilConnection(self, outputPort:'vtkAlgorithmOutput') -> None: ...
    def SetStencilData(self, stencil:'vtkImageStencilData') -> None: ...

class vtkImageStencilToImage(vtkmodules.vtkCommonExecutionModel.vtkImageAlgorithm):
    inside_value:'getset_descriptor'
    output_scalar_type:'getset_descriptor'
    outside_value:'getset_descriptor'
    def GetInsideValue(self) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOutputScalarType(self) -> int: ...
    def GetOutsideValue(self) -> float: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkImageStencilToImage': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkImageStencilToImage': ...
    def SetInsideValue(self, _arg:float) -> None: ...
    def SetOutputScalarType(self, _arg:int) -> None: ...
    def SetOutputScalarTypeToChar(self) -> None: ...
    def SetOutputScalarTypeToDouble(self) -> None: ...
    def SetOutputScalarTypeToFloat(self) -> None: ...
    def SetOutputScalarTypeToInt(self) -> None: ...
    def SetOutputScalarTypeToLong(self) -> None: ...
    def SetOutputScalarTypeToShort(self) -> None: ...
    def SetOutputScalarTypeToUnsignedChar(self) -> None: ...
    def SetOutputScalarTypeToUnsignedInt(self) -> None: ...
    def SetOutputScalarTypeToUnsignedLong(self) -> None: ...
    def SetOutputScalarTypeToUnsignedShort(self) -> None: ...
    def SetOutsideValue(self, _arg:float) -> None: ...

class vtkImageToImageStencil(vtkmodules.vtkImagingCore.vtkImageStencilAlgorithm):
    input:'getset_descriptor'
    input_data:'getset_descriptor'
    lower_threshold:'getset_descriptor'
    upper_threshold:'getset_descriptor'
    def GetInput(self) -> 'vtkImageData': ...
    def GetLowerThreshold(self) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetUpperThreshold(self) -> float: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkImageToImageStencil': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkImageToImageStencil': ...
    def SetInputData(self, input:'vtkImageData') -> None: ...
    def SetLowerThreshold(self, _arg:float) -> None: ...
    def SetUpperThreshold(self, _arg:float) -> None: ...
    def ThresholdBetween(self, lower:float, upper:float) -> None: ...
    def ThresholdByLower(self, thresh:float) -> None: ...
    def ThresholdByUpper(self, thresh:float) -> None: ...

class vtkImplicitFunctionToImageStencil(vtkmodules.vtkImagingCore.vtkImageStencilSource):
    input:'getset_descriptor'
    m_time:'getset_descriptor'
    threshold:'getset_descriptor'
    def GetInput(self) -> 'vtkImplicitFunction': ...
    def GetMTime(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetThreshold(self) -> float: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkImplicitFunctionToImageStencil': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkImplicitFunctionToImageStencil': ...
    def SetInput(self, __a:'vtkImplicitFunction') -> None: ...
    def SetThreshold(self, _arg:float) -> None: ...

class vtkLassoStencilSource(vtkmodules.vtkImagingCore.vtkImageStencilSource):
    POLYGON:int
    SPLINE:int
    m_time:'getset_descriptor'
    points:'getset_descriptor'
    shape:'getset_descriptor'
    slice_orientation:'getset_descriptor'
    def GetMTime(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPoints(self) -> 'vtkPoints': ...
    def GetShape(self) -> int: ...
    def GetShapeAsString(self) -> str: ...
    def GetShapeMaxValue(self) -> int: ...
    def GetShapeMinValue(self) -> int: ...
    def GetSliceOrientation(self) -> int: ...
    def GetSliceOrientationMaxValue(self) -> int: ...
    def GetSliceOrientationMinValue(self) -> int: ...
    def GetSlicePoints(self, i:int) -> 'vtkPoints': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkLassoStencilSource': ...
    def RemoveAllSlicePoints(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkLassoStencilSource': ...
    def SetPoints(self, points:'vtkPoints') -> None: ...
    def SetShape(self, _arg:int) -> None: ...
    def SetShapeToPolygon(self) -> None: ...
    def SetShapeToSpline(self) -> None: ...
    def SetSliceOrientation(self, _arg:int) -> None: ...
    def SetSlicePoints(self, i:int, points:'vtkPoints') -> None: ...

class vtkPolyDataToImageStencil(vtkmodules.vtkImagingCore.vtkImageStencilSource):
    enable_smp:'getset_descriptor'
    input:'getset_descriptor'
    input_data:'getset_descriptor'
    tolerance:'getset_descriptor'
    def GetEnableSMP(self) -> bool: ...
    def GetInput(self) -> 'vtkPolyData': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetTolerance(self) -> float: ...
    def GetToleranceMaxValue(self) -> float: ...
    def GetToleranceMinValue(self) -> float: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkPolyDataToImageStencil': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPolyDataToImageStencil': ...
    def SetEnableSMP(self, _arg:bool) -> None: ...
    def SetInputData(self, __a:'vtkPolyData') -> None: ...
    def SetTolerance(self, _arg:float) -> None: ...

class vtkROIStencilSource(vtkmodules.vtkImagingCore.vtkImageStencilSource):
    BOX:int
    CYLINDERX:int
    CYLINDERY:int
    CYLINDERZ:int
    ELLIPSOID:int
    bounds:'getset_descriptor'
    shape:'getset_descriptor'
    def GetBounds(self) -> Tuple[float, float, float, float, float, float]: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetShape(self) -> int: ...
    def GetShapeAsString(self) -> str: ...
    def GetShapeMaxValue(self) -> int: ...
    def GetShapeMinValue(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkROIStencilSource': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkROIStencilSource': ...
    @overload
    def SetBounds(self, _arg1:float, _arg2:float, _arg3:float, _arg4:float, _arg5:float, _arg6:float) -> None: ...
    @overload
    def SetBounds(self, _arg:Sequence[float]) -> None: ...
    def SetShape(self, _arg:int) -> None: ...
    def SetShapeToBox(self) -> None: ...
    def SetShapeToCylinderX(self) -> None: ...
    def SetShapeToCylinderY(self) -> None: ...
    def SetShapeToCylinderZ(self) -> None: ...
    def SetShapeToEllipsoid(self) -> None: ...

