from typing import overload, Any, Callable, TypeVar, Union
from typing import Tuple, List, Sequence, MutableSequence

Callback = Union[Callable[..., None], None]
Buffer = TypeVar('Buffer')
Pointer = TypeVar('Pointer')
Template = TypeVar('Template')

import vtkmodules.vtkCommonCore
import vtkmodules.vtkCommonExecutionModel
import vtkmodules.vtkRenderingCore

class vtkFreeTypeStringToImage(vtkmodules.vtkRenderingCore.vtkStringToImage):
    scale_to_power_of_two:'getset_descriptor'
    def DeepCopy(self, utility:'vtkFreeTypeStringToImage') -> None: ...
    def GetBounds(self, property:'vtkTextProperty', string:str, dpi:int) -> 'vtkVector2i': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkFreeTypeStringToImage': ...
    def RenderString(self, property:'vtkTextProperty', string:str, dpi:int, data:'vtkImageData', textDims:MutableSequence[int]=...) -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkFreeTypeStringToImage': ...
    def SetScaleToPowerOfTwo(self, scale:bool) -> None: ...

class vtkFreeTypeTools(vtkmodules.vtkCommonCore.vtkObject):
    debug_textures:'getset_descriptor'
    force_compiled_fonts:'getset_descriptor'
    instance:'getset_descriptor'
    maximum_number_of_bytes:'getset_descriptor'
    maximum_number_of_faces:'getset_descriptor'
    maximum_number_of_sizes:'getset_descriptor'
    scale_to_power_two:'getset_descriptor'
    def DebugTexturesOff(self) -> None: ...
    def DebugTexturesOn(self) -> None: ...
    def ForceCompiledFontsOff(self) -> None: ...
    def ForceCompiledFontsOn(self) -> None: ...
    def GetBoundingBox(self, tprop:'vtkTextProperty', str:str, dpi:int, bbox:MutableSequence[int]) -> bool: ...
    def GetConstrainedFontSize(self, str:str, tprop:'vtkTextProperty', dpi:int, targetWidth:int, targetHeight:int) -> int: ...
    def GetDebugTextures(self) -> bool: ...
    def GetForceCompiledFonts(self) -> bool: ...
    @staticmethod
    def GetInstance() -> 'vtkFreeTypeTools': ...
    def GetMaximumNumberOfBytes(self) -> int: ...
    def GetMaximumNumberOfBytesMaxValue(self) -> int: ...
    def GetMaximumNumberOfBytesMinValue(self) -> int: ...
    def GetMaximumNumberOfFaces(self) -> int: ...
    def GetMaximumNumberOfFacesMaxValue(self) -> int: ...
    def GetMaximumNumberOfFacesMinValue(self) -> int: ...
    def GetMaximumNumberOfSizes(self) -> int: ...
    def GetMaximumNumberOfSizesMaxValue(self) -> int: ...
    def GetMaximumNumberOfSizesMinValue(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetScaleToPowerTwo(self) -> bool: ...
    @staticmethod
    def HashBuffer(buffer:Pointer, n:int, hash:int=0) -> int: ...
    @staticmethod
    def HashString(str:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def MapIdToTextProperty(self, tprop_cache_id:int, tprop:'vtkTextProperty') -> None: ...
    def MapTextPropertyToId(self, tprop:'vtkTextProperty', tprop_cache_id:MutableSequence[int]) -> None: ...
    def NewInstance(self) -> 'vtkFreeTypeTools': ...
    def RenderString(self, tprop:'vtkTextProperty', str:str, dpi:int, data:'vtkImageData', textDims:MutableSequence[int]=...) -> bool: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkFreeTypeTools': ...
    def ScaleToPowerTwoOff(self) -> None: ...
    def ScaleToPowerTwoOn(self) -> None: ...
    def SetDebugTextures(self, _arg:bool) -> None: ...
    def SetForceCompiledFonts(self, _arg:bool) -> None: ...
    @staticmethod
    def SetInstance(instance:'vtkFreeTypeTools') -> None: ...
    def SetMaximumNumberOfBytes(self, _arg:int) -> None: ...
    def SetMaximumNumberOfFaces(self, _arg:int) -> None: ...
    def SetMaximumNumberOfSizes(self, _arg:int) -> None: ...
    def SetScaleToPowerTwo(self, _arg:bool) -> None: ...
    def StringToPath(self, tprop:'vtkTextProperty', str:str, dpi:int, path:'vtkPath') -> bool: ...

class vtkFreeTypeToolsCleanup(object):
    def __init__(self) -> None: ...

class vtkMathTextFreeTypeTextRenderer(vtkmodules.vtkRenderingCore.vtkTextRenderer):
    def FreeTypeIsSupported(self) -> bool: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def MathTextIsSupported(self) -> bool: ...
    def NewInstance(self) -> 'vtkMathTextFreeTypeTextRenderer': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkMathTextFreeTypeTextRenderer': ...

class vtkMathTextUtilities(vtkmodules.vtkCommonCore.vtkObject):
    instance:'getset_descriptor'
    scale_to_power_of_two:'getset_descriptor'
    def GetBoundingBox(self, tprop:'vtkTextProperty', str:str, dpi:int, bbox:MutableSequence[int]) -> bool: ...
    def GetConstrainedFontSize(self, str:str, tprop:'vtkTextProperty', targetWidth:int, targetHeight:int, dpi:int) -> int: ...
    @staticmethod
    def GetInstance() -> 'vtkMathTextUtilities': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetScaleToPowerOfTwo(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    def IsAvailable(self) -> bool: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkMathTextUtilities': ...
    def RenderString(self, str:str, data:'vtkImageData', tprop:'vtkTextProperty', dpi:int, textDims:MutableSequence[int]=...) -> bool: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkMathTextUtilities': ...
    @staticmethod
    def SetInstance(instance:'vtkMathTextUtilities') -> None: ...
    def SetScaleToPowerOfTwo(self, scale:bool) -> None: ...
    def StringToPath(self, str:str, path:'vtkPath', tprop:'vtkTextProperty', dpi:int) -> bool: ...

class vtkMathTextUtilitiesCleanup(object):
    def __init__(self) -> None: ...

class vtkScaledTextActor(vtkmodules.vtkRenderingCore.vtkTextActor):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkScaledTextActor': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkScaledTextActor': ...

class vtkTextRendererStringToImage(vtkmodules.vtkRenderingCore.vtkStringToImage):
    scale_to_power_of_two:'getset_descriptor'
    def DeepCopy(self, utility:'vtkTextRendererStringToImage') -> None: ...
    def GetBounds(self, property:'vtkTextProperty', string:str, dpi:int) -> 'vtkVector2i': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkTextRendererStringToImage': ...
    def RenderString(self, property:'vtkTextProperty', string:str, dpi:int, data:'vtkImageData', textDims:MutableSequence[int]=...) -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkTextRendererStringToImage': ...
    def SetScaleToPowerOfTwo(self, scale:bool) -> None: ...

class vtkVectorText(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    text:'getset_descriptor'
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetText(self) -> str: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkVectorText': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkVectorText': ...
    def SetText(self, _arg:str) -> None: ...

