from typing import overload, Any, Callable, TypeVar, Union
from typing import Tuple, List, Sequence, MutableSequence

Callback = Union[Callable[..., None], None]
Buffer = TypeVar('Buffer')
Pointer = TypeVar('Pointer')
Template = TypeVar('Template')

import vtkmodules.vtkCommonCore

class vtkViewNode(vtkmodules.vtkCommonCore.vtkObject):
    class operation_type(int): ...
    build:'operation_type'
    invalidate:'operation_type'
    my_factory:'getset_descriptor'
    noop:'operation_type'
    parent:'getset_descriptor'
    render:'operation_type'
    renderable:'getset_descriptor'
    synchronize:'operation_type'
    def Build(self, __a:bool) -> None: ...
    def GetFirstAncestorOfType(self, type:str) -> 'vtkViewNode': ...
    def GetFirstChildOfType(self, type:str) -> 'vtkViewNode': ...
    def GetMyFactory(self) -> 'vtkViewNodeFactory': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetParent(self) -> 'vtkViewNode': ...
    def GetRenderable(self) -> 'vtkObject': ...
    def GetViewNodeFor(self, __a:'vtkObject') -> 'vtkViewNode': ...
    def Invalidate(self, __a:bool) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkViewNode': ...
    def Render(self, __a:bool) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkViewNode': ...
    def SetMyFactory(self, __a:'vtkViewNodeFactory') -> None: ...
    def SetParent(self, __a:'vtkViewNode') -> None: ...
    def SetRenderable(self, __a:'vtkObject') -> None: ...
    def Synchronize(self, __a:bool) -> None: ...
    def Traverse(self, operation:int) -> None: ...
    def TraverseAllPasses(self) -> None: ...

class vtkActorNode(vtkViewNode):
    def Build(self, prepass:bool) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkActorNode': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkActorNode': ...

class vtkCameraNode(vtkViewNode):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkCameraNode': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkCameraNode': ...

class vtkLightNode(vtkViewNode):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkLightNode': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkLightNode': ...

class vtkMapperNode(vtkViewNode):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkMapperNode': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkMapperNode': ...

class vtkPolyDataMapperNode(vtkMapperNode):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkPolyDataMapperNode': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPolyDataMapperNode': ...

class vtkRendererNode(vtkViewNode):
    scale:'getset_descriptor'
    size:'getset_descriptor'
    viewport:'getset_descriptor'
    def Build(self, prepass:bool) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetScale(self) -> Tuple[int, int]: ...
    def GetSize(self) -> Tuple[int, int]: ...
    def GetViewport(self) -> Tuple[float, float, float, float]: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkRendererNode': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkRendererNode': ...
    @overload
    def SetScale(self, _arg1:int, _arg2:int) -> None: ...
    @overload
    def SetScale(self, _arg:Sequence[int]) -> None: ...
    @overload
    def SetSize(self, _arg1:int, _arg2:int) -> None: ...
    @overload
    def SetSize(self, _arg:Sequence[int]) -> None: ...
    @overload
    def SetViewport(self, _arg1:float, _arg2:float, _arg3:float, _arg4:float) -> None: ...
    @overload
    def SetViewport(self, _arg:Sequence[float]) -> None: ...

class vtkViewNodeFactory(vtkmodules.vtkCommonCore.vtkObject):
    def CreateNode(self, __a:'vtkObject') -> 'vtkViewNode': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkViewNodeFactory': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkViewNodeFactory': ...

class vtkVolumeMapperNode(vtkMapperNode):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkVolumeMapperNode': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkVolumeMapperNode': ...

class vtkVolumeNode(vtkViewNode):
    def Build(self, prepass:bool) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkVolumeNode': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkVolumeNode': ...

class vtkWindowNode(vtkViewNode):
    color_buffer:'getset_descriptor'
    size:'getset_descriptor'
    z_buffer:'getset_descriptor'
    def Build(self, prepass:bool) -> None: ...
    def GetColorBuffer(self) -> 'vtkUnsignedCharArray': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetSize(self) -> Pointer: ...
    def GetZBuffer(self) -> 'vtkFloatArray': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkWindowNode': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkWindowNode': ...
    def Synchronize(self, prepass:bool) -> None: ...

