# coding: utf-8

"""
    Equinix Fabric API v4

    Equinix Fabric is an advanced software-defined interconnection solution that enables you to directly, securely and dynamically connect to distributed infrastructure and digital ecosystems on platform Equinix via a single port, Customers can use Fabric to connect to: </br> 1. Cloud Service Providers - Clouds, network and other service providers.  </br> 2. Enterprises - Other Equinix customers, vendors and partners.  </br> 3. Myself - Another customer instance deployed at Equinix. </br> </br> <b>Integrations (SDKs, Tools) links:</b> </br> <a href=\"https://deploy.equinix.com/labs/fabric-java\\\">Fabric Java SDK</a> </br> <a href=\"https://deploy.equinix.com/labs/equinix-sdk-go\\\">Fabric Go SDK</a> </br> <a href=\"https://deploy.equinix.com/labs/terraform-provider-equinix\\\">Equinix Terraform Provider</a> </br> <a href=\"https://deploy.equinix.com/labs/terraform-equinix-fabric\\\">Fabric Terraform Modules</a> </br> <a href=\"https://deploy.equinix.com/labs/pulumi-provider-equinix/\">Equinix Pulumi Provider</a> </br>

    The version of the OpenAPI document: 4.15
    Contact: api-support@equinix.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import json
from enum import Enum
from typing_extensions import Self


class EquinixStatus(str, Enum):
    """
    Connection status
    """

    """
    allowed enum values
    """
    REJECTED_ACK = 'REJECTED_ACK'
    REJECTED = 'REJECTED'
    PENDING_DELETE = 'PENDING_DELETE'
    PROVISIONED = 'PROVISIONED'
    BEING_REPROVISIONED = 'BEING_REPROVISIONED'
    BEING_DEPROVISIONED = 'BEING_DEPROVISIONED'
    BEING_PROVISIONED = 'BEING_PROVISIONED'
    CREATED = 'CREATED'
    ERRORED = 'ERRORED'
    PENDING_DEPROVISIONING = 'PENDING_DEPROVISIONING'
    APPROVED = 'APPROVED'
    ORDERING = 'ORDERING'
    PENDING_APPROVAL = 'PENDING_APPROVAL'
    NOT_PROVISIONED = 'NOT_PROVISIONED'
    DEPROVISIONING = 'DEPROVISIONING'
    NOT_DEPROVISIONED = 'NOT_DEPROVISIONED'
    PENDING_AUTO_APPROVAL = 'PENDING_AUTO_APPROVAL'
    PROVISIONING = 'PROVISIONING'
    PENDING_BGP_PEERING = 'PENDING_BGP_PEERING'
    PENDING_PROVIDER_VLAN = 'PENDING_PROVIDER_VLAN'
    DEPROVISIONED = 'DEPROVISIONED'
    DELETED = 'DELETED'
    PENDING_BANDWIDTH_APPROVAL = 'PENDING_BANDWIDTH_APPROVAL'
    AUTO_APPROVAL_FAILED = 'AUTO_APPROVAL_FAILED'
    UPDATE_PENDING = 'UPDATE_PENDING'
    DELETED_API = 'DELETED_API'
    MODIFIED = 'MODIFIED'
    PENDING_PROVIDER_VLAN_ERROR = 'PENDING_PROVIDER_VLAN_ERROR'
    DRAFT = 'DRAFT'
    CANCELLED = 'CANCELLED'
    PENDING_INTERFACE_CONFIGURATION = 'PENDING_INTERFACE_CONFIGURATION'

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of EquinixStatus from a JSON string"""
        return cls(json.loads(json_str))


