# coding: utf-8

"""
    Equinix Fabric API v4

    Equinix Fabric is an advanced software-defined interconnection solution that enables you to directly, securely and dynamically connect to distributed infrastructure and digital ecosystems on platform Equinix via a single port, Customers can use Fabric to connect to: </br> 1. Cloud Service Providers - Clouds, network and other service providers.  </br> 2. Enterprises - Other Equinix customers, vendors and partners.  </br> 3. Myself - Another customer instance deployed at Equinix. </br> </br> <b>Integrations (SDKs, Tools) links:</b> </br> <a href=\"https://deploy.equinix.com/labs/fabric-java\\\">Fabric Java SDK</a> </br> <a href=\"https://deploy.equinix.com/labs/equinix-sdk-go\\\">Fabric Go SDK</a> </br> <a href=\"https://deploy.equinix.com/labs/terraform-provider-equinix\\\">Equinix Terraform Provider</a> </br> <a href=\"https://deploy.equinix.com/labs/terraform-equinix-fabric\\\">Fabric Terraform Modules</a> </br> <a href=\"https://deploy.equinix.com/labs/pulumi-provider-equinix/\">Equinix Pulumi Provider</a> </br>

    The version of the OpenAPI document: 4.15
    Contact: api-support@equinix.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from equinix.services.fabricv4.models.changelog import Changelog
from equinix.services.fabricv4.models.link_protocol_connection import LinkProtocolConnection
from equinix.services.fabricv4.models.link_protocol_request_type import LinkProtocolRequestType
from equinix.services.fabricv4.models.link_protocol_service_token import LinkProtocolServiceToken
from equinix.services.fabricv4.models.link_protocol_state import LinkProtocolState
from equinix.services.fabricv4.models.sub_interface import SubInterface
from typing import Optional, Set
from typing_extensions import Self

class LinkProtocolResponse(BaseModel):
    """
    Link Protocol response
    """ # noqa: E501
    href: Optional[StrictStr] = Field(default=None, description="LinkProtocol URI")
    uuid: Optional[StrictStr] = Field(default=None, description="Equinix-assigned network identifier")
    state: Optional[LinkProtocolState] = None
    type: Optional[LinkProtocolRequestType] = None
    vlan_tag: Optional[StrictInt] = Field(default=None, alias="vlanTag")
    vni: Optional[StrictInt] = None
    vlan_tag_min: Optional[StrictInt] = Field(default=None, alias="vlanTagMin")
    vlan_tag_max: Optional[StrictInt] = Field(default=None, alias="vlanTagMax")
    vlan_s_tag: Optional[StrictInt] = Field(default=None, alias="vlanSTag")
    vlan_c_tag: Optional[StrictInt] = Field(default=None, alias="vlanCTag")
    vlan_c_tag_min: Optional[StrictInt] = Field(default=None, alias="vlanCTagMin")
    vlan_c_tag_max: Optional[StrictInt] = Field(default=None, alias="vlanCTagMax")
    sub_interface: Optional[SubInterface] = Field(default=None, alias="subInterface")
    asset: Optional[LinkProtocolConnection] = None
    service_token: Optional[LinkProtocolServiceToken] = Field(default=None, alias="serviceToken")
    change_log: Optional[Changelog] = Field(default=None, alias="changeLog")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["href", "uuid", "state", "type", "vlanTag", "vni", "vlanTagMin", "vlanTagMax", "vlanSTag", "vlanCTag", "vlanCTagMin", "vlanCTagMax", "subInterface", "asset", "serviceToken", "changeLog"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of LinkProtocolResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "href",
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of sub_interface
        if self.sub_interface:
            _dict['subInterface'] = self.sub_interface.to_dict()
        # override the default output from pydantic by calling `to_dict()` of asset
        if self.asset:
            _dict['asset'] = self.asset.to_dict()
        # override the default output from pydantic by calling `to_dict()` of service_token
        if self.service_token:
            _dict['serviceToken'] = self.service_token.to_dict()
        # override the default output from pydantic by calling `to_dict()` of change_log
        if self.change_log:
            _dict['changeLog'] = self.change_log.to_dict()
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of LinkProtocolResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "href": obj.get("href"),
            "uuid": obj.get("uuid"),
            "state": obj.get("state"),
            "type": obj.get("type"),
            "vlanTag": obj.get("vlanTag"),
            "vni": obj.get("vni"),
            "vlanTagMin": obj.get("vlanTagMin"),
            "vlanTagMax": obj.get("vlanTagMax"),
            "vlanSTag": obj.get("vlanSTag"),
            "vlanCTag": obj.get("vlanCTag"),
            "vlanCTagMin": obj.get("vlanCTagMin"),
            "vlanCTagMax": obj.get("vlanCTagMax"),
            "subInterface": SubInterface.from_dict(obj["subInterface"]) if obj.get("subInterface") is not None else None,
            "asset": LinkProtocolConnection.from_dict(obj["asset"]) if obj.get("asset") is not None else None,
            "serviceToken": LinkProtocolServiceToken.from_dict(obj["serviceToken"]) if obj.get("serviceToken") is not None else None,
            "changeLog": Changelog.from_dict(obj["changeLog"]) if obj.get("changeLog") is not None else None
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


