# coding: utf-8

"""
    Equinix Fabric API v4

    Equinix Fabric is an advanced software-defined interconnection solution that enables you to directly, securely and dynamically connect to distributed infrastructure and digital ecosystems on platform Equinix via a single port, Customers can use Fabric to connect to: </br> 1. Cloud Service Providers - Clouds, network and other service providers.  </br> 2. Enterprises - Other Equinix customers, vendors and partners.  </br> 3. Myself - Another customer instance deployed at Equinix. </br> </br> <b>Integrations (SDKs, Tools) links:</b> </br> <a href=\"https://deploy.equinix.com/labs/fabric-java\\\">Fabric Java SDK</a> </br> <a href=\"https://deploy.equinix.com/labs/equinix-sdk-go\\\">Fabric Go SDK</a> </br> <a href=\"https://deploy.equinix.com/labs/terraform-provider-equinix\\\">Equinix Terraform Provider</a> </br> <a href=\"https://deploy.equinix.com/labs/terraform-equinix-fabric\\\">Fabric Terraform Modules</a> </br> <a href=\"https://deploy.equinix.com/labs/pulumi-provider-equinix/\">Equinix Pulumi Provider</a> </br>

    The version of the OpenAPI document: 4.15
    Contact: api-support@equinix.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from equinix.services.fabricv4.models.changelog import Changelog
from equinix.services.fabricv4.models.route_filter_rule_state import RouteFilterRuleState
from equinix.services.fabricv4.models.route_filter_rules_change import RouteFilterRulesChange
from equinix.services.fabricv4.models.route_filter_rules_data_action import RouteFilterRulesDataAction
from equinix.services.fabricv4.models.route_filter_rules_data_type import RouteFilterRulesDataType
from typing import Optional, Set
from typing_extensions import Self

class RouteFilterRulesData(BaseModel):
    """
    RouteFilterRulesData
    """ # noqa: E501
    href: Optional[StrictStr] = Field(default=None, description="Route Filter Rules URI")
    type: Optional[RouteFilterRulesDataType] = None
    uuid: Optional[StrictStr] = Field(default=None, description="Route Filter Rule identifier")
    name: Optional[StrictStr] = None
    description: Optional[StrictStr] = Field(default=None, description="Customer-provided Route Filter Rule description")
    state: Optional[RouteFilterRuleState] = None
    prefix_match: Optional[StrictStr] = Field(default='orlonger', description="prefix matching operator", alias="prefixMatch")
    change: Optional[RouteFilterRulesChange] = None
    action: Optional[RouteFilterRulesDataAction] = None
    prefix: Optional[StrictStr] = None
    changelog: Optional[Changelog] = None
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["href", "type", "uuid", "name", "description", "state", "prefixMatch", "change", "action", "prefix", "changelog"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of RouteFilterRulesData from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of change
        if self.change:
            _dict['change'] = self.change.to_dict()
        # override the default output from pydantic by calling `to_dict()` of changelog
        if self.changelog:
            _dict['changelog'] = self.changelog.to_dict()
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of RouteFilterRulesData from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "href": obj.get("href"),
            "type": obj.get("type"),
            "uuid": obj.get("uuid"),
            "name": obj.get("name"),
            "description": obj.get("description"),
            "state": obj.get("state"),
            "prefixMatch": obj.get("prefixMatch") if obj.get("prefixMatch") is not None else 'orlonger',
            "change": RouteFilterRulesChange.from_dict(obj["change"]) if obj.get("change") is not None else None,
            "action": obj.get("action"),
            "prefix": obj.get("prefix"),
            "changelog": Changelog.from_dict(obj["changelog"]) if obj.get("changelog") is not None else None
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


