# coding: utf-8

"""
    Metal API

    The version of the OpenAPI document: 1.0.0
    Contact: support@equinixmetal.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from equinix.services.metalv1.models.auth_token_project import AuthTokenProject
from equinix.services.metalv1.models.auth_token_user import AuthTokenUser
from typing import Optional, Set
from typing_extensions import Self

class AuthToken(BaseModel):
    """
    AuthToken
    """ # noqa: E501
    created_at: Optional[datetime] = None
    description: Optional[StrictStr] = Field(default=None, description="Available only for API keys")
    href: Optional[StrictStr] = None
    id: Optional[StrictStr] = None
    project: Optional[AuthTokenProject] = None
    read_only: Optional[StrictBool] = None
    token: Optional[StrictStr] = None
    updated_at: Optional[datetime] = None
    user: Optional[AuthTokenUser] = None
    __properties: ClassVar[List[str]] = ["created_at", "description", "href", "id", "project", "read_only", "token", "updated_at", "user"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AuthToken from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of project
        if self.project:
            _dict['project'] = self.project.to_dict()
        # override the default output from pydantic by calling `to_dict()` of user
        if self.user:
            _dict['user'] = self.user.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AuthToken from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "created_at": obj.get("created_at"),
            "description": obj.get("description"),
            "href": obj.get("href"),
            "id": obj.get("id"),
            "project": AuthTokenProject.from_dict(obj["project"]) if obj.get("project") is not None else None,
            "read_only": obj.get("read_only"),
            "token": obj.get("token"),
            "updated_at": obj.get("updated_at"),
            "user": AuthTokenUser.from_dict(obj["user"]) if obj.get("user") is not None else None
        })
        return _obj


