# coding: utf-8

"""
    Metal API

    The version of the OpenAPI document: 1.0.0
    Contact: support@equinixmetal.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from equinix.services.metalv1.models.bgp_session import BgpSession
from equinix.services.metalv1.models.global_bgp_range import GlobalBgpRange
from equinix.services.metalv1.models.href import Href
from typing import Optional, Set
from typing_extensions import Self

class BgpConfig(BaseModel):
    """
    BgpConfig
    """ # noqa: E501
    asn: Optional[Annotated[int, Field(le=4294967295, strict=True, ge=0)]] = Field(default=None, description="Autonomous System Number. ASN is required with Global BGP. With Local BGP the private ASN, 65000, is assigned.")
    created_at: Optional[datetime] = None
    deployment_type: Optional[StrictStr] = Field(default=None, description="In a Local BGP deployment, a customer uses an internal ASN to control routes within a single Equinix Metal datacenter. This means that the routes are never advertised to the global Internet. Global BGP, on the other hand, requires a customer to have a registered ASN and IP space. ")
    href: Optional[StrictStr] = None
    id: Optional[StrictStr] = None
    max_prefix: Optional[StrictInt] = Field(default=10, description="The maximum number of route filters allowed per server")
    md5: Optional[StrictStr] = Field(default=None, description="(Optional) Password for BGP session in plaintext (not a checksum)")
    project: Optional[Href] = None
    ranges: Optional[List[GlobalBgpRange]] = Field(default=None, description="The IP block ranges associated to the ASN (Populated in Global BGP only)")
    requested_at: Optional[datetime] = None
    route_object: Optional[StrictStr] = Field(default=None, description="Specifies AS-MACRO (aka AS-SET) to use when building client route filters")
    sessions: Optional[List[BgpSession]] = Field(default=None, description="The direct connections between neighboring routers that want to exchange routing information.")
    status: Optional[StrictStr] = Field(default=None, description="Status of the BGP Config. Status \"requested\" is valid only with the \"global\" deployment_type.")
    __properties: ClassVar[List[str]] = ["asn", "created_at", "deployment_type", "href", "id", "max_prefix", "md5", "project", "ranges", "requested_at", "route_object", "sessions", "status"]

    @field_validator('deployment_type')
    def deployment_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['global', 'local']):
            raise ValueError("must be one of enum values ('global', 'local')")
        return value

    @field_validator('status')
    def status_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['requested', 'enabled', 'disabled']):
            raise ValueError("must be one of enum values ('requested', 'enabled', 'disabled')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of BgpConfig from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of project
        if self.project:
            _dict['project'] = self.project.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in ranges (list)
        _items = []
        if self.ranges:
            for _item in self.ranges:
                if _item:
                    _items.append(_item.to_dict())
            _dict['ranges'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in sessions (list)
        _items = []
        if self.sessions:
            for _item in self.sessions:
                if _item:
                    _items.append(_item.to_dict())
            _dict['sessions'] = _items
        # set to None if md5 (nullable) is None
        # and model_fields_set contains the field
        if self.md5 is None and "md5" in self.model_fields_set:
            _dict['md5'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of BgpConfig from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "asn": obj.get("asn"),
            "created_at": obj.get("created_at"),
            "deployment_type": obj.get("deployment_type"),
            "href": obj.get("href"),
            "id": obj.get("id"),
            "max_prefix": obj.get("max_prefix") if obj.get("max_prefix") is not None else 10,
            "md5": obj.get("md5"),
            "project": Href.from_dict(obj["project"]) if obj.get("project") is not None else None,
            "ranges": [GlobalBgpRange.from_dict(_item) for _item in obj["ranges"]] if obj.get("ranges") is not None else None,
            "requested_at": obj.get("requested_at"),
            "route_object": obj.get("route_object"),
            "sessions": [BgpSession.from_dict(_item) for _item in obj["sessions"]] if obj.get("sessions") is not None else None,
            "status": obj.get("status")
        })
        return _obj


