# coding: utf-8

"""
    Metal API

    The version of the OpenAPI document: 1.0.0
    Contact: support@equinixmetal.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from equinix.services.metalv1.models.bgp_route import BgpRoute
from typing import Optional, Set
from typing_extensions import Self

class BgpNeighborData(BaseModel):
    """
    BgpNeighborData
    """ # noqa: E501
    address_family: Optional[StrictInt] = Field(default=None, description="Address Family for IP Address. Accepted values are 4 or 6")
    customer_as: Optional[StrictInt] = Field(default=None, description="The customer's ASN. In a local BGP deployment, this will be an internal ASN used to route within the data center. For a global BGP deployment, this will be the your own ASN, configured when you set up BGP for your project.")
    customer_ip: Optional[StrictStr] = Field(default=None, description="The device's IP address. For an IPv4 BGP session, this is typically the private bond0 address for the device.")
    href: Optional[StrictStr] = None
    md5_enabled: Optional[StrictBool] = Field(default=None, description="True if an MD5 password is configured for the project.")
    md5_password: Optional[StrictStr] = Field(default=None, description="The MD5 password configured for the project, if set.")
    multihop: Optional[StrictBool] = Field(default=None, description="True when the BGP session should be configured as multihop.")
    peer_as: Optional[StrictInt] = Field(default=None, description="The Peer ASN to use when configuring BGP on your device.")
    peer_ips: Optional[List[StrictStr]] = Field(default=None, description="A list of one or more IP addresses to use for the Peer IP section of your BGP configuration. For non-multihop sessions, this will typically be a single gateway address for the device. For multihop sessions, it will be a list of IPs.")
    routes_in: Optional[List[BgpRoute]] = Field(default=None, description="A list of project subnets")
    routes_out: Optional[List[BgpRoute]] = Field(default=None, description="A list of outgoing routes. Only populated if the BGP session has default route enabled.")
    __properties: ClassVar[List[str]] = ["address_family", "customer_as", "customer_ip", "href", "md5_enabled", "md5_password", "multihop", "peer_as", "peer_ips", "routes_in", "routes_out"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of BgpNeighborData from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in routes_in (list)
        _items = []
        if self.routes_in:
            for _item in self.routes_in:
                if _item:
                    _items.append(_item.to_dict())
            _dict['routes_in'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in routes_out (list)
        _items = []
        if self.routes_out:
            for _item in self.routes_out:
                if _item:
                    _items.append(_item.to_dict())
            _dict['routes_out'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of BgpNeighborData from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "address_family": obj.get("address_family"),
            "customer_as": obj.get("customer_as"),
            "customer_ip": obj.get("customer_ip"),
            "href": obj.get("href"),
            "md5_enabled": obj.get("md5_enabled"),
            "md5_password": obj.get("md5_password"),
            "multihop": obj.get("multihop"),
            "peer_as": obj.get("peer_as"),
            "peer_ips": obj.get("peer_ips"),
            "routes_in": [BgpRoute.from_dict(_item) for _item in obj["routes_in"]] if obj.get("routes_in") is not None else None,
            "routes_out": [BgpRoute.from_dict(_item) for _item in obj["routes_out"]] if obj.get("routes_out") is not None else None
        })
        return _obj


