# coding: utf-8

"""
    Metal API

    The version of the OpenAPI document: 1.0.0
    Contact: support@equinixmetal.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import json
import pprint
from pydantic import BaseModel, ConfigDict, Field, StrictStr, ValidationError, field_validator
from typing import Any, List, Optional
from equinix.services.metalv1.models.dedicated_port_create_input import DedicatedPortCreateInput
from equinix.services.metalv1.models.shared_port_vc_vlan_create_input import SharedPortVCVlanCreateInput
from equinix.services.metalv1.models.vlan_csp_connection_create_input import VlanCSPConnectionCreateInput
from equinix.services.metalv1.models.vlan_fabric_vc_create_input import VlanFabricVcCreateInput
from equinix.services.metalv1.models.vrf_fabric_vc_create_input import VrfFabricVcCreateInput
from pydantic import StrictStr, Field
from typing import Union, List, Optional, Dict
from typing_extensions import Literal, Self

CREATEORGANIZATIONINTERCONNECTIONREQUEST_ONE_OF_SCHEMAS = ["DedicatedPortCreateInput", "SharedPortVCVlanCreateInput", "VlanCSPConnectionCreateInput", "VlanFabricVcCreateInput", "VrfFabricVcCreateInput"]

class CreateOrganizationInterconnectionRequest(BaseModel):
    """
    CreateOrganizationInterconnectionRequest
    """
    # data type: DedicatedPortCreateInput
    oneof_schema_1_validator: Optional[DedicatedPortCreateInput] = None
    # data type: VlanFabricVcCreateInput
    oneof_schema_2_validator: Optional[VlanFabricVcCreateInput] = None
    # data type: VrfFabricVcCreateInput
    oneof_schema_3_validator: Optional[VrfFabricVcCreateInput] = None
    # data type: SharedPortVCVlanCreateInput
    oneof_schema_4_validator: Optional[SharedPortVCVlanCreateInput] = None
    # data type: VlanCSPConnectionCreateInput
    oneof_schema_5_validator: Optional[VlanCSPConnectionCreateInput] = None
    actual_instance: Optional[Union[DedicatedPortCreateInput, SharedPortVCVlanCreateInput, VlanCSPConnectionCreateInput, VlanFabricVcCreateInput, VrfFabricVcCreateInput]] = None
    one_of_schemas: List[str] = Field(default=Literal["DedicatedPortCreateInput", "SharedPortVCVlanCreateInput", "VlanCSPConnectionCreateInput", "VlanFabricVcCreateInput", "VrfFabricVcCreateInput"])

    model_config = ConfigDict(
        validate_assignment=True,
        protected_namespaces=(),
    )


    def __init__(self, *args, **kwargs) -> None:
        if args:
            if len(args) > 1:
                raise ValueError("If a position argument is used, only 1 is allowed to set `actual_instance`")
            if kwargs:
                raise ValueError("If a position argument is used, keyword arguments cannot be used.")
            super().__init__(actual_instance=args[0])
        else:
            super().__init__(**kwargs)

    @field_validator('actual_instance')
    def actual_instance_must_validate_oneof(cls, v):
        instance = CreateOrganizationInterconnectionRequest.model_construct()
        error_messages = []
        match = 0
        # validate data type: DedicatedPortCreateInput
        if not isinstance(v, DedicatedPortCreateInput):
            error_messages.append(f"Error! Input type `{type(v)}` is not `DedicatedPortCreateInput`")
        else:
            match += 1
        # validate data type: VlanFabricVcCreateInput
        if not isinstance(v, VlanFabricVcCreateInput):
            error_messages.append(f"Error! Input type `{type(v)}` is not `VlanFabricVcCreateInput`")
        else:
            match += 1
        # validate data type: VrfFabricVcCreateInput
        if not isinstance(v, VrfFabricVcCreateInput):
            error_messages.append(f"Error! Input type `{type(v)}` is not `VrfFabricVcCreateInput`")
        else:
            match += 1
        # validate data type: SharedPortVCVlanCreateInput
        if not isinstance(v, SharedPortVCVlanCreateInput):
            error_messages.append(f"Error! Input type `{type(v)}` is not `SharedPortVCVlanCreateInput`")
        else:
            match += 1
        # validate data type: VlanCSPConnectionCreateInput
        if not isinstance(v, VlanCSPConnectionCreateInput):
            error_messages.append(f"Error! Input type `{type(v)}` is not `VlanCSPConnectionCreateInput`")
        else:
            match += 1
        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when setting `actual_instance` in CreateOrganizationInterconnectionRequest with oneOf schemas: DedicatedPortCreateInput, SharedPortVCVlanCreateInput, VlanCSPConnectionCreateInput, VlanFabricVcCreateInput, VrfFabricVcCreateInput. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when setting `actual_instance` in CreateOrganizationInterconnectionRequest with oneOf schemas: DedicatedPortCreateInput, SharedPortVCVlanCreateInput, VlanCSPConnectionCreateInput, VlanFabricVcCreateInput, VrfFabricVcCreateInput. Details: " + ", ".join(error_messages))
        else:
            return v

    @classmethod
    def from_dict(cls, obj: Union[str, Dict[str, Any]]) -> Self:
        return cls.from_json(json.dumps(obj))

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Returns the object represented by the json string"""
        instance = cls.model_construct()
        error_messages = []
        match = 0

        # deserialize data into DedicatedPortCreateInput
        try:
            instance.actual_instance = DedicatedPortCreateInput.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into VlanFabricVcCreateInput
        try:
            instance.actual_instance = VlanFabricVcCreateInput.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into VrfFabricVcCreateInput
        try:
            instance.actual_instance = VrfFabricVcCreateInput.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into SharedPortVCVlanCreateInput
        try:
            instance.actual_instance = SharedPortVCVlanCreateInput.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into VlanCSPConnectionCreateInput
        try:
            instance.actual_instance = VlanCSPConnectionCreateInput.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))

        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when deserializing the JSON string into CreateOrganizationInterconnectionRequest with oneOf schemas: DedicatedPortCreateInput, SharedPortVCVlanCreateInput, VlanCSPConnectionCreateInput, VlanFabricVcCreateInput, VrfFabricVcCreateInput. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when deserializing the JSON string into CreateOrganizationInterconnectionRequest with oneOf schemas: DedicatedPortCreateInput, SharedPortVCVlanCreateInput, VlanCSPConnectionCreateInput, VlanFabricVcCreateInput, VrfFabricVcCreateInput. Details: " + ", ".join(error_messages))
        else:
            return instance

    def to_json(self) -> str:
        """Returns the JSON representation of the actual instance"""
        if self.actual_instance is None:
            return "null"

        if hasattr(self.actual_instance, "to_json") and callable(self.actual_instance.to_json):
            return self.actual_instance.to_json()
        else:
            return json.dumps(self.actual_instance)

    def to_dict(self) -> Optional[Union[Dict[str, Any], DedicatedPortCreateInput, SharedPortVCVlanCreateInput, VlanCSPConnectionCreateInput, VlanFabricVcCreateInput, VrfFabricVcCreateInput]]:
        """Returns the dict representation of the actual instance"""
        if self.actual_instance is None:
            return None

        if hasattr(self.actual_instance, "to_dict") and callable(self.actual_instance.to_dict):
            return self.actual_instance.to_dict()
        else:
            # primitive type
            return self.actual_instance

    def to_str(self) -> str:
        """Returns the string representation of the actual instance"""
        return pprint.pformat(self.model_dump())


