# coding: utf-8

"""
    Metal API

    The version of the OpenAPI document: 1.0.0
    Contact: support@equinixmetal.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class DeviceUpdateInput(BaseModel):
    """
    DeviceUpdateInput
    """ # noqa: E501
    always_pxe: Optional[StrictBool] = None
    billing_cycle: Optional[StrictStr] = None
    customdata: Optional[Dict[str, Any]] = None
    description: Optional[StrictStr] = None
    firmware_set_id: Optional[StrictStr] = None
    hostname: Optional[StrictStr] = None
    href: Optional[StrictStr] = None
    ipxe_script_url: Optional[StrictStr] = None
    locked: Optional[StrictBool] = Field(default=None, description="Whether the device should be locked, preventing accidental deletion.")
    network_frozen: Optional[StrictBool] = Field(default=None, description="If true, this instance can not be converted to a different network type.")
    spot_instance: Optional[StrictBool] = Field(default=None, description="Can be set to false to convert a spot-market instance to on-demand.")
    tags: Optional[List[StrictStr]] = None
    userdata: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["always_pxe", "billing_cycle", "customdata", "description", "firmware_set_id", "hostname", "href", "ipxe_script_url", "locked", "network_frozen", "spot_instance", "tags", "userdata"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DeviceUpdateInput from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DeviceUpdateInput from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "always_pxe": obj.get("always_pxe"),
            "billing_cycle": obj.get("billing_cycle"),
            "customdata": obj.get("customdata"),
            "description": obj.get("description"),
            "firmware_set_id": obj.get("firmware_set_id"),
            "hostname": obj.get("hostname"),
            "href": obj.get("href"),
            "ipxe_script_url": obj.get("ipxe_script_url"),
            "locked": obj.get("locked"),
            "network_frozen": obj.get("network_frozen"),
            "spot_instance": obj.get("spot_instance"),
            "tags": obj.get("tags"),
            "userdata": obj.get("userdata")
        })
        return _obj


