# coding: utf-8

"""
    Metal API

    The version of the OpenAPI document: 1.0.0
    Contact: support@equinixmetal.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class Entitlement(BaseModel):
    """
    Entitlement
    """ # noqa: E501
    description: Optional[StrictStr] = None
    feature_access: Optional[Dict[str, Any]] = None
    href: Optional[StrictStr] = None
    id: StrictStr
    instance_quota: Optional[Dict[str, Any]] = None
    ip_quota: Optional[Dict[str, Any]] = None
    name: Optional[StrictStr] = None
    project_quota: Optional[StrictInt] = 0
    slug: StrictStr
    volume_limits: Optional[Dict[str, Any]] = None
    volume_quota: Optional[Dict[str, Any]] = None
    weight: StrictInt
    __properties: ClassVar[List[str]] = ["description", "feature_access", "href", "id", "instance_quota", "ip_quota", "name", "project_quota", "slug", "volume_limits", "volume_quota", "weight"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Entitlement from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Entitlement from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "description": obj.get("description"),
            "feature_access": obj.get("feature_access"),
            "href": obj.get("href"),
            "id": obj.get("id"),
            "instance_quota": obj.get("instance_quota"),
            "ip_quota": obj.get("ip_quota"),
            "name": obj.get("name"),
            "project_quota": obj.get("project_quota") if obj.get("project_quota") is not None else 0,
            "slug": obj.get("slug"),
            "volume_limits": obj.get("volume_limits"),
            "volume_quota": obj.get("volume_quota"),
            "weight": obj.get("weight")
        })
        return _obj


