# coding: utf-8

"""
    Metal API

    The version of the OpenAPI document: 1.0.0
    Contact: support@equinixmetal.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from equinix.services.metalv1.models.address import Address
from equinix.services.metalv1.models.device_metro import DeviceMetro
from typing import Optional, Set
from typing_extensions import Self

class Facility(BaseModel):
    """
    Facility
    """ # noqa: E501
    address: Optional[Address] = None
    code: Optional[StrictStr] = None
    features: Optional[List[StrictStr]] = None
    href: Optional[StrictStr] = None
    id: Optional[StrictStr] = None
    ip_ranges: Optional[List[StrictStr]] = Field(default=None, description="IP ranges registered in facility. Can be used for GeoIP location")
    metro: Optional[DeviceMetro] = None
    name: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["address", "code", "features", "href", "id", "ip_ranges", "metro", "name"]

    @field_validator('features')
    def features_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        for i in value:
            if i not in set(['baremetal', 'backend_transfer', 'layer_2', 'global_ipv4', 'ibx']):
                raise ValueError("each list item must be one of ('baremetal', 'backend_transfer', 'layer_2', 'global_ipv4', 'ibx')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Facility from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of address
        if self.address:
            _dict['address'] = self.address.to_dict()
        # override the default output from pydantic by calling `to_dict()` of metro
        if self.metro:
            _dict['metro'] = self.metro.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Facility from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "address": Address.from_dict(obj["address"]) if obj.get("address") is not None else None,
            "code": obj.get("code"),
            "features": obj.get("features"),
            "href": obj.get("href"),
            "id": obj.get("id"),
            "ip_ranges": obj.get("ip_ranges"),
            "metro": DeviceMetro.from_dict(obj["metro"]) if obj.get("metro") is not None else None,
            "name": obj.get("name")
        })
        return _obj


