# coding: utf-8

"""
    Metal API

    The version of the OpenAPI document: 1.0.0
    Contact: support@equinixmetal.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from equinix.services.metalv1.models.facility import Facility
from equinix.services.metalv1.models.plan import Plan
from equinix.services.metalv1.models.project import Project
from typing import Optional, Set
from typing_extensions import Self

class HardwareReservation(BaseModel):
    """
    HardwareReservation
    """ # noqa: E501
    created_at: Optional[datetime] = None
    custom_rate: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Amount that will be charged for every billing_cycle.")
    device: Optional[Device] = None
    facility: Optional[Facility] = None
    href: Optional[StrictStr] = None
    id: Optional[StrictStr] = None
    need_of_service: Optional[StrictBool] = Field(default=None, description="Whether this Device requires assistance from Equinix Metal.")
    plan: Optional[Plan] = None
    project: Optional[Project] = None
    provisionable: Optional[StrictBool] = Field(default=None, description="Whether the reserved server is provisionable or not. Spare devices can't be provisioned unless they are activated first.")
    short_id: Optional[StrictStr] = Field(default=None, description="Short version of the ID.")
    spare: Optional[StrictBool] = Field(default=None, description="Whether the Hardware Reservation is a spare. Spare Hardware Reservations are used when a Hardware Reservations requires service from Equinix Metal")
    switch_uuid: Optional[StrictStr] = Field(default=None, description="Switch short id. This can be used to determine if two devices are connected to the same switch, for example.")
    termination_time: Optional[datetime] = Field(default=None, description="Expiration date for the reservation.")
    __properties: ClassVar[List[str]] = ["created_at", "custom_rate", "device", "facility", "href", "id", "need_of_service", "plan", "project", "provisionable", "short_id", "spare", "switch_uuid", "termination_time"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of HardwareReservation from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of device
        if self.device:
            _dict['device'] = self.device.to_dict()
        # override the default output from pydantic by calling `to_dict()` of facility
        if self.facility:
            _dict['facility'] = self.facility.to_dict()
        # override the default output from pydantic by calling `to_dict()` of plan
        if self.plan:
            _dict['plan'] = self.plan.to_dict()
        # override the default output from pydantic by calling `to_dict()` of project
        if self.project:
            _dict['project'] = self.project.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of HardwareReservation from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "created_at": obj.get("created_at"),
            "custom_rate": obj.get("custom_rate"),
            "device": Device.from_dict(obj["device"]) if obj.get("device") is not None else None,
            "facility": Facility.from_dict(obj["facility"]) if obj.get("facility") is not None else None,
            "href": obj.get("href"),
            "id": obj.get("id"),
            "need_of_service": obj.get("need_of_service"),
            "plan": Plan.from_dict(obj["plan"]) if obj.get("plan") is not None else None,
            "project": Project.from_dict(obj["project"]) if obj.get("project") is not None else None,
            "provisionable": obj.get("provisionable"),
            "short_id": obj.get("short_id"),
            "spare": obj.get("spare"),
            "switch_uuid": obj.get("switch_uuid"),
            "termination_time": obj.get("termination_time")
        })
        return _obj

from equinix.services.metalv1.models.device import Device
# TODO: Rewrite to not use raise_errors
HardwareReservation.model_rebuild(raise_errors=False)

