# coding: utf-8

"""
    Metal API

    The version of the OpenAPI document: 1.0.0
    Contact: support@equinixmetal.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from equinix.services.metalv1.models.href import Href
from equinix.services.metalv1.models.ip_assignment_metro import IPAssignmentMetro
from equinix.services.metalv1.models.parent_block import ParentBlock
from typing import Optional, Set
from typing_extensions import Self

class IPAssignment(BaseModel):
    """
    IPAssignment
    """ # noqa: E501
    address: Optional[StrictStr] = None
    address_family: Optional[StrictInt] = None
    assigned_to: Href
    cidr: Optional[StrictInt] = None
    created_at: Optional[datetime] = None
    enabled: Optional[StrictBool] = None
    gateway: Optional[StrictStr] = None
    global_ip: Optional[StrictBool] = None
    href: Optional[StrictStr] = None
    id: Optional[StrictStr] = None
    manageable: Optional[StrictBool] = None
    management: Optional[StrictBool] = None
    metro: Optional[IPAssignmentMetro] = None
    netmask: Optional[StrictStr] = None
    network: Optional[StrictStr] = None
    next_hop: Optional[StrictStr] = Field(default=None, description="Only set when this is a Metal Gateway Elastic IP Assignment.  The IP address within the Metal Gateway to which requests to the Elastic IP are forwarded. ")
    parent_block: Optional[ParentBlock] = None
    public: Optional[StrictBool] = None
    state: Optional[StrictStr] = Field(default=None, description="Only set when this is a Metal Gateway Elastic IP Assignment.  Describes the current configuration state of this IP on the network. ")
    __properties: ClassVar[List[str]] = ["address", "address_family", "assigned_to", "cidr", "created_at", "enabled", "gateway", "global_ip", "href", "id", "manageable", "management", "metro", "netmask", "network", "next_hop", "parent_block", "public", "state"]

    @field_validator('state')
    def state_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['pending', 'active', 'deleting']):
            raise ValueError("must be one of enum values ('pending', 'active', 'deleting')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of IPAssignment from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of assigned_to
        if self.assigned_to:
            _dict['assigned_to'] = self.assigned_to.to_dict()
        # override the default output from pydantic by calling `to_dict()` of metro
        if self.metro:
            _dict['metro'] = self.metro.to_dict()
        # override the default output from pydantic by calling `to_dict()` of parent_block
        if self.parent_block:
            _dict['parent_block'] = self.parent_block.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of IPAssignment from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "address": obj.get("address"),
            "address_family": obj.get("address_family"),
            "assigned_to": Href.from_dict(obj["assigned_to"]) if obj.get("assigned_to") is not None else None,
            "cidr": obj.get("cidr"),
            "created_at": obj.get("created_at"),
            "enabled": obj.get("enabled"),
            "gateway": obj.get("gateway"),
            "global_ip": obj.get("global_ip"),
            "href": obj.get("href"),
            "id": obj.get("id"),
            "manageable": obj.get("manageable"),
            "management": obj.get("management"),
            "metro": IPAssignmentMetro.from_dict(obj["metro"]) if obj.get("metro") is not None else None,
            "netmask": obj.get("netmask"),
            "network": obj.get("network"),
            "next_hop": obj.get("next_hop"),
            "parent_block": ParentBlock.from_dict(obj["parent_block"]) if obj.get("parent_block") is not None else None,
            "public": obj.get("public"),
            "state": obj.get("state")
        })
        return _obj


