# coding: utf-8

"""
    Metal API

    The version of the OpenAPI document: 1.0.0
    Contact: support@equinixmetal.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class IPReservationRequestInput(BaseModel):
    """
    IPReservationRequestInput
    """ # noqa: E501
    comments: Optional[StrictStr] = None
    customdata: Optional[Dict[str, Any]] = None
    details: Optional[StrictStr] = None
    facility: Optional[StrictStr] = None
    fail_on_approval_required: Optional[StrictBool] = None
    href: Optional[StrictStr] = None
    metro: Optional[StrictStr] = Field(default=None, description="The code of the metro you are requesting the IP reservation in.")
    quantity: StrictInt
    tags: Optional[List[StrictStr]] = None
    type: StrictStr
    __properties: ClassVar[List[str]] = ["comments", "customdata", "details", "facility", "fail_on_approval_required", "href", "metro", "quantity", "tags", "type"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of IPReservationRequestInput from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of IPReservationRequestInput from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "comments": obj.get("comments"),
            "customdata": obj.get("customdata"),
            "details": obj.get("details"),
            "facility": obj.get("facility"),
            "fail_on_approval_required": obj.get("fail_on_approval_required"),
            "href": obj.get("href"),
            "metro": obj.get("metro"),
            "quantity": obj.get("quantity"),
            "tags": obj.get("tags"),
            "type": obj.get("type")
        })
        return _obj


