# coding: utf-8

"""
    Metal API

    The version of the OpenAPI document: 1.0.0
    Contact: support@equinixmetal.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import date
from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from equinix.services.metalv1.models.line_item_adjustment import LineItemAdjustment
from equinix.services.metalv1.models.plan_id_name import PlanIdName
from equinix.services.metalv1.models.project_id_name import ProjectIdName
from typing import Optional, Set
from typing_extensions import Self

class LineItem(BaseModel):
    """
    LineItem
    """ # noqa: E501
    adjustments: Optional[List[LineItemAdjustment]] = Field(default=None, description="Adjustments for the line item")
    amount: Optional[Union[StrictFloat, StrictInt]] = None
    currency: Optional[StrictStr] = None
    description: Optional[StrictStr] = None
    details: Optional[StrictStr] = None
    end_date: Optional[date] = None
    hostname: Optional[StrictStr] = None
    href: Optional[StrictStr] = None
    item_type: Optional[StrictStr] = None
    location: Optional[StrictStr] = None
    plan: Optional[PlanIdName] = None
    plan_id: Optional[StrictStr] = None
    project: Optional[ProjectIdName] = None
    project_id: Optional[StrictStr] = None
    service_id: Optional[StrictStr] = None
    start_date: Optional[date] = None
    unit: Optional[StrictStr] = None
    unit_price: Optional[Union[StrictFloat, StrictInt]] = None
    __properties: ClassVar[List[str]] = ["adjustments", "amount", "currency", "description", "details", "end_date", "hostname", "href", "item_type", "location", "plan", "plan_id", "project", "project_id", "service_id", "start_date", "unit", "unit_price"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of LineItem from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in adjustments (list)
        _items = []
        if self.adjustments:
            for _item in self.adjustments:
                if _item:
                    _items.append(_item.to_dict())
            _dict['adjustments'] = _items
        # override the default output from pydantic by calling `to_dict()` of plan
        if self.plan:
            _dict['plan'] = self.plan.to_dict()
        # override the default output from pydantic by calling `to_dict()` of project
        if self.project:
            _dict['project'] = self.project.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of LineItem from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "adjustments": [LineItemAdjustment.from_dict(_item) for _item in obj["adjustments"]] if obj.get("adjustments") is not None else None,
            "amount": obj.get("amount"),
            "currency": obj.get("currency"),
            "description": obj.get("description"),
            "details": obj.get("details"),
            "end_date": obj.get("end_date"),
            "hostname": obj.get("hostname"),
            "href": obj.get("href"),
            "item_type": obj.get("item_type"),
            "location": obj.get("location"),
            "plan": PlanIdName.from_dict(obj["plan"]) if obj.get("plan") is not None else None,
            "plan_id": obj.get("plan_id"),
            "project": ProjectIdName.from_dict(obj["project"]) if obj.get("project") is not None else None,
            "project_id": obj.get("project_id"),
            "service_id": obj.get("service_id"),
            "start_date": obj.get("start_date"),
            "unit": obj.get("unit"),
            "unit_price": obj.get("unit_price")
        })
        return _obj


