# coding: utf-8

"""
    Metal API

    The version of the OpenAPI document: 1.0.0
    Contact: support@equinixmetal.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from equinix.services.metalv1.models.address import Address
from equinix.services.metalv1.models.href import Href
from typing import Optional, Set
from typing_extensions import Self

class Organization(BaseModel):
    """
    Organization
    """ # noqa: E501
    address: Optional[Address] = None
    billing_address: Optional[Address] = None
    created_at: Optional[datetime] = None
    credit_amount: Optional[Union[StrictFloat, StrictInt]] = None
    customdata: Optional[Dict[str, Any]] = None
    description: Optional[StrictStr] = None
    enforce_2fa_at: Optional[datetime] = Field(default=None, description="Force to all members to have enabled the two factor authentication after that date, unless the value is null")
    href: Optional[StrictStr] = None
    id: Optional[StrictStr] = None
    logo: Optional[StrictStr] = None
    members: Optional[List[Href]] = None
    memberships: Optional[List[Href]] = None
    name: Optional[StrictStr] = None
    projects: Optional[List[Href]] = None
    terms: Optional[StrictInt] = None
    twitter: Optional[StrictStr] = None
    updated_at: Optional[datetime] = None
    website: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["address", "billing_address", "created_at", "credit_amount", "customdata", "description", "enforce_2fa_at", "href", "id", "logo", "members", "memberships", "name", "projects", "terms", "twitter", "updated_at", "website"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Organization from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of address
        if self.address:
            _dict['address'] = self.address.to_dict()
        # override the default output from pydantic by calling `to_dict()` of billing_address
        if self.billing_address:
            _dict['billing_address'] = self.billing_address.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in members (list)
        _items = []
        if self.members:
            for _item in self.members:
                if _item:
                    _items.append(_item.to_dict())
            _dict['members'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in memberships (list)
        _items = []
        if self.memberships:
            for _item in self.memberships:
                if _item:
                    _items.append(_item.to_dict())
            _dict['memberships'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in projects (list)
        _items = []
        if self.projects:
            for _item in self.projects:
                if _item:
                    _items.append(_item.to_dict())
            _dict['projects'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Organization from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "address": Address.from_dict(obj["address"]) if obj.get("address") is not None else None,
            "billing_address": Address.from_dict(obj["billing_address"]) if obj.get("billing_address") is not None else None,
            "created_at": obj.get("created_at"),
            "credit_amount": obj.get("credit_amount"),
            "customdata": obj.get("customdata"),
            "description": obj.get("description"),
            "enforce_2fa_at": obj.get("enforce_2fa_at"),
            "href": obj.get("href"),
            "id": obj.get("id"),
            "logo": obj.get("logo"),
            "members": [Href.from_dict(_item) for _item in obj["members"]] if obj.get("members") is not None else None,
            "memberships": [Href.from_dict(_item) for _item in obj["memberships"]] if obj.get("memberships") is not None else None,
            "name": obj.get("name"),
            "projects": [Href.from_dict(_item) for _item in obj["projects"]] if obj.get("projects") is not None else None,
            "terms": obj.get("terms"),
            "twitter": obj.get("twitter"),
            "updated_at": obj.get("updated_at"),
            "website": obj.get("website")
        })
        return _obj


