# coding: utf-8

"""
    Metal API

    The version of the OpenAPI document: 1.0.0
    Contact: support@equinixmetal.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from equinix.services.metalv1.models.spot_market_request_create_input_instance_parameters import SpotMarketRequestCreateInputInstanceParameters
from typing import Optional, Set
from typing_extensions import Self

class SpotMarketRequestCreateInput(BaseModel):
    """
    SpotMarketRequestCreateInput
    """ # noqa: E501
    devices_max: Optional[StrictInt] = None
    devices_min: Optional[StrictInt] = None
    end_at: Optional[datetime] = None
    facilities: Optional[List[StrictStr]] = None
    href: Optional[StrictStr] = None
    instance_parameters: Optional[SpotMarketRequestCreateInputInstanceParameters] = None
    max_bid_price: Optional[Union[StrictFloat, StrictInt]] = None
    metro: Optional[StrictStr] = Field(default=None, description="The metro ID or code the spot market request will be created in.")
    __properties: ClassVar[List[str]] = ["devices_max", "devices_min", "end_at", "facilities", "href", "instance_parameters", "max_bid_price", "metro"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of SpotMarketRequestCreateInput from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of instance_parameters
        if self.instance_parameters:
            _dict['instance_parameters'] = self.instance_parameters.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of SpotMarketRequestCreateInput from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "devices_max": obj.get("devices_max"),
            "devices_min": obj.get("devices_min"),
            "end_at": obj.get("end_at"),
            "facilities": obj.get("facilities"),
            "href": obj.get("href"),
            "instance_parameters": SpotMarketRequestCreateInputInstanceParameters.from_dict(obj["instance_parameters"]) if obj.get("instance_parameters") is not None else None,
            "max_bid_price": obj.get("max_bid_price"),
            "metro": obj.get("metro")
        })
        return _obj


