# coding: utf-8

"""
    Metal API

    The version of the OpenAPI document: 1.0.0
    Contact: support@equinixmetal.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class SpotMarketRequestCreateInputInstanceParameters(BaseModel):
    """
    SpotMarketRequestCreateInputInstanceParameters
    """ # noqa: E501
    always_pxe: Optional[StrictBool] = None
    billing_cycle: Optional[StrictStr] = None
    customdata: Optional[Dict[str, Any]] = None
    description: Optional[StrictStr] = None
    features: Optional[List[StrictStr]] = None
    hostname: Optional[StrictStr] = None
    hostnames: Optional[List[StrictStr]] = None
    href: Optional[StrictStr] = None
    locked: Optional[StrictBool] = Field(default=None, description="Whether the device should be locked, preventing accidental deletion.")
    no_ssh_keys: Optional[StrictBool] = None
    operating_system: Optional[StrictStr] = None
    plan: Optional[StrictStr] = None
    private_ipv4_subnet_size: Optional[StrictInt] = None
    project_ssh_keys: Optional[List[StrictStr]] = None
    public_ipv4_subnet_size: Optional[StrictInt] = None
    tags: Optional[List[StrictStr]] = None
    termination_time: Optional[datetime] = None
    user_ssh_keys: Optional[List[StrictStr]] = Field(default=None, description="The UUIDs of users whose SSH keys should be included on the provisioned device.")
    userdata: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["always_pxe", "billing_cycle", "customdata", "description", "features", "hostname", "hostnames", "href", "locked", "no_ssh_keys", "operating_system", "plan", "private_ipv4_subnet_size", "project_ssh_keys", "public_ipv4_subnet_size", "tags", "termination_time", "user_ssh_keys", "userdata"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of SpotMarketRequestCreateInputInstanceParameters from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of SpotMarketRequestCreateInputInstanceParameters from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "always_pxe": obj.get("always_pxe"),
            "billing_cycle": obj.get("billing_cycle"),
            "customdata": obj.get("customdata"),
            "description": obj.get("description"),
            "features": obj.get("features"),
            "hostname": obj.get("hostname"),
            "hostnames": obj.get("hostnames"),
            "href": obj.get("href"),
            "locked": obj.get("locked"),
            "no_ssh_keys": obj.get("no_ssh_keys"),
            "operating_system": obj.get("operating_system"),
            "plan": obj.get("plan"),
            "private_ipv4_subnet_size": obj.get("private_ipv4_subnet_size"),
            "project_ssh_keys": obj.get("project_ssh_keys"),
            "public_ipv4_subnet_size": obj.get("public_ipv4_subnet_size"),
            "tags": obj.get("tags"),
            "termination_time": obj.get("termination_time"),
            "user_ssh_keys": obj.get("user_ssh_keys"),
            "userdata": obj.get("userdata")
        })
        return _obj


