# coding: utf-8

"""
    Metal API

    The version of the OpenAPI document: 1.0.0
    Contact: support@equinixmetal.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from equinix.services.metalv1.models.href import Href
from equinix.services.metalv1.models.metal_gateway_lite import MetalGatewayLite
from equinix.services.metalv1.models.metro import Metro
from equinix.services.metalv1.models.project import Project
from typing import Optional, Set
from typing_extensions import Self

class VirtualNetwork(BaseModel):
    """
    VirtualNetwork
    """ # noqa: E501
    assigned_to: Optional[Project] = None
    assigned_to_virtual_circuit: Optional[StrictBool] = Field(default=None, description="True if the virtual network is attached to a virtual circuit. False if not.")
    created_at: Optional[datetime] = None
    description: Optional[StrictStr] = None
    facility: Optional[Href] = None
    href: Optional[StrictStr] = None
    id: Optional[StrictStr] = None
    instances: Optional[List[Device]] = Field(default=None, description="A list of instances with ports currently associated to this Virtual Network.")
    metal_gateways: Optional[List[MetalGatewayLite]] = Field(default=None, description="A list of metal gateways currently associated to this Virtual Network.")
    metro: Optional[Metro] = None
    metro_code: Optional[StrictStr] = Field(default=None, description="The Metro code of the metro in which this Virtual Network is defined.")
    tags: Optional[List[StrictStr]] = None
    vxlan: Optional[StrictInt] = None
    __properties: ClassVar[List[str]] = ["assigned_to", "assigned_to_virtual_circuit", "created_at", "description", "facility", "href", "id", "instances", "metal_gateways", "metro", "metro_code", "tags", "vxlan"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of VirtualNetwork from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of assigned_to
        if self.assigned_to:
            _dict['assigned_to'] = self.assigned_to.to_dict()
        # override the default output from pydantic by calling `to_dict()` of facility
        if self.facility:
            _dict['facility'] = self.facility.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in instances (list)
        _items = []
        if self.instances:
            for _item in self.instances:
                if _item:
                    _items.append(_item.to_dict())
            _dict['instances'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in metal_gateways (list)
        _items = []
        if self.metal_gateways:
            for _item in self.metal_gateways:
                if _item:
                    _items.append(_item.to_dict())
            _dict['metal_gateways'] = _items
        # override the default output from pydantic by calling `to_dict()` of metro
        if self.metro:
            _dict['metro'] = self.metro.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of VirtualNetwork from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "assigned_to": Project.from_dict(obj["assigned_to"]) if obj.get("assigned_to") is not None else None,
            "assigned_to_virtual_circuit": obj.get("assigned_to_virtual_circuit"),
            "created_at": obj.get("created_at"),
            "description": obj.get("description"),
            "facility": Href.from_dict(obj["facility"]) if obj.get("facility") is not None else None,
            "href": obj.get("href"),
            "id": obj.get("id"),
            "instances": [Device.from_dict(_item) for _item in obj["instances"]] if obj.get("instances") is not None else None,
            "metal_gateways": [MetalGatewayLite.from_dict(_item) for _item in obj["metal_gateways"]] if obj.get("metal_gateways") is not None else None,
            "metro": Metro.from_dict(obj["metro"]) if obj.get("metro") is not None else None,
            "metro_code": obj.get("metro_code"),
            "tags": obj.get("tags"),
            "vxlan": obj.get("vxlan")
        })
        return _obj

from equinix.services.metalv1.models.device import Device
# TODO: Rewrite to not use raise_errors
VirtualNetwork.model_rebuild(raise_errors=False)

